/*
 * Decompiled with CFR 0.152.
 */
package jd.utils;

import java.util.ArrayList;
import java.util.Calendar;
import jd.config.SubConfiguration;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.nrouter.IPCheck;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class Replacer {
    private static ArrayList<String[]> KEYS = null;

    public static String[] getKeyList() {
        if (KEYS == null) {
            Replacer.initKeys();
        }
        String[] stringArray = new String[KEYS.size()];
        int n = 0;
        while (n < KEYS.size()) {
            stringArray[n] = "%" + KEYS.get(n)[0] + "%" + "   (" + KEYS.get(n)[1] + ")";
            ++n;
        }
        return stringArray;
    }

    public static String getKey(int n) {
        if (KEYS == null) {
            Replacer.initKeys();
        }
        if (n >= KEYS.size()) {
            return null;
        }
        return KEYS.get(n)[0];
    }

    private static void initKeys() {
        KEYS = new ArrayList();
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.PASSWORD", JDL.L("replacer.password", "Last finished package: Password")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.FILELIST", JDL.L("replacer.filelist", "Last finished package: Filelist")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.PACKAGENAME", JDL.L("replacer.packagename", "Last finished package: Packagename")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.COMMENT", JDL.L("replacer.comment", "Last finished package: Comment")});
        KEYS.add(new String[]{"LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY", JDL.L("replacer.downloaddirectory", "Last finished package: Download Directory")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.DOWNLOAD_PATH", JDL.L("replacer.filepath", "Last finished File: Filepath")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.INFOSTRING", JDL.L("replacer.informationstring", "Last finished File: Plugin given informationstring")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.HOST", JDL.L("replacer.hoster", "Last finished File: Hoster")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.NAME", JDL.L("replacer.filename", "Last finished File: Filename")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.FILESIZE", JDL.L("replacer.filesize", "Last finished File: Filesize")});
        KEYS.add(new String[]{"LAST_FINISHED_FILE.AVAILABLE", JDL.L("replacer.available", "Last finished File: is Available (Yes,No)")});
        KEYS.add(new String[]{"SYSTEM.IP", JDL.L("replacer.ipaddress", "Current IP Address")});
        KEYS.add(new String[]{"SYSTEM.DATE", JDL.L("replacer.date", "Current Date")});
        KEYS.add(new String[]{"SYSTEM.TIME", JDL.L("replacer.time", "Current Time")});
        KEYS.add(new String[]{"SYSTEM.JAVA_VERSION", JDL.L("replacer.javaversion", "Used Java Version")});
        KEYS.add(new String[]{"JD.REVISION", JDL.L("replacer.jdversion", "jDownloader: Revision/Version")});
        KEYS.add(new String[]{"JD.HOME_DIR", JDL.L("replacer.jdhomedirectory", "jDownloader: Homedirectory/Installdirectory")});
    }

    public static String getReplacement(String string) {
        JDController jDController = JDUtilities.getController();
        DownloadLink downloadLink = jDController.getLastFinishedDownloadLink();
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.PASSWORD")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getFilePackage().getPassword();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.FILELIST")) {
            if (downloadLink == null) {
                return "";
            }
            ArrayList<DownloadLink> arrayList = downloadLink.getFilePackage().getDownloadLinkList();
            return arrayList.toString();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.PACKAGENAME")) {
            if (downloadLink == null) {
                return "";
            }
            if (downloadLink.getFilePackage().getName() == null || downloadLink.getFilePackage().getName().length() == 0) {
                return downloadLink.getName();
            }
            return downloadLink.getFilePackage().getName();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.COMMENT")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getFilePackage().getComment();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_PACKAGE.DOWNLOAD_DIRECTORY")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getFilePackage().getDownloadDirectory();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.DOWNLOAD_PATH")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getFileOutput();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.INFOSTRING")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getFileInfomationString();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.HOST")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getHost();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.NAME")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.getName();
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.FILESIZE")) {
            if (downloadLink == null) {
                return "";
            }
            return String.valueOf(downloadLink.getDownloadSize());
        }
        if (string.equalsIgnoreCase("LAST_FINISHED_FILE.AVAILABLE")) {
            if (downloadLink == null) {
                return "";
            }
            return downloadLink.isAvailable() ? "YES" : "NO";
        }
        if (string.equalsIgnoreCase("SYSTEM.IP")) {
            if (SubConfiguration.getConfig("DOWNLOAD").getBooleanProperty("GLOBAL_IP_DISABLE2", false).booleanValue()) {
                return "IPCheck disabled";
            }
            return IPCheck.getIPAddress();
        }
        if (string.equalsIgnoreCase("SYSTEM.DATE")) {
            Calendar calendar = Calendar.getInstance();
            return String.valueOf(Formatter.fillInteger((long)calendar.get(5), (int)2, (String)"0")) + "." + Formatter.fillInteger((long)(calendar.get(2) + 1), (int)2, (String)"0") + "." + calendar.get(1);
        }
        if (string.equalsIgnoreCase("SYSTEM.TIME")) {
            Calendar calendar = Calendar.getInstance();
            return String.valueOf(Formatter.fillInteger((long)calendar.get(11), (int)2, (String)"0")) + ":" + Formatter.fillInteger((long)calendar.get(12), (int)2, (String)"0") + ":" + Formatter.fillInteger((long)calendar.get(13), (int)2, (String)"0");
        }
        if (string.equalsIgnoreCase("JD.REVISION")) {
            return JDUtilities.getRevision();
        }
        if (string.equalsIgnoreCase("SYSTEM.JAVA_VERSION")) {
            return JDUtilities.getJavaVersion().toString();
        }
        if (string.equalsIgnoreCase("JD.HOME_DIR")) {
            return JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath();
        }
        return "";
    }

    public static String insertVariables(String string) {
        if (string == null) {
            return "";
        }
        if (KEYS == null) {
            Replacer.initKeys();
        }
        for (String[] stringArray : KEYS) {
            if (string.indexOf("%" + stringArray[0] + "%") < 0) continue;
            JDLogger.getLogger().finer("%" + stringArray[0] + "%" + " --> *****");
            string = Replacer.replace(string, "%" + stringArray[0] + "%", Replacer.getReplacement(stringArray[0]));
        }
        return string;
    }

    private static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        while ((n2 = string.indexOf(string2, n)) > -1) {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + n3;
        }
        int n4 = string.length();
        if (n < n4) {
            stringBuilder.append(string.substring(n, n4));
        }
        return stringBuilder.toString();
    }
}

