/*
 * Decompiled with CFR 0.152.
 */
package jd.utils.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.event.JDBroadcaster;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import jd.nutils.io.JDFileFilter;
import jd.utils.EditDistance;
import jd.utils.JDGeoCode;
import jd.utils.JDUtilities;
import jd.utils.locale.JDLEvent;
import jd.utils.locale.JDLListener;
import jd.utils.locale.JDLocale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDL {
    private static final HashMap<String, JDLocale> CACHE = new HashMap();
    public static final String CONFIG = "LOCALE";
    private static String COUNTRY_CODE = null;
    private static HashMap<Integer, String> DATA = new HashMap();
    public static boolean DEBUG = false;
    private static HashMap<Integer, String> DEFAULT_DATA = null;
    private static int KEY;
    private static String LANGUAGES_DIR;
    public static final String LOCALE_PARAM_ID = "LOCALE4";
    public static final JDLocale DEFAULT_LOCALE;
    private static JDBroadcaster<JDLListener, JDLEvent> BROADCASTER;
    private static File LOCALE_FILE;
    private static JDLocale LOCALE_ID;
    private static String STATIC_LOCALE;
    private static HashMap<String, String> SETTINGS;

    static {
        LANGUAGES_DIR = "jd/languages/";
        DEFAULT_LOCALE = JDL.getInstance("en");
        BROADCASTER = null;
    }

    public static boolean isNorthAmerica(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        String[] stringArray2 = stringArray = new String[]{"US", "CA", "BS", "BB", "AI", "AG", "VG", "VI", "KY", "BM", "GD", "TC", "MS", "MP", "GU", "AS", "LC", "DM", "VC", "PR", "DO", "DO", "DO", "TT", "KN", "JM", "PR"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isEurope(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        String[] stringArray2 = stringArray = new String[]{"GR", "NL", "BE", "FR", "ES", "GI", "PT", "LU", "IE", "IS", "AL", "MT", "CY", "FI", "AX", "BG", "HU", "LT", "LV", "EE", "MD", "AM", "QN", "BY", "AD", "MC", "SM", "VA", "UA", "RS", "ME", "HR", "SI", "BA", "EU", "MK", "IT", "VA", "RO", "CH", "CZ", "SK", "LI", "AT", "GB", "GG", "IM", "JE", "DK", "SE", "NO", "SJ", "PL", "DE"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isSouthAmerica(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        String[] stringArray2 = stringArray = new String[]{"FK", "BZ", "GT", "SV", "HN", "NI", "CR", "PA", "PM", "HT", "PE", "MX", "CU", "AR", "BR", "CL", "CO", "VE", "GP", "BL", "MF", "BO", "GY", "EC", "GF", "PY", "MQ", "SR", "UY", "AN"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static HashMap<String, String> getSettings() {
        if (SETTINGS == null) {
            SETTINGS = new HashMap();
        }
        return SETTINGS;
    }

    public static JDBroadcaster<JDLListener, JDLEvent> getBroadcaster() {
        if (BROADCASTER == null) {
            BROADCASTER = new JDBroadcaster<JDLListener, JDLEvent>(){

                @Override
                protected void fireEvent(JDLListener jDLListener, JDLEvent jDLEvent) {
                    jDLListener.onJDLEvent(jDLEvent);
                }
            };
        }
        return BROADCASTER;
    }

    public static String getCountryCodeByIP() {
        if (COUNTRY_CODE != null) {
            return COUNTRY_CODE;
        }
        COUNTRY_CODE = SubConfiguration.getConfig(CONFIG).getStringProperty("DEFAULTLANGUAGE", null);
        if (COUNTRY_CODE != null) {
            return COUNTRY_CODE;
        }
        Browser browser = new Browser();
        browser.setConnectTimeout(10000);
        browser.setReadTimeout(10000);
        try {
            COUNTRY_CODE = browser.getPage("http://www.jdownloader.org/advert/getLanguage.php?id=" + System.currentTimeMillis() + new Random(System.currentTimeMillis()).nextLong());
            if (!browser.getRequest().getHttpConnection().isOK()) {
                COUNTRY_CODE = null;
            } else {
                COUNTRY_CODE = COUNTRY_CODE.trim().toUpperCase();
                SubConfiguration.getConfig(CONFIG).setProperty("DEFAULTLANGUAGE", COUNTRY_CODE);
                SubConfiguration.getConfig(CONFIG).save();
            }
        }
        catch (Exception exception) {
            COUNTRY_CODE = null;
        }
        return COUNTRY_CODE;
    }

    public static JDLocale getInstance(String string) {
        JDLocale jDLocale = CACHE.get(string);
        if (jDLocale != null) {
            return jDLocale;
        }
        jDLocale = new JDLocale(string);
        CACHE.put(string, jDLocale);
        return jDLocale;
    }

    public static String[] getKeysFor(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = Integer.MAX_VALUE;
        for (Map.Entry<Integer, String> stringArray2 : DATA.entrySet()) {
            int n2 = EditDistance.getLevenshteinDistance(string, stringArray2.getValue());
            if (n2 < n) {
                arrayList.clear();
                arrayList.add(stringArray2.getKey());
                n = n2;
                continue;
            }
            if (n != n2) continue;
            arrayList.add(stringArray2.getKey());
            n = n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        int n3 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = JDL.hashToKey((Integer)arrayList.get(n3));
            ++n3;
        }
        return stringArray;
    }

    public static File getLanguageFile() {
        return LOCALE_FILE;
    }

    public static JDLocale getConfigLocale() {
        return SubConfiguration.getConfig(CONFIG).getGenericProperty(LOCALE_PARAM_ID, DEFAULT_LOCALE);
    }

    public static void setConfigLocale(JDLocale jDLocale) {
        SubConfiguration.getConfig(CONFIG).setProperty(LOCALE_PARAM_ID, jDLocale);
        SubConfiguration.getConfig(CONFIG).save();
    }

    public static JDLocale getLocale() {
        return LOCALE_ID;
    }

    public static ArrayList<JDLocale> getLocaleIDs() {
        File file = JDUtilities.getResourceFile(LANGUAGES_DIR);
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles((FileFilter)new JDFileFilter(null, ".loc", false));
        ArrayList<JDLocale> arrayList = new ArrayList<JDLocale>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            if (JDGeoCode.parseLanguageCode(file2.getName().split("\\.")[0]) == null) {
                file2.renameTo(new File(file2, ".outdated"));
            } else {
                arrayList.add(JDL.getInstance(file2.getName().split("\\.")[0]));
            }
            ++n2;
        }
        return arrayList;
    }

    public static String getLocaleString(String string, String string2) {
        if (DEBUG) {
            return string;
        }
        if (DATA == null || LOCALE_FILE == null) {
            JDL.setLocale(JDL.getConfigLocale());
        }
        if (DATA == null) {
            return "Error in JDL: DATA==null";
        }
        KEY = string.toLowerCase().hashCode();
        if (DATA.containsKey(KEY)) {
            return DATA.get(KEY);
        }
        System.out.println("Key not found: " + string + " Defaultvalue: " + string2);
        if (string2 == null) {
            JDL.loadDefault();
            if (DEFAULT_DATA.containsKey(KEY)) {
                string2 = DEFAULT_DATA.get(KEY);
            }
            if (string2 == null) {
                string2 = string;
            }
        }
        DATA.put(KEY, string2);
        return string2;
    }

    /*
     * Exception decompiling
     */
    private static String hashToKey(Integer var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void initLocalisation() {
        JComponent.setDefaultLocale(new Locale(JDL.getLocale().getLanguageCode()));
    }

    public static boolean isGerman() {
        String string = System.getProperty("user.country");
        return string != null && string.equalsIgnoreCase("DE");
    }

    public static String L(String string, String string2) {
        return JDL.getLocaleString(string, string2);
    }

    public static String LF(String string, String string2, Object ... objectArray) {
        if (DEBUG) {
            return string;
        }
        if (objectArray == null || objectArray.length == 0) {
            JDLogger.getLogger().severe("FIXME: " + string);
        }
        try {
            return String.format(JDL.L(string, string2), objectArray);
        }
        catch (Exception exception) {
            JDLogger.getLogger().severe("FIXME: " + string);
            return "FIXME: " + string;
        }
    }

    private static void loadDefault() {
        if (DEFAULT_DATA == null) {
            File file;
            System.err.println("JD have to load the default language, there is an missing entry");
            DEFAULT_DATA = new HashMap();
            File file2 = file = STATIC_LOCALE == null ? JDUtilities.getResourceFile(String.valueOf(LANGUAGES_DIR) + DEFAULT_LOCALE.getLngGeoCode() + ".loc") : new File(STATIC_LOCALE);
            if (file.exists()) {
                JDL.parseLanguageFile(file, DEFAULT_DATA);
            } else {
                System.out.println("Could not load the default languagefile: " + file);
            }
        }
    }

    public static void parseLanguageFile(File file, HashMap<Integer, String> hashMap) {
        JDLogger.getLogger().info("parse lng file " + file);
        hashMap.clear();
        if (file == null || !file.exists()) {
            System.out.println("JDLocale: " + file + " not found");
            return;
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.startsWith("#") || (n = string.indexOf("=")) <= 0) continue;
                String string2 = string.substring(0, n).trim().toLowerCase();
                String string3 = String.valueOf(string.substring(n + 1).trim()) + (string.endsWith(" ") ? " " : "");
                string3 = string3.replace("\\r", "\r").replace("\\n", "\n");
                if (string2.startsWith("!")) {
                    JDL.getSettings().put(string2.substring(1), string3);
                }
                hashMap.put(string2.hashCode(), string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
        }
        JDLogger.getLogger().info("parse lng file end " + file);
    }

    public static void setLocale(JDLocale jDLocale) {
        if (jDLocale == null) {
            return;
        }
        LOCALE_ID = jDLocale;
        System.out.println("Loaded language: " + jDLocale);
        File file = LOCALE_FILE = STATIC_LOCALE == null ? JDUtilities.getResourceFile(String.valueOf(LANGUAGES_DIR) + LOCALE_ID.getLngGeoCode() + ".loc") : new File(STATIC_LOCALE);
        if (!LOCALE_FILE.exists()) {
            System.out.println("Language " + LOCALE_ID + " not installed");
            return;
        }
        JDL.parseLanguageFile(LOCALE_FILE, DATA);
        JDL.getBroadcaster().fireEvent(new JDLEvent(jDLocale, 1));
    }

    public static String translate(String string, String string2) {
        return JDL.translate("auto", string, string2);
    }

    public static String translate(String string, String string2, String string3) {
        try {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("hl", "de");
            linkedHashMap.put("text", string3);
            linkedHashMap.put("sl", string);
            linkedHashMap.put("tl", string2);
            linkedHashMap.put("ie", "UTF8");
            Browser browser = new Browser();
            browser.postPage("http://translate.google.com/translate_t", linkedHashMap);
            return Encoding.UTF8Decode((String)Encoding.htmlDecode((String)browser.getRegex("<div id\\=result_box dir\\=\"ltr\">(.*?)</div>").getMatch(0)));
        }
        catch (IOException iOException) {
            JDLogger.exception(iOException);
            return null;
        }
    }

    public static void setStaticLocale(String string) {
        STATIC_LOCALE = string;
    }
}

