/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import it.sauronsoftware.junique.AlreadyLockedException;
import it.sauronsoftware.junique.Lock;
import it.sauronsoftware.junique.Message;
import it.sauronsoftware.junique.MessageHandler;
import it.sauronsoftware.junique.Server;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import jd.utils.JDUtilities;

public class JUnique {
    private static final File LOCK_FILES_DIR = JDUtilities.getResourceFile((String)".junique");
    private static final File GLOBAL_LOCK_FILE = new File(LOCK_FILES_DIR, "global.lock");
    private static FileChannel globalFileChannel = null;
    private static FileLock globalFileLock = null;
    private static Hashtable<String, Lock> locks = new Hashtable();

    static {
        if (!LOCK_FILES_DIR.exists()) {
            LOCK_FILES_DIR.mkdirs();
        }
    }

    public static void acquireLock(String id) throws AlreadyLockedException {
        JUnique.acquireLock(id, null);
    }

    public static void acquireLock(String id, MessageHandler messageHandler) throws AlreadyLockedException {
        block18: {
            String nid = JUnique.normalizeID(id);
            JUnique.j_lock();
            try {
                FileLock fileLock;
                FileChannel fileChannel;
                File lockFile = JUnique.getLockFileForNID(nid);
                File portFile = JUnique.getPortFileForNID(nid);
                LOCK_FILES_DIR.mkdirs();
                try {
                    RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
                    fileChannel = raf.getChannel();
                    fileLock = fileChannel.tryLock();
                    if (fileLock == null) {
                        throw new AlreadyLockedException(id);
                    }
                }
                catch (Throwable t) {
                    throw new AlreadyLockedException(id);
                }
                Server server = new Server(id, messageHandler);
                Lock lock = new Lock(id, lockFile, portFile, fileChannel, fileLock, server);
                locks.put(nid, lock);
                server.start();
                FileWriter portWriter = null;
                try {
                    try {
                        portWriter = new FileWriter(portFile);
                        portWriter.write(String.valueOf(server.getListenedPort()));
                        ((Writer)portWriter).flush();
                    }
                    catch (Throwable throwable) {
                        if (portWriter == null) break block18;
                        try {
                            ((Writer)portWriter).close();
                        }
                        catch (Throwable throwable2) {}
                    }
                }
                finally {
                    if (portWriter != null) {
                        try {
                            ((Writer)portWriter).close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            finally {
                JUnique.j_unlock();
            }
        }
    }

    public static void releaseLock(String id) {
        String nid = JUnique.normalizeID(id);
        JUnique.j_lock();
        try {
            Lock lock = locks.remove(nid);
            if (lock != null) {
                JUnique.releaseLock(lock);
            }
        }
        finally {
            JUnique.j_unlock();
        }
    }

    private static void releaseLock(Lock lock) {
        lock.getServer().stop();
        try {
            lock.getLockFileLock().release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            lock.getLockFileChannel().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        lock.getPortFile().delete();
        lock.getLockFile().delete();
    }

    public static String sendMessage(String id, String message) {
        String response;
        block48: {
            int port;
            block47: {
                port = -1;
                JUnique.j_lock();
                try {
                    String nid = JUnique.normalizeID(id);
                    File portFile = JUnique.getPortFileForNID(nid);
                    BufferedReader reader = null;
                    try {
                        try {
                            reader = new BufferedReader(new FileReader(portFile));
                            String line = reader.readLine();
                            if (line != null) {
                                port = Integer.parseInt(line);
                            }
                        }
                        catch (Throwable line) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {}
                            }
                            break block47;
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                finally {
                    JUnique.j_unlock();
                }
            }
            response = null;
            if (port > 0) {
                Socket socket = null;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    try {
                        InetAddress localhost = InetAddress.getLocalHost();
                        socket = new Socket(localhost, port);
                        inputStream = socket.getInputStream();
                        outputStream = socket.getOutputStream();
                        Message.write(message, outputStream);
                        response = Message.read(inputStream);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (socket == null) break block48;
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        return response;
    }

    private static String normalizeID(String id) {
        int hashcode = id.hashCode();
        boolean positive = hashcode >= 0;
        long longcode = positive ? (long)hashcode : -((long)hashcode);
        StringBuffer hexstring = new StringBuffer(Long.toHexString(longcode));
        while (hexstring.length() < 8) {
            hexstring.insert(0, '0');
        }
        if (positive) {
            hexstring.insert(0, '0');
        } else {
            hexstring.insert(0, '1');
        }
        return hexstring.toString();
    }

    private static File getLockFileForNID(String nid) {
        String filename = String.valueOf(JUnique.normalizeID(nid)) + ".lock";
        return new File(LOCK_FILES_DIR, filename);
    }

    private static File getPortFileForNID(String nid) {
        String filename = String.valueOf(JUnique.normalizeID(nid)) + ".port";
        return new File(LOCK_FILES_DIR, filename);
    }

    private static void j_lock() {
        while (true) {
            LOCK_FILES_DIR.mkdirs();
            try {
                RandomAccessFile raf = new RandomAccessFile(GLOBAL_LOCK_FILE, "rw");
                FileChannel channel = raf.getChannel();
                FileLock lock = channel.lock();
                globalFileChannel = channel;
                globalFileLock = lock;
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private static void j_unlock() {
        FileChannel channel = globalFileChannel;
        FileLock lock = globalFileLock;
        globalFileChannel = null;
        globalFileLock = null;
        try {
            lock.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        public void run() {
            System.out.println("Release Instance: LOCK");
            JUnique.j_lock();
            try {
                ArrayList<String> nids = new ArrayList<String>();
                Enumeration e = locks.keys();
                while (e.hasMoreElements()) {
                    String nid = (String)e.nextElement();
                    nids.add(nid);
                }
                for (String nid : nids) {
                    Lock lock = (Lock)locks.remove(nid);
                    JUnique.releaseLock(lock);
                }
            }
            finally {
                JUnique.j_unlock();
            }
            System.out.println("Release Instance: UNLOCK");
        }
    }
}

