/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Message {
    Message() {
    }

    public static String read(InputStream inputStream) throws IOException {
        byte[] b = new byte[4];
        if (inputStream.read(b) != 4) {
            throw new IOException("Unexpected end of stream");
        }
        int length = b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
        if (length < 0) {
            throw new IOException("Invalid length block");
        }
        if (length == 0) {
            return "";
        }
        byte[] message = new byte[length];
        if (inputStream.read(message) != length) {
            throw new IOException("Unexpected end of stream");
        }
        return new String(message, "UTF-8");
    }

    public static void write(String message, OutputStream outputStream) throws IOException {
        if (message == null) {
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.flush();
        } else {
            int length = message.length();
            byte[] l = new byte[]{(byte)(length >> 24 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
            outputStream.write(l);
            outputStream.flush();
            byte[] b = message.getBytes("UTF-8");
            outputStream.write(b);
            outputStream.flush();
        }
    }
}

