/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.junique;

import it.sauronsoftware.junique.Connection;
import it.sauronsoftware.junique.ConnectionListener;
import it.sauronsoftware.junique.MessageHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;

class Server
implements Runnable,
ConnectionListener {
    private String id;
    private MessageHandler messageHandler;
    private Object synchLock = new Object();
    private ServerSocket serverSocket = null;
    private Thread thread = null;
    private ArrayList<Connection> connections = new ArrayList();

    public Server(String id, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.serverSocket != null) {
                throw new IllegalStateException("JUnique/Server for id \"" + this.id + "\" already started");
            }
            try {
                InetAddress localhost;
                this.serverSocket = new ServerSocket();
                try {
                    localhost = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    localhost = InetAddress.getByName(null);
                }
                InetSocketAddress socketAddress = new InetSocketAddress(localhost, 0);
                this.serverSocket.bind(socketAddress);
            }
            catch (IOException e) {
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw new RuntimeException("Unexpected IOException while starting JUnique/Server for id \"" + this.id + "\"", e);
            }
            this.thread = new Thread((Runnable)this, "JUnique/Server/" + this.id);
            this.thread.setDaemon(true);
            this.thread.start();
            while (true) {
                try {
                    this.synchLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.serverSocket == null) {
                throw new IllegalStateException("JUnique/Server for id \"" + this.id + "\" not started");
            }
            while (true) {
                if (this.connections.size() <= 0) {
                    this.thread.interrupt();
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    break;
                }
                Connection c = this.connections.remove(0);
                c.stop();
            }
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.serverSocket = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = this.synchLock;
        synchronized (var1_1) {
            this.synchLock.notify();
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl24
        }
        do {
            try {
                incoming = this.serverSocket.accept();
                c = new Connection(this.id, incoming, this);
                var3_4 = this.synchLock;
                synchronized (var3_4) {
                    this.connections.add(c);
                    c.start();
                }
            }
            catch (Throwable var1_2) {
                // empty catch block
            }
lbl24:
            // 3 sources

        } while (!Thread.interrupted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenedPort() throws IllegalStateException {
        Object object = this.synchLock;
        synchronized (object) {
            if (this.serverSocket == null) {
                throw new IllegalStateException("JUnique/Server for id \"" + this.id + "\" not started");
            }
            return this.serverSocket.getLocalPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        ArrayList<Connection> arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String messageReceived(Connection connection, String message) {
        if (this.messageHandler != null) {
            MessageHandler messageHandler = this.messageHandler;
            synchronized (messageHandler) {
                return this.messageHandler.handle(message);
            }
        }
        return null;
    }
}

