/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.hjsplit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.ProgressController;
import jd.controlling.SingleDownloadController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.Formatter;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginOptional;
import jd.plugins.optional.hjsplit.FileSignatures;
import jd.plugins.optional.hjsplit.Signature;
import jd.plugins.optional.hjsplit.jaxe.JAxeJoiner;
import jd.plugins.optional.hjsplit.jaxe.JoinerFactory;
import jd.plugins.optional.hjsplit.jaxe.ProgressEvent;
import jd.plugins.optional.hjsplit.jaxe.ProgressEventListener;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9563 $", defaultEnabled=true, id="hjsplit", interfaceversion=5)
public class JDHJSplit
extends PluginOptional
implements ControlListener {
    private static final String CONFIG_KEY_REMOVE_MERGED = "REMOVE_MERGED";
    private static final String DUMMY_HOSTER = "dum.my";
    private static final int ARCHIVE_TYPE_NONE = -1;
    private static final int ARCHIVE_TYPE_NORMAL = 0;
    private static final int ARCHIVE_TYPE_UNIX = 1;
    private static final String CONFIG_KEY_OVERWRITE = "OVERWRITE";
    private Jobber queue = new Jobber(1);

    public JDHJSplit(PluginWrapper wrapper) {
        super(wrapper);
        this.initConfig();
    }

    public String getIconKey() {
        return "gui.images.addons.merge";
    }

    public void controlEvent(ControlEvent event) {
        super.controlEvent(event);
        switch (event.getID()) {
            case 4: {
                if (!(event.getSource() instanceof PluginForHost)) {
                    return;
                }
                if (!this.getPluginConfig().getBooleanProperty("ACTIVATED", true).booleanValue()) break;
                DownloadLink link = ((SingleDownloadController)event.getParameter()).getDownloadLink();
                File file = new File(link.getFileOutput());
                if (!link.getLinkStatus().isFinished()) break;
                if ((file = this.getStartFile(file)) == null) {
                    return;
                }
                if (!this.validateArchive(file)) break;
                this.addFileList(new File[]{file});
                break;
            }
            case 33: {
                this.addFileList((File[])event.getParameter());
                break;
            }
            case 22: {
                ArrayList items = (ArrayList)event.getParameter();
                if (event.getSource() instanceof DownloadLink) {
                    DownloadLink link = (DownloadLink)event.getSource();
                    MenuAction m = new MenuAction("optional.jdhjsplit.linkmenu.merge", 1000);
                    items.add(m);
                    m.setActionListener((ActionListener)((Object)this));
                    m.setEnabled(false);
                    if (link.getLinkStatus().hasStatus(2) && this.isStartVolume(new File(link.getFileOutput()))) {
                        m.setEnabled(true);
                    }
                    if (new File(link.getFileOutput()).exists() && link.getName().matches(".*rar$")) {
                        m.setEnabled(true);
                    }
                    m.setProperty("LINK", (Object)link);
                    break;
                }
                FilePackage fp = (FilePackage)event.getSource();
                MenuAction m = new MenuAction("optional.jdhjsplit.linkmenu.package.merge", 1001);
                items.add(m);
                m.setActionListener((ActionListener)((Object)this));
                m.setProperty("PACKAGE", (Object)fp);
            }
        }
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        MenuAction m = new MenuAction("optional.hjsplit.menu.toggle", 1);
        menu.add(m);
        m.setActionListener((ActionListener)((Object)this));
        m.setSelected(this.getPluginConfig().getBooleanProperty("ACTIVATED", true).booleanValue());
        m = new MenuAction("optional.hjsplit.menu.extract.singlefils", 21);
        menu.add(m);
        m.setActionListener((ActionListener)((Object)this));
        return menu;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuAction) {
            this.menuitemActionPerformed((MenuAction)e.getSource());
        }
    }

    private void menuitemActionPerformed(MenuAction source) {
        SubConfiguration cfg = this.getPluginConfig();
        switch (source.getActionID()) {
            case 1: {
                cfg.setProperty("ACTIVATED", (Object)(cfg.getBooleanProperty("ACTIVATED", true) == false ? 1 : 0));
                cfg.save();
                break;
            }
            case 21: {
                JDFileChooser fc = new JDFileChooser("_JDHJSPLIT_");
                fc.setMultiSelectionEnabled(true);
                javax.swing.filechooser.FileFilter ff = new javax.swing.filechooser.FileFilter(){

                    public boolean accept(File pathname) {
                        if (JDHJSplit.this.isStartVolume(pathname)) {
                            return true;
                        }
                        return pathname.isDirectory();
                    }

                    public String getDescription() {
                        return JDL.L((String)"plugins.optional.hjsplit.filefilter", (String)"HJSPLIT-Startvolumes");
                    }
                };
                fc.setFileFilter(ff);
                if (fc.showOpenDialog((Component)SwingGui.getInstance().getMainFrame()) != 0) break;
                File[] list = fc.getSelectedFiles();
                if (list == null) {
                    return;
                }
                this.addFileList(list);
                break;
            }
            case 1000: {
                File file = new File(((DownloadLink)source.getProperty("LINK")).getFileOutput());
                file = this.getStartFile(file);
                if (!this.validateArchive(file)) break;
                this.addFileList(new File[]{file});
                break;
            }
            case 1001: {
                FilePackage fp = (FilePackage)source.getProperty("PACKAGE");
                ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
                for (DownloadLink l : fp.getDownloadLinkList()) {
                    File file;
                    if (!l.getLinkStatus().hasStatus(2) || !this.validateArchive(file = new File(l.getFileOutput()))) continue;
                    links.add(l);
                }
                if (links.size() <= 0) {
                    return;
                }
                this.addFileList(links.toArray(new File[0]));
            }
        }
    }

    private void addFileList(File[] list) {
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File archiveStartFile = fileArray[n2];
            if (this.isStartVolume(archiveStartFile)) {
                boolean b = this.validateArchive(archiveStartFile);
                if (!b) {
                    logger.info("Archive " + archiveStartFile + " is incomplete or no archive. Validation failed");
                    return;
                }
                DownloadLink link = JDUtilities.getController().getDownloadLinkByFileOutput(archiveStartFile, Integer.valueOf(2));
                if (link == null) {
                    link = this.createDummyLink(archiveStartFile);
                }
                DownloadLink finalLink = link;
                this.addToQueue(finalLink);
            }
            ++n2;
        }
    }

    private void addToQueue(final DownloadLink link) {
        this.queue.add(new JDRunnable(){

            public void go() {
                final File output = JDHJSplit.this.getOutputFile(new File(link.getFileOutput()));
                if (output == null) {
                    return;
                }
                final ProgressController progress = new ProgressController("Default HJMerge", 100L);
                JAxeJoiner join = JoinerFactory.getJoiner(new File(link.getFileOutput()));
                join.setProgressEventListener(new ProgressEventListener(){
                    long last = System.currentTimeMillis() + 1000L;

                    public void handleEvent(ProgressEvent pe) {
                        try {
                            if (System.currentTimeMillis() - this.last > 100L) {
                                progress.setStatus((long)((int)(pe.getCurrent() * 100L / pe.getMax())));
                                this.last = System.currentTimeMillis();
                                progress.setStatusText(JDL.LF((String)"plugins.optional.hjsplit.merged", (String)"%s: %s MB merged", (Object[])new Object[]{output.getName(), pe.getCurrent() / 0x100000L}));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                if (JDHJSplit.this.getPluginConfig().getBooleanProperty(JDHJSplit.CONFIG_KEY_OVERWRITE, false).booleanValue() && output.exists()) {
                    output.delete();
                }
                try {
                    ArrayList list;
                    join.run();
                    if (join.wasSuccessfull() && JDHJSplit.this.getPluginConfig().getBooleanProperty(JDHJSplit.CONFIG_KEY_REMOVE_MERGED, false).booleanValue() && (list = JDHJSplit.this.getFileList(new File(link.getFileOutput()))) != null) {
                        for (File f : list) {
                            f.delete();
                            f.deleteOnExit();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                progress.doFinalize();
                JDUtilities.getController().fireControlEvent(new ControlEvent((Object)this, 33, (Object)new File[]{output}));
            }
        });
        this.queue.start();
    }

    private File getOutputFile(File file) {
        int type = this.getArchiveType(file);
        switch (type) {
            case 1: {
                return new File(file.getParentFile(), file.getName().replaceFirst("\\.a.$", ""));
            }
            case 0: {
                return new File(file.getParentFile(), file.getName().replaceFirst("\\.[\\d]+($|\\.[^\\d]*$)", ""));
            }
        }
        return null;
    }

    private boolean validateArchive(File file) {
        File startFile = this.getStartFile(file);
        if (startFile == null || !startFile.exists() || !startFile.isFile()) {
            return false;
        }
        int type = this.getArchiveType(file);
        switch (type) {
            case 1: {
                return this.typeCrossCheck(this.validateUnixType(startFile)) != null;
            }
            case 0: {
                return this.typeCrossCheck(this.validateNormalType(startFile)) != null;
            }
        }
        return false;
    }

    private ArrayList<File> getFileList(File file) {
        File startFile = this.getStartFile(file);
        if (startFile == null || !startFile.exists() || !startFile.isFile()) {
            return null;
        }
        int type = this.getArchiveType(file);
        switch (type) {
            case 1: {
                return this.validateUnixType(startFile);
            }
            case 0: {
                return this.validateNormalType(startFile);
            }
        }
        return null;
    }

    private ArrayList<File> validateNormalType(File file) {
        final String matcher = file.getName().replaceAll("\\[|\\]|\\(|\\)|\\?", ".").replaceFirst("\\.[\\d]+($|\\.[^\\d]*$)", "\\\\.[\\\\d]+$1");
        ArrayList missing = JDUtilities.getController().getDownloadLinksByNamePattern(matcher);
        if (missing == null) {
            return null;
        }
        for (DownloadLink miss : missing) {
            File par2;
            if (!miss.getLinkStatus().isFinished()) {
                return null;
            }
            File par1 = new File(miss.getFileOutput()).getParentFile();
            if (!par1.equals(par2 = file.getParentFile()) || new File(miss.getFileOutput()).exists()) continue;
            return null;
        }
        File[] files = file.getParentFile().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().matches(matcher);
            }
        });
        int c = 1;
        ArrayList<File> ret = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            String volume = Formatter.fillString((String)String.valueOf(c), (String)"0", (String)"", (int)3);
            File newFile = new File(file.getParentFile(), file.getName().replaceFirst("\\.[\\d]+($|\\.[^\\d]*$)", "\\." + volume + "$1"));
            if (newFile.exists()) {
                ++c;
            } else {
                return null;
            }
            ret.add(newFile);
            ++i;
        }
        String volume = Formatter.fillString((String)String.valueOf(c), (String)"0", (String)"", (int)3);
        if (JDUtilities.getController().getDownloadLinkByFileOutput(new File(file.getParentFile(), file.getName().replaceFirst("\\.[\\d]+($|\\.[^\\d]*$)", "\\." + volume + "$1")), null) != null) {
            return null;
        }
        return ret;
    }

    private ArrayList<File> typeCrossCheck(ArrayList<File> files) {
        if (files == null) {
            return null;
        }
        int ArchiveCheckFailed = 0;
        for (File file : files) {
            try {
                Signature fs = FileSignatures.getFileSignature(file);
                if (fs == null || !fs.getId().equals("RAR") && !fs.getId().equals("\ufeff7Z")) continue;
                ++ArchiveCheckFailed;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ArchiveCheckFailed > 1) {
            logger.warning("Found more than 1 non-HJArchive Header, skip HJMerge!");
            return null;
        }
        return files;
    }

    private ArrayList<File> validateUnixType(File file) {
        final String matcher = file.getName().replaceAll("\\[|\\]|\\(|\\)|\\?", ".").replaceFirst("\\.a.($|\\..*)", "\\\\.a.$1");
        ArrayList missing = JDUtilities.getController().getDownloadLinksByNamePattern(matcher);
        if (missing == null) {
            return null;
        }
        for (DownloadLink miss : missing) {
            if (!miss.getLinkStatus().isFinished()) {
                return null;
            }
            if (new File(miss.getFileOutput()).exists() && new File(miss.getFileOutput()).getParentFile().equals(file.getParentFile())) continue;
            return null;
        }
        File[] files = file.getParentFile().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().matches(matcher);
            }
        });
        ArrayList<File> ret = new ArrayList<File>();
        char c = 'a';
        int i = 0;
        while (i < files.length) {
            File newFile = new File(file.getParentFile(), file.getName().replaceFirst("\\.a.($|\\..*)", "\\.a" + c + "$1"));
            if (!newFile.exists()) {
                return null;
            }
            ret.add(newFile);
            c = (char)(c + '\u0001');
            ++i;
        }
        if (JDUtilities.getController().getDownloadLinkByFileOutput(new File(file.getParentFile(), file.getName().replaceFirst("\\.a.($|\\..*)", "\\.a" + c + "$1")), null) != null) {
            return null;
        }
        return ret;
    }

    private File getStartFile(File file) {
        int type = this.getArchiveType(file);
        switch (type) {
            case 1: {
                return new File(file.getParentFile(), file.getName().replaceFirst("\\.a.$", ".aa"));
            }
            case 0: {
                return new File(file.getParentFile(), file.getName().replaceFirst("\\.[\\d]+($|\\.[^\\d]*$)", ".001$1"));
            }
        }
        return null;
    }

    private boolean isStartVolume(File file) {
        if (file.getName().matches(".*\\.aa$")) {
            return true;
        }
        return file.getName().matches(".*\\.001($|\\.[^\\d]*$)");
    }

    private int getArchiveType(File file) {
        String name = file.getName();
        if (name.matches(".*\\.a.$")) {
            return 1;
        }
        if (name.matches(".*\\.[\\d]+($|\\.[^\\d]*$)")) {
            return 0;
        }
        return -1;
    }

    private DownloadLink createDummyLink(File archiveStartFile) {
        DownloadLink link = new DownloadLink(null, archiveStartFile.getName(), DUMMY_HOSTER, "", true);
        link.setDownloadSize(archiveStartFile.length());
        FilePackage fp = FilePackage.getInstance();
        fp.setDownloadDirectory(archiveStartFile.getParent());
        link.setFilePackage(fp);
        return link;
    }

    public boolean initAddon() {
        JDUtilities.getController().addControlListener((ControlListener)this);
        return true;
    }

    public void initConfig() {
        SubConfiguration subConfig = this.getPluginConfig();
        ConfigEntry ce = new ConfigEntry(3, (Property)subConfig, CONFIG_KEY_REMOVE_MERGED, JDL.L((String)"gui.config.hjsplit.remove_merged", (String)"Delete archive after merging"));
        this.config.addEntry(ce);
        ce.setDefaultValue((Object)true);
        ce = new ConfigEntry(3, (Property)subConfig, CONFIG_KEY_OVERWRITE, JDL.L((String)"gui.config.hjsplit.overwrite", (String)"Overwrite existing files"));
        this.config.addEntry(ce);
        ce.setDefaultValue((Object)true);
    }

    public void onExit() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }
}

