/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.hjsplit.jaxe;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private int iLastRead = 0;
    private InputStream is;
    private long lRead = 0L;
    private long lTotal = -1L;

    public CountingInputStream(InputStream input) {
        this.is = input;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public long getDiff() {
        return this.lTotal - this.lRead;
    }

    public int getLastRead() {
        return this.iLastRead;
    }

    public int getLastReadAndReset() {
        int i = this.iLastRead;
        this.iLastRead = 0;
        return i;
    }

    public long getRead() {
        return this.lRead;
    }

    public void mark(int i) {
        this.is.mark(i);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public int read() throws IOException {
        ++this.lRead;
        this.iLastRead = 1;
        return this.is.read();
    }

    public int read(byte[] ba) throws IOException {
        this.iLastRead = this.is.read(ba);
        this.lRead += (long)this.iLastRead;
        return this.iLastRead;
    }

    public int read(byte[] ba, int off, int len) throws IOException {
        this.iLastRead = this.is.read(ba, off, len);
        this.lRead += (long)this.iLastRead;
        return this.iLastRead;
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public void setTotal(long l) {
        this.lTotal = l;
    }

    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }
}

