/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.hjsplit.jaxe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jd.plugins.optional.hjsplit.jaxe.JAxeJoiner;
import jd.plugins.optional.hjsplit.jaxe.JobEndEvent;
import jd.plugins.optional.hjsplit.jaxe.JobErrorEvent;
import jd.plugins.optional.hjsplit.jaxe.UnixSplitFileFilter;

public class UnixSplitJoiner
extends JAxeJoiner {
    public UnixSplitJoiner(String sFile) {
        super(sFile);
        this.sDestDir = new File(sFile).getParent();
    }

    public UnixSplitJoiner(String sFile, String sDir) {
        super(sFile, sDir);
    }

    protected boolean checkNoOverwrite(File f) {
        File fTemp = new File(this.sJoinedFile);
        return !fTemp.exists();
    }

    protected void computeJobSize() {
        File fTemp;
        long lReturn = 0L;
        int i = 0;
        do {
            fTemp = new File(String.valueOf(this.sJoinedFile) + this.getSuffix(i));
            lReturn += fTemp.length();
            ++i;
        } while (fTemp.exists());
        this.lJobSize = lReturn;
    }

    protected void doCleanup() {
        new File(this.sJoinedFile).delete();
    }

    private String getSuffix(int n) {
        char[] ca = new char[]{(char)(97 + n / 26), (char)(97 + n % 26)};
        return "." + new String(ca);
    }

    public void run() {
        BufferedOutputStream bos;
        File fTemp = null;
        InputStream is = null;
        int i = 1;
        byte[] ba = new byte[1024];
        this.bStopped = false;
        File fToJoin = new File(this.sFileToJoin);
        if (!UnixSplitFileFilter.isSplitFile(this.sFileToJoin)) {
            this.dispatchEvent(new JobErrorEvent(this, "File to join does not seem a file split using Unix split"));
            return;
        }
        this.sJoinedFile = UnixSplitFileFilter.getJoinedFileName(this.sFileToJoin);
        System.out.println("Joined file: " + this.sJoinedFile);
        if (!fToJoin.exists() || fToJoin.isDirectory()) {
            this.dispatchEvent(new JobErrorEvent(this, "File to join does not exist or is a directory"));
            return;
        }
        if (!this.checkNoOverwrite(fToJoin)) {
            this.dispatchEvent(new JobErrorEvent(this, "Error: destination file already exists!"));
            return;
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(this.sJoinedFile));
        }
        catch (FileNotFoundException fnfe) {
            this.dispatchEvent(new JobErrorEvent(this, "Error while opening: " + this.sJoinedFile + " (" + fnfe.getMessage() + ")"));
            return;
        }
        this.computeJobSize();
        System.out.println("Job size: " + this.lJobSize);
        this.initProgress();
        i = 0;
        try {
            try {
                do {
                    if (is == null) {
                        fTemp = i == 0 ? new File(this.sFileToJoin) : new File(String.valueOf(this.sJoinedFile) + this.getSuffix(i));
                        if (!fTemp.exists()) {
                            break;
                        }
                        is = new BufferedInputStream(new FileInputStream(fTemp));
                    }
                    if (this.bStopped) continue;
                    int nLength = is.read(ba, 0, 1024);
                    if (nLength > 0) {
                        bos.write(ba, 0, nLength);
                        this.lCurrent += (long)nLength;
                        this.dispatchProgress();
                        continue;
                    }
                    ++i;
                    is.close();
                    is = null;
                } while (!this.bStopped);
            }
            catch (FileNotFoundException fnfe) {
                this.dispatchEvent(new JobErrorEvent(this, "Error while opening: " + fTemp.getName()));
                try {
                    bos.close();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            catch (IOException ioe) {
                this.dispatchEvent(new JobErrorEvent(this, "I/O error with file " + fTemp.getName() + " (" + ioe.getMessage() + ")"));
                try {
                    bos.close();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                bos.close();
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.bStopped) {
            this.doCleanup();
            this.dispatchEvent(new JobEndEvent(this, "Join stopped by user."));
        } else {
            this.dispatchProgress(this.lJobSize);
            this.dispatchEvent(new JobEndEvent(this, "Join terminated."));
        }
    }
}

