/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ImageIcon;
import jd.PluginWrapper;
import jd.controlling.LinkGrabberController;
import jd.controlling.LinkGrabberPackagingEvent;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.plugins.DownloadLink;
import jd.plugins.LinkGrabberFilePackage;
import jd.plugins.LinkGrabberFilePackageListener;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.plugins.optional.customizer.CustomizeSetting;
import jd.plugins.optional.customizer.CustomizerGui;
import jd.plugins.optional.customizer.CustomizerView;
import jd.utils.JDTheme;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9366 $", id="packagecustomizer", hasGui=true, interfaceversion=5)
public class JDPackageCustomizer
extends PluginOptional
implements LinkGrabberPackagingEvent {
    private static final String JDL_PREFIX = "jd.plugins.optional.customizer.JDPackageCustomizer.";
    private static final String PROPERTY_ENABLE = "ENABLE";
    public static final String PROPERTY_SETTINGS = "SETTINGS";
    private LinkGrabberController ctrl;
    private final ImageIcon customIcon = JDTheme.II((String)"gui.images.newpackage", (int)16, (int)16);
    private final String customIconText = JDL.L((String)"jd.plugins.optional.customizer.JDPackageCustomizer.customized", (String)"Customized with the Regex %s");
    private CustomizerView view;
    private MenuAction enableAction;
    private MenuAction showAction;

    public JDPackageCustomizer(PluginWrapper wrapper) {
        super(wrapper);
    }

    public String getIconKey() {
        return "gui.images.newpackage";
    }

    public boolean initAddon() {
        this.ctrl = LinkGrabberController.getInstance();
        this.ctrl.setCustomizedPackager((LinkGrabberPackagingEvent)this);
        this.enableAction = new MenuAction(this.getWrapper().getID(), 1);
        this.enableAction.setActionListener((ActionListener)((Object)this));
        this.enableAction.setTitle(JDL.L((String)"jd.plugins.optional.customizer.JDPackageCustomizer.enabled", (String)"Enable Customizer"));
        this.enableAction.setSelected(this.getPluginConfig().getBooleanProperty(PROPERTY_ENABLE, true).booleanValue());
        this.showAction = new MenuAction(this.getWrapper().getID(), 0);
        this.showAction.setActionListener((ActionListener)((Object)this));
        this.showAction.setTitle(JDL.L((String)"jd.plugins.optional.customizer.JDPackageCustomizer.settings", (String)"Show Settings-GUI"));
        this.showAction.setSelected(false);
        logger.info("Customizer OK");
        return true;
    }

    public void onExit() {
        this.ctrl.setCustomizedPackager(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.enableAction) {
            this.getPluginConfig().setProperty(PROPERTY_ENABLE, (Object)this.enableAction.isSelected());
            this.getPluginConfig().save();
        } else if (e.getSource() == this.showAction) {
            if (this.showAction.isSelected()) {
                this.showGui();
            } else {
                this.view.close();
            }
        }
    }

    private void showGui() {
        if (this.view == null) {
            this.view = new CustomizerView();
            this.view.getBroadcaster().addListener((EventListener)new SwitchPanelListener(){

                public void onPanelEvent(SwitchPanelEvent event) {
                    if (event.getID() == 3) {
                        JDPackageCustomizer.this.showAction.setSelected(false);
                    }
                }
            });
            this.view.setContent(new CustomizerGui(this.getPluginConfig()));
        }
        this.showAction.setSelected(true);
        JDGui.getInstance().setContent((SwitchPanel)this.view);
    }

    public void setGuiEnable(boolean b) {
        if (b) {
            this.showGui();
        } else if (this.view != null) {
            this.view.close();
        }
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        menu.add(this.enableAction);
        menu.add(new MenuAction(ToolBarAction.Types.SEPARATOR));
        menu.add(this.showAction);
        return menu;
    }

    public void attachToPackagesFirstStage(DownloadLink link) {
        this.ctrl.attachToPackagesFirstStageInternal(link);
    }

    public void attachToPackagesSecondStage(DownloadLink link) {
        if (this.enableAction.isSelected()) {
            ArrayList settings = (ArrayList)this.getPluginConfig().getGenericProperty(PROPERTY_SETTINGS, new ArrayList());
            for (CustomizeSetting setting : settings) {
                LinkGrabberFilePackage fp;
                if (!setting.isEnabled() || !setting.matches(link.getName())) continue;
                logger.info("Customizer: Using customization of filepackage for link " + link.getName());
                if (this.ctrl.isExtensionFiltered(link)) {
                    this.ctrl.getFilterPackage().add(link);
                    return;
                }
                String packageName = setting.getPackageName();
                if (packageName == null || packageName.equals("")) {
                    fp = this.ctrl.getGeneratedPackage(link);
                } else {
                    fp = this.ctrl.getFPwithName(packageName);
                    if (fp == null) {
                        fp = new LinkGrabberFilePackage(packageName, (LinkGrabberFilePackageListener)this.ctrl);
                    }
                }
                fp.setExtractAfterDownload(setting.isExtract());
                fp.setDownloadDirectory(setting.getDownloadDir());
                fp.setUseSubDir(setting.isUseSubDirectory());
                fp.setPassword(setting.getPassword());
                fp.add(link);
                link.setPriority(setting.getPriority());
                fp.setCustomIcon(this.customIcon, String.format(this.customIconText, setting.getRegex()));
                link.setCustomIcon(this.customIcon, String.format(this.customIconText, setting.getRegex()));
                setting.incMatchCount();
                return;
            }
        }
        LinkGrabberController.getInstance().attachToPackagesSecondStageInternal(link);
    }
}

