/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.SpecialEntities;

public class Utils {
    public static String ltrim(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return n >= n2 ? "" : string.substring(n);
    }

    public static String rtrim(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = n = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return n2 <= 0 ? "" : string.substring(0, n2);
    }

    public static StringBuffer readUrl(URL uRL, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Object object = uRL.getContent();
        if (object instanceof InputStream) {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, string);
            char[] cArray = new char[1024];
            int n = 0;
            do {
                if ((n = inputStreamReader.read(cArray)) < 0) continue;
                stringBuffer.append(cArray, 0, n);
            } while (n > 0);
        }
        return stringBuffer;
    }

    public static boolean isHexadecimalDigit(char c) {
        return Character.isDigit(c) || c == 'A' || c == 'a' || c == 'B' || c == 'b' || c == 'C' || c == 'c' || c == 'D' || c == 'd' || c == 'E' || c == 'e' || c == 'F' || c == 'f';
    }

    public static String escapeXml(String string, CleanerProperties cleanerProperties, boolean bl) {
        boolean bl2 = cleanerProperties.isAdvancedXmlEscape();
        boolean bl3 = cleanerProperties.isRecognizeUnicodeChars();
        boolean bl4 = cleanerProperties.isTranslateSpecialEntities();
        if (string != null) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '&') {
                    String string2;
                    Integer n2;
                    String string3;
                    int n3;
                    if ((bl2 || bl3) && i < n - 1 && string.charAt(i + 1) == '#') {
                        int n4;
                        String string4 = "";
                        for (n4 = i + 2; n4 < n && (Utils.isHexadecimalDigit(string.charAt(n4)) || string.charAt(n4) == 'x' || string.charAt(n4) == 'X'); ++n4) {
                            string4 = string4 + string.charAt(n4);
                        }
                        if (n4 == n || !"".equals(string4)) {
                            try {
                                char c2;
                                char c3 = c2 = string4.toLowerCase().startsWith("x") ? (char)Integer.parseInt(string4.substring(1), 16) : (char)Integer.parseInt(string4);
                                if ("&<>'\"".indexOf(c2) < 0) {
                                    int n5 = n4 < n && string.charAt(n4) == ';' ? string4.length() + 1 : string4.length();
                                    stringBuffer.append(bl3 ? String.valueOf(c2) : "&#" + string4 + ";");
                                    i += n5 + 1;
                                    continue;
                                }
                                i = n4;
                                stringBuffer.append("&amp;#" + string4 + ";");
                            }
                            catch (NumberFormatException numberFormatException) {
                                i = n4;
                                stringBuffer.append("&amp;#" + string4 + ";");
                            }
                            continue;
                        }
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (bl4 && (n3 = (string3 = string.substring(i, i + Math.min(10, n - i))).indexOf(59)) > 0 && (n2 = (Integer)SpecialEntities.entities.get(string2 = string3.substring(1, n3))) != null) {
                        int n6 = string2.length();
                        if (bl3) {
                            stringBuffer.append((char)n2.intValue());
                        } else {
                            stringBuffer.append("&#" + n2 + ";");
                        }
                        i += n6 + 1;
                        continue;
                    }
                    if (bl2) {
                        String string5 = string.substring(i);
                        if (string5.startsWith("&amp;")) {
                            stringBuffer.append(bl ? "&" : "&amp;");
                            i += 4;
                            continue;
                        }
                        if (string5.startsWith("&apos;")) {
                            stringBuffer.append(bl ? "'" : "&apos;");
                            i += 5;
                            continue;
                        }
                        if (string5.startsWith("&gt;")) {
                            stringBuffer.append(bl ? ">" : "&gt;");
                            i += 3;
                            continue;
                        }
                        if (string5.startsWith("&lt;")) {
                            stringBuffer.append(bl ? "<" : "&lt;");
                            i += 3;
                            continue;
                        }
                        if (string5.startsWith("&quot;")) {
                            stringBuffer.append(bl ? "\"" : "&quot;");
                            i += 5;
                            continue;
                        }
                        stringBuffer.append(bl ? "&" : "&amp;");
                        continue;
                    }
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c == '\'') {
                    stringBuffer.append("&apos;");
                    continue;
                }
                if (c == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append("&quot;");
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isWhitespaceString(Object object) {
        if (object != null) {
            String string = object.toString();
            return string != null && "".equals(string.trim());
        }
        return false;
    }
}

