/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import net.java.balloontip.styles.BalloonTipStyle;

public class MinimalBalloonStyle
extends BalloonTipStyle {
    private int arcWidth;
    private Color fillColor;

    public MinimalBalloonStyle(Color color, int n) {
        this.fillColor = color;
        this.arcWidth = n;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcWidth, this.arcWidth, this.arcWidth, this.arcWidth);
        }
        return new Insets(this.arcWidth, this.arcWidth, this.arcWidth + this.verticalOffset, this.arcWidth);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.flipY) {
            n6 = n2 + this.verticalOffset;
            n5 = n2 + n4;
        } else {
            n6 = n2;
            n5 = n2 + n4 - this.verticalOffset;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n + this.arcWidth, n6);
        generalPath.quadTo(n, n6, n, n6 + this.arcWidth);
        generalPath.lineTo(n, n5 - this.arcWidth);
        generalPath.quadTo(n, n5, n + this.arcWidth, n5);
        if (!this.flipX && !this.flipY) {
            generalPath.lineTo(n + this.horizontalOffset - this.verticalOffset, n5);
            generalPath.lineTo(n + this.horizontalOffset, n5 + this.verticalOffset);
            generalPath.lineTo(n + this.horizontalOffset + this.verticalOffset, n5);
        } else if (this.flipX && !this.flipY) {
            generalPath.lineTo(n + n3 - this.horizontalOffset - this.verticalOffset, n5);
            generalPath.lineTo(n + n3 - this.horizontalOffset, n5 + this.verticalOffset);
            generalPath.lineTo(n + n3 - this.horizontalOffset + this.verticalOffset, n5);
        }
        generalPath.lineTo(n + n3 - this.arcWidth, n5);
        generalPath.quadTo(n + n3, n5, n + n3, n5 - this.arcWidth);
        generalPath.lineTo(n + n3, n6 + this.arcWidth);
        generalPath.quadTo(n + n3, n6, n + n3 - this.arcWidth, n6);
        if (!this.flipX && this.flipY) {
            generalPath.lineTo(n + this.horizontalOffset + this.verticalOffset, n6);
            generalPath.lineTo(n + this.horizontalOffset, n6 - this.verticalOffset);
            generalPath.lineTo(n + this.horizontalOffset - this.verticalOffset, n6);
        } else if (this.flipX && this.flipY) {
            generalPath.lineTo(n + n3 - this.horizontalOffset + this.verticalOffset, n6);
            generalPath.lineTo(n + n3 - this.horizontalOffset, n6 - this.verticalOffset);
            generalPath.lineTo(n + n3 - this.horizontalOffset - this.verticalOffset, n6);
        }
        generalPath.closePath();
        graphics2D.setPaint(this.fillColor);
        graphics2D.fill(generalPath);
    }

    @Override
    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset;
    }

    @Override
    public boolean isBorderOpaque() {
        return this.fillColor.getAlpha() == 255;
    }
}

