/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.schedule;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import jd.plugins.optional.schedule.Actions;
import jd.plugins.optional.schedule.Executions;
import jd.plugins.optional.schedule.MainGui;
import jd.plugins.optional.schedule.Schedule;
import jd.plugins.optional.schedule.modules.SchedulerModuleInterface;
import jd.utils.locale.JDL;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class AddGui
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener,
MouseListener {
    private static final long serialVersionUID = 8080132393187788526L;
    private MainGui gui;
    private Schedule schedule;
    private MyTableModel tableModel;
    private JXTable table;
    private Actions orgact;
    private JComboBox cboActions;
    private JButton add;
    private JTextField parameter;
    private JButton delete;
    private JTextField name;
    private JRadioButton optDate;
    private JRadioButton optDaily;
    private JSpinner day;
    private JSpinner month;
    private JSpinner year;
    private JSpinner hour;
    private JSpinner minute;
    private JPanel datepre;
    private JButton cancel;
    private JButton save;
    private JLabel problems;
    private JRadioButton optHourly;
    private JRadioButton optWeekly;
    private JRadioButton optSpecific;
    private JSpinner repeathour;
    private JSpinner repeatminute;
    private boolean edit;
    private Actions editact;

    public AddGui(Schedule schedule, MainGui gui, Actions act, boolean edit) {
        this.schedule = schedule;
        this.gui = gui;
        this.orgact = act;
        this.editact = new Actions(this.orgact.getName());
        this.editact.setDate(this.orgact.getDate());
        this.editact.setRepeat(this.orgact.getRepeat());
        this.editact.setEnabled(this.orgact.isEnabled());
        this.editact.setAlreadyHandled(this.orgact.wasAlreadyHandled());
        for (Executions e : this.orgact.getExecutions()) {
            this.editact.addExecutions(new Executions(e.getModule(), e.getParameter()));
        }
        this.edit = edit;
        this.setLayout((LayoutManager)new MigLayout("wrap 1, fill", "[fill, grow]"));
        JPanel main = new JPanel((LayoutManager)new MigLayout("ins 5, wrap 1", "[fill, grow]", "[fill, grow][]"));
        JPanel date = new JPanel();
        date.setLayout((LayoutManager)new MigLayout("ins 5, wrap 2", "[fill, grow]10[fill, grow]"));
        date.setBorder(BorderFactory.createLineBorder(this.getBackground().darker()));
        date.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.name", (String)"Name")));
        this.name = new JTextField(act.getName());
        this.name.getDocument().addDocumentListener(this);
        date.add((Component)this.name, "w 20%");
        JPanel repeats = new JPanel();
        repeats.setLayout((LayoutManager)new MigLayout("wrap 2", "[fill, grow][fill, grow]"));
        this.optDate = new JRadioButton(JDL.L((String)"plugin.optional.scheduler.add.once", (String)"Only once"));
        this.optDate.setSelected(true);
        repeats.add((Component)this.optDate, "split 4");
        this.optHourly = new JRadioButton(JDL.L((String)"plugin.optional.scheduler.add.hourly", (String)"Hourly"));
        repeats.add((Component)this.optHourly, "");
        this.optDaily = new JRadioButton(JDL.L((String)"plugin.optional.scheduler.add.daily", (String)"Daily"));
        repeats.add((Component)this.optDaily, "");
        this.optWeekly = new JRadioButton(JDL.L((String)"plugin.optional.scheduler.add.weekly", (String)"Weekly"));
        repeats.add((Component)this.optWeekly, "");
        this.optSpecific = new JRadioButton(JDL.L((String)"plugin.optional.scheduler.add.specific", (String)"Choose interval"));
        this.optSpecific.addChangeListener(this);
        repeats.add((Component)this.optSpecific, "newline");
        JPanel specpre = new JPanel();
        specpre.setLayout((LayoutManager)new MigLayout("", "[left]"));
        specpre.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.hour", (String)"Hour: ")));
        this.repeathour = new JSpinner();
        this.repeathour.setModel(new SpinnerNumberModel(1, 0, 23, 1));
        this.repeathour.setEnabled(false);
        specpre.add(this.repeathour);
        specpre.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.minute", (String)"Minute: ")));
        this.repeatminute = new JSpinner();
        this.repeatminute.setModel(new SpinnerNumberModel(0, 0, 59, 1));
        this.repeatminute.setEnabled(false);
        specpre.add(this.repeatminute);
        repeats.add(specpre);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.optDate);
        grp.add(this.optHourly);
        grp.add(this.optDaily);
        grp.add(this.optWeekly);
        grp.add(this.optSpecific);
        date.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.repeats", (String)"Repeats")));
        date.add(repeats);
        this.datepre = new JPanel();
        this.datepre.setLayout((LayoutManager)new MigLayout("ins 0", "[][]10[][]10[][]"));
        this.datepre.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.day", (String)"Day: ")));
        this.day = new JSpinner();
        this.day.setModel(new SpinnerNumberModel(Calendar.getInstance().get(5), 1, 31, 1));
        this.datepre.add((Component)this.day, "sizegroup spinner");
        this.datepre.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.month", (String)"Month: ")));
        this.month = new JSpinner();
        this.month.setModel(new SpinnerNumberModel(Calendar.getInstance().get(2) + 1, 1, 12, 1));
        this.datepre.add((Component)this.month, "sizegroup spinner");
        this.datepre.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.year", (String)"Year: ")));
        this.year = new JSpinner();
        this.year.setModel(new SpinnerNumberModel(Calendar.getInstance().get(1), 2009, 2015, 1));
        this.datepre.add((Component)this.year, "sizegroup spinner");
        this.datepre.add((Component)new JLabel(JDL.L((String)"plugin.optional.scheduler.add.hour", (String)"Hour: ")), "newline");
        this.hour = new JSpinner();
        this.hour.setModel(new SpinnerNumberModel(Calendar.getInstance().get(11), 0, 23, 1));
        this.datepre.add((Component)this.hour, "sizegroup spinner");
        this.datepre.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.minute", (String)"Minute: ")));
        this.minute = new JSpinner();
        this.minute.setModel(new SpinnerNumberModel(Calendar.getInstance().get(12), 0, 59, 1));
        this.datepre.add((Component)this.minute, "sizegroup spinner");
        date.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.date", (String)"Date")));
        date.add((Component)this.datepre, "spany 2");
        date.add(new JLabel(JDL.L((String)"plugin.optional.scheduler.add.time", (String)"Time")));
        JPanel actions = new JPanel();
        actions.setLayout((LayoutManager)new MigLayout("ins 5, wrap 2", "[fill, grow]10[fill, grow]"));
        actions.setBorder(BorderFactory.createLineBorder(this.getBackground().darker()));
        this.cboActions = new JComboBox();
        this.cboActions.addActionListener(this);
        actions.add((Component)this.cboActions, "w 80%");
        this.add = new JButton("+");
        this.add.addActionListener(this);
        actions.add(this.add);
        this.parameter = new JTextField();
        this.parameter.setEnabled(false);
        actions.add(this.parameter);
        this.delete = new JButton("-");
        this.delete.setEnabled(false);
        this.delete.addActionListener(this);
        actions.add(this.delete);
        this.tableModel = new MyTableModel();
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.addMouseListener((MouseListener)this);
        JPanel control = new JPanel((LayoutManager)new MigLayout("wrap 3", "[grow, fill, right][right][right]"));
        this.problems = new JLabel();
        this.problems.setForeground(Color.RED);
        control.add(this.problems);
        this.cancel = new JButton(JDL.L((String)"plugin.optional.scheduler.add.cancel", (String)"Cancel"));
        this.cancel.addActionListener(this);
        control.add((Component)this.cancel, "align right,tag cancel");
        this.save = new JButton(JDL.L((String)"plugin.optional.scheduler.add.save", (String)"Save"));
        this.save.addActionListener(this);
        control.add((Component)this.save, "align right,tag save");
        if (edit) {
            Calendar c = Calendar.getInstance();
            c.setTime(act.getDate());
            this.day.setValue(c.get(5));
            this.month.setValue(c.get(2) + 1);
            this.year.setValue(c.get(1));
            this.hour.setValue(c.get(11));
            this.minute.setValue(c.get(12));
            switch (act.getRepeat()) {
                case 0: {
                    this.optDate.setSelected(true);
                    break;
                }
                case 60: {
                    this.optHourly.setSelected(true);
                    break;
                }
                case 1440: {
                    this.optDaily.setSelected(true);
                    break;
                }
                case 10080: {
                    this.optWeekly.setSelected(true);
                    break;
                }
                default: {
                    this.optSpecific.setSelected(true);
                    int hour = act.getRepeat() / 60;
                    this.repeathour.setValue(hour);
                    this.repeatminute.setValue(act.getRepeat() - hour * 60);
                }
            }
            this.tableModel.fireTableRowsInserted(0, act.getExecutions().size());
        }
        this.fillComboBox();
        main.add(date);
        main.add(actions);
        main.add((Component)new JScrollPane((Component)this.table), "hmin 100");
        main.add(control);
        this.add(main);
    }

    public void actionPerformed(ActionEvent e) {
        this.problems.setText("");
        Calendar c = Calendar.getInstance();
        c.set(1, (Integer)this.year.getValue());
        c.set(2, (Integer)this.month.getValue() - 1);
        c.set(5, (Integer)this.day.getValue());
        c.set(11, (Integer)this.hour.getValue());
        c.set(12, (Integer)this.minute.getValue());
        Date d = c.getTime();
        if (e.getSource() == this.save) {
            if (this.name.getText().equals("")) {
                this.problems.setText(JDL.L((String)"plugin.optional.scheduler.add.problem.emptyname", (String)"Name is empty"));
                return;
            }
            if (this.editact.getExecutions().size() == 0) {
                this.problems.setText(JDL.L((String)"plugin.optional.scheduler.add.problem.nochanges", (String)"No changes made"));
                return;
            }
            if (this.optSpecific.isSelected() && (Integer)this.repeathour.getValue() * 60 + (Integer)this.repeatminute.getValue() == 0) {
                this.problems.setText(JDL.L((String)"plugin.optional.scheduler.add.problem.zerorepeat", (String)"Repeattime equals Zero"));
                return;
            }
            if (d.compareTo(new Date()) < 0) {
                this.problems.setText(JDL.L((String)"plugin.optional.scheduler.add.problem.pastdate", (String)"Execution time is in the past"));
                return;
            }
            this.orgact.setName(this.name.getText());
            this.orgact.setDate(d);
            if (this.optDate.isSelected()) {
                this.orgact.setRepeat(0);
            } else if (this.optHourly.isSelected()) {
                this.orgact.setRepeat(60);
            } else if (this.optDaily.isSelected()) {
                this.orgact.setRepeat(1440);
            } else if (this.optWeekly.isSelected()) {
                this.orgact.setRepeat(10080);
            } else if (this.optSpecific.isSelected()) {
                this.orgact.setRepeat((Integer)this.repeathour.getValue() * 60 + (Integer)this.repeatminute.getValue());
            }
            this.orgact.getExecutions().clear();
            this.orgact.getExecutions().addAll(this.editact.getExecutions());
            this.orgact.setAlreadyHandled(false);
            if (this.edit) {
                this.gui.updateActions(this);
            } else {
                this.schedule.addAction(this.orgact);
                this.gui.updateActions(this);
            }
            this.editact = null;
            return;
        }
        if (e.getSource() == this.cboActions) {
            for (SchedulerModuleInterface smi : this.schedule.getModules()) {
                if (!smi.getTranslation().equals(this.cboActions.getSelectedItem())) continue;
                if (smi.needParameter()) {
                    this.parameter.setText("");
                } else {
                    this.parameter.setText(JDL.L((String)"plugin.optional.scheduler.add.noparameter", (String)"No Parameter needed"));
                }
                this.parameter.setEnabled(smi.needParameter());
                this.parameter.requestFocus();
                return;
            }
        } else if (e.getSource() == this.add) {
            for (SchedulerModuleInterface smi : this.schedule.getModules()) {
                if (!smi.getTranslation().equals(this.cboActions.getSelectedItem())) continue;
                if (smi.needParameter() && !smi.checkParameter(this.parameter.getText())) {
                    this.problems.setText(JDL.L((String)"plugin.optional.scheduler.add.problem.badparameter", (String)"No correct Parameter"));
                    return;
                }
                if (this.parameter.getText().equals(JDL.L((String)"plugin.optional.scheduler.add.noparameter", (String)"No Parameter needed"))) {
                    this.editact.addExecutions(new Executions(smi, ""));
                } else {
                    this.editact.addExecutions(new Executions(smi, this.parameter.getText()));
                }
                this.tableModel.fireTableRowsInserted(this.editact.getExecutions().size(), this.editact.getExecutions().size());
                this.fillComboBox();
                return;
            }
        } else if (e.getSource() == this.delete) {
            this.editact.removeExecution(this.table.getSelectedRow());
            this.tableModel.fireTableRowsDeleted(this.table.getSelectedRow(), this.table.getSelectedRow());
            this.delete.setEnabled(false);
            this.fillComboBox();
        } else if (e.getSource() == this.cancel) {
            this.gui.removeTab(this.orgact);
        }
    }

    private void fillComboBox() {
        this.cboActions.removeAllItems();
        int i = 0;
        while (i < this.schedule.getModules().size()) {
            boolean found = false;
            for (Executions e : this.editact.getExecutions()) {
                if (!e.getModule().getTranslation().equals(this.schedule.getModules().get(i).getTranslation())) continue;
                found = true;
                break;
            }
            if (!found) {
                this.cboActions.addItem(this.schedule.getModules().get(i).getTranslation());
            }
            ++i;
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.repeathour.setEnabled(this.optSpecific.isSelected());
        this.repeatminute.setEnabled(this.optSpecific.isSelected());
    }

    public void changedUpdate(DocumentEvent e) {
        this.gui.changeTabText(this.orgact, this.name.getText());
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.table.getSelectedRowCount() > 0) {
            this.delete.setEnabled(true);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public Actions getAction() {
        return this.orgact;
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2404339596786592942L;

        private MyTableModel() {
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return JDL.L((String)"plugin.optional.scheduler.add.column.executions.name", (String)"Name");
                }
                case 1: {
                    return JDL.L((String)"plugin.optional.scheduler.add.column.executions.parameter", (String)"Parameter");
                }
            }
            return super.getColumnName(column);
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return AddGui.this.editact.getExecutions().size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AddGui.this.editact.getExecutions().get(rowIndex).getModule().getTranslation();
                }
                case 1: {
                    return AddGui.this.editact.getExecutions().get(rowIndex).getParameter();
                }
            }
            return null;
        }
    }
}

