/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.schedule;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import jd.PluginWrapper;
import jd.controlling.JDLogger;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginOptional;
import jd.plugins.optional.schedule.Actions;
import jd.plugins.optional.schedule.Executions;
import jd.plugins.optional.schedule.MainGui;
import jd.plugins.optional.schedule.SchedulerView;
import jd.plugins.optional.schedule.modules.DisablePremium;
import jd.plugins.optional.schedule.modules.DisablePremiumForHost;
import jd.plugins.optional.schedule.modules.DisableReconnect;
import jd.plugins.optional.schedule.modules.DoReconnect;
import jd.plugins.optional.schedule.modules.EnablePremium;
import jd.plugins.optional.schedule.modules.EnablePremiumForHost;
import jd.plugins.optional.schedule.modules.EnableReconnect;
import jd.plugins.optional.schedule.modules.PauseDownloads;
import jd.plugins.optional.schedule.modules.SchedulerModuleInterface;
import jd.plugins.optional.schedule.modules.SetChunck;
import jd.plugins.optional.schedule.modules.SetMaxDownloads;
import jd.plugins.optional.schedule.modules.SetSpeed;
import jd.plugins.optional.schedule.modules.SetStopMark;
import jd.plugins.optional.schedule.modules.StartDownloads;
import jd.plugins.optional.schedule.modules.StopDownloads;
import jd.plugins.optional.schedule.modules.UnPauseDownloads;
import jd.plugins.optional.schedule.modules.UnSetStopMark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9524 $", id="scheduler", hasGui=true, interfaceversion=5)
public class Schedule
extends PluginOptional {
    private ArrayList<Actions> actions = (ArrayList)this.getPluginConfig().getGenericProperty("Scheduler_Actions", new ArrayList());
    private ArrayList<SchedulerModuleInterface> modules;
    private SchedulerView view;
    private MainGui gui;
    private Schedulercheck sc = null;
    private boolean running = false;
    private MenuAction activateAction;
    public static final Object LOCK = new Object();

    public Schedule(PluginWrapper wrapper) {
        super(wrapper);
        if (this.actions == null) {
            this.actions = new ArrayList();
            this.saveActions();
        }
        this.initModules();
        this.activateAction = new MenuAction(this.getWrapper().getID(), 0);
        this.activateAction.setActionListener((ActionListener)((Object)this));
        this.activateAction.setTitle(this.getHost());
        this.activateAction.setIcon(this.getIconKey());
        this.activateAction.setSelected(false);
    }

    private void initModules() {
        this.modules = new ArrayList();
        this.modules.add(new StartDownloads());
        this.modules.add(new StopDownloads());
        this.modules.add(new SetSpeed());
        this.modules.add(new SetChunck());
        this.modules.add(new SetMaxDownloads());
        this.modules.add(new PauseDownloads());
        this.modules.add(new UnPauseDownloads());
        this.modules.add(new EnablePremium());
        this.modules.add(new DisablePremium());
        this.modules.add(new EnablePremiumForHost());
        this.modules.add(new DisablePremiumForHost());
        this.modules.add(new EnableReconnect());
        this.modules.add(new DisableReconnect());
        this.modules.add(new DoReconnect());
        this.modules.add(new SetStopMark());
        this.modules.add(new UnSetStopMark());
    }

    public ArrayList<SchedulerModuleInterface> getModules() {
        return this.modules;
    }

    public ArrayList<Actions> getActions() {
        return this.actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(int row) {
        if (row < 0) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            this.actions.remove(row);
            this.saveActions();
        }
        this.updateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(Actions act) {
        Object object = LOCK;
        synchronized (object) {
            this.actions.add(act);
            this.saveActions();
        }
        this.updateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveActions() {
        Object object = LOCK;
        synchronized (object) {
            this.getPluginConfig().setProperty("Scheduler_Actions", this.actions);
            this.getPluginConfig().save();
        }
    }

    public void updateTable() {
        if (this.sc != null && this.sc.isSleeping()) {
            this.sc.interrupt();
        }
        if (this.gui != null) {
            this.gui.updateTable();
        }
    }

    public String getIconKey() {
        return "gui.images.config.eventmanager";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.activateAction) {
            if (((MenuAction)e.getSource()).isSelected()) {
                this.showGui();
            } else {
                this.view.close();
            }
        }
    }

    private void showGui() {
        if (this.view == null) {
            this.view = new SchedulerView();
            this.view.getBroadcaster().addListener((EventListener)new SwitchPanelListener(){

                public void onPanelEvent(SwitchPanelEvent event) {
                    if (event.getID() == 3) {
                        Schedule.this.activateAction.setSelected(false);
                    }
                }
            });
            this.gui = new MainGui(this);
            this.view.setContent(this.gui);
        }
        this.activateAction.setSelected(true);
        JDGui.getInstance().setContent((SwitchPanel)this.view);
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        menu.add(this.activateAction);
        return menu;
    }

    public boolean initAddon() {
        logger.info("Schedule Init: OK");
        this.running = true;
        this.sc = new Schedulercheck();
        this.sc.start();
        return true;
    }

    public void setGuiEnable(boolean b) {
        if (b) {
            this.showGui();
        } else if (this.view != null) {
            this.view.close();
        }
    }

    public void onExit() {
        this.saveActions();
        this.running = false;
        if (this.sc != null && this.sc.isSleeping()) {
            this.sc.interrupt();
        }
        this.sc = null;
    }

    public class Schedulercheck
    extends Thread {
        private Date today;
        private SimpleDateFormat time;
        private SimpleDateFormat date;
        private ArrayList<Actions> tmpactions;
        private ArrayList<Executions> tmpexe;
        private boolean sleeping;

        public Schedulercheck() {
            super("Schedulercheck");
            this.tmpactions = null;
            this.tmpexe = null;
            this.sleeping = false;
            this.time = new SimpleDateFormat("HH:mm");
            this.date = new SimpleDateFormat("dd.MM.yyyy");
            this.tmpactions = new ArrayList();
            this.tmpexe = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSleeping() {
            Schedulercheck schedulercheck = this;
            synchronized (schedulercheck) {
                return this.sleeping;
            }
        }

        private boolean updateTimer(Actions a, long curtime) {
            long currenttime;
            long timestamp;
            if (a.getRepeat() != 0 && (timestamp = a.getDate().getTime()) <= (currenttime = curtime)) {
                a.setAlreadyHandled(false);
                currenttime /= 60000L;
                currenttime *= 60000L;
                long add = (long)(a.getRepeat() * 60) * 1000L;
                while (timestamp <= currenttime) {
                    timestamp += add;
                }
                Calendar newrepeat = Calendar.getInstance();
                newrepeat.setTimeInMillis(timestamp);
                a.setDate(newrepeat.getTime());
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                logger.finest("Scheduler: start");
                while (Schedule.this.running) {
                    logger.finest("Scheduler: checking");
                    long currenttime = System.currentTimeMillis();
                    this.today = new Date(currenttime);
                    String todaydate = this.date.format(this.today);
                    String todaytime = this.time.format(this.today);
                    boolean savechanges = false;
                    Object object = LOCK;
                    synchronized (object) {
                        this.tmpactions.clear();
                        this.tmpactions.addAll(Schedule.this.actions);
                    }
                    for (Actions a : this.tmpactions) {
                        if (a.isEnabled() && todaydate.equals(this.date.format(a.getDate())) && todaytime.equals(this.time.format(a.getDate())) && !a.wasAlreadyHandled()) {
                            a.setAlreadyHandled(true);
                            Object object2 = LOCK;
                            synchronized (object2) {
                                this.tmpexe.clear();
                                this.tmpexe.addAll(a.getExecutions());
                            }
                            for (Executions e : this.tmpexe) {
                                logger.finest("Execute: " + e.getModule().getTranslation());
                                e.exceute();
                            }
                        }
                        if (!this.updateTimer(a, currenttime)) continue;
                        savechanges = true;
                    }
                    if (savechanges) {
                        Schedule.this.saveActions();
                    } else {
                        Schedule.this.updateTable();
                    }
                    object = this;
                    synchronized (object) {
                        this.sleeping = true;
                    }
                    try {
                        Schedulercheck.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object = this;
                    synchronized (object) {
                        this.sleeping = false;
                    }
                }
                logger.finest("Scheduler: stop");
            }
            catch (Exception e) {
                logger.severe("Scheduler: died!!");
                JDLogger.exception((Throwable)e);
            }
        }
    }
}

