/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import jd.PluginWrapper;
import jd.config.ConfigEntry;
import jd.config.MenuItem;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.plugins.PluginOptional;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDFolderWatch
extends PluginOptional {
    private SubConfiguration subConfig = SubConfiguration.getConfig((String)"FOLDERWATCH");
    private ArrayList<String> added = (ArrayList)this.subConfig.getProperty("ADDED");
    private check i;
    private boolean running = true;
    private boolean threadend = true;

    public static int getAddonInterfaceVersion() {
        return 3;
    }

    public JDFolderWatch(PluginWrapper wrapper) {
        super(wrapper);
        ConfigEntry cfg = new ConfigEntry(9, (Property)this.subConfig, "FOLDER", JDL.L((String)"plugins.optional.folderwatch.folder", (String)"Ordner:"));
        this.config.addEntry(cfg);
        cfg.setDefaultValue((Object)JDUtilities.getConfiguration().getDefaultDownloadDirectory());
        cfg = new ConfigEntry(8, (Property)this.subConfig, "WAITTIME", JDL.L((String)"plugins.optional.folderwatch.checkintervall", (String)"Checkintervall [min]"), 1, 60);
        this.config.addEntry(cfg);
        cfg.setDefaultValue((Object)"5");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Check")) {
            this.checkFolder();
        }
        if (e.getActionCommand().equals("Reset")) {
            logger.info("Folderwatch: Reseting saved containers");
            this.added = new ArrayList();
            this.subConfig.setProperty("ADDED", this.added);
            this.subConfig.save();
        }
        if (e.getActionCommand().equals("Start/Stop")) {
            if (this.running) {
                logger.info("Folderwatch: Stopping");
                this.threadend = false;
                this.running = false;
            } else {
                logger.info("Folderwatch: Starting");
                this.i = new check();
                this.i.start();
                this.running = true;
            }
        }
    }

    private synchronized void checkFolder() {
        logger.info("Folderwatch: Checking folder");
        boolean dabei = false;
        File folder = new File(this.subConfig.getStringProperty("FOLDER", JDUtilities.getConfiguration().getStringProperty("DOWNLOAD_DIRECTORY")));
        if (folder.isDirectory()) {
            String[] help;
            String[] stringArray = help = folder.list();
            int n = help.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.toLowerCase().endsWith(".dlc") || element.toLowerCase().endsWith(".ccf") || element.toLowerCase().endsWith(".rsdf")) {
                    dabei = false;
                    File container = new File(folder, element);
                    try {
                        int j = 0;
                        while (j < this.added.size()) {
                            if (container.getAbsolutePath().equals(this.added.get(j))) {
                                dabei = true;
                                break;
                            }
                            ++j;
                        }
                        if (!dabei) {
                            JDUtilities.getController().loadContainerFile(container);
                            this.added.add(container.getAbsolutePath());
                            this.subConfig.setProperty("ADDED", this.added);
                            this.subConfig.save();
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Exception e) {
                        JDLogger.exception((Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    public ArrayList<MenuItem> createMenuitems() {
        ArrayList<MenuItem> menu = new ArrayList<MenuItem>();
        menu.add(new MenuItem(JDL.L((String)"plugins.optional.folderwatch.menu.startstop", (String)"Start/Stop"), 0).setActionListener((ActionListener)((Object)this)));
        menu.add(new MenuItem(JDL.L((String)"plugins.optional.folderwatch.menu.check", (String)"Check"), 0).setActionListener((ActionListener)((Object)this)));
        menu.add(new MenuItem(JDL.L((String)"plugins.optional.folderwatch.menu.reset", (String)"Reset"), 0).setActionListener((ActionListener)((Object)this)));
        return menu;
    }

    public String getHost() {
        return JDL.L((String)"plugins.optional.folderwatch.name", (String)"JDFolderWatch");
    }

    public String getRequirements() {
        return "JRE 1.5+";
    }

    public String getVersion() {
        return this.getVersion("$Revision: 6389 $");
    }

    private int getWaittime() {
        return this.subConfig.getIntegerProperty("WAITTIME", 5) * 60000;
    }

    public boolean initAddon() {
        if (JDUtilities.getJavaVersion() >= 1.5) {
            logger.info("FolderWatch OK");
            if (this.added == null) {
                this.added = new ArrayList();
                this.subConfig.setProperty("ADDED", this.added);
                this.subConfig.save();
            }
            this.i = new check();
            this.i.setName("FolderWatch");
            this.i.start();
            return true;
        }
        return false;
    }

    public void onExit() {
    }

    public class check
    extends Thread {
        public void run() {
            JDFolderWatch.this.threadend = true;
            while (JDFolderWatch.this.threadend) {
                JDFolderWatch.this.checkFolder();
                try {
                    Thread.sleep(JDFolderWatch.this.getWaittime());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            JDFolderWatch.this.running = false;
        }
    }
}

