/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.XmlSerializer;

public class DoctypeToken
implements BaseToken {
    private String part1;
    private String part2;
    private String part3;
    private String part4;

    public DoctypeToken(String string, String string2, String string3, String string4) {
        this.part1 = string != null ? string.toUpperCase() : string;
        this.part2 = string2 != null ? string2.toUpperCase() : string2;
        this.part3 = this.clean(string3);
        this.part4 = this.clean(string4);
    }

    private String clean(String string) {
        if (string != null) {
            string = string.replace('>', ' ');
            string = string.replace('<', ' ');
            string = string.replace('&', ' ');
            string = string.replace('\'', ' ');
            string = string.replace('\"', ' ');
        }
        return string;
    }

    public boolean isValid() {
        if (this.part1 == null || "".equals(this.part1)) {
            return false;
        }
        if (!"public".equalsIgnoreCase(this.part2) && !"system".equalsIgnoreCase(this.part2)) {
            return false;
        }
        if ("system".equalsIgnoreCase(this.part2) && this.part4 != null && !"".equals(this.part4)) {
            return false;
        }
        return !"public".equalsIgnoreCase(this.part2) || this.part4 != null && !"".equals(this.part4);
    }

    public String getContent() {
        String string = "<!DOCTYPE " + this.part1 + " ";
        string = string + this.part2 + " \"" + this.part3 + "\"";
        if (this.part4 != null && !"".equals(this.part4)) {
            string = string + " \"" + this.part4 + "\"";
        }
        string = string + ">";
        return string;
    }

    public String toString() {
        return this.getContent();
    }

    public String getName() {
        return "";
    }

    public void serialize(XmlSerializer xmlSerializer, Writer writer) throws IOException {
        writer.write(this.getContent() + "\n");
    }
}

