/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.httpserver;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import jd.controlling.JDLogger;
import jd.nutils.httpserver.Handler;
import jd.nutils.httpserver.Request;
import jd.nutils.httpserver.Response;

public class RequestHandler
extends Thread {
    private Socket socket;
    private Handler handler;
    private boolean eof = false;

    public RequestHandler(Socket socket, Handler handler) {
        this.socket = socket;
        this.handler = handler;
    }

    public void run() {
        try {
            try {
                BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream());
                String line = "";
                Request req = new Request();
                while (!this.eof && (line = this.readline(reader)) != null) {
                    String key = null;
                    String value = null;
                    if (line.equals("\r\n") && req.getRequestType().equals("GET")) {
                        this.eof = true;
                        continue;
                    }
                    if (line.equals("\r\n") && req.getRequestType().equals("POST")) {
                        int data = (int)req.getContentLength();
                        byte[] buffer = new byte[data];
                        int offset = 0;
                        while (data - offset > 0) {
                            offset += reader.read(buffer, offset, data - offset);
                        }
                        req.setPostData(buffer);
                        this.parseParameter(req, new String(buffer));
                        this.eof = true;
                        continue;
                    }
                    if ((line = line.trim()).startsWith("GET ") || line.startsWith("POST ")) {
                        String[] help = line.split(" ");
                        req.setRequestType(help[0]);
                        req.setHttpType(help[2]);
                        if (help[1].indexOf("?") > 0) {
                            req.setRequestUrl(help[1].substring(0, help[1].indexOf("?")));
                            this.parseParameter(req, help[1].substring(help[1].indexOf("?") + 1));
                        } else {
                            req.setRequestUrl(help[1]);
                        }
                    } else if (line.indexOf(": ") > 0) {
                        key = line.substring(0, line.indexOf(": ")).toLowerCase();
                        value = line.substring(line.indexOf(": ") + 2);
                    }
                    if (key == null) continue;
                    req.addHeader(key, value);
                }
                Response res = new Response();
                try {
                    this.handler.handle(req, res);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                    res.setReturnStatus("404 ERROR");
                    res.addContent(e.toString());
                }
                OutputStream out = this.socket.getOutputStream();
                res.writeToStream(out);
                out.close();
            }
            catch (IOException e) {
                JDLogger.exception((Throwable)e);
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    JDLogger.exception((Throwable)e2);
                }
            }
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                JDLogger.exception((Throwable)e);
            }
        }
    }

    public void parseParameter(Request req, String parameter) {
        String[] help;
        String[] stringArray = help = parameter.split("\\&");
        int n = help.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            int index = (entry = entry.trim()).indexOf("=");
            if (index > 0) {
                req.addParameter(entry.substring(0, index), entry.substring(index + 1));
            } else {
                req.addParameter(entry, "");
            }
            ++n2;
        }
    }

    private String readline(BufferedInputStream reader) {
        StringBuilder sb = new StringBuilder();
        int byteread = -6;
        try {
            while ((byteread = reader.read()) != -1) {
                if (byteread == 10 || byteread == 13) {
                    reader.mark(0);
                    sb.append((char)byteread);
                    byteread = reader.read();
                    if (byteread != -1) {
                        if (byteread == 13 || byteread == 10) {
                            sb.append((char)byteread);
                            break;
                        }
                        reader.reset();
                        break;
                    }
                }
                sb.append((char)byteread);
            }
            if (byteread == -1) {
                this.eof = true;
            }
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
        return sb.toString();
    }
}

