/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.jna.Win32;

import com.sun.jna.FromNativeContext;
import com.sun.jna.IntegerType;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.HashMap;
import jd.nutils.jna.Win32.W32Errors;

public interface W32API
extends StdCallLibrary,
W32Errors {
    public static final HashMap<String, Object> UNICODE_OPTIONS = new HashMap<String, Object>(){
        private static final long serialVersionUID = -8837658858578832002L;
        {
            this.put("type-mapper", W32APITypeMapper.UNICODE);
            this.put("function-mapper", W32APIFunctionMapper.UNICODE);
        }
    };
    public static final HashMap<String, Object> ASCII_OPTIONS = new HashMap<String, Object>(){
        private static final long serialVersionUID = -7031534000369274766L;
        {
            this.put("type-mapper", W32APITypeMapper.ASCII);
            this.put("function-mapper", W32APIFunctionMapper.ASCII);
        }
    };
    public static final HashMap<String, Object> DEFAULT_OPTIONS = Boolean.getBoolean("w32.ascii") ? ASCII_OPTIONS : UNICODE_OPTIONS;
    public static final HANDLE INVALID_HANDLE_VALUE = new HANDLE(Pointer.createConstant((long)-1L));

    public static class DWORD
    extends IntegerType {
        private static final long serialVersionUID = -7809675461872394546L;

        public DWORD() {
            this(0L);
        }

        public DWORD(long value) {
            super(4, value);
        }
    }

    public static class HANDLE
    extends PointerType {
        private boolean immutable;

        public HANDLE() {
        }

        public HANDLE(Pointer p) {
            this.setPointer(p);
            this.immutable = true;
        }

        public Object fromNative(Object nativeValue, FromNativeContext context) {
            Object o = super.fromNative(nativeValue, context);
            if (INVALID_HANDLE_VALUE.equals(o)) {
                return INVALID_HANDLE_VALUE;
            }
            return o;
        }

        public void setPointer(Pointer p) {
            if (this.immutable) {
                throw new UnsupportedOperationException("immutable reference");
            }
            super.setPointer(p);
        }
    }

    public static class HRESULT
    extends NativeLong {
        private static final long serialVersionUID = 1322522029438435184L;
    }

    public static class HWND
    extends HANDLE {
        public HWND() {
        }

        public HWND(Pointer p) {
            super(p);
        }
    }
}

