/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.storage.StorageException;
import org.appwork.storage.StorageKeyAddedEvent;
import org.appwork.storage.StorageKeyRemovedEvent;
import org.appwork.storage.StorageValueChangeEvent;
import org.appwork.utils.Application;
import org.appwork.utils.logging.Log;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JacksonStorageChest
extends Storage {
    private final HashMap<String, Object> map = new HashMap();
    private final String name;
    private final File file;
    private final boolean plain;
    private final byte[] key;
    private boolean autoPutValues = true;
    private boolean closed = false;

    public JacksonStorageChest(File file) throws StorageException {
        this(file, false);
    }

    public JacksonStorageChest(File file, boolean plain) throws StorageException {
        this(file, plain, JSonStorage.KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JacksonStorageChest(File file, boolean plain, byte[] key) throws StorageException {
        this.plain = plain;
        this.file = file;
        this.name = file.getName();
        this.key = key;
        Object object = JSonStorage.LOCK;
        synchronized (object) {
            HashMap load = JSonStorage.restoreFrom(file, plain, key, null, new HashMap());
            this.map.putAll(load);
        }
    }

    public JacksonStorageChest(String name) throws StorageException {
        this(name, false);
    }

    public JacksonStorageChest(String name, boolean plain) throws StorageException {
        this(name, plain, JSonStorage.KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JacksonStorageChest(String name, boolean plain, byte[] key) throws StorageException {
        this.name = name;
        this.plain = plain;
        this.file = Application.getRessource("cfg/" + name + (plain ? ".json" : ".ejs"));
        this.key = key;
        Object object = JSonStorage.LOCK;
        synchronized (object) {
            HashMap load = JSonStorage.restoreFrom(this.file, plain, key, null, new HashMap());
            this.map.putAll(load);
        }
    }

    @Override
    public void clear() throws StorageException {
        Iterator<Map.Entry<String, Object>> it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> next = it.next();
            it.remove();
            this.getEventSender().fireEvent(new StorageKeyRemovedEvent<Object>(this, next.getKey(), next.getValue()));
        }
        this.map.clear();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public long decrease(String key) {
        long ret = this.get(key, 0L).intValue();
        this.put(key, --ret);
        return ret;
    }

    @Override
    public <E> E get(String key, E def) throws StorageException {
        Object[] ret;
        boolean contains = this.map.containsKey(key);
        Object[] objectArray = ret = contains ? this.map.get(key) : null;
        if (ret != null && def != null && ret.getClass() != def.getClass()) {
            if (ret instanceof ArrayList) {
                int index = 0;
                if (def instanceof int[]) {
                    int[] rets = new int[((ArrayList)ret).size()];
                    for (Object o : (ArrayList)ret) {
                        if (o instanceof Integer) {
                            rets[index++] = (Integer)o;
                            continue;
                        }
                        throw new RuntimeException("Cannot cast " + o.getClass() + " to int");
                    }
                    ret = rets;
                } else if (def instanceof Integer[]) {
                    Integer[] rets = new Integer[((ArrayList)ret).size()];
                    for (Object o : (ArrayList)ret) {
                        if (o instanceof Integer) {
                            rets[index++] = (Integer)o;
                            continue;
                        }
                        throw new RuntimeException("Cannot cast " + o.getClass() + " to Integer");
                    }
                    ret = rets;
                } else if (def instanceof long[]) {
                    long[] rets = new long[((ArrayList)ret).size()];
                    for (Object o : (ArrayList)ret) {
                        if (o instanceof Long) {
                            rets[index++] = (Long)o;
                            continue;
                        }
                        if (o instanceof Integer) {
                            rets[index++] = ((Integer)o).longValue();
                            continue;
                        }
                        throw new RuntimeException("Cannot cast " + o.getClass() + " to long");
                    }
                    ret = rets;
                } else if (def instanceof Long[]) {
                    Long[] rets = new Long[((ArrayList)ret).size()];
                    for (Object o : (ArrayList)ret) {
                        if (o instanceof Integer) {
                            rets[index++] = ((Integer)o).longValue();
                            continue;
                        }
                        if (o instanceof Long) {
                            rets[index++] = (Long)o;
                            continue;
                        }
                        throw new RuntimeException("Cannot cast " + o.getClass() + " to Long");
                    }
                    ret = rets;
                }
            }
            if (def instanceof Long) {
                if (ret instanceof Integer) {
                    ret = new Long(((Integer)ret).longValue());
                }
            } else if (def instanceof Integer && ret instanceof Long) {
                ret = new Integer(((Long)ret).intValue());
            }
        }
        if (!contains && this.autoPutValues) {
            ret = def;
            if (def instanceof Boolean) {
                this.put(key, (Boolean)def);
            } else if (def instanceof Long) {
                this.put(key, (Long)def);
            } else if (def instanceof Long[]) {
                this.put(key, (Long[])def);
            } else if (def instanceof long[]) {
                this.put(key, (long[])def);
            } else if (def instanceof Integer) {
                this.put(key, (Integer)def);
            } else if (def instanceof Integer[]) {
                this.put(key, (Integer[])def);
            } else if (def instanceof int[]) {
                this.put(key, (int[])def);
            } else if (def instanceof Byte) {
                this.put(key, (Byte)def);
            } else if (def instanceof String || def == null) {
                this.put(key, (String)def);
            } else if (def instanceof Enum) {
                this.put(key, (Enum)def);
            } else if (def instanceof Double) {
                this.put(key, (Double)def);
            } else {
                throw new StorageException("Invalid datatype: " + (def != null ? def.getClass() : "null"));
            }
        }
        if (def instanceof Enum && ret instanceof String) {
            try {
                ret = Enum.valueOf(((Enum)def).getDeclaringClass(), (String)ret);
            }
            catch (Throwable e) {
                Log.exception((Throwable)e);
                if (this.autoPutValues) {
                    this.put(key, (Enum)def);
                }
                ret = def;
            }
        }
        return (E)ret;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getID() {
        return this.file.getAbsolutePath();
    }

    public byte[] getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public long increase(String key) {
        long ret = this.get(key, 0).intValue();
        this.put(key, ++ret);
        return ret;
    }

    public boolean isAutoPutValues() {
        return this.autoPutValues;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void put(String key, boolean value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        boolean old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Boolean>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Boolean>(this, key, value));
        }
    }

    @Override
    public void put(String key, Boolean value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Boolean old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Boolean>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Boolean>(this, key, value));
        }
    }

    @Override
    public void put(String key, Byte value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Byte old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Byte>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Byte>(this, key, value));
        }
    }

    @Override
    public void put(String key, Double value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Double old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Double>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Double>(this, key, value));
        }
    }

    @Override
    public void put(String key, Enum<?> value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Enum<?> old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent(this, key, value));
        }
    }

    @Override
    public void put(String key, Float value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Float old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Float>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Float>(this, key, value));
        }
    }

    public void put(String key, int value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Integer old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Integer>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Integer>(this, key, value));
        }
    }

    public void put(String key, int[] value) {
        boolean contains = this.map.containsKey(key);
        int[] old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<int[]>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<int[]>(this, key, value));
        }
    }

    @Override
    public void put(String key, Integer value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Integer old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Integer>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Integer>(this, key, value));
        }
    }

    public void put(String key, Integer[] value) {
        boolean contains = this.map.containsKey(key);
        Integer[] old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Integer[]>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Integer[]>(this, key, value));
        }
    }

    public void put(String key, long value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Long old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Long>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Long>(this, key, value));
        }
    }

    @Override
    public void put(String key, Long value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        Long old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Long>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Long>(this, key, value));
        }
    }

    public void put(String key, long[] value) {
        boolean contains = this.map.containsKey(key);
        long[] old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<long[]>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<long[]>(this, key, value));
        }
    }

    public void put(String key, Long[] value) {
        boolean contains = this.map.containsKey(key);
        Long[] old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<Long[]>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<Long[]>(this, key, value));
        }
    }

    @Override
    public void put(String key, String value) throws StorageException {
        boolean contains = this.map.containsKey(key);
        String old = contains ? this.get(key, value) : null;
        this.map.put(key, value);
        if (contains) {
            this.getEventSender().fireEvent(new StorageValueChangeEvent<String>((Storage)this, key, old, value));
        } else {
            this.getEventSender().fireEvent(new StorageKeyAddedEvent<String>(this, key, value));
        }
    }

    @Override
    public Object remove(String key) {
        Object ret = this.map.remove(key);
        if (ret != null) {
            this.getEventSender().fireEvent(new StorageKeyRemovedEvent<Object>(this, key, ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws StorageException {
        if (this.closed) {
            throw new StorageException("StorageChest already closed!");
        }
        Object object = JSonStorage.LOCK;
        synchronized (object) {
            try {
                String json = null;
                json = JSonStorage.getMapper().writeValueAsString(this.map);
                JSonStorage.saveTo(this.file, this.plain, this.key, json);
            }
            catch (JsonGenerationException e) {
                Log.exception((Throwable)e);
            }
            catch (JsonMappingException e) {
                Log.exception((Throwable)e);
            }
            catch (IOException e) {
                Log.exception((Throwable)e);
            }
        }
    }

    public void setAutoPutValues(boolean autoPutValues) {
        this.autoPutValues = autoPutValues;
    }

    public String toString() {
        try {
            return JSonStorage.getMapper().writeValueAsString(this.map);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.map.toString();
    }
}

