/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.appwork.utils.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static String APP_FOLDER = ".appwork";
    private static String ROOT;

    public static void addFolderToClassPath(File file) throws IOException {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)Application.class.getClassLoader(), file.toURI().toURL());
        }
        catch (Throwable t) {
            Log.exception((Throwable)t);
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static double getJavaVersion() {
        try {
            String v = System.getProperty("java.version");
            StringBuilder ret = new StringBuilder();
            int lc = 48;
            int i = 0;
            while (i < v.length()) {
                char c = v.charAt(i);
                if (c >= '0' && c <= '9') {
                    if (lc == 98) {
                        ret.append(".");
                    }
                    ret.append(c);
                }
                lc = c;
                ++i;
            }
            return Double.parseDouble(ret.toString());
        }
        catch (Exception e) {
            Log.exception((Throwable)e);
            return 0.0;
        }
    }

    public static File getRessource(String relative) {
        return new File(Application.getRoot(), relative);
    }

    public static URL getRessourceURL(String relative) {
        URL res = Application.class.getClassLoader().getResource(relative);
        if (res != null) {
            return res;
        }
        try {
            return new File(Application.getRoot(), relative).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRoot() {
        return Application.getRoot(Application.class);
    }

    public static String getRoot(Class<?> rootOfClazz) {
        if (ROOT != null) {
            return ROOT;
        }
        if (Application.isJared(rootOfClazz)) {
            String loc;
            try {
                loc = URLDecoder.decode(rootOfClazz.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
            }
            catch (Exception e) {
                loc = rootOfClazz.getProtectionDomain().getCodeSource().getLocation().getFile();
                System.err.println("failed urldecoding Location: " + loc);
            }
            File appRoot = new File(loc);
            if (appRoot.isFile()) {
                appRoot = appRoot.getParentFile();
            }
            ROOT = appRoot.getAbsolutePath();
        } else {
            ROOT = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + APP_FOLDER + System.getProperty("file.separator");
        }
        return ROOT;
    }

    public static boolean isJared(Class<?> rootOfClazz) {
        String name = String.valueOf(rootOfClazz.getName().replaceAll("\\.", "/")) + ".class";
        ClassLoader cll = Thread.currentThread().getContextClassLoader();
        if (cll == null) {
            Log.L.severe("getContextClassLoader() is null");
            return true;
        }
        URL caller = cll.getResource(name);
        if (caller == null) {
            return false;
        }
        return caller.toString().matches("jar\\:.*\\.jar\\!.*");
    }

    public static void main(String[] args) {
        System.out.println(Application.getJavaVersion());
    }

    public static synchronized void setApplication(String newAppFolder) {
        APP_FOLDER = newAppFolder;
    }
}

