/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import org.appwork.utils.os.CrossSystem;

public class IO {
    public static void copyFile(File in, File out) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        fis = new FileInputStream(in);
        FileChannel inChannel = fis.getChannel();
        fos = new FileOutputStream(out);
        FileChannel outChannel = fos.getChannel();
        try {
            if (CrossSystem.isWindows()) {
                int maxCount = 67076096;
                long size = inChannel.size();
                long position = 0L;
                while (position < size) {
                    position += inChannel.transferTo(position, 67076096L, outChannel);
                }
            } else {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
        }
        finally {
            try {
                outChannel.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            try {
                inChannel.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String importFileToString(File file) throws IOException {
        return IO.importFileToString(file, -1);
    }

    public static String importFileToString(File file, int maxSize) throws IOException {
        byte[] bytes = IO.readFile(file, maxSize);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    public static byte[] readFile(File ressource) throws IOException {
        return IO.readFile(ressource, -1);
    }

    public static byte[] readFile(File ressource, int maxSize) throws IOException {
        return IO.readURL(ressource.toURI().toURL(), maxSize);
    }

    public static String readFileToString(File file) throws IOException {
        return IO.readURLToString(file.toURI().toURL());
    }

    public static byte[] readURL(URL f) throws IOException {
        return IO.readURL(f, -1);
    }

    public static byte[] readURL(URL url, int maxSize) throws IOException {
        InputStream input = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            input = url.openStream();
            bis = new BufferedInputStream(input);
            baos = new ByteArrayOutputStream();
            byte[] b = new byte[Short.MAX_VALUE];
            while ((len = bis.read(b)) != -1) {
                if (len <= 0) continue;
                baos.write(b, 0, len);
                if (maxSize <= 0 || baos.size() <= maxSize) continue;
                throw new IOException("Max size exeeded!");
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
            try {
                bis.close();
            }
            catch (Exception exception) {}
            try {
                baos.close();
            }
            catch (Throwable throwable) {}
        }
        return baos.toByteArray();
    }

    public static String readURLToString(URL ressourceURL) throws IOException {
        BufferedReader f = null;
        InputStreamReader isr = null;
        InputStream fis = null;
        try {
            String line;
            fis = ressourceURL.openStream();
            isr = new InputStreamReader(fis, "UTF8");
            f = new BufferedReader(isr);
            StringBuilder ret = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = f.readLine()) != null) {
                if (ret.length() > 0) {
                    ret.append(sep);
                }
                ret.append(line);
            }
            String string = ret.toString();
            return string;
        }
        finally {
            try {
                f.close();
            }
            catch (Throwable throwable) {}
            try {
                isr.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        FileWriter fw = null;
        fw = new FileWriter(file);
        BufferedWriter output = new BufferedWriter(fw);
        try {
            output.write(string);
        }
        finally {
            try {
                ((Writer)output).flush();
            }
            catch (Throwable throwable) {}
            try {
                fw.flush();
            }
            catch (Throwable throwable) {}
            try {
                ((Writer)output).close();
            }
            catch (Throwable throwable) {}
            try {
                fw.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void writeToFile(File file, byte[] data) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(data);
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

