/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.formatter;

import java.text.DecimalFormat;
import java.util.regex.Pattern;
import org.appwork.utils.Regex;

public class SizeFormatter {
    public static String formatBytes(long fileSize) {
        if (fileSize < 0L) {
            fileSize = 0L;
        }
        DecimalFormat c = new DecimalFormat("0.00");
        if (fileSize >= 0x10000000000L) {
            return String.valueOf(c.format((double)fileSize / 1.099511627776E12)) + " TiB";
        }
        if (fileSize >= 0x40000000L) {
            return String.valueOf(c.format((double)fileSize / 1.073741824E9)) + " GiB";
        }
        if (fileSize >= 0x100000L) {
            return String.valueOf(c.format((double)fileSize / 1048576.0)) + " MiB";
        }
        if (fileSize >= 1024L) {
            return String.valueOf(c.format((double)fileSize / 1024.0)) + " KiB";
        }
        return String.valueOf(fileSize) + " B";
    }

    public static long getSize(String string) {
        String[][] matches = new Regex(string, Pattern.compile("([\\d]+)[\\.|\\,|\\:]([\\d]+)", 2)).getMatches();
        if (matches == null || matches.length == 0) {
            matches = new Regex(string, Pattern.compile("([\\d]+)", 2)).getMatches();
        }
        if (matches == null || matches.length == 0) {
            return -1L;
        }
        double res = 0.0;
        if (matches[0].length == 1) {
            res = Double.parseDouble(matches[0][0]);
        }
        if (matches[0].length == 2) {
            res = Double.parseDouble(String.valueOf(matches[0][0]) + "." + matches[0][1]);
        }
        if (Regex.matches((Object)string, Pattern.compile("(gb|gbyte|gig|gib)", 2))) {
            res *= 1.073741824E9;
        } else if (Regex.matches((Object)string, Pattern.compile("(mb|mbyte|megabyte|mib)", 2))) {
            res *= 1048576.0;
        } else if (Regex.matches((Object)string, Pattern.compile("(kb|kbyte|kilobyte|kib)", 2))) {
            res *= 1024.0;
        }
        return Math.round(res);
    }
}

