/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.io.InputStream;
import org.appwork.utils.net.throttledconnection.ThrottledInputStream;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class MeteredThrottledInputStream
extends ThrottledInputStream
implements SpeedMeterInterface {
    private SpeedMeterInterface speedmeter = null;
    private long time = 0L;
    private long speed = 0L;
    private long lastTime;
    private long lastTrans;
    private long transferedCounter3;
    private final Object LOCK = new Object();

    public MeteredThrottledInputStream(InputStream in) {
        super(in);
    }

    public MeteredThrottledInputStream(InputStream in, SpeedMeterInterface speedmeter) {
        super(in);
        this.speedmeter = speedmeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            block7: {
                if (this.time != 0L) break block7;
                this.time = System.currentTimeMillis();
                this.transferedCounter3 = this.transferedCounter;
                return 0L;
            }
            if (System.currentTimeMillis() - this.time < 1000L) {
                if (this.speedmeter != null) {
                    return this.speedmeter.getSpeedMeter();
                }
                return this.speed;
            }
            this.lastTime = System.currentTimeMillis() - this.time;
            this.time = System.currentTimeMillis();
            this.lastTrans = this.transferedCounter - this.transferedCounter3;
            this.transferedCounter3 = this.transferedCounter;
            if (this.speedmeter != null) {
                this.speedmeter.putSpeedMeter(this.lastTrans, this.lastTime);
                this.speed = this.speedmeter.getSpeedMeter();
                return this.speed;
            }
            this.speed = this.lastTrans / this.lastTime * 1000L;
            return this.speed;
        }
    }

    public void putSpeedMeter(long bytes, long time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSpeedMeter() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.speedmeter != null) {
                this.speedmeter.resetSpeedMeter();
            }
            this.time = System.currentTimeMillis();
            this.speed = 0L;
            this.transferedCounter3 = this.transferedCounter;
        }
    }
}

