/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.singleapp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging.Log;
import org.appwork.utils.singleapp.AnotherInstanceRunningException;
import org.appwork.utils.singleapp.InstanceMessageListener;
import org.appwork.utils.singleapp.UncheckableInstanceException;

public class SingleAppInstance {
    private String appID;
    private InstanceMessageListener listener = null;
    private File lockFile = null;
    private FileLock fileLock = null;
    private FileChannel lockChannel = null;
    private boolean daemonRunning = false;
    private boolean alreadyUsed = false;
    private ServerSocket serverSocket = null;
    private final String SINGLEAPP = "SingleAppInstance";
    private Thread daemon = null;
    private File portFile = null;

    public SingleAppInstance(String appID) {
        this(appID, new File(Application.getRoot()));
    }

    public SingleAppInstance(String appID, File directory) {
        this.appID = appID;
        this.lockFile = new File(directory, String.valueOf(appID) + ".lock");
        this.portFile = new File(directory, String.valueOf(appID) + ".port");
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook(this)));
    }

    public synchronized void setInstanceMessageListener(InstanceMessageListener listener) {
        this.listener = listener;
    }

    private InetAddress getLocalHost() {
        InetAddress localhost = null;
        try {
            localhost = Inet4Address.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (localhost != null) {
            return localhost;
        }
        try {
            localhost = Inet4Address.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localhost;
    }

    public synchronized boolean sendToRunningInstance(String[] message) {
        if (this.portFile.exists()) {
            int port = this.readPortFromPortFile();
            Socket runninginstance = null;
            if (port != 0) {
                try {
                    runninginstance = new Socket(this.getLocalHost(), port);
                    runninginstance.setSoTimeout(10000);
                    BufferedInputStream in = new BufferedInputStream(runninginstance.getInputStream());
                    OutputStream out = runninginstance.getOutputStream();
                    String response = this.readLine(in);
                    if (response == null || !response.equalsIgnoreCase("SingleAppInstance")) {
                        return false;
                    }
                    try {
                        if (message == null || message.length == 0) {
                            this.writeLine(out, "0");
                        } else {
                            this.writeLine(out, String.valueOf(message.length));
                            String[] stringArray = message;
                            int n = message.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String msg = stringArray[n2];
                                this.writeLine(out, msg);
                                ++n2;
                            }
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        return false;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
                finally {
                    if (runninginstance != null) {
                        try {
                            runninginstance.shutdownInput();
                        }
                        catch (Throwable throwable) {}
                        try {
                            runninginstance.shutdownOutput();
                        }
                        catch (Throwable throwable) {}
                        try {
                            runninginstance.close();
                        }
                        catch (Throwable throwable) {}
                        runninginstance = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private synchronized void foundRunningInstance() throws AnotherInstanceRunningException {
        this.alreadyUsed = true;
        this.lockChannel = null;
        this.fileLock = null;
        throw new AnotherInstanceRunningException(this.appID);
    }

    private synchronized void cannotStart(String cause) throws UncheckableInstanceException {
        this.alreadyUsed = true;
        this.lockChannel = null;
        this.fileLock = null;
        throw new UncheckableInstanceException(cause);
    }

    public synchronized void start() throws AnotherInstanceRunningException, UncheckableInstanceException {
        if (this.fileLock != null) {
            return;
        }
        if (this.alreadyUsed) {
            this.cannotStart("create new instance!");
        }
        try {
            if (this.sendToRunningInstance(null)) {
                this.foundRunningInstance();
            }
            this.lockChannel = new RandomAccessFile(this.lockFile, "rw").getChannel();
            try {
                this.fileLock = this.lockChannel.tryLock();
                if (this.fileLock == null) {
                    this.foundRunningInstance();
                }
            }
            catch (OverlappingFileLockException e) {
                this.foundRunningInstance();
            }
            catch (IOException e) {
                this.foundRunningInstance();
            }
            this.portFile.delete();
            this.serverSocket = new ServerSocket();
            InetSocketAddress socketAddress = new InetSocketAddress(this.getLocalHost(), 0);
            this.serverSocket.bind(socketAddress);
            FileOutputStream portWriter = null;
            try {
                portWriter = new FileOutputStream(this.portFile);
                portWriter.write(String.valueOf(this.serverSocket.getLocalPort()).getBytes());
                portWriter.flush();
                this.startDaemon();
                return;
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    portWriter.close();
                }
                catch (Throwable throwable) {}
            }
            this.cannotStart("could not create instance!");
        }
        catch (FileNotFoundException e) {
            this.cannotStart(e.getMessage());
        }
        catch (IOException e) {
            try {
                this.serverSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cannotStart(e.getMessage());
        }
    }

    public synchronized void exit() {
        if (this.fileLock == null) {
            return;
        }
        this.daemonRunning = false;
        if (this.daemon != null) {
            this.daemon.interrupt();
        }
        try {
            try {
                this.fileLock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.lockChannel.close();
            }
            catch (IOException iOException) {}
        }
        finally {
            this.lockChannel = null;
            this.fileLock = null;
            this.lockFile.delete();
            this.portFile.delete();
        }
    }

    private synchronized void startDaemon() {
        if (this.daemon != null) {
            return;
        }
        this.daemon = new Thread(new Runnable(){

            public void run() {
                SingleAppInstance.this.daemonRunning = true;
                while (SingleAppInstance.this.daemonRunning) {
                    if (SingleAppInstance.this.daemon.isInterrupted()) break;
                    Socket client = null;
                    try {
                        try {
                            int lines;
                            client = SingleAppInstance.this.serverSocket.accept();
                            client.setSoTimeout(10000);
                            BufferedInputStream in = new BufferedInputStream(client.getInputStream());
                            OutputStream out = client.getOutputStream();
                            SingleAppInstance.this.writeLine(out, "SingleAppInstance");
                            String line = SingleAppInstance.this.readLine(in);
                            if (line != null && line.length() > 0 && (lines = Integer.parseInt(line)) != 0) {
                                String[] message = new String[lines];
                                int index = 0;
                                while (index < lines) {
                                    message[index] = SingleAppInstance.this.readLine(in);
                                    ++index;
                                }
                                if (SingleAppInstance.this.listener != null) {
                                    try {
                                        SingleAppInstance.this.listener.parseMessage(message);
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                        catch (IOException e) {
                            Log.exception((Throwable)e);
                            if (client == null) continue;
                            try {
                                client.shutdownInput();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                client.shutdownOutput();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            client = null;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (client != null) {
                            try {
                                client.shutdownInput();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            try {
                                client.shutdownOutput();
                            }
                            catch (Throwable throwable3) {
                                // empty catch block
                            }
                            try {
                                client.close();
                            }
                            catch (Throwable throwable4) {
                                // empty catch block
                            }
                            client = null;
                        }
                        throw throwable;
                    }
                    if (client == null) continue;
                    try {
                        client.shutdownInput();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        client.shutdownOutput();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    client = null;
                }
                try {
                    SingleAppInstance.this.serverSocket.close();
                }
                catch (Throwable e) {
                    Log.exception((Throwable)e);
                }
            }
        });
        this.daemon.setName("SingleAppInstance: " + this.appID);
        this.daemon.setDaemon(true);
        this.daemon.start();
    }

    private void writeLine(OutputStream outputStream, String line) {
        if (outputStream == null || line == null) {
            return;
        }
        try {
            outputStream.write(line.getBytes("UTF-8"));
            outputStream.write("\r\n".getBytes());
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String readLine(BufferedInputStream in) {
        ByteArrayOutputStream inbuffer;
        block9: {
            inbuffer = new ByteArrayOutputStream();
            if (in == null) {
                return "";
            }
            in.mark(1);
            if (in.read() != -1) break block9;
            return null;
        }
        try {
            int c;
            in.reset();
            while ((c = in.read()) >= 0) {
                if (c == 0 || c == 10 || c == 13) break;
                inbuffer.write(c);
            }
            if (c == 13) {
                in.mark(1);
                if (in.read() != 10) {
                    in.reset();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return inbuffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private int readPortFromPortFile() {
        if (!this.portFile.exists()) {
            return 0;
        }
        try {
            String port = IO.readFileToString(this.portFile);
            return Integer.parseInt(String.valueOf(port).trim());
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static class ShutdownHook
    implements Runnable {
        private SingleAppInstance instance = null;

        public ShutdownHook(SingleAppInstance instance) {
            this.instance = instance;
        }

        public void run() {
            if (this.instance != null) {
                this.instance.exit();
            }
        }
    }
}

