/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.util.List;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Letter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevenShteinLetterComperator {
    private boolean[][][][] letterDB;
    private JAntiCaptcha jac;
    public boolean onlySameWidth = false;
    public int costs = 6;
    public boolean detectVerticalOffset = false;
    public boolean detectHorizonalOffset = false;

    public void run(Letter letter) {
        if (this.letterDB.length == 0 || letter.getWidth() == 0 || letter.getHeight() == 0) {
            return;
        }
        boolean[][][] b = this.getBooleanArrays(letter);
        int best = 0;
        int bestdist = Integer.MAX_VALUE;
        int[] bestOffset = null;
        int i = 0;
        while (i < this.letterDB.length) {
            int[] dist;
            if (!(this.onlySameWidth && this.jac.letterDB.get(i).getWidth() != letter.getWidth() || (dist = this.getLevenshteinDistance(b, this.letterDB[i], bestdist)) == null || bestdist <= dist[0])) {
                bestOffset = dist;
                bestdist = dist[0];
                best = i;
            }
            ++i;
        }
        if (bestOffset == null) {
            return;
        }
        Letter bestLetter = this.jac.letterDB.get(best);
        letter.detected = new LetterComperator(letter, bestLetter);
        letter.detected.setOffset(new int[]{bestOffset[1], bestOffset[2]});
        letter.detected.setValityPercent(75.0 * (double)bestdist / (double)this.costs / (double)letter.getArea());
        letter.setDecodedValue(bestLetter.getDecodedValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final Letter[] letters) {
        Thread[] ths = new Thread[letters.length];
        final LevenShteinLetterComperator lv = this;
        int i = 0;
        while (i < ths.length) {
            final int j = i;
            ths[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    lv.run(letters[j]);
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notify();
                    }
                }
            });
            ths[i].start();
            ++i;
        }
        Thread[] threadArray = ths;
        int n = ths.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            while (thread.isAlive()) {
                Thread thread2 = thread;
                synchronized (thread2) {
                    try {
                        thread.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
    }

    public void run(List<Letter> letters) {
        this.run(letters.toArray(new Letter[0]));
    }

    public LevenShteinLetterComperator(JAntiCaptcha jac) {
        this.letterDB = new boolean[jac.letterDB.size()][][][];
        this.jac = jac;
        int i = 0;
        while (i < this.letterDB.length) {
            this.letterDB[i] = this.getBooleanArrays(jac.letterDB.get(i));
            ++i;
        }
    }

    private boolean[][][] getBooleanArrays(Letter letter) {
        int y;
        int w = letter.getWidth();
        int h = letter.getHeight();
        if (w == 0 || h == 0) {
            return null;
        }
        boolean[][] leth1 = new boolean[w][h];
        int avg = (int)((double)letter.getAverage() * letter.owner.getJas().getDouble("RelativeContrast"));
        int x = 0;
        while (x < leth1.length) {
            y = 0;
            while (y < leth1[0].length) {
                leth1[x][y] = letter.grid[x][y] < avg;
                ++y;
            }
            ++x;
        }
        boolean[][] leth12 = new boolean[h][w];
        y = 0;
        while (y < leth1[0].length) {
            int x2 = 0;
            while (x2 < leth1.length) {
                leth12[y][x2] = leth1[x2][y];
                ++x2;
            }
            ++y;
        }
        return new boolean[][][]{leth1, leth12};
    }

    public double getLevenshteinDistance(Letter a, Letter b) {
        boolean[][][] bb;
        boolean[][][] ba = this.getBooleanArrays(a);
        int[] d = this.getLevenshteinDistance(ba, bb = this.getBooleanArrays(b), Integer.MAX_VALUE);
        if (d != null) {
            a.detected = new LetterComperator(a, b);
            a.detected.setOffset(new int[]{d[1], d[2]});
            double ret = 75.0 * (double)d[0] / (double)this.costs / (double)a.getArea();
            a.detected.setValityPercent(ret);
            return ret;
        }
        return Double.MAX_VALUE;
    }

    private int getBounds(boolean[][] lengthLong, boolean[][] lengthShort, boolean detectOffset) {
        int d = lengthLong.length - lengthShort.length;
        if (!detectOffset) {
            return d / 2;
        }
        int bestDist = Integer.MAX_VALUE;
        int besti = 0;
        int lsm1 = lengthShort.length - 1;
        int i = 0;
        while (i < d) {
            int dist = this.getLevenshteinDistance(lengthLong[i], lengthShort[0]);
            if ((dist += this.getLevenshteinDistance(lengthLong[i + lsm1], lengthShort[lsm1])) < bestDist) {
                bestDist = dist;
                besti = i;
            }
            ++i;
        }
        return besti;
    }

    private int getBoundDiff(boolean[][] bba1, int start, int end) {
        int c;
        int res = 0;
        int i = 0;
        while (i < start) {
            c = 0;
            while (c < bba1[i].length) {
                if (bba1[i][c]) {
                    ++res;
                }
                ++c;
            }
            ++i;
        }
        i = end;
        while (i < bba1.length) {
            c = 0;
            while (c < bba1[i].length) {
                if (bba1[i][c]) {
                    ++res;
                }
                ++c;
            }
            ++i;
        }
        return res;
    }

    private int[] getLevenshteinDistance(boolean[][][] ba, boolean[][][] bb, int best) {
        int res = 0;
        if (ba == null || bb == null) {
            return null;
        }
        boolean[][] bba1 = ba[0];
        boolean[][] bbb1 = bb[0];
        boolean[][] bba2 = ba[1];
        boolean[][] bbb2 = bb[1];
        int bounds1 = 0;
        int diff1 = bba1.length - bbb1.length;
        boolean swV = false;
        boolean swH = false;
        if (diff1 > 0) {
            bounds1 = this.getBounds(bba1, bbb1, this.detectVerticalOffset);
        } else if (diff1 < 0) {
            boolean[][] bac = bbb1;
            bbb1 = bba1;
            bba1 = bac;
            swV = true;
            bounds1 = this.getBounds(bba1, bbb1, this.detectVerticalOffset);
        } else {
            bounds1 = 0;
        }
        if (best < (res += this.getBoundDiff(bba1, bounds1, bbb1.length) * this.costs)) {
            return null;
        }
        int bounds2 = 0;
        int diff2 = bba2.length - bbb2.length;
        if (diff2 > 0) {
            bounds2 = this.getBounds(bba2, bbb2, this.detectHorizonalOffset);
        } else if (diff2 < 0) {
            boolean[][] bac = bbb2;
            bbb2 = bba2;
            bba2 = bac;
            swH = true;
            bounds2 = this.getBounds(bba2, bbb2, this.detectHorizonalOffset);
        } else {
            bounds2 = 0;
        }
        if (best < (res += this.getBoundDiff(bba2, bounds2, bbb2.length) * this.costs)) {
            return null;
        }
        int c = 0;
        while (c < bbb1.length) {
            if (best < (res += this.getLevenshteinDistance(bba1[c + bounds1], bbb1[c]))) {
                return null;
            }
            ++c;
        }
        c = 0;
        while (c < bbb2.length) {
            if (best < (res += this.getLevenshteinDistance(bba2[c + bounds2], bbb2[c]))) {
                return null;
            }
            ++c;
        }
        return new int[]{res, swV ? -bounds1 : bounds1, swH ? -bounds2 : bounds2};
    }

    private int getLevenshteinDistance(boolean[] l1, boolean[] l2) {
        if (l1 == null || l2 == null) {
            throw new IllegalArgumentException("Letter must not be null");
        }
        int n = l1.length;
        int m = l2.length;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int n1 = n + 1;
        int[] p = new int[n1];
        int[] d = new int[n1];
        int[] c = new int[n1];
        int cost = 0;
        int i = 1;
        while (i <= n) {
            p[i] = i;
            c[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= m) {
            int j1 = j;
            int j2 = --j1;
            --j2;
            boolean t_j = l2[j1];
            d[0] = j;
            i = 1;
            while (i <= n) {
                int i2;
                int i1 = i - 1;
                cost = l1[i1] == t_j ? 0 : 1;
                d[i] = Math.min(d[i1] + this.costs, Math.min(p[i] + this.costs, p[i1] + cost * this.costs));
                if (i > 1 && j > 1 && l1[i1] == l2[j2] && l1[i2 = i1 - 1] == l2[j1]) {
                    d[i] = Math.min(d[i], c[i2] + cost);
                }
                ++i;
            }
            i = 1;
            while (i <= n) {
                c[i] = p[i];
                ++i;
            }
            int[] _d = p;
            p = d;
            d = _d;
            ++j;
        }
        return p[n];
    }
}

