/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import jd.JDInit;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.BackGroundImageGUIList;
import jd.captcha.easy.ColorTrainerGUI;
import jd.captcha.easy.CreateHoster;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.easy.load.LoadCaptchas;
import jd.config.SubConfiguration;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.events.EDTEventQueue;
import jd.gui.swing.jdgui.settings.JDLabelListRenderer;
import jd.gui.swing.laf.LookAndFeelController;
import jd.gui.userio.DummyFrame;
import jd.nutils.Screen;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class EasyCaptchaTool {
    public static SubConfiguration config = SubConfiguration.getConfig((String)"EasyCaptcha");
    public static final String CONFIG_LASTSESSION = "CONFIG_LASTSESSION";
    public static final String CONFIG_AUTHOR = "AUTHOR";
    public static JFrame ownerFrame = DummyFrame.getDialogParent();

    public static EasyMethodFile showMethodes() {
        final EasyMethodFile ef = new EasyMethodFile();
        new GuiRunnable<Object>(){

            public Object runSave() {
                final JDialog cHosterDialog = new JDialog(ownerFrame);
                cHosterDialog.setDefaultCloseOperation(2);
                cHosterDialog.setTitle(JDL.L((String)"easycaptcha.tool.mothodedialog.title", (String)"EasyCaptcha Methodes"));
                cHosterDialog.setModal(true);
                cHosterDialog.setAlwaysOnTop(true);
                Box box = new Box(1);
                JPanel pa = new JPanel(new GridLayout(2, 1));
                pa.add(new JLabel(JDL.L((String)"easycaptcha.tool.mothodedialog.selectmethode", (String)"select the methode:")));
                EasyMethodFile[] paths = EasyMethodFile.getMethodeList();
                final JComboBox<EasyMethodFile> combox = new JComboBox<EasyMethodFile>(paths);
                combox.setRenderer((ListCellRenderer<EasyMethodFile>)new JDLabelListRenderer());
                combox.setMinimumSize(new Dimension(24, 70));
                pa.add(combox);
                box.add(pa);
                pa = new JPanel(new GridLayout(1, 2));
                JButton ok = new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
                pa.add(ok);
                ok.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        EasyMethodFile ef2 = (EasyMethodFile)combox.getSelectedItem();
                        if (ef2 != null) {
                            ef.file = ef2.file;
                            cHosterDialog.dispose();
                        }
                    }
                });
                JButton cancel = new JButton(JDL.L((String)"gui.btn_cancel", (String)"Cancel"));
                pa.add(cancel);
                cancel.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        cHosterDialog.dispose();
                    }
                });
                box.add(pa);
                cHosterDialog.add(box);
                cHosterDialog.pack();
                cHosterDialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)cHosterDialog));
                cHosterDialog.setVisible(true);
                return null;
            }
        }.waitForEDT();
        if (ef.file == null) {
            return null;
        }
        return ef;
    }

    private static EasyMethodFile getCaptchaMethode() {
        return (EasyMethodFile)new GuiRunnable<EasyMethodFile>(){

            public EasyMethodFile runSave() {
                final EasyMethodFile ef = new EasyMethodFile();
                final JDialog dialog = new JDialog(ownerFrame);
                dialog.setDefaultCloseOperation(2);
                dialog.setTitle(JDL.L((String)"easycaptcha.tool.title", (String)"EasyCaptcha"));
                dialog.setModal(true);
                JPanel box = new JPanel(new GridLayout(3, 1));
                JButton btcs = new JButton(JDL.L((String)"easycaptcha.tool.continuelastsession", (String)"Continue Last Session"));
                final EasyMethodFile lastEF = (EasyMethodFile)config.getProperty(EasyCaptchaTool.CONFIG_LASTSESSION, null);
                if (lastEF == null) {
                    btcs.setEnabled(false);
                }
                btcs.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ef.file = lastEF.file;
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                dialog.dispose();
                                return null;
                            }
                        }.waitForEDT();
                    }
                });
                box.add(btcs);
                JButton btl = new JButton(JDL.L((String)"easycaptcha.tool.loadmethode", (String)"Load Methode"));
                btl.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        EasyMethodFile ef2 = EasyCaptchaTool.showMethodes();
                        if (ef2 != null) {
                            ef.file = ef2.file;
                            dialog.dispose();
                        }
                    }
                });
                box.add(btl);
                JButton btc = new JButton(JDL.L((String)"easycaptcha.tool.createmethode", (String)"Create Methode"));
                btc.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                final JDialog cHosterDialog = new JDialog(ownerFrame);
                                cHosterDialog.setAlwaysOnTop(true);
                                cHosterDialog.setDefaultCloseOperation(2);
                                cHosterDialog.setTitle(JDL.L((String)"easycaptcha.tool.title", (String)"EasyCaptcha"));
                                cHosterDialog.setModal(true);
                                JPanel box = new JPanel(new GridLayout(4, 2));
                                final JTextField tfHoster = new JTextField();
                                box.add(new JLabel(String.valueOf(JDL.L((String)"gui.column_host", (String)"Host")) + ":"));
                                box.add(tfHoster);
                                final JTextField tfAuthor = new JTextField(config.getStringProperty(EasyCaptchaTool.CONFIG_AUTHOR, "JDTeam"));
                                box.add(new JLabel(String.valueOf(JDL.L((String)"gui.config.jac.column.author", (String)"Author")) + ":"));
                                box.add(tfAuthor);
                                final JSpinner spMaxLetters = new JSpinner(new SpinnerNumberModel(4, 1, 40, 1));
                                box.add(new JLabel(String.valueOf(JDL.L((String)"easycaptcha.tool.maxletternum", (String)"Maximal number of letters")) + ":"));
                                box.add(spMaxLetters);
                                JButton ok = new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
                                box.add(ok);
                                ok.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        if (tfHoster.getText() != null && !tfHoster.getText().matches("\\s*")) {
                                            ef.file = new File(String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/" + JDUtilities.getJACMethodsDirectory(), tfHoster.getText());
                                            dialog.dispose();
                                            cHosterDialog.dispose();
                                            if (tfAuthor.getText() != null && !tfAuthor.getText().matches("\\s*")) {
                                                config.setProperty(EasyCaptchaTool.CONFIG_AUTHOR, (Object)tfAuthor.getText());
                                            }
                                            CreateHoster.create(new EasyMethodFile("easycaptcha"), ef, tfAuthor.getText(), (Integer)spMaxLetters.getValue());
                                        } else {
                                            JOptionPane.showConfirmDialog(null, JDL.L((String)"easycaptcha.tool.warning.hostnamemissing", (String)"the hostname is missing"), JDL.L((String)"easycaptcha.tool.warning.hostnamemissing", (String)"the hostname is missing"), -1, 2);
                                        }
                                    }
                                });
                                JButton cancel = new JButton(JDL.L((String)"gui.btn_cancel", (String)"Cancel"));
                                box.add(cancel);
                                cancel.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        cHosterDialog.dispose();
                                    }
                                });
                                cHosterDialog.add(box);
                                cHosterDialog.pack();
                                cHosterDialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)cHosterDialog));
                                cHosterDialog.setVisible(true);
                                return null;
                            }
                        }.waitForEDT();
                    }
                });
                box.add(btc);
                dialog.add(box);
                dialog.pack();
                dialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)dialog));
                dialog.setVisible(true);
                if (ef.file != null) {
                    config.setProperty(EasyCaptchaTool.CONFIG_LASTSESSION, (Object)ef);
                    EasyCaptchaTool.saveConfig();
                    return ef;
                }
                return null;
            }
        }.getReturnValue();
    }

    public static void saveConfig() {
        config.save();
        JDUtilities.getConfiguration().save();
    }

    public static void checkReadyToTrain(final EasyMethodFile meth, final JButton btnTrain) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                btnTrain.setEnabled(meth.isReadyToTrain());
                return null;
            }
        }.waitForEDT();
    }

    public static void showToolKid(final EasyMethodFile meth) {
        CreateHoster.setImageType(meth);
        File folder = meth.getCaptchaFolder();
        if (!folder.exists() || folder.list().length < 1) {
            System.exit(0);
        }
        final JAntiCaptcha jac = new JAntiCaptcha(meth.getName());
        final JDialog dialog = (JDialog)new GuiRunnable<JDialog>(){

            public JDialog runSave() {
                return new JDialog(ownerFrame);
            }
        }.getReturnValue();
        dialog.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        dialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)dialog));
        dialog.setTitle(JDL.L((String)"easycaptcha.tool.title", (String)"EasyCaptcha"));
        JPanel box = (JPanel)new GuiRunnable<JPanel>(){

            public JPanel runSave() {
                return new JPanel(new GridLayout(5, 1));
            }
        }.getReturnValue();
        final JButton btnTrain = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"easycaptcha.tool.btn.train", (String)"Train"));
            }
        }.getReturnValue();
        btnTrain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        jac.trainAllCaptchas(meth.getCaptchaFolder().getAbsolutePath());
                    }
                }).start();
            }
        });
        box.add(btnTrain);
        JButton btnShowLetters = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"easycaptcha.tool.btn.letterdb", (String)"Show Letter Database"));
            }
        }.getReturnValue();
        btnShowLetters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        jac.displayLibrary();
                    }
                }).start();
            }
        });
        box.add(btnShowLetters);
        final JButton btnColorTrainer = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"easycaptcha.tool.btn.colortrainer", (String)"Train Colors"));
            }
        }.getReturnValue();
        btnColorTrainer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        ColorTrainerGUI.getColor(meth, ownerFrame);
                        EasyCaptchaTool.checkReadyToTrain(meth, btnTrain);
                    }
                }).start();
            }
        });
        box.add(btnColorTrainer);
        final JButton btnBackGround = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"easycaptcha.tool.btn.background", (String)"Remove Backgrounds"));
            }
        }.getReturnValue();
        btnBackGround.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        new BackGroundImageGUIList(meth, ownerFrame).show();
                    }
                }).start();
            }
        });
        box.add(btnBackGround);
        JButton btnColorLoadCaptchas = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"easycaptcha.tool.btn.loadcaptchas", (String)"Load Captchas"));
            }
        }.getReturnValue();
        btnColorLoadCaptchas.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        new LoadCaptchas(ownerFrame, meth.file.getName()).start();
                    }
                }).start();
            }
        });
        if (!meth.isEasyCaptchaMethode()) {
            new GuiRunnable<Object>(){

                public Object runSave() {
                    btnColorTrainer.setEnabled(false);
                    btnBackGround.setEnabled(false);
                    return null;
                }
            }.waitForEDT();
        } else {
            EasyCaptchaTool.checkReadyToTrain(meth, btnTrain);
        }
        box.add(btnColorLoadCaptchas);
        dialog.add(box);
        new GuiRunnable<Object>(){

            public Object runSave() {
                dialog.pack();
                dialog.setVisible(true);
                return null;
            }
        }.waitForEDT();
    }

    public static void main(String[] args) {
        new JDInit().loadConfiguration();
        LookAndFeelController.setUIManager();
        new GuiRunnable<Object>(){

            public Object runSave() {
                Toolkit.getDefaultToolkit().getSystemEventQueue().push((EventQueue)new EDTEventQueue());
                return null;
            }
        }.waitForEDT();
        EasyMethodFile meth = EasyCaptchaTool.getCaptchaMethode();
        EasyCaptchaTool.showToolKid(meth);
    }
}

