/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.CPoint;
import jd.captcha.easy.ColorTrainer;
import jd.captcha.easy.EasyCaptchaTool;
import jd.captcha.easy.load.LoadCaptchas;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.Utilities;
import jd.config.container.JDLabelContainer;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.jdgui.userio.UserIOGui;
import jd.nutils.JDFlags;
import jd.nutils.JDImage;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

public class EasyMethodFile
implements JDLabelContainer,
Serializable {
    public File file = null;
    private static final long serialVersionUID = 1L;

    public EasyMethodFile(String methodename) {
        this.file = new File(String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/" + JDUtilities.getJACMethodsDirectory(), methodename);
    }

    public EasyMethodFile(File file) {
        this.file = file;
    }

    public boolean copyExampleImage() {
        File[] listF;
        File exf = this.getExampleImage();
        if (!(exf != null && exf.exists() || (listF = this.getCaptchaFolder().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("(?is).*\\.(jpg|png|gif)");
            }
        })) == null || listF.length <= 1)) {
            JDIO.copyFile((File)listF[0], (File)new File(this.file, "example." + this.getCaptchaType(false)));
            return true;
        }
        return false;
    }

    public EasyMethodFile() {
    }

    public boolean isReadyToTrain() {
        if (!this.isEasyCaptchaMethode()) {
            return true;
        }
        Vector<CPoint> list = ColorTrainer.load(new File(this.file, "CPoints.xml"));
        boolean hasForderGround = false;
        boolean hasBackGround = false;
        for (CPoint point : list) {
            if (point.isForeground()) {
                hasForderGround = true;
                continue;
            }
            hasBackGround = true;
        }
        return hasForderGround && hasBackGround;
    }

    public boolean isEasyCaptchaMethode() {
        File js = this.getScriptJas();
        return js.exists() && JDIO.readFileToString((File)js).contains("param.useSpecialGetLetters=EasyCaptcha");
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getScriptJas() {
        return new File(this.file, "script.jas");
    }

    public File getJacinfoXml() {
        return new File(this.file, "jacinfo.xml");
    }

    public JAntiCaptcha getJac() {
        return new JAntiCaptcha(this.getName());
    }

    public static EasyMethodFile[] getMethodeList() {
        File[] files = new File(String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/" + JDUtilities.getJACMethodsDirectory()).listFiles();
        ArrayList<EasyMethodFile> ret = new ArrayList<EasyMethodFile>();
        int i = 0;
        while (i < files.length) {
            EasyMethodFile ef = new EasyMethodFile(files[i]);
            if (ef.getScriptJas().exists()) {
                ret.add(ef);
            }
            ++i;
        }
        return ret.toArray(new EasyMethodFile[0]);
    }

    public File getCaptchaFolder() {
        return new File(String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/captchas/" + this.file.getName());
    }

    public File getExampleImage() {
        File[] files = this.file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String ln = pathname.getName().toLowerCase();
                return ln.contains("example") && ln.matches(".*\\.(jpg|jpeg|gif|png|bmp)");
            }
        });
        if (files != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    public String getCaptchaType(boolean showLoadDialog) {
        final File folder2 = this.getCaptchaFolder();
        if (showLoadDialog && (!folder2.exists() || folder2.list().length < 1)) {
            int res = UserIOGui.getInstance().requestConfirmDialog(0, JDL.L((String)"easycaptcha.loadcaptchas.title", (String)"Load Captchas"), JDL.L((String)"easycaptcha.needCaptchas", (String)"You need Captchas first!"), null, JDL.L((String)"easycaptcha.openCaptchaFolder", (String)"Open Captcha Folder"), JDL.L((String)"easycaptcha.loadcaptchas", (String)"Load Captchas"));
            if (JDFlags.hasSomeFlags((int)res, (int[])new int[]{2})) {
                folder2.mkdir();
                this.openCaptchaFolder();
                return "jpg";
            }
            return (String)new GuiRunnable<String>(){

                public String runSave() {
                    if (!new LoadCaptchas(EasyCaptchaTool.ownerFrame, EasyMethodFile.this.file.getName()).start()) {
                        EasyMethodFile.this.openCaptchaFolder();
                        return "jpg";
                    }
                    String filetype = "jpg";
                    File[] fl = folder2.listFiles();
                    if (fl[fl.length - 1].getName().toLowerCase().contains("png")) {
                        filetype = "png";
                    } else if (fl[fl.length - 1].getName().toLowerCase().contains("gif")) {
                        filetype = "gif";
                    }
                    return filetype;
                }
            }.getReturnValue();
        }
        String filetype = "jpg";
        File[] fl = folder2.listFiles();
        if (fl != null && fl.length > 0) {
            if (fl[fl.length - 1].getName().toLowerCase().contains("png")) {
                filetype = "png";
            } else if (fl[fl.length - 1].getName().toLowerCase().contains("gif")) {
                filetype = "gif";
            }
        }
        return filetype;
    }

    public void openCaptchaFolder() {
        JDUtilities.openExplorer((File)this.getCaptchaFolder());
    }

    public ImageIcon getIcon() {
        try {
            File image = this.getExampleImage();
            if (image != null) {
                ImageIcon img = JDImage.getScaledImageIcon((ImageIcon)JDImage.getImageIcon((File)image), (int)44, (int)24);
                return img;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public File getRandomCaptchaFile() {
        File[] list = this.getCaptchaFolder().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String ln = pathname.getName().toLowerCase();
                return pathname.isFile() && ln.matches(".*\\.(jpg|jpeg|gif|png|bmp)") && pathname.length() > 1L;
            }
        });
        if (list.length == 0) {
            return null;
        }
        int id = (int)(Math.random() * (double)(list.length - 1));
        return list[id];
    }

    public Captcha getRandomCaptcha() {
        Captcha captchaImage = this.getJac().createCaptcha(Utilities.loadImage(this.getRandomCaptchaFile()));
        if (captchaImage != null && captchaImage.getWidth() > 0 && captchaImage.getWidth() > 0) {
            return captchaImage;
        }
        captchaImage = this.getJac().createCaptcha(Utilities.loadImage(this.getRandomCaptchaFile()));
        if (captchaImage != null && captchaImage.getWidth() > 0 && captchaImage.getWidth() > 0) {
            return captchaImage;
        }
        return null;
    }

    public String toString() {
        File infoxml = this.getJacinfoXml();
        String ret = null;
        try {
            if (infoxml.exists()) {
                ret = new Regex(JDIO.readFileToString((File)infoxml), "name=\"([^\"]*)").getMatch(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            ret = this.file.getName();
        }
        return ret;
    }

    public String getLabel() {
        return this.toString();
    }

    public String getName() {
        return this.toString();
    }
}

