/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import com.jhlabs.image.BoxBlurFilter;
import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.PosterizeFilter;
import com.jhlabs.image.QuantizeFilter;
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.gui.BasicWindow;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.utils.Utilities;
import jd.controlling.JDLogger;
import jd.nutils.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Captcha
extends PixelGrid {
    private static Logger logger = Utilities.getLogger();
    private static final long serialVersionUID = 1L;
    private File captchafile;
    private ColorModel colorModel;
    private String correctCaptchaCode;
    private boolean[] gaps;
    private int lastletterX = 0;
    private LetterComperator[] letterComperators;
    private boolean perfectObjectDetection;
    private boolean prepared = false;
    public int[][] rgbGrid;
    private Letter[] seperatedLetters;
    private double valityPercent;

    public static Captcha getCaptcha(File file, JAntiCaptcha owner) {
        Image img = Utilities.loadImage(file);
        Captcha ret = Captcha.getCaptcha(img, owner);
        return ret;
    }

    public static Captcha getCaptcha(Image image, JAntiCaptcha owner) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            return null;
        }
        if ((width <= 0 || height <= 0) && Utilities.isLoggerActive()) {
            logger.severe("ERROR: Image nicht korrekt. Kein Inhalt. Pfad URl angaben Korrigieren");
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, false);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            return null;
        }
        Captcha ret = new Captcha(width, height);
        ret.setOwner(owner);
        if (Utilities.isLoggerActive()) {
            logger.fine(String.valueOf(width) + "/" + height);
        }
        ret.setColorModel(pg.getColorModel());
        ColorModel cm = pg.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            ret.setPixel((int[])pg.getPixels());
        } else {
            ret.setPixel((byte[])pg.getPixels());
        }
        ret.setOrgGrid(PixelGrid.getGridCopy(ret.getGrid()));
        return ret;
    }

    public void resizetoHeight(int newHeight) {
        double faktor = (double)newHeight / (double)this.getHeight();
        int newWidth = (int)Math.ceil((double)this.getWidth() * faktor);
        int[][] newGrid = new int[newWidth][newHeight];
        int x = 0;
        while (x < newWidth) {
            int y = 0;
            while (y < newHeight) {
                int v;
                newGrid[x][y] = v = this.grid[(int)Math.floor((double)x / faktor)][(int)Math.floor((double)y / faktor)];
                ++y;
            }
            ++x;
        }
        this.setGrid(newGrid);
    }

    public static Captcha getCaptcha(Letter a, Letter b) {
        int y;
        int newWidth = a.getWidth() + b.getWidth() + 6;
        int newHeight = Math.max(a.getHeight(), b.getHeight());
        Captcha ret = new Captcha(newWidth, newHeight);
        if (a.owner != null) {
            ret.setOwner(a.owner);
        }
        if (ret.owner == null) {
            ret.setOwner(b.owner);
        }
        if (ret.owner == null && Utilities.isLoggerActive()) {
            logger.warning("Owner konnte nicht bestimmt werden!Dieser captcha ist nur eingeschr\u00e4nkt verwendbar.");
        }
        ret.grid = new int[newWidth][newHeight];
        int x = 0;
        while (x < a.getWidth()) {
            y = 0;
            while (y < newHeight) {
                ret.grid[x][y] = y < a.getHeight() ? a.grid[x][y] : a.getMaxPixelValue();
                ++y;
            }
            ++x;
        }
        x = a.getWidth();
        while (x < a.getWidth() + 6) {
            y = 0;
            while (y < newHeight) {
                ret.grid[x][y] = x == a.getWidth() + 2 || x == a.getWidth() + 3 ? 0 : a.getMaxPixelValue();
                ++y;
            }
            ++x;
        }
        x = a.getWidth() + 6;
        while (x < newWidth) {
            y = 0;
            while (y < newHeight) {
                ret.grid[x][y] = y < b.getHeight() ? b.grid[x - (a.getWidth() + 6)][y] : b.getMaxPixelValue();
                ++y;
            }
            ++x;
        }
        return ret;
    }

    public Captcha(int width, int height) {
        super(width, height);
        this.rgbGrid = new int[width][height];
    }

    public void cleanBackgroundByHorizontalSampleLine(int x1, int x2, int y1, int y2) {
        int avg = this.getAverage(x1, y1, x2 - x1, y2 - y1);
        this.cleanBackgroundByColor(avg);
    }

    public void cleanWithDetailMask(Captcha mask, int dif, int tolerance) {
        int[][] newgrid = new int[this.getWidth()][this.getHeight()];
        int[][] test = new int[this.getWidth()][this.getHeight()];
        if (mask.getWidth() != this.getWidth() || mask.getHeight() != this.getHeight()) {
            if (Utilities.isLoggerActive()) {
                logger.info("ERROR Maske und Bild passen nicht zusammmen");
            }
            return;
        }
        if (Utilities.isLoggerActive()) {
            logger.info(String.valueOf(dif) + "_");
        }
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                int min2 = 1;
                test[x][y] = Math.abs(mask.getPixelValue(x, y) - this.getPixelValue(x, y));
                int del = 0;
                int del2 = 0;
                if (Colors.getColorDifference((int)mask.getPixelValue(x, y), (int)this.getPixelValue(x, y)) < (double)dif) {
                    del += tolerance;
                    del2 += tolerance;
                    int i = 1;
                    while (i < tolerance) {
                        if (y + i < this.getHeight()) {
                            if (Colors.getColorDifference((int)mask.getPixelValue(x, y + i), (int)this.getPixelValue(x, y + i)) < (double)dif) {
                                del += tolerance - i;
                            }
                            del2 += tolerance - i;
                        } else {
                            ++min2;
                        }
                        ++i;
                    }
                    i = 1;
                    while (i < tolerance) {
                        if (x + i < this.getWidth()) {
                            if (Colors.getColorDifference((int)mask.getPixelValue(x + i, y), (int)this.getPixelValue(x + i, y)) < (double)dif) {
                                del += tolerance - i;
                            }
                            del2 += tolerance - i;
                        } else {
                            ++min2;
                        }
                        ++i;
                    }
                }
                if ((double)(del *= min2) > (double)del2 / 1.5) {
                    PixelGrid.setPixelValue(x, y, newgrid, this.getMaxPixelValue());
                } else {
                    newgrid[x][y] = this.grid[x][y];
                }
                ++y;
            }
            ++x;
        }
        this.grid = newgrid;
    }

    public void cleanWithDetailMask(Captcha mask, int dif) {
        int[][] newgrid = new int[this.getWidth()][this.getHeight()];
        if (mask.getWidth() != this.getWidth() || mask.getHeight() != this.getHeight()) {
            if (Utilities.isLoggerActive()) {
                logger.info("ERROR Maske und Bild passen nicht zusammmen");
            }
            return;
        }
        if (Utilities.isLoggerActive()) {
            logger.info(String.valueOf(dif) + "_");
        }
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                if (Colors.getColorDifference((int)mask.getPixelValue(x, y), (int)this.getPixelValue(x, y)) < (double)dif) {
                    PixelGrid.setPixelValue(x, y, newgrid, this.getMaxPixelValue());
                } else {
                    newgrid[x][y] = this.grid[x][y];
                }
                ++y;
            }
            ++x;
        }
        this.grid = newgrid;
    }

    public void cleanWithMask(Captcha mask, int width, int height) {
        int[][] newgrid = new int[this.getWidth()][this.getHeight()];
        if (mask.getWidth() != this.getWidth() || mask.getHeight() != this.getHeight()) {
            if (Utilities.isLoggerActive()) {
                logger.info("ERROR Maske und Bild passen nicht zusammmen");
            }
            return;
        }
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                if (mask.getPixelValue(x, y) < 100) {
                    PixelGrid.setPixelValue(x, y, newgrid, this.getAverage(x, y, width, height, mask));
                } else {
                    newgrid[x][y] = this.grid[x][y];
                }
                ++y;
            }
            ++x;
        }
        this.grid = newgrid;
    }

    public void concat(Captcha tmp) {
        if (this.getWidth() != tmp.getWidth() || this.getHeight() != tmp.getHeight()) {
            if (Utilities.isLoggerActive()) {
                logger.severe("Concat fehlgeschlagen Dimensions nicht gleich");
            }
            return;
        }
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                if ((double)PixelGrid.getPixelValue(x, y, tmp.grid) > this.owner.getJas().getDouble("getBlackPercent") * (double)this.getMaxPixelValue()) {
                    int newPixelValue = Colors.mixColors((int)this.getPixelValue(x, y), (int)PixelGrid.getPixelValue(x, y, tmp.grid));
                    this.setPixelValue(x, y, newPixelValue);
                }
                ++y;
            }
            ++x;
        }
    }

    public void convertOriginalPixel(String newColorFormat) {
        this.owner.getJas().setColorType(newColorFormat);
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                Color c = new Color(this.rgbGrid[x][y]);
                float[] col = new float[4];
                if (this.owner.getJas().getColorFormat() == 0) {
                    Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), col);
                    col[3] = 0.0f;
                } else if (this.owner.getJas().getColorFormat() == 1) {
                    col[0] = (float)c.getRed() / 255.0f;
                    col[1] = (float)c.getGreen() / 255.0f;
                    col[2] = (float)c.getBlue() / 255.0f;
                    col[3] = 0.0f;
                }
                this.grid[x][y] = (int)(col[this.owner.getJas().getColorComponent(0)] * 255.0f) * 65536 + (int)(col[this.owner.getJas().getColorComponent(1)] * 255.0f) * 256 + (int)(col[this.owner.getJas().getColorComponent(2)] * 255.0f);
                ++x;
            }
            ++y;
        }
    }

    public void convertPixel(String newColorFormat) {
        this.owner.getJas().setColorType(newColorFormat);
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                Color c = new Color(this.grid[x][y]);
                float[] col = new float[4];
                if (this.owner.getJas().getColorFormat() == 0) {
                    Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), col);
                    col[3] = 0.0f;
                } else if (this.owner.getJas().getColorFormat() == 1) {
                    col[0] = (float)c.getRed() / 255.0f;
                    col[1] = (float)c.getGreen() / 255.0f;
                    col[2] = (float)c.getBlue() / 255.0f;
                    col[3] = 0.0f;
                }
                this.grid[x][y] = (int)(col[this.owner.getJas().getColorComponent(0)] * 255.0f) * 65536 + (int)(col[this.owner.getJas().getColorComponent(1)] * 255.0f) * 256 + (int)(col[this.owner.getJas().getColorComponent(2)] * 255.0f);
                ++x;
            }
            ++y;
        }
    }

    public void destroyInternalData() {
    }

    public int getAverage(int px, int py, int width, int height, Captcha mask) {
        int[] avg = new int[3];
        int i = 0;
        int halfW = width / 2;
        int halfH = height / 2;
        if (width == 1 && px == 0) {
            width = 2;
        }
        if (height == 1 && py == 0) {
            height = 2;
        }
        int x = Math.max(0, px - halfW);
        while (x < Math.min(px + width - halfW, this.getWidth())) {
            int y = Math.max(0, py - halfH);
            while (y < Math.min(py + height - halfH, this.getHeight())) {
                if (mask.getPixelValue(x, y) > 100) {
                    int[] bv = Colors.hexToRgb((int)this.getPixelValue(x, y));
                    avg[0] = avg[0] + bv[0];
                    avg[1] = avg[1] + bv[1];
                    avg[2] = avg[2] + bv[2];
                    ++i;
                }
                ++y;
            }
            ++x;
        }
        avg[0] = avg[0] / i;
        avg[1] = avg[1] / i;
        avg[2] = avg[2] / i;
        return Colors.rgbToHex((int[])avg);
    }

    public Vector<PixelObject> getBiggestObjects(int letterNum, int minArea, double contrast, double objectContrast) {
        int found = 0;
        int i = 0;
        int minWidth = Integer.MAX_VALUE;
        Vector<PixelObject> objects = this.getObjects(contrast, objectContrast);
        if (this.owner.jas.getBoolean("directLetterDetection")) {
            logger.info("Get directLetterDetection");
            Vector<PixelObject> objectsret = new Vector<PixelObject>();
            int bx = this.owner.getJas().getInteger("borderVarianceX");
            int by = this.owner.getJas().getInteger("borderVarianceY");
            int objectI = 0;
            while (objectI < objects.size()) {
                LetterComperator resletter;
                Letter letter;
                PixelObject current;
                PixelObject pixelObject = objects.get(objectI);
                if (pixelObject.getArea() > minArea * 2) {
                    int b;
                    this.owner.getJas().set("borderVarianceX", bx * this.owner.getJas().getInteger("minimumLetterWidth") * 100);
                    this.owner.getJas().set("borderVarianceY", by * this.owner.getJas().getInteger("minimumLetterWidth") * 100);
                    current = pixelObject;
                    letter = current.toLetter();
                    resletter = this.owner.getLetter(letter);
                    resletter.setValityPercent(resletter.getValityPercent() * 0.75);
                    current.detected = resletter;
                    if (resletter.getB() != null && !resletter.getDecodedValue().equals("-") && (b = pixelObject.getArea() - resletter.getB().getArea()) > minArea && b > resletter.getB().getArea() / 3 && resletter.getOffset() != null && resletter.getOffset().length > 0) {
                        logger.info("dld: got letter: " + resletter.getDecodedValue());
                        PixelObject[] spobjects = current.cut(resletter.getOffset()[0], resletter.getOffset()[0] + resletter.getB().getWidth(), this.owner.jas.getInteger("splitPixelObjectsOverlap"));
                        PixelObject cutter = spobjects[1];
                        PixelObject pre = spobjects[0];
                        PixelObject post = spobjects[2];
                        if (this.owner.isShowDebugGui()) {
                            BasicWindow.showImage(cutter.toLetter().getImage(), "cutter " + resletter.getDecodedValue());
                        }
                        objectsret.add(cutter);
                        cutter.detected = resletter;
                        if (pre != null && pre.getArea() > minArea && pre.getSize() > this.owner.getJas().getInteger("minObjectSize")) {
                            objects.add(pre);
                            if (this.owner.isShowDebugGui()) {
                                BasicWindow.showImage(pre.toLetter().getImage(), "pre cut " + resletter.getDecodedValue());
                            }
                        }
                        if (post != null && post.getArea() > minArea && post.getSize() > this.owner.getJas().getInteger("minObjectSize")) {
                            objects.add(post);
                            if (this.owner.isShowDebugGui()) {
                                BasicWindow.showImage(post.toLetter().getImage(), "post cut " + resletter.getDecodedValue());
                            }
                        }
                    } else {
                        objectsret.add(current);
                        if (this.owner.isShowDebugGui()) {
                            BasicWindow.showImage(current.toLetter().getImage(), "normal ext " + resletter.getDecodedValue());
                        }
                    }
                    this.owner.getJas().set("borderVarianceX", bx);
                    this.owner.getJas().set("borderVarianceY", by);
                } else {
                    current = pixelObject;
                    letter = current.toLetter();
                    current.detected = resletter = this.owner.getLetter(letter);
                    if (this.owner.isShowDebugGui()) {
                        BasicWindow.showImage(current.toLetter().getImage(), "normal " + resletter.getDecodedValue());
                    }
                    objectsret.add(current);
                }
                ++objectI;
            }
            objects = objectsret;
        }
        this.mergeMultiPartObjects(objects);
        if (this.owner.jas.getBoolean("autoLetterNum")) {
            Iterator<PixelObject> iterr = objects.iterator();
            int r = 0;
            while (iterr.hasNext()) {
                PixelObject pixelObject = iterr.next();
                if (pixelObject.getArea() <= minArea) continue;
                ++r;
            }
            this.owner.setLetterNum(r);
            letterNum = r;
        }
        boolean perfectObjectDetection = true;
        while (i < objects.size() && objects.elementAt(i++).getArea() > minArea && found < letterNum) {
            if (Utilities.isLoggerActive()) {
                logger.info(String.valueOf(objects.elementAt(i - 1).getWidth()) + " Element: " + found + " : " + objects.elementAt(i - 1).getArea());
            }
            ++found;
        }
        if (!this.owner.jas.getBoolean("autoLetterNum")) {
            if (Utilities.isLoggerActive()) {
                logger.fine("found " + found + " minArea: " + minArea);
            }
            while (objects.size() > 0 && found < letterNum) {
                int splitNum;
                PixelObject po = objects.remove(0);
                PixelObject next = null;
                if (objects.size() > 0) {
                    next = objects.elementAt(0);
                }
                --found;
                int maxWidth = po.getWidth();
                minWidth = minArea / po.getHeight();
                if (this.owner.getJas().getInteger("minimumLetterWidth") > 0 && this.owner.getJas().getInteger("minimumLetterWidth") > minWidth) {
                    minWidth = this.owner.getJas().getInteger("minimumLetterWidth");
                }
                int splitter = 1;
                if (Utilities.isLoggerActive()) {
                    logger.info(String.valueOf(maxWidth) + "/" + minWidth);
                }
                while ((splitNum = Math.min((int)Math.ceil((double)maxWidth / ((double)minWidth / (double)splitter)), letterNum - found)) < 2) {
                    ++splitter;
                }
                if (Utilities.isLoggerActive()) {
                    logger.info("l " + splitNum);
                }
                while (found + splitNum > letterNum) {
                    --splitNum;
                }
                if (Utilities.isLoggerActive()) {
                    logger.info("l " + splitNum);
                }
                while (splitNum > 2 && next != null && (double)(maxWidth / splitNum) < (double)next.getWidth() * 0.55) {
                    --splitNum;
                }
                if (Utilities.isLoggerActive()) {
                    logger.finer("teile erstes element " + po.getWidth() + " : splitnum " + splitNum);
                }
                if (found + splitNum - 1 > letterNum || splitNum < 2) {
                    if (Utilities.isLoggerActive()) {
                        logger.severe("Richtige Letteranzahl 1 konnte nicht ermittelt werden");
                    }
                    return null;
                }
                Vector<PixelObject> splitObjects = po.split(splitNum, this.owner.jas.getInteger("splitPixelObjectsOverlap"));
                if (Utilities.isLoggerActive()) {
                    logger.finer("Got splited: " + splitObjects.size());
                }
                int t = 0;
                while (t < splitNum) {
                    int s = 0;
                    while (s < objects.size()) {
                        if (splitObjects.elementAt(t).getArea() > objects.elementAt(s).getArea()) {
                            objects.add(s, splitObjects.elementAt(t));
                            splitObjects.setElementAt(null, t);
                            ++found;
                            perfectObjectDetection = false;
                            if (!Utilities.isLoggerActive()) break;
                            logger.finer("add split " + found);
                            break;
                        }
                        ++s;
                    }
                    if (splitObjects.elementAt(t) != null) {
                        objects.add(splitObjects.elementAt(t));
                        splitObjects.setElementAt(null, t);
                        ++found;
                        perfectObjectDetection = false;
                        if (Utilities.isLoggerActive()) {
                            logger.finer("add split " + found);
                        }
                    }
                    ++t;
                }
                if (!Utilities.isLoggerActive()) continue;
                logger.finer("splitted ... treffer: " + found);
            }
            if (found != letterNum && !this.owner.jas.getBoolean("autoLetterNum")) {
                perfectObjectDetection = false;
                if (Utilities.isLoggerActive()) {
                    logger.severe("Richtige Letteranzahl 2 konnte nicht ermittelt werden");
                }
                return null;
            }
            int ii = objects.size() - 1;
            while (ii >= found) {
                objects.remove(ii);
                --ii;
            }
            this.setPerfectObjectDetection(perfectObjectDetection);
        }
        Collections.sort(objects);
        if (Utilities.isLoggerActive()) {
            logger.finer("Found " + objects.size() + " Elements");
        }
        return objects;
    }

    public File getCaptchaFile() {
        return this.captchafile;
    }

    private Letter[] getColoredLetters(int letterNum) {
        Vector<PixelObject> objects = this.getColorObjects(letterNum);
        Letter[] letters = new Letter[objects.size()];
        Iterator<PixelObject> iter = objects.iterator();
        int i = 0;
        while (iter.hasNext()) {
            PixelObject pixelObject = iter.next();
            letters[i] = pixelObject.toLetter();
            letters[i].toBlackAndWhite();
            letters[i].removeSmallObjects(0.6, 0.5, 4);
            letters[i].clean();
            ++i;
        }
        i = 0;
        while (i < letters.length) {
            this.owner.getJas().executeLetterPrepareCommands(letters[i]);
            letters[i] = letters[i].getSimplified(this.owner.getJas().getDouble("simplifyFaktor"));
            ++i;
        }
        return letters;
    }

    public String getCorrectCaptchaCode() {
        return this.correctCaptchaCode;
    }

    public int[][] getGridWithGaps() {
        int[][] pix = new int[this.getWidth()][this.getHeight()];
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                pix[x][y] = this.grid[x][y];
                if (this.gaps != null && this.gaps.length + 1 > x && this.gaps[x]) {
                    pix[x][y] = 0;
                }
                ++x;
            }
            ++y;
        }
        return pix;
    }

    @Override
    public int getHeight() {
        if (this.grid.length == 0) {
            return 0;
        }
        return this.grid[0].length;
    }

    public Image getImageWithGaps(int faktor) {
        int[][] tmp = this.grid;
        this.grid = this.getGridWithGaps();
        BufferedImage image = this.getImage(faktor);
        this.grid = tmp;
        return image;
    }

    public LetterComperator[] getLetterComperators() {
        return this.letterComperators;
    }

    public Letter[] getLetters(int letterNum) {
        if (this.seperatedLetters != null) {
            return this.seperatedLetters;
        }
        Letter[] ret = this.getLetters0(letterNum);
        if (ret == null) {
            return null;
        }
        if (this.owner.getJas().getString("useLetterFilter") != null && this.owner.getJas().getString("useLetterFilter").length() > 0) {
            String[] ref = this.owner.getJas().getString("useLetterFilter").split("\\.");
            if (ref.length != 2) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("useLetterFilter should have the format Class.Method");
                }
                return null;
            }
            String cl = ref[0];
            String methodname = ref[1];
            try {
                Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                Class[] parameterTypes = new Class[]{ret.getClass(), this.owner.getClass()};
                Method method = newClass.getMethod(methodname, parameterTypes);
                Object[] arguments = new Object[]{ret, this.owner};
                Object instance = null;
                Letter[] ret2 = (Letter[])method.invoke(instance, arguments);
                if (ret2 != null) {
                    this.seperatedLetters = ret2;
                    return ret2;
                }
                if (Utilities.isLoggerActive()) {
                    logger.severe("Special filter failed.");
                }
                this.seperatedLetters = ret;
                return ret;
            }
            catch (Exception e) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("Fehler in useLetterFilter:" + e.getLocalizedMessage() + " / " + this.owner.getJas().getString("useSpecialGetLetters"));
                }
                JDLogger.exception((Throwable)e);
                this.seperatedLetters = ret;
                return ret;
            }
        }
        this.seperatedLetters = ret;
        return ret;
    }

    public Letter[] getLetters(int letterNum, double contrast, double objectContrast, int minArea) {
        Vector<PixelObject> letters = this.getBiggestObjects(letterNum, minArea, contrast, objectContrast);
        if (letters == null) {
            return null;
        }
        this.gaps = new boolean[this.getWidth() + 1];
        ArrayList<Letter> ret = new ArrayList<Letter>();
        int i = 0;
        while (i < letters.size()) {
            PixelObject obj = letters.elementAt(i);
            Letter l = obj.toLetter();
            this.owner.getJas().executeLetterPrepareCommands(l);
            ret.add(l.getSimplified(this.owner.getJas().getDouble("simplifyFaktor")));
            this.gaps[letters.elementAt((int)i).getLocation()[0] + letters.elementAt((int)i).getWidth()] = true;
            ++i;
        }
        return ret.toArray(new Letter[ret.size()]);
    }

    public Letter[] getLetters(int letterNum, int[] gaps) {
        if (this.seperatedLetters != null) {
            return this.seperatedLetters;
        }
        Letter[] ret = new Letter[letterNum];
        this.lastletterX = 0;
        this.gaps = new boolean[this.getWidth() + 1];
        int letterId = 0;
        while (letterId < letterNum) {
            ret[letterId] = this.getNextLetter(letterId, gaps);
            if (ret[letterId] == null) {
                return null;
            }
            this.owner.getJas().executeLetterPrepareCommands(ret[letterId]);
            ret[letterId] = ret[letterId].getSimplified(this.owner.getJas().getDouble("simplifyFaktor"));
            ++letterId;
        }
        this.seperatedLetters = ret;
        return ret;
    }

    public Letter[] getLetters0(int letterNum, int[] gaps) {
        if (this.seperatedLetters != null) {
            return this.seperatedLetters;
        }
        Letter[] ret = new Letter[letterNum];
        this.lastletterX = 0;
        this.gaps = new boolean[this.getWidth() + 1];
        int letterId = 0;
        while (letterId < letterNum) {
            ret[letterId] = this.getNextLetter(letterId, gaps);
            if (ret[letterId] != null) {
                this.owner.getJas().executeLetterPrepareCommands(ret[letterId]);
                ret[letterId] = ret[letterId].getSimplified(this.owner.getJas().getDouble("simplifyFaktor"));
            }
            ++letterId;
        }
        this.seperatedLetters = ret;
        return ret;
    }

    public Letter[] getLetters0(int letterNum) {
        Letter[] ret;
        if (letterNum == 1) {
            Letter ret2 = this.createLetter();
            ret2.setGrid(this.getGrid());
            logger.info("Letternum=1 --> captch to Letter");
            return new Letter[]{ret2};
        }
        if (this.owner.getJas().getString("useSpecialGetLetters") != null && this.owner.getJas().getString("useSpecialGetLetters").length() > 0) {
            String[] ref = this.owner.getJas().getString("useSpecialGetLetters").split("\\.");
            if (ref.length != 2) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("useSpecialGetLetters should have the format Class.Method");
                }
                return null;
            }
            String cl = ref[0];
            String methodname = ref[1];
            try {
                logger.severe("Special detection :jd.captcha.specials." + cl);
                Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                Class[] parameterTypes = new Class[]{((Object)((Object)this)).getClass()};
                Method method = newClass.getMethod(methodname, parameterTypes);
                Object[] arguments = new Object[]{this};
                Object instance = null;
                Letter[] ret3 = (Letter[])method.invoke(instance, arguments);
                if (ret3 != null) {
                    return ret3;
                }
                if (Utilities.isLoggerActive()) {
                    logger.severe("Special detection failed.");
                }
                return null;
            }
            catch (Exception e) {
                if (Utilities.isLoggerActive()) {
                    logger.severe("Fehler in useSpecialGetLetters:" + e.getLocalizedMessage() + " / " + this.owner.getJas().getString("useSpecialGetLetters"));
                }
                JDLogger.exception((Throwable)e);
                return null;
            }
        }
        if (this.owner.getJas().getBoolean("useColorObjectDetection")) {
            if (Utilities.isLoggerActive()) {
                logger.finer("Use Color Object Detection");
            }
            if ((ret = this.getColoredLetters(letterNum)) != null) {
                return ret;
            }
            if (Utilities.isLoggerActive()) {
                logger.severe("Color Object detection failed. Try alternative Methods");
            }
        }
        if (this.owner.getJas().getBoolean("useObjectDetection")) {
            if (Utilities.isLoggerActive()) {
                logger.finer("Use Object Detection");
            }
            if ((ret = this.getLetters(letterNum, this.owner.getJas().getDouble("ObjectColorContrast"), this.owner.getJas().getDouble("ObjectDetectionContrast"), this.owner.getJas().getInteger("MinimumObjectArea"))) != null) {
                return ret;
            }
            if (Utilities.isLoggerActive()) {
                logger.severe("Object detection failed. Try alternative Methods");
            }
        }
        if (this.owner.getJas().getBoolean("cancelIfObjectDetectionFailed")) {
            return null;
        }
        if (!this.owner.getJas().getBoolean("UseAverageGapDetection") && !this.owner.getJas().getBoolean("UsePeakGapdetection") && this.owner.getJas().getGaps() != null) {
            if (Utilities.isLoggerActive()) {
                logger.finer("Use predefined Gaps");
            }
            return this.getLetters(letterNum, this.owner.getJas().getGaps());
        }
        if (Utilities.isLoggerActive()) {
            logger.finer("Use Line Detection");
        }
        this.gaps = new boolean[this.getWidth() + 1];
        ret = new Letter[letterNum];
        this.lastletterX = 0;
        int letters = 0;
        int letterId = 0;
        while (letterId < letterNum) {
            ret[letterId] = this.getNextLetter();
            if (ret[letterId] == null && !this.owner.jas.getBoolean("autoLetterNum")) {
                if (this.owner.getJas().getGaps() != null) {
                    return this.getLetters(letterNum, this.owner.getJas().getGaps());
                }
                return null;
            }
            if (ret[letterId] != null) {
                ++letters;
                this.owner.getJas().executeLetterPrepareCommands(ret[letterId]);
                ret[letterId] = ret[letterId].getSimplified(this.owner.getJas().getDouble("simplifyFaktor"));
            }
            ++letterId;
        }
        if (this.owner.jas.getBoolean("autoLetterNum") && letters < ret.length) {
            Letter[] tmp = ret;
            ret = new Letter[letters];
            System.arraycopy(tmp, 0, ret, 0, letters);
        }
        return ret;
    }

    public void setContrast(float contrast) {
        this.setContrast(contrast, 0.0f);
    }

    public void setContrast(float contrast, float brightness) {
        BufferedImage image = this.getImage();
        ContrastFilter cf = new ContrastFilter();
        cf.setContrast(contrast);
        if (brightness != 0.0f) {
            cf.setBrightness(brightness);
        }
        BufferedImage dest = cf.createCompatibleDestImage(image, null);
        cf.filter(image, dest);
        Captcha cap2 = this.owner.createCaptcha(dest);
        this.grid = cap2.grid;
    }

    public void blur(int hRadius, int vRadius, int iteration) {
        BufferedImage image = this.getImage();
        BoxBlurFilter blur = new BoxBlurFilter(hRadius, vRadius, iteration);
        BufferedImage dest = blur.createCompatibleDestImage(image, null);
        blur.filter(image, dest);
        Captcha cap2 = this.owner.createCaptcha(dest);
        this.grid = cap2.grid;
    }

    public void reduceColors(int colorNums) {
        BufferedImage image = this.getImage();
        QuantizeFilter reduceFilter = new QuantizeFilter();
        BufferedImage dest = reduceFilter.createCompatibleDestImage(image, null);
        reduceFilter.setNumColors(colorNums);
        reduceFilter.filter(image, dest);
        Captcha cap2 = this.owner.createCaptcha(dest);
        this.grid = cap2.grid;
    }

    public void reduceColorsPosterizeFilter(int numLevels) {
        BufferedImage image = this.getImage();
        PosterizeFilter reduceFilter = new PosterizeFilter();
        BufferedImage dest = reduceFilter.createCompatibleDestImage(image, null);
        reduceFilter.setNumLevels(numLevels);
        reduceFilter.filter(image, dest);
        Captcha cap2 = this.owner.createCaptcha(dest);
        this.grid = cap2.grid;
    }

    private Letter getNextLetter() {
        Letter ret = this.createLetter();
        int[][] letterGrid = new int[this.getWidth()][this.getHeight()];
        int[] rowAverage = new int[this.getWidth()];
        int[] rowPeak = new int[this.getWidth()];
        int i = 0;
        while (i < rowAverage.length) {
            rowAverage[i] = 0;
            rowPeak[i] = Integer.MAX_VALUE;
            ++i;
        }
        int average = this.getAverage();
        int noGapCount = 0;
        boolean lastOverPeak = false;
        int x = this.lastletterX;
        while (x < this.getWidth()) {
            boolean isPeakGap;
            boolean isOverPeak;
            boolean isAverageGap;
            int count = 0;
            int y = 0;
            while (y < this.getHeight()) {
                int line = 0;
                while (line < this.owner.getJas().getInteger("GapWidthPeak")) {
                    int pixelValue;
                    if (this.getWidth() > x + line && (pixelValue = this.getPixelValue(x + line, y)) < rowPeak[x]) {
                        rowPeak[x] = pixelValue;
                    }
                    ++line;
                }
                line = 0;
                while (line < this.owner.getJas().getInteger("GapWidthAverage")) {
                    if (this.getWidth() > x + line) {
                        rowAverage[x] = Colors.mixColors((int)rowAverage[x], (int)this.getPixelValue(x + line, y), (int)count, (int)1);
                        ++count;
                    }
                    ++line;
                }
                letterGrid[x][y] = this.getPixelValue(x, y);
                ++y;
            }
            boolean isGap = false;
            if (this.owner.getJas().getBoolean("GapAndAverageLogic")) {
                isAverageGap = (double)rowAverage[x] > (double)average * this.owner.getJas().getDouble("GapDetectionAverageContrast") || !this.owner.getJas().getBoolean("UseAverageGapDetection");
                isOverPeak = (double)rowPeak[x] < (double)average * this.owner.getJas().getDouble("GapDetectionPeakContrast");
                isPeakGap = lastOverPeak && !isOverPeak || !this.owner.getJas().getBoolean("UsePeakGapdetection");
                isGap = isAverageGap && isPeakGap;
            } else {
                isAverageGap = (double)rowAverage[x] > (double)average * this.owner.getJas().getDouble("GapDetectionAverageContrast") && this.owner.getJas().getBoolean("UseAverageGapDetection");
                isOverPeak = (double)rowPeak[x] < (double)average * this.owner.getJas().getDouble("GapDetectionPeakContrast");
                isPeakGap = lastOverPeak && !isOverPeak || !this.owner.getJas().getBoolean("UsePeakGapdetection");
                isGap = isAverageGap || isPeakGap;
            }
            lastOverPeak = isOverPeak;
            if (isGap && noGapCount > this.owner.getJas().getInteger("MinimumLetterWidth")) break;
            if ((double)rowAverage[x] < (double)average * this.owner.getJas().getDouble("GapDetectionAverageContrast")) {
                ++noGapCount;
            }
            ++x;
        }
        ret.setGrid(letterGrid);
        ret.setLocation(new int[2]);
        if (!ret.trim(this.lastletterX, x)) {
            return null;
        }
        if (!ret.clean()) {
            return null;
        }
        this.lastletterX = x;
        this.gaps[Math.min((int)this.lastletterX, (int)this.getWidth())] = true;
        return ret;
    }

    private Letter getNextLetter(int letterId, int[] gaps) {
        Letter ret = this.createLetter();
        int overlap = this.owner.jas.getInteger("splitGapsOverlap");
        int nextGap = -1;
        if (gaps != null && gaps.length > letterId) {
            nextGap = gaps[letterId];
        }
        if ((gaps == null || gaps.length == 0) && Utilities.isLoggerActive()) {
            logger.severe("Das Gaps Array wurde nicht erstellt");
        }
        if (gaps != null && letterId > gaps.length - 1 && Utilities.isLoggerActive()) {
            logger.severe("LetterNum und Gaps Array passen nicht zusammen. Siem\u00fcssen die selbe L\u00e4nge haben!");
        }
        if (letterId > 0 && nextGap <= gaps[letterId - 1] && Utilities.isLoggerActive()) {
            logger.severe(String.valueOf(letterId) + " Das Userdefinierte gaps array ist falsch!. Die Gaps m\u00fcssen aufsteigend sortiert sein!");
        }
        int[][] letterGrid = new int[Math.min(this.getWidth() - 1, nextGap + overlap) - Math.max(0, this.lastletterX - overlap)][this.getHeight()];
        if (Utilities.isLoggerActive()) {
            logger.info("Gap at " + nextGap + " last gap: " + this.lastletterX + " this: " + Math.max(0, this.lastletterX - overlap) + " - " + Math.min(this.getWidth() - 1, nextGap + overlap));
        }
        int[] nArray = new int[2];
        nArray[0] = Math.max(0, this.lastletterX - overlap);
        ret.setLocation(nArray);
        int x = Math.max(0, this.lastletterX - overlap);
        while (x < Math.min(this.getWidth() - 1, nextGap + overlap)) {
            int y = 0;
            while (y < this.getHeight()) {
                letterGrid[x - Math.max((int)0, (int)(this.lastletterX - overlap))][y] = this.getPixelValue(x, y);
                ++y;
            }
            ++x;
        }
        ret.setGrid(letterGrid);
        if (!ret.clean()) {
            return null;
        }
        this.lastletterX = x - overlap;
        this.gaps[Math.min((int)this.lastletterX, (int)this.getWidth())] = true;
        return ret;
    }

    @Override
    public int[] getPixel() {
        int[] pix = new int[this.getWidth() * this.getHeight()];
        int pixel = 0;
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                pix[pixel] = this.getPixelValue(x, y);
                ++pixel;
                ++x;
            }
            ++y;
        }
        return pix;
    }

    public int[] getPixelWithGaps() {
        int[] pix = new int[this.getWidth() * this.getHeight()];
        int pixel = 0;
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                pix[pixel] = this.getPixelValue(x, y);
                if (this.gaps[x]) {
                    pix[pixel] = 0;
                }
                ++pixel;
                ++x;
            }
            ++y;
        }
        return pix;
    }

    public Captcha getSimplified(double faktor) {
        int y;
        int newWidth = (int)Math.ceil((double)this.getWidth() / faktor);
        int newHeight = (int)Math.ceil((double)this.getHeight() / faktor);
        Captcha ret = new Captcha(newWidth, newHeight);
        int[][] newGrid = new int[newWidth][newHeight];
        int avg = this.getAverage();
        if (faktor == 1.0 || faktor == 0.0) {
            return this;
        }
        int x = 0;
        while (x < newWidth) {
            y = 0;
            while (y < newHeight) {
                PixelGrid.setPixelValue(x, y, newGrid, this.getMaxPixelValue());
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.getWidth()) {
            y = 0;
            while (y < this.getHeight()) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    int newX = (int)Math.round((double)x / faktor);
                    int newY = (int)Math.round((double)y / faktor);
                    PixelGrid.setPixelValue(newX, newY, newGrid, 0);
                }
                ++y;
            }
            ++x;
        }
        ret.setGrid(newGrid);
        ret.printGrid();
        return ret;
    }

    @Override
    public String getString() {
        int avg = this.getAverage();
        StringBuilder ret = new StringBuilder();
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    ret.append("*");
                } else {
                    ret.append((int)Math.floor(9 * (this.getPixelValue(x, y) / this.getMaxPixelValue())));
                }
                ++x;
            }
            ret.append(new char[]{'\r', '\n'});
            ++y;
        }
        return ret.toString();
    }

    public double getValityPercent() {
        return this.valityPercent;
    }

    @Override
    public int getWidth() {
        return this.grid.length;
    }

    public boolean isPerfectObjectDetection() {
        return this.perfectObjectDetection;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    private void mergeMultiPartObjects(Vector<PixelObject> objects) {
        if (this.owner.getJas().getInteger("multiplePartMergeMinSize") <= 0) {
            return;
        }
        int i = objects.size() - 1;
        while (i >= 0) {
            PixelObject current = objects.get(i);
            if (current.getSize() >= this.owner.getJas().getInteger("multiplePartMergeMinSize")) {
                int xMin = current.getXMin();
                int xMax = current.getXMin() + current.getWidth();
                int yMin = current.getYMin();
                int yMax = current.getYMin() + current.getHeight();
                int ii = i - 1;
                while (ii >= 0) {
                    PixelObject tmp = objects.get(ii);
                    if (xMin >= tmp.getXMin() && xMax <= tmp.getXMin() + tmp.getWidth() && yMin >= tmp.getYMin() && yMax <= tmp.getYMin() + tmp.getHeight()) {
                        logger.info("current liegt mitten in tmp.. merge");
                        tmp.add(current);
                        objects.remove(i);
                        break;
                    }
                    --ii;
                }
            }
            --i;
        }
    }

    public boolean objectContainCaptcha(PixelObject pixelObject, Captcha captcha, ArrayList<Integer[]> blackPoints) {
        if (captcha.getWidth() > pixelObject.getWidth() || captcha.getHeight() > pixelObject.getHeight()) {
            return true;
        }
        int avg = this.getAverage();
        int size = blackPoints.size();
        int y = 0;
        while (y < pixelObject.getHeight()) {
            int x = 0;
            while (x < pixelObject.getWidth()) {
                int right = 0;
                int bad = 0;
                Iterator<Integer[]> bpiter = blackPoints.iterator();
                while (bpiter.hasNext()) {
                    if (bad > size / 3 || right + size / 10 < bad) break;
                    try {
                        Integer[] integers = bpiter.next();
                        if (pixelObject.getWidth() <= x + integers[0] || pixelObject.getHeight() <= y + integers[1]) continue;
                        if (this.isElement(this.getPixelValue(x + integers[0], y + integers[1]), avg)) {
                            ++right;
                            continue;
                        }
                        ++bad;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (right > 200) {
                    return true;
                }
                ++x;
            }
            ++y;
        }
        return false;
    }

    public void printCaptcha() {
        if (Utilities.isLoggerActive()) {
            logger.info("\r\n" + this.getString());
        }
    }

    public boolean rapidshareSpecial(PixelObject pixelObject, JAntiCaptcha jac) {
        return !jac.getLetter(pixelObject.toLetter()).getDecodedValue().equals("k");
    }

    public int[][] getOrgGridCopy() {
        return PixelGrid.getGridCopy(this.tmpGrid);
    }

    public boolean reset() {
        this.seperatedLetters = null;
        this.setPrepared(false);
        if (this.tmpGrid == null) {
            return false;
        }
        this.grid = PixelGrid.getGridCopy(this.tmpGrid);
        return true;
    }

    public void saveImageasJpgWithGaps(File file) {
        BufferedImage bimg = null;
        bimg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        bimg.setRGB(0, 0, this.getWidth(), this.getHeight(), this.getPixelWithGaps(), 0, this.getWidth());
        try {
            FileOutputStream fos = new FileOutputStream(file);
            JPEGImageEncoder jpeg = JPEGCodec.createJPEGEncoder((OutputStream)fos);
            jpeg.encode(bimg);
            fos.close();
        }
        catch (FileNotFoundException e) {
            JDLogger.exception((Throwable)e);
        }
        catch (ImageFormatException e) {
            JDLogger.exception((Throwable)e);
        }
        catch (IOException e) {
            JDLogger.exception((Throwable)e);
        }
    }

    public void setCaptchaFile(File captchafile) {
        this.captchafile = captchafile;
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public void setCorrectcaptchaCode(String trim) {
        this.correctCaptchaCode = trim;
    }

    public void setLetterComperators(LetterComperator[] newLetters) {
        this.letterComperators = newLetters;
    }

    public void setPerfectObjectDetection(boolean perfectObjectDetection) {
        this.perfectObjectDetection = perfectObjectDetection;
    }

    public void setPixel(byte[] bpixel) {
        this.pixel = new int[bpixel.length];
        int i = 0;
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                try {
                    int pb;
                    int maskbits = pb = ((IndexColorModel)this.colorModel).getPixelSize();
                    if (maskbits == 3) {
                        maskbits = 4;
                    } else if (maskbits > 4 && maskbits < 8) {
                        maskbits = 8;
                    }
                    int pixel_mask = (1 << maskbits) - 1;
                    this.pixel[i] = ((IndexColorModel)this.colorModel).getRGB(bpixel[i] & pixel_mask);
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                    this.pixel[i] = 0;
                }
                Color c = new Color(this.pixel[i]);
                float[] col = new float[4];
                if (this.owner.getJas().getColorFormat() == 0) {
                    Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), col);
                    col[3] = 0.0f;
                } else if (this.owner.getJas().getColorFormat() == 1) {
                    col[0] = (float)c.getRed() / 255.0f;
                    col[1] = (float)c.getGreen() / 255.0f;
                    col[2] = (float)c.getBlue() / 255.0f;
                    col[3] = 0.0f;
                }
                this.grid[x][y] = (int)(col[this.owner.getJas().getColorComponent(0)] * 255.0f) * 65536 + (int)(col[this.owner.getJas().getColorComponent(1)] * 255.0f) * 256 + (int)(col[this.owner.getJas().getColorComponent(2)] * 255.0f);
                this.rgbGrid[x][y] = this.pixel[i];
                ++i;
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void setPixel(int[] pixel) {
        this.pixel = pixel;
        int i = 0;
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                Color c = new Color(pixel[i]);
                float[] col = new float[4];
                if (this.owner.getJas().getColorFormat() == 0) {
                    Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), col);
                    col[3] = 0.0f;
                } else if (this.owner.getJas().getColorFormat() == 1) {
                    col[0] = (float)c.getRed() / 255.0f;
                    col[1] = (float)c.getGreen() / 255.0f;
                    col[2] = (float)c.getBlue() / 255.0f;
                    col[3] = 0.0f;
                }
                this.grid[x][y] = (int)(col[this.owner.getJas().getColorComponent(0)] * 255.0f) * 65536 + (int)(col[this.owner.getJas().getColorComponent(1)] * 255.0f) * 256 + (int)(col[this.owner.getJas().getColorComponent(2)] * 255.0f);
                this.rgbGrid[x][y] = pixel[i];
                ++i;
                ++x;
            }
            ++y;
        }
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public void setValityPercent(double d) {
        this.valityPercent = d;
    }

    public void cleanBySaturation(int mode, int tollerance) {
        int[][] newgrid = new int[this.getWidth()][this.getHeight()];
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                int p = this.getPixelValue(x, y);
                Color c = new Color(p);
                int min = Math.min(c.getRed(), Math.min(c.getGreen(), c.getBlue()));
                int max = Math.max(c.getRed(), Math.max(c.getGreen(), c.getBlue()));
                int v = 0;
                if (max > 0) {
                    v = (max - min) * 100 / max;
                }
                if (mode == 1) {
                    if (v > tollerance) {
                        PixelGrid.setPixelValue(x, y, newgrid, this.getMaxPixelValue());
                    } else {
                        newgrid[x][y] = this.grid[x][y];
                    }
                } else if (v < tollerance) {
                    PixelGrid.setPixelValue(x, y, newgrid, this.getMaxPixelValue());
                } else {
                    newgrid[x][y] = this.grid[x][y];
                }
                ++y;
            }
            ++x;
        }
        this.grid = newgrid;
    }

    public void cleanByRGBDistance(int mode, int tollerance) {
        int[][] newgrid = new int[this.getWidth()][this.getHeight()];
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                int p = this.getPixelValue(x, y);
                Color c = new Color(p);
                int br = Math.abs(c.getBlue() - c.getRed());
                int bg = Math.abs(c.getBlue() - c.getGreen());
                int rg = Math.abs(c.getGreen() - c.getRed());
                int v = (br + bg + rg) / 3;
                if (mode == 1) {
                    if (v > tollerance) {
                        PixelGrid.setPixelValue(x, y, newgrid, this.getMaxPixelValue());
                    } else {
                        newgrid[x][y] = this.grid[x][y];
                    }
                } else if (v < tollerance) {
                    PixelGrid.setPixelValue(x, y, newgrid, this.getMaxPixelValue());
                } else {
                    newgrid[x][y] = this.grid[x][y];
                }
                ++y;
            }
            ++x;
        }
        this.grid = newgrid;
    }

    public void addAt(int xx, int yy, Captcha tmp) {
        int x = 0;
        while (x < tmp.getWidth()) {
            int y = 0;
            while (y < tmp.getHeight()) {
                if (this.getWidth() > x + xx && this.getHeight() > y + yy) {
                    this.setPixelValue(x + xx, y + yy, tmp.getPixelValue(x, y));
                }
                ++y;
            }
            ++x;
        }
    }
}

