/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.utils;

import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jd.controlling.JDLogger;
import jd.gui.swing.GuiRunnable;
import jd.utils.JDUtilities;

public class Utilities {
    private static Logger logger = JDLogger.getLogger();

    public static Logger getLogger() {
        return logger;
    }

    public static boolean isLoggerActive() {
        return JDUtilities.getRunType() == 1;
    }

    public static boolean checkJumper(int x, int from, int to) {
        return x >= from && x <= to;
    }

    public static File directoryChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("OK");
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(null) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static String getMethodDir() {
        return String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/" + JDUtilities.getJACMethodsDirectory();
    }

    public static GridBagConstraints getGBC(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        return gbc;
    }

    public static int getJumperStart(int from, int to) {
        return from + (to - from) / 2;
    }

    public static int getPercent(int a, int b) {
        if (b == 0) {
            return 100;
        }
        return a * 100 / b;
    }

    public static Image loadImage(final File file) {
        GuiRunnable<Image> run = new GuiRunnable<Image>(){

            public Image runSave() {
                JFrame jf = new JFrame();
                Image img = jf.getToolkit().getImage(file.getAbsolutePath());
                MediaTracker mediaTracker = new MediaTracker(jf);
                mediaTracker.addImage(img, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException e) {
                    return null;
                }
                mediaTracker.removeImage(img);
                return img;
            }
        };
        return (Image)run.getReturnValue();
    }

    public static int nextJump(int x, int from, int to, int step) {
        int ret;
        int start = Utilities.getJumperStart(from, to);
        if (x == start) {
            ret = start + step;
            if (ret > to) {
                ret = start - step;
            }
        } else if (x > start) {
            int dif = x - start;
            ret = start - dif;
        } else {
            int dif = start - x + step;
            ret = start + dif;
            if (ret > to) {
                ret = start - dif;
            }
        }
        return ret;
    }

    public static int[] turnCoordinates(int x, int y, int nullX, int nullY, double winkel) {
        winkel /= 180.0;
        int newX = x - nullX;
        int newY = y - nullY;
        double aktAngle = Math.atan2(newY, newX);
        int[] ret = new int[2];
        double radius = Math.sqrt(newX * newX + newY * newY);
        int yTrans = (int)Math.round(radius * Math.sin(aktAngle + winkel * Math.PI));
        int xTrans = (int)Math.round(radius * Math.cos(aktAngle + winkel * Math.PI));
        ret[0] = xTrans + nullX;
        ret[1] = yTrans + nullY;
        return ret;
    }
}

