/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdchat;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.gui.UserIO;
import jd.parser.Regex;
import jd.plugins.optional.jdchat.JDChat;
import jd.plugins.optional.jdchat.JDChatPMS;
import jd.plugins.optional.jdchat.User;
import jd.plugins.optional.jdchat.Utils;
import jd.utils.Upload;
import jd.utils.locale.JDL;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;

class IRCListener
implements IRCEventListener {
    public static Logger logger = JDLogger.getLogger();
    private JDChat owner;

    public IRCListener(JDChat owner) {
        this.owner = owner;
    }

    public void onDisconnected() {
        this.owner.setLoggedIn(false);
        this.owner.addToText(null, "system", "Connection lost. type /connect if jd does not connect by itself");
    }

    public void onError(int num, String msg) {
        this.owner.addToText(null, "error", msg);
        switch (num) {
            case 433: {
                if (this.owner.isLoggedIn()) break;
                this.owner.setNickCount(this.owner.getNickCount() + 1);
                this.owner.setNick(this.owner.getNickname());
            }
        }
    }

    public void onError(String msg) {
        this.owner.addToText(null, "error", Utils.prepareMsg(msg));
    }

    public void onInvite(String chan, IRCUser u, String nickPass) {
    }

    public void onJoin(String chan, IRCUser u) {
        this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " joins");
        this.owner.addUser(u.getNick());
    }

    public void onKick(String chan, IRCUser u, String nickPass, String msg) {
        this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " kicks " + nickPass + " (" + msg + ")");
    }

    public void onMode(IRCUser u, String nickPass, String mode) {
        this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " sets modes " + mode + " " + nickPass);
    }

    public void onMode(String chan, IRCUser u, IRCModeParser mp) {
        int i = 1;
        while (i <= mp.getCount()) {
            this.owner.onMode(mp.getOperatorAt(i), mp.getModeAt(i), mp.getArgAt(i));
            ++i;
        }
        this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " sets mode: " + mp.getLine());
    }

    public void onNick(IRCUser u, String nickNew) {
        this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " is now known as " + nickNew);
        this.owner.renameUser(u.getNick(), nickNew);
        if (this.owner.getPms().containsKey(u.getNick().toLowerCase())) {
            this.owner.renamePMS(u.getNick().toLowerCase(), nickNew);
        }
    }

    public void onNotice(String target, IRCUser u, String msg) {
        if (u.getNick() != null) {
            this.owner.addToText(null, "notice", String.valueOf(u.getNick()) + " (notice): " + Utils.prepareMsg(msg));
        }
        if (msg.endsWith("has been ghosted.")) {
            this.owner.removeUser(msg.substring(0, msg.indexOf("has been ghosted.")).trim());
        }
    }

    public void onPart(String chan, IRCUser u, String msg) {
        if (msg != null && msg.trim().length() > 0) {
            this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " has left the channel (" + msg + ")");
        } else {
            this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " has left the channel");
        }
        this.owner.removeUser(u.getNick());
    }

    public void onPing(String p) {
    }

    public void onPrivmsg(String chan, IRCUser u, String msg) {
        final User user = this.owner.getUser(u.getNick());
        if (user == null) {
            return;
        }
        String nickt = this.owner.getNick().toLowerCase();
        boolean isPrivate = chan.toLowerCase().equals(nickt);
        String msgt = msg.toLowerCase();
        if ((user.rank == 1 || user.rank == 0) && (msgt.matches("!gettv[\\s]+.*") && msgt.replaceFirst("!gettv[\\s]+", "").trim().equals(nickt) || isPrivate && (msgt.matches("!gettv.*") || msgt.matches("!tv.*")))) {
            new Thread(new Runnable(){

                public void run() {
                    String[] data = UserIO.getInstance().requestTwoTextFieldDialog(JDL.L((String)"plugin.optional.jdchat.teamviewer.yourtvdata", (String)"Deine Teamviewer Daten:"), "ID:", "", "PW:", "");
                    if (data == null || new Regex(data[0], "^[\\s]*$").matches()) {
                        IRCListener.this.owner.sendMessage(user.name, String.valueOf(IRCListener.this.owner.getNick()) + " hat den Teamviewer Dialog geschlossen.");
                    } else {
                        IRCListener.this.owner.sendMessage(user.name, "Teamviewerdaten von " + IRCListener.this.owner.getNick() + ": ID: " + data[0] + " PW: " + data[1]);
                    }
                }
            }).start();
        } else if ((user.rank == 1 || user.rank == 0) && (msgt.matches("!getlog[\\s]+.*") && msgt.replaceFirst("!getlog[\\s]+", "").trim().equals(nickt) || isPrivate && (msgt.matches("!getlog.*") || msgt.matches("!log.*")))) {
            new Thread(new Runnable(){

                public void run() {
                    if (2 == UserIO.getInstance().requestConfirmDialog(0, JDL.LF((String)"plugin.optional.jdchat.getlog", (String)"%s needs a log to solve your problem. Do you agree to send him the Log?", (Object[])new Object[]{user.name}))) {
                        String url = Upload.toJDownloader((String)JDLogger.getLog((Level)Level.ALL), (String)("JDChatuser:\r\n\r\n" + IRCListener.this.owner.getNick()));
                        if (url == null) {
                            UserIO.getInstance().requestConfirmDialog(48, JDL.L((String)"sys.warning.loguploadfailed", (String)"Upload of logfile failed!"));
                        } else {
                            IRCListener.this.owner.sendMessage(user.name, url);
                        }
                    } else {
                        IRCListener.this.owner.sendMessage(user.name, String.valueOf(IRCListener.this.owner.getNick()) + " gibt seine Log nicht her");
                    }
                }
            }).start();
        } else if (msg.trim().startsWith("ACTION ")) {
            this.owner.addToText(null, "action", String.valueOf(user.getNickLink("pmnick")) + " " + Utils.prepareMsg(msg.trim().substring(6).trim()));
        } else if (chan.equals(this.owner.getNick())) {
            TreeMap<String, JDChatPMS> pms = this.owner.getPms();
            if (!pms.containsKey(user.name.toLowerCase())) {
                this.owner.addPMS(user.name);
                pms = this.owner.getPms();
            }
            this.owner.notifyPMS(user.name, msg);
            this.owner.addToText(user, null, Utils.prepareMsg(msg), pms.get(user.name.toLowerCase()).getTextArea(), pms.get(user.name.toLowerCase()).getSb());
        } else {
            this.owner.addToText(user, null, Utils.prepareMsg(msg));
        }
    }

    public void onQuit(IRCUser u, String msg) {
        if (this.owner.getPms().containsKey(u.getNick().toLowerCase())) {
            if (msg != null && msg.trim().length() > 0) {
                this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " has left the channel (" + msg + ")", this.owner.getPms().get(u.getNick().toLowerCase()).getTextArea(), this.owner.getPms().get(u.getNick().toLowerCase()).getSb());
            } else {
                this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " has left the channel", this.owner.getPms().get(u.getNick().toLowerCase()).getTextArea(), this.owner.getPms().get(u.getNick().toLowerCase()).getSb());
            }
        }
        if (msg != null && msg.trim().length() > 0) {
            this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " has left the channel (" + msg + ")");
        } else {
            this.owner.addToText(null, "system", String.valueOf(u.getNick()) + " has left the channel");
        }
        this.owner.removeUser(u.getNick());
    }

    public void onRegistered() {
        this.owner.addToText(null, "system", "Connection estabilished");
        this.owner.onConnected();
    }

    public void onReply(int num, String value, String msg) {
        if (num == 353) {
            this.owner.addUsers(msg.trim().split(" "));
        }
        if (num == 366) {
            this.owner.updateNamesPanel();
        }
        if (num == 332) {
            this.owner.setTopic(msg);
        }
    }

    public void onTopic(String chan, IRCUser u, String topic) {
    }

    public void unknown(String a, String b, String c, String d) {
    }
}

