/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdchat;

import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
implements Comparable<User> {
    public static final int RANK_DEFAULT = -1;
    public static final int RANK_OP = 0;
    public static final int RANK_VOICE = 1;
    public String name;
    public int rank = -1;

    public String getColor() {
        String col = Integer.toHexString(new Color(this.name.hashCode()).getRGB());
        while (col.length() < 6) {
            col = "0" + col;
        }
        return col.substring(col.length() - 6);
    }

    public User(String name) {
        if (name.startsWith("@")) {
            this.rank = 0;
            name = name.substring(1);
        }
        if (name.startsWith("+")) {
            this.rank = 1;
            name = name.substring(1);
        }
        this.name = name;
    }

    @Override
    public int compareTo(User o) {
        return this.getRangName().compareTo(o.getRangName());
    }

    public String getNickLink(String id) {
        return "<a href='intern:" + id + "|" + this.name + "'>" + this.name + "</a>";
    }

    private String getRangName() {
        switch (this.rank) {
            case 0: {
                return "!!!" + this.name.toLowerCase();
            }
            case 1: {
                return "!!" + this.name.toLowerCase();
            }
        }
        return this.name.toLowerCase();
    }

    public String getRank() {
        switch (this.rank) {
            case 0: {
                return "@";
            }
            case 1: {
                return "+";
            }
        }
        return "";
    }

    public String getStyle() {
        return "color:#" + this.getColor();
    }

    public boolean isUser(String name) {
        if (name.startsWith("@")) {
            name = name.substring(1);
        }
        if (name.startsWith("+")) {
            name = name.substring(1);
        }
        return name.equals(this.name);
    }

    public String toString() {
        switch (this.rank) {
            case 0: {
                return "@" + this.name;
            }
            case 1: {
                return "+" + this.name;
            }
        }
        return this.name;
    }
}

