/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jd.controlling.JDLogger;

public class Cookie {
    private static final String[] dateformats = new String[]{"EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEEE, dd-MMM-yy HH:mm:ss z"};
    private String path;
    private String host;
    private String value;
    private String key;
    private String domain;
    private long hostTime = -1L;
    private long creationTime = System.currentTimeMillis();
    private long expireTime = -1L;

    public Cookie(String host, String key, String value) {
        this.host = host;
        this.key = key;
        this.value = value;
    }

    public Cookie() {
        this.host = "";
        this.key = "";
        this.value = "";
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setExpires(String expires) {
        if (expires == null) {
            this.expireTime = -1L;
            return;
        }
        Date expireDate = null;
        String[] stringArray = dateformats;
        int n = dateformats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.UK);
                sdf.setLenient(false);
                expireDate = sdf.parse(expires);
                break;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        if (expireDate != null) {
            this.expireTime = expireDate.getTime();
            return;
        }
        this.expireTime = -1L;
        JDLogger.getLogger().severe("Cookie: no Format for " + expires + " found!");
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isExpired() {
        if (this.expireTime == -1L) {
            return false;
        }
        if (this.hostTime == -1L) {
            JDLogger.getLogger().severe("Cookie: no HostTime found! ExpireStatus cannot be checked " + this.host + " " + this.key);
            return false;
        }
        long check = System.currentTimeMillis() - this.creationTime + this.hostTime;
        return check > this.expireTime;
    }

    public long getHostTime() {
        return this.hostTime;
    }

    public void setHostTime(long time) {
        this.hostTime = time;
    }

    public long getExpireDate() {
        return this.expireTime;
    }

    public void setExpireDate(long time) {
        this.expireTime = time;
    }

    public void setHostTime(String Date2) {
        if (Date2 == null) {
            this.hostTime = -1L;
            return;
        }
        Date ResponseDate = null;
        String[] stringArray = dateformats;
        int n = dateformats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.UK);
                sdf.setLenient(false);
                ResponseDate = sdf.parse(Date2);
                break;
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        if (ResponseDate != null) {
            this.hostTime = ResponseDate.getTime();
            return;
        }
        this.hostTime = -1L;
        JDLogger.getLogger().severe("Cookie: no Format for " + Date2 + " found!");
    }

    public String getPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public String getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        return String.valueOf(this.key) + "=" + this.value + " @" + this.host;
    }

    public void update(Cookie cookie2) {
        this.setCreationTime(cookie2.getCreationTime());
        this.setExpireDate(cookie2.getExpireDate());
        this.setValue(cookie2.getValue());
        this.setHostTime(cookie2.getCreationTime());
    }

    public boolean equals(Cookie cookie2) {
        if (cookie2 == this) {
            return true;
        }
        if (!cookie2.getHost().equalsIgnoreCase(this.getHost())) {
            return false;
        }
        return cookie2.getKey().equalsIgnoreCase(this.getKey());
    }
}

