/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Random;
import jd.nutils.Formatter;

public class RandomUserAgent {
    private static final String[] releaseDate = new String[]{"2005", "11", "11"};
    private static ArrayList<String> langs = new ArrayList();
    private static ArrayList<String> ffVersionInfos = new ArrayList();
    private static ArrayList<String> ieVersions = new ArrayList();
    private static String winVersions = "";
    private static ArrayList<String[]> winAddons = new ArrayList();
    private static ArrayList<String> linuxAddons = new ArrayList();
    private static ArrayList<String> macAddons = new ArrayList();
    private static ArrayList<System> system = new ArrayList();

    private static final void initData() {
        ieVersions.add("6.0");
        ieVersions.add("7.0");
        ieVersions.add("8.0");
        winVersions = "NT 5.0|NT 5.1|NT 5.2|NT 6.0|NT 6.1";
        winAddons.add(new String[]{"", ".NET CLR 1.0.3705", ".NET CLR 1.1.4322"});
        winAddons.add(new String[]{"", ".NET CLR 2.0.40607", ".NET CLR 2.0.50727"});
        winAddons.add(new String[]{"", ".NET CLR 3.0.04506.648", ".NET CLR 3.0.4506.2152"});
        winAddons.add(new String[]{"", ".NET CLR 3.5.21022", ".NET CLR 3.5.30729"});
        langs.add("en");
        langs.add("en-US");
        langs.add("en-GB");
        ffVersionInfos.add("1.8|1.5|2005.11.11");
        ffVersionInfos.add("1.8.1|2.0|2006.10.10");
        ffVersionInfos.add("1.9|3.0|2008.05.29.xx");
        ffVersionInfos.add("1.9.0.5|3.0.5|2008.12.01.xx");
        ffVersionInfos.add("1.9.0.6|3.0.6|2009.01.19.xx");
        ffVersionInfos.add("1.9.0.7|3.0.7|2009.02.19.xx");
        ffVersionInfos.add("1.9.0.8|3.0.8|2009.03.26.xx");
        ffVersionInfos.add("1.9.0.9|3.0.9|2009.04.08.xx");
        ffVersionInfos.add("1.9.0.10|3.0.10|2009.04.23.xx");
        linuxAddons.add(" ");
        linuxAddons.add("Ubuntu/8.04 (hardy)");
        linuxAddons.add("Ubuntu/8.10 (intrepid)");
        linuxAddons.add("Fedora/3.0.6-1.fc10");
        linuxAddons.add("Fedora/3.0.10-1.fc10");
        linuxAddons.add("(Gentoo)");
        linuxAddons.add("SUSE/3.0-1.2");
        linuxAddons.add("SUSE/3.0-1.1");
        linuxAddons.add("Red Hat/3.0.5-1.el5_2");
        macAddons.add("");
        macAddons.add("Mach-O");
        macAddons.add("10.4");
        macAddons.add("10.5");
        macAddons.add("10.6");
        system.add(new System("Windows", "Windows", winVersions, false, true));
        system.add(new System("X11", "Linux", "x86|x86_64|i586|i686", false, true));
        system.add(new System("Macintosh", "Mac OS X", "Intel|PPC|68K", true, true));
        system.add(new System("X11", "FreeBSD", "i386|amd64|sparc64|alpha", false, true));
        system.add(new System("X11", "OpenBSD", "i386|amd64|sparc64|alpha", false, true));
        system.add(new System("X11", "NetBSD", "i386|amd64|sparc64|alpha", false, true));
        system.add(new System("X11", "SunOS", "i86pc|sun4u", false, true));
    }

    public static String generate() {
        Random rand = new Random();
        if (rand.nextInt() % 2 == 0) {
            return RandomUserAgent.generateFF();
        }
        return RandomUserAgent.generateIE();
    }

    public static String generateFF() {
        RandomUserAgent.initData();
        Random rand = new Random();
        String platform = "";
        String osAndArch = "";
        String winAddon = "";
        String linuxAddon = " ";
        String macAddon = "";
        int i = rand.nextInt(system.size());
        do {
            platform = RandomUserAgent.system.get((int)i).platform;
            String osName = RandomUserAgent.system.get((int)i).osName;
            String[] archs = RandomUserAgent.system.get((int)i).archs.split("\\|");
            String arch = archs[rand.nextInt(archs.length)];
            boolean inverseOrder = RandomUserAgent.system.get((int)i).inverseOrder;
            osAndArch = !inverseOrder ? String.valueOf(osName) + " " + arch : String.valueOf(arch) + " " + osName;
        } while (!RandomUserAgent.system.get((int)i).useIt);
        if (RandomUserAgent.system.get((int)i).osName.equalsIgnoreCase("Windows")) {
            winAddon = RandomUserAgent.dotNetString();
            if (winAddon.trim().length() > 0) {
                winAddon = (" (" + winAddon.trim() + ")").replace("(; ", "(");
            }
        } else if (RandomUserAgent.system.get((int)i).osName.equalsIgnoreCase("Linux")) {
            linuxAddon = linuxAddons.get(rand.nextInt(linuxAddons.size()));
            if (linuxAddon != " ") {
                linuxAddon = " " + linuxAddon.trim() + " ";
            }
        } else if (RandomUserAgent.system.get((int)i).osName.equalsIgnoreCase("Mac OS X") && (macAddon = macAddons.get(rand.nextInt(macAddons.size()))) != "") {
            macAddon = " " + macAddon.trim();
        }
        String lang = langs.get(rand.nextInt(langs.size()));
        String[] tmpFFVersionInfos = ffVersionInfos.get(rand.nextInt(ffVersionInfos.size())).split("\\|");
        String ffRev = tmpFFVersionInfos[0];
        String ffVersion = tmpFFVersionInfos[1];
        String[] ffReleaseDate = tmpFFVersionInfos[2].split("\\.");
        return "Mozilla/5.0 (" + platform + "; U; " + osAndArch + macAddon + "; " + lang + "; rv:" + ffRev + ") Gecko/" + RandomUserAgent.randomDate(ffReleaseDate) + linuxAddon + "Firefox/" + ffVersion + winAddon;
    }

    public static String generateIE() {
        RandomUserAgent.initData();
        Random rand = new Random();
        String ieVersion = ieVersions.get(rand.nextInt(ieVersions.size()));
        String winVersion = winVersions.split("\\|")[rand.nextInt(winVersions.split("\\|").length)];
        String trident = "";
        if (ieVersion.equalsIgnoreCase("8.0")) {
            trident = "; Trident/4.0";
        }
        return "Mozilla/4.0 (compatible; MSIE " + ieVersion + "; Windows " + winVersion + trident + RandomUserAgent.dotNetString() + ")";
    }

    private static String dotNetString() {
        String dotNet20;
        Random rand = new Random();
        String dotNet10 = "; " + winAddons.get(0)[rand.nextInt(winAddons.get(0).length)];
        if (dotNet10.equalsIgnoreCase("; ")) {
            dotNet10 = "";
        }
        if ((dotNet20 = "; " + winAddons.get(1)[rand.nextInt(winAddons.get(1).length)]).equalsIgnoreCase("; ")) {
            dotNet20 = "";
        }
        String dotNet30 = "";
        if (dotNet20.length() != 0) {
            dotNet30 = "; " + winAddons.get(2)[rand.nextInt(winAddons.get(2).length)];
        }
        if (dotNet30.equalsIgnoreCase("; ")) {
            dotNet30 = "";
        }
        String dotNet35 = "";
        if (dotNet30.length() != 0) {
            dotNet35 = "; " + winAddons.get(3)[rand.nextInt(winAddons.get(3).length)];
        }
        if (dotNet35.equalsIgnoreCase("; ")) {
            dotNet35 = "";
        }
        return String.valueOf(dotNet10) + dotNet20 + dotNet30 + dotNet35;
    }

    private static String randomDate(String[] releaseDate) {
        String returnDate = String.valueOf(RandomUserAgent.releaseDate[0]) + RandomUserAgent.releaseDate[1] + RandomUserAgent.releaseDate[2];
        if (releaseDate == null || releaseDate.length < 3 || releaseDate.length > 4) {
            return returnDate;
        }
        GregorianCalendar rCal = new GregorianCalendar(Integer.parseInt(releaseDate[0]), Integer.parseInt(releaseDate[1]) - 1, Integer.parseInt(releaseDate[2]));
        long rTime = rCal.getTimeInMillis();
        long cTime = new GregorianCalendar().getTimeInMillis();
        Random rand = new Random();
        int temp = (int)((cTime - rTime) / 60000L) + (int)(rTime / 60000L);
        if (temp < 0) {
            temp = -temp;
        }
        long randTime = rand.nextInt(temp);
        rCal.setTimeInMillis(randTime * 60000L);
        int year = rCal.get(1);
        String month = Formatter.fillString((String)String.valueOf(rCal.get(2) + 1), (String)"0", (String)"", (int)2);
        String day = Formatter.fillString((String)String.valueOf(rCal.get(5)), (String)"0", (String)"", (int)2);
        String hour = "";
        if (releaseDate.length == 4) {
            hour = Formatter.fillString((String)String.valueOf(rand.nextInt(24)), (String)"0", (String)"", (int)2);
        }
        returnDate = year + month + day + hour;
        return returnDate;
    }

    private static class System {
        public String platform;
        public String osName;
        public String archs;
        public boolean inverseOrder;
        public boolean useIt;

        public System(String platform, String osName, String archs, boolean inverseOrder, boolean useIt) {
            this.platform = platform;
            this.osName = osName;
            this.archs = archs;
            this.inverseOrder = inverseOrder;
            this.useIt = useIt;
        }
    }
}

