/*
 * Decompiled with CFR 0.152.
 */
package jd.http.download;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jd.http.Browser;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.download.BrowserException;
import jd.http.download.ChunkProgress;
import jd.http.download.DownloadChunkInterface;
import jd.http.download.HDWriter;
import jd.http.download.HTTPDownload;
import jd.http.download.TwoLayerSpeedMeter;
import jd.http.requests.PostRequest;
import jd.nutils.jobber.JDRunnable;
import jd.utils.locale.JDL;

public class DownloadChunk
extends DownloadChunkInterface
implements JDRunnable {
    private static final int MAXBUFFER_SIZE = 131072;
    private static final int TIMEOUT_READ = 20000;
    private static final int TIMEOUT_CONNECT = 20000;
    private static final int SPEEDMETER_INTERVAL = 3000;
    private Request request;
    private URLConnectionAdapter connection;
    private InputStream inputStream;
    private long writePosition = 0L;
    private ReadableByteChannel channel;
    private boolean connectionRequested = false;
    private HTTPDownload owner;
    private long bytesLoaded = 0L;
    private boolean alive;
    private TwoLayerSpeedMeter speedmeter;
    private ByteBuffer buffer;
    private ChunkProgress chunkProgress;

    public long getWritePosition() {
        return this.getChunkStart() + this.writePosition;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String toString() {
        return "Chunk [" + this.getChunkStart() + " - " + this.getChunkEnd() + "]";
    }

    public HTTPDownload getOwner() {
        return this.owner;
    }

    public ReadableByteChannel getChannel() {
        return this.channel;
    }

    public DownloadChunk(HTTPDownload owner, long start, long end) throws BrowserException {
        this.owner = owner;
        this.setChunkStart(start);
        this.setChunkEnd(end);
        this.chunkProgress = new ChunkProgress();
        if (start > end && end > 0L) {
            throw new BrowserException("range error " + start + " - " + end);
        }
        this.request = owner.getRequest();
    }

    public DownloadChunk(HTTPDownload owner) {
        this.owner = owner;
        this.request = owner.getRequest();
        this.chunkProgress = new ChunkProgress();
    }

    public void connect() throws IOException, BrowserException {
        if (this.connectionRequested) {
            throw new IllegalStateException("Already Connected");
        }
        this.connectionRequested = true;
        if (this.request.getHttpConnection() == null) {
            this.owner.getBrowser().openRequestConnection(this.request);
            this.connection = this.request.getHttpConnection();
        } else {
            URLConnectionAdapter connection = this.request.getHttpConnection();
            Browser br = this.owner.getBrowser().cloneBrowser();
            br.setDebug(true);
            br.setReadTimeout(this.request.getReadTimeout());
            br.setConnectTimeout(this.request.getConnectTimeout());
            Map<String, List<String>> request = connection.getRequestProperties();
            if (request != null) {
                Set<Map.Entry<String, List<String>>> requestEntries = request.entrySet();
                for (Map.Entry<String, List<String>> next : requestEntries) {
                    String value = next.getValue().toString();
                    br.getHeaders().put(next.getKey(), value.substring(1, value.length() - 1));
                }
            }
            if (this.getChunkEnd() < 0L) {
                br.getHeaders().put("Range", "bytes=" + this.getChunkStart() + "-");
            } else {
                br.getHeaders().put("Range", "bytes=" + this.getChunkStart() + "-" + this.getChunkEnd());
            }
            URLConnectionAdapter con = connection.getDoOutput() ? br.openPostConnection("" + connection.getURL(), ((PostRequest)connection.getRequest()).getPostDataString()) : br.openGetConnection("" + connection.getURL());
            if (!con.isOK()) {
                throw new BrowserException(JDL.L((String)"exceptions.browserexception.chunkcopyerror.badrequest", (String)"Unexpected chunkcopy error"), 2);
            }
            if (con.getHeaderField("Location") != null) {
                throw new BrowserException(JDL.L((String)"exceptions.browserexception.redirecterror", (String)"Unexpected chunkcopy error: Redirect"), 3);
            }
            this.connection = con;
            long[] range = this.connection.getRange();
            System.out.println("CL " + con.getLongContentLength() + "- " + (range[1] - range[0]));
            if (range[0] != this.getChunkStart()) {
                throw new BrowserException(JDL.L((String)"exceptions.browserexception.rangeerror", (String)"Chunkload error"), 1);
            }
            if (this.getChunkEnd() > 0L && range[1] < this.getChunkEnd()) {
                throw new BrowserException(JDL.L((String)"exceptions.browserexception.rangeerror", (String)"Chunkload error"), 1);
            }
        }
        if (!this.connection.isOK()) {
            throw new BrowserException(JDL.LF((String)"exceptions.browserexception.badrequest", (String)"Bad Request: %s(%s)", (Object[])new Object[]{this.connection.getResponseMessage(), String.valueOf(this.connection.getResponseCode())}), 2);
        }
        this.connection.setReadTimeout(20000);
        this.connection.setConnectTimeout(20000);
        this.inputStream = this.connection.getInputStream();
        this.channel = Channels.newChannel(this.inputStream);
    }

    public boolean isConnectionRequested() {
        return this.connectionRequested;
    }

    public void setRange(long start, long end) {
        this.setChunkStart(start);
        this.setChunkEnd(end);
    }

    public long getChunkBytes() {
        return this.bytesLoaded;
    }

    public long getRemainingChunkBytes() {
        long end = this.getChunkEnd();
        if (end < 0L) {
            end = this.owner.getFileSize() - 1L;
            System.out.println("FIlesize: " + end);
        }
        return Math.max(0L, end - this.getChunkStart() - this.bytesLoaded + 1L);
    }

    public void go() throws Exception {
        this.alive = true;
        this.speedmeter = new TwoLayerSpeedMeter(3000);
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            this.download();
            System.out.println("F2 " + this);
        }
        finally {
            System.out.println("F3 " + this);
            this.setChunkEnd(this.getWritePosition() - 1L);
            this.alive = false;
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() throws Exception, InterruptedException {
        this.bytesLoaded = 0L;
        this.buffer = ByteBuffer.allocateDirect(131072);
        ByteBuffer miniBuffer = ByteBuffer.allocateDirect(10240);
        miniBuffer.clear();
        long loadUntil = 0L;
        int miniRead = 0;
        long limit = -1L;
        this.buffer.clear();
        try {
            block12: while (true) {
                if (this.getChunkEnd() > 0L && this.getWritePosition() + (long)this.buffer.limit() > this.getChunkEnd()) {
                    try {
                        this.buffer.limit((int)(this.getChunkEnd() - this.getWritePosition() + 1L));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                loadUntil = System.currentTimeMillis() + 250L;
                limit = this.owner.getChunkBandwidth();
                if (limit > 0L) {
                    limit /= 4L;
                    limit = Math.max(1L, limit);
                    limit = Math.min((long)this.buffer.capacity(), limit);
                    if (limit > (long)this.buffer.capacity()) {
                        HTTPDownload.debug("Buffer auf " + (double)limit * 1.1);
                        this.buffer = ByteBuffer.allocateDirect((int)((double)limit * 1.1));
                    }
                    this.buffer.limit((int)limit);
                }
                while (this.buffer.hasRemaining() && System.currentTimeMillis() < loadUntil) {
                    miniBuffer.clear();
                    if (miniBuffer.remaining() > this.buffer.remaining()) {
                        miniBuffer.limit(this.buffer.remaining());
                    }
                    try {
                        miniRead = this.channel.read(miniBuffer);
                    }
                    finally {
                        miniBuffer.flip();
                        this.buffer.put(miniBuffer);
                        if (miniRead > 0) {
                            this.bytesLoaded += (long)miniRead;
                        }
                    }
                    if (miniRead == -1) {
                        if (this.buffer.position() != 0) break;
                        break block12;
                    }
                    TwoLayerSpeedMeter twoLayerSpeedMeter = this.speedmeter;
                    synchronized (twoLayerSpeedMeter) {
                        this.speedmeter.update(miniRead);
                    }
                }
                System.out.println("write " + this + " " + this.buffer.position());
                HDWriter.getWriter().writeAndWait(this.getBuffer(), this.owner.getOutputChannel(), this.getWritePosition());
                System.out.println(this + "Buffer written.. continue " + this.writePosition + "+" + this.buffer.limit() + " = " + (this.writePosition + (long)this.buffer.limit()));
                this.writePosition += (long)this.buffer.limit();
                this.buffer.clear();
                System.out.println(this + "Buffer written.. continue " + this.getWritePosition());
                this.owner.onBufferWritten(this);
                if (miniRead == -1) break;
                if (this.getChunkEnd() > 0L && this.getWritePosition() > this.getChunkEnd()) {
                    System.out.println("Overhead interrupt " + (this.getChunkEnd() - this.getWritePosition() + 1L));
                    return;
                }
                long restWait = loadUntil - System.currentTimeMillis();
                if (limit <= 0L && restWait > 100L) {
                    HTTPDownload.debug("Buffer auf " + (double)this.buffer.capacity() * 1.5);
                    this.buffer = ByteBuffer.allocateDirect((int)((double)this.buffer.capacity() * 1.5));
                }
                if (limit <= 0L || restWait <= 0L) continue;
                Thread.sleep(restWait);
            }
            miniRead = 0;
        }
        finally {
            if (this.buffer.position() > 0) {
                System.out.println("F1 " + this);
                HDWriter.getWriter().writeAndWait(this.getBuffer(), this.owner.getOutputChannel(), this.getWritePosition());
                this.writePosition += (long)this.buffer.limit();
                System.out.println(this + " 2Buffer written.. continue " + this.writePosition);
                this.buffer.clear();
                this.owner.onBufferWritten(this);
            }
            this.disconnect();
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getSpeed() {
        if (this.speedmeter == null || !this.isAlive()) {
            return 0L;
        }
        return this.speedmeter.getSpeed();
    }

    private void disconnect() throws IOException {
        System.out.println(this + " CLOSE & Disconnect");
        this.channel.close();
        this.inputStream.close();
        this.connection.disconnect();
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void resetSpeedMeter() {
        this.speedmeter = new TwoLayerSpeedMeter(3000);
    }

    protected ChunkProgress getChunkProgress() {
        this.chunkProgress.setStart(this.getChunkStart());
        this.chunkProgress.setEnd(this.getWritePosition() - 1L);
        return this.chunkProgress;
    }
}

