/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSPathChange
extends SVNLogEntryPath {
    private static final long serialVersionUID = 4845L;
    private static final String FLAG_TRUE = "true";
    private static final String FLAG_FALSE = "false";
    private String myPath;
    private FSID myRevNodeId;
    private FSPathChangeKind myChangeKind;
    boolean isTextModified;
    boolean arePropertiesModified;

    public FSPathChange(String path, FSID id, FSPathChangeKind kind, boolean textModified, boolean propsModified, String copyfromPath, long copyfromRevision) {
        super(path, FSPathChangeKind.getType(kind), copyfromPath, copyfromRevision);
        this.myPath = path;
        this.myRevNodeId = id;
        this.myChangeKind = kind;
        this.isTextModified = textModified;
        this.arePropertiesModified = propsModified;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean arePropertiesModified() {
        return this.arePropertiesModified;
    }

    public void setPropertiesModified(boolean propertiesModified) {
        this.arePropertiesModified = propertiesModified;
    }

    public boolean isTextModified() {
        return this.isTextModified;
    }

    public void setTextModified(boolean textModified) {
        this.isTextModified = textModified;
    }

    public FSPathChangeKind getChangeKind() {
        return this.myChangeKind;
    }

    public void setChangeKind(FSPathChangeKind changeKind) {
        this.myChangeKind = changeKind;
        super.setChangeType(FSPathChangeKind.getType(changeKind));
    }

    public FSID getRevNodeId() {
        return this.myRevNodeId;
    }

    public void setRevNodeId(FSID revNodeId) {
        this.myRevNodeId = revNodeId;
    }

    public void setCopyRevision(long revision) {
        super.setCopyRevision(revision);
    }

    public void setCopyPath(String path) {
        super.setCopyPath(path);
    }

    public static FSPathChange fromString(String changeLine, String copyfromLine) throws SVNException {
        SVNErrorMessage err;
        SVNErrorMessage err2;
        String changesKindStr;
        FSPathChangeKind changesKind;
        int delimiterInd = changeLine.indexOf(32);
        if (delimiterInd == -1) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error(err3, SVNLogType.FSFS);
        }
        String id = changeLine.substring(0, delimiterInd);
        FSID nodeRevID = FSID.fromString(id);
        if ((delimiterInd = (changeLine = changeLine.substring(delimiterInd + 1)).indexOf(32)) == -1) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error(err4, SVNLogType.FSFS);
        }
        if ((changesKind = FSPathChangeKind.fromString(changesKindStr = changeLine.substring(0, delimiterInd))) == null) {
            err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid change kind in rev file");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        if ((delimiterInd = (changeLine = changeLine.substring(delimiterInd + 1)).indexOf(32)) == -1) {
            err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        String textModeStr = changeLine.substring(0, delimiterInd);
        boolean textModeBool = false;
        if (FLAG_TRUE.equals(textModeStr)) {
            textModeBool = true;
        } else if (FLAG_FALSE.equals(textModeStr)) {
            textModeBool = false;
        } else {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid text-mod flag in rev-file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        changeLine = changeLine.substring(delimiterInd + 1);
        delimiterInd = changeLine.indexOf(32);
        if (delimiterInd == -1) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String propModeStr = changeLine.substring(0, delimiterInd);
        boolean propModeBool = false;
        if (FLAG_TRUE.equals(propModeStr)) {
            propModeBool = true;
        } else if (FLAG_FALSE.equals(propModeStr)) {
            propModeBool = false;
        } else {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid prop-mod flag in rev-file");
            SVNErrorManager.error(err5, SVNLogType.FSFS);
        }
        String pathStr = changeLine.substring(delimiterInd + 1);
        String copyfromPath = null;
        long copyfromRevision = -1L;
        if (copyfromLine != null && copyfromLine.length() != 0) {
            delimiterInd = copyfromLine.indexOf(32);
            if (delimiterInd == -1) {
                SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Invalid changes line in rev-file");
                SVNErrorManager.error(err6, SVNLogType.FSFS);
            }
            try {
                copyfromRevision = Long.parseLong(copyfromLine.substring(0, delimiterInd));
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, nfe), SVNLogType.FSFS);
            }
            copyfromPath = copyfromLine.substring(delimiterInd + 1);
        }
        return new FSPathChange(pathStr, nodeRevID, changesKind, textModeBool, propModeBool, copyfromPath, copyfromRevision);
    }
}

