/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdunrar;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;
import jd.PluginWrapper;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.config.ConfigPropertyListener;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.JDController;
import jd.controlling.JDLogger;
import jd.controlling.PasswordListController;
import jd.controlling.ProgressController;
import jd.controlling.SingleDownloadController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.UserIO;
import jd.gui.swing.SwingGui;
import jd.gui.swing.components.JDFileChooser;
import jd.gui.swing.jdgui.actions.ToolBarAction;
import jd.gui.swing.jdgui.menu.MenuAction;
import jd.nutils.Executer;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.OSDetector;
import jd.nutils.jobber.JDRunnable;
import jd.nutils.jobber.Jobber;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkStatus;
import jd.plugins.OptionalPlugin;
import jd.plugins.PluginForHost;
import jd.plugins.PluginOptional;
import jd.plugins.PluginProgress;
import jd.plugins.optional.jdunrar.ArchivFile;
import jd.plugins.optional.jdunrar.UnrarListener;
import jd.plugins.optional.jdunrar.UnrarWrapper;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OptionalPlugin(rev="$Revision: 9486 $", defaultEnabled=true, id="unrar", interfaceversion=5)
public class JDUnrar
extends PluginOptional
implements ControlListener,
UnrarListener,
ActionListener {
    private static final String DUMMY_HOSTER = "dum.my";
    private static MenuAction menuAction = null;
    private Jobber queue = new Jobber(1);

    public JDUnrar(PluginWrapper wrapper) {
        super(wrapper);
        this.checkUnrarCommand();
        this.initConfig();
    }

    public void controlEvent(ControlEvent event) {
        super.controlEvent(event);
        switch (event.getID()) {
            case 4: {
                if (!this.getPluginConfig().getBooleanProperty("ACTIVATED", true).booleanValue()) break;
                if (!(event.getSource() instanceof PluginForHost)) {
                    return;
                }
                DownloadLink link = ((SingleDownloadController)event.getParameter()).getDownloadLink();
                if ((link = this.findStartLink(link)) == null) {
                    return;
                }
                if (!link.getLinkStatus().hasStatus(2) || !link.getFilePackage().isExtractAfterDownload() && link.getFilePackage() != FilePackage.getDefaultFilePackage() || !this.isArchiveComplete(link)) break;
                this.addToQueue(link);
                break;
            }
            case 33: {
                if (!this.getPluginConfig().getBooleanProperty("DEEP_EXTRACT", true).booleanValue()) break;
                try {
                    File[] list = (File[])event.getParameter();
                    ArrayList<String> processed = new ArrayList<String>();
                    File[] fileArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File archiveStartFile = fileArray[n2];
                        if (!processed.contains(archiveStartFile.toString()) && JDUnrar.getArchivePartType(archiveStartFile) != 3 && JDUnrar.getArchivePartType(archiveStartFile) != 0) {
                            DownloadLink link = JDUtilities.getController().getDownloadLinkByFileOutput(archiveStartFile, Integer.valueOf(2));
                            if (link == null) {
                                link = new DownloadLink(null, archiveStartFile.getName(), DUMMY_HOSTER, "", true);
                                link.setDownloadSize(archiveStartFile.length());
                                FilePackage fp = FilePackage.getInstance();
                                fp.setDownloadDirectory(archiveStartFile.getParent());
                                link.setFilePackage(fp);
                            }
                            if ((link = this.findStartLink(link)) != null) {
                                processed.addAll(this.getFileList(link.getFileOutput0()));
                                this.addToQueue(link);
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                }
                break;
            }
            case 22: {
                ArrayList items = (ArrayList)event.getParameter();
                MenuAction container = new MenuAction("optional.jdunrar.linkmenu.container", 0);
                items.add(container);
                if (event.getSource() instanceof DownloadLink) {
                    boolean isLocalyAvailable;
                    DownloadLink link = (DownloadLink)event.getSource();
                    MenuAction m = new MenuAction("optional.jdunrar.linkmenu.extract", 1000);
                    container.addMenuItem(m);
                    m.setActionListener((ActionListener)this);
                    m.setEnabled(false);
                    boolean bl = isLocalyAvailable = new File(link.getFileOutput()).exists() || new File(link.getStringProperty("STATIC_OUTPUTFILE", link.getFileOutput())).exists();
                    if (isLocalyAvailable && link.getName().matches(".*rar$")) {
                        m.setEnabled(true);
                    }
                    m.setProperty("LINK", (Object)link);
                    m = new MenuAction("optional.jdunrar.linkmenu.autoextract", 1005);
                    container.addMenuItem(m);
                    m.setActionListener((ActionListener)this);
                    m.setSelected(link.getFilePackage().isExtractAfterDownload());
                    m.setProperty("LINK", (Object)link);
                    m = new MenuAction(ToolBarAction.Types.SEPARATOR);
                    container.addMenuItem(m);
                    m = new MenuAction("optional.jdunrar.linkmenu.setextract", 1003);
                    container.addMenuItem(m);
                    m.setActionListener((ActionListener)this);
                    m.setProperty("LINK", (Object)link);
                    File dir = this.getExtractToPath(link);
                    while (dir != null && !dir.exists()) {
                        if (dir.getParentFile() == null) break;
                        dir = dir.getParentFile();
                    }
                    if (dir == null) break;
                    m = new MenuAction("optional.jdunrar.linkmenu.openextract3", 1002);
                    container.addMenuItem(m);
                    m.setActionListener((ActionListener)this);
                    link.setProperty("EXTRACTEDPATH2", (Object)dir.getAbsolutePath());
                    m.setProperty("LINK", (Object)link);
                    break;
                }
                FilePackage fp = (FilePackage)event.getSource();
                MenuAction m = new MenuAction("optional.jdunrar.linkmenu.package.extract", 1001);
                container.addMenuItem(m);
                m.setActionListener((ActionListener)this);
                m.setProperty("PACKAGE", (Object)fp);
                m = new MenuAction("optional.jdunrar.linkmenu.package.autoextract", 1006);
                container.addMenuItem(m);
                m.setSelected(fp.isExtractAfterDownload());
                m.setActionListener((ActionListener)this);
                m.setProperty("PACKAGE", (Object)fp);
            }
        }
    }

    private boolean isArchiveComplete(DownloadLink link) {
        String pattern = link.getFileOutput().replaceAll("\\.pa?r?t?\\.?[0-9]+.rar$", "");
        pattern = pattern.replaceAll("\\.rar$", "");
        pattern = pattern.replaceAll("\\.r\\d+$", "");
        pattern = "^" + Regex.escape((String)pattern) + ".*";
        ArrayList matches = JDUtilities.getController().getDownloadLinksByPathPattern(pattern);
        if (matches == null) {
            return false;
        }
        for (DownloadLink l : matches) {
            if (!new File(l.getFileOutput()).exists()) {
                return false;
            }
            if (l.getLinkStatus().hasStatus(2) || !l.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public static int getArchivePartType(DownloadLink link) {
        return JDUnrar.getArchivePartType(new File(link.getFileOutput()));
    }

    public static int getArchivePartType(File file) {
        if (file.getName().matches(".*pa?r?t?\\.?\\d+.rar$")) {
            return 1;
        }
        if (file.getName().matches(".*.rar$")) {
            String filename = new Regex((Object)file, "(.*)\\.rar$").getMatch(0);
            if (new File(String.valueOf(filename) + ".r0").exists()) {
                return 11;
            }
            if (new File(String.valueOf(filename) + ".r00").exists()) {
                return 11;
            }
            if (new File(String.valueOf(filename) + ".r000").exists()) {
                return 11;
            }
            if (new File(String.valueOf(filename) + ".r0000").exists()) {
                return 11;
            }
        }
        if (file.getName().matches(".*rar$")) {
            return 2;
        }
        if (!file.getName().matches(".*rar$")) {
            return 3;
        }
        return 0;
    }

    private DownloadLink findStartLink(DownloadLink link) {
        int type = JDUnrar.getArchivePartType(link);
        switch (type) {
            case 1: 
            case 11: {
                break;
            }
            case 2: {
                return link;
            }
            case 3: {
                return null;
            }
        }
        File file = null;
        String filename = null;
        if (type == 1 ? !(file = new File(String.valueOf(filename = new Regex(link.getFileOutput(), "(.*)\\.pa?r?t?\\.?[0-9]+.rar$").getMatch(0)) + ".part1.rar")).exists() && !(file = new File(String.valueOf(filename) + ".part01.rar")).exists() && !(file = new File(String.valueOf(filename) + ".part001.rar")).exists() && !(file = new File(String.valueOf(filename) + ".part0001.rar")).exists() && !(file = new File(String.valueOf(filename) + ".part000.rar")).exists() : type == 11 && !(file = new File(String.valueOf(filename = new Regex(link.getFileOutput(), "(.*)\\.r(\\d+|ar)$").getMatch(0)) + ".rar")).exists()) {
            return null;
        }
        DownloadLink dlink = JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2));
        if (dlink == null) {
            dlink = new DownloadLink(null, file.getName(), DUMMY_HOSTER, "", true);
            dlink.getLinkStatus().setStatus(link.getLinkStatus().getStatus());
            FilePackage fp = FilePackage.getInstance();
            fp.setDownloadDirectory(file.getParent());
            dlink.setFilePackage(fp);
        }
        return dlink;
    }

    private String getArchiveName(DownloadLink link) {
        return this.getArchiveName(link.getFileOutput0());
    }

    private String getArchiveName(String link) {
        String match = new Regex(new File(link).getName(), "(.*)\\.pa?r?t?\\.?[0]*[1].rar$").getMatch(0);
        if (match != null) {
            return match;
        }
        match = new Regex(new File(link).getName(), "(.*)\\.pa?r?t?\\.?[0-9]+.rar$").getMatch(0);
        if (match != null) {
            return match;
        }
        match = new Regex(new File(link).getName(), "(.*)\\.rar$").getMatch(0);
        if (match != null) {
            return match;
        }
        match = new Regex(new File(link).getName(), "(.*)\\.r\\d+$").getMatch(0);
        return match;
    }

    private void addToQueue(DownloadLink link) {
        if (this.getPluginConfig().getStringProperty("UNRAR_HASH", null) == null) {
            logger.warning("JDUnrar: no valid binary found!");
            return;
        }
        if (!new File(link.getFileOutput()).exists()) {
            return;
        }
        link.getLinkStatus().removeStatus(0x1000000);
        link.getLinkStatus().setErrorMessage(null);
        File dl = this.getExtractToPath(link);
        UnrarWrapper wrapper = new UnrarWrapper(link);
        if (link.getHost().equals(DUMMY_HOSTER)) {
            ProgressController progress = new ProgressController(JDL.LF((String)"plugins.optional.jdunrar.progress.extractfile", (String)"Extract %s", (Object[])new Object[]{link.getFileOutput()}), 100L);
            wrapper.setProgressController(progress);
        }
        wrapper.addUnrarListener(this);
        wrapper.setExtractTo(dl);
        wrapper.setRemoveAfterExtract(this.getPluginConfig().getBooleanProperty("REMOVE_AFTER_EXTRACT", false));
        wrapper.setOverwrite(this.getPluginConfig().getBooleanProperty("OVERWRITE", true));
        wrapper.setUnrarCommand(this.getPluginConfig().getStringProperty("UNRARCOMMAND"));
        ArrayList<String> pwList = new ArrayList<String>();
        pwList.add(link.getFilePackage().getPassword());
        pwList.addAll(link.getFilePackage().getPasswordAuto());
        String dlpw = link.getStringProperty("pass", null);
        if (dlpw != null) {
            pwList.add(dlpw);
        }
        pwList.addAll(PasswordListController.getInstance().getPasswordList());
        pwList.add(this.getArchiveName(link));
        pwList.add(new File(link.getFileOutput()).getName());
        wrapper.setPasswordList(pwList);
        this.queue.add((JDRunnable)wrapper);
        this.queue.start();
        ArrayList<DownloadLink> list = this.getArchiveList(link);
        for (DownloadLink l : list) {
            if (l == null) continue;
            l.setProperty("EXTRACTEDPATH", (Object)dl.getAbsolutePath());
        }
    }

    private File getExtractToPath(DownloadLink link) {
        if (link.getProperty("EXTRAXT_TO_PATH") != null) {
            return (File)link.getProperty("EXTRAXT_TO_PATH");
        }
        if (link.getHost().equals(DUMMY_HOSTER)) {
            return new File(link.getFileOutput()).getParentFile();
        }
        String path = this.getPluginConfig().getBooleanProperty("USE_EXTRACT_PATH", false) == false ? new File(link.getFileOutput()).getParent() : this.getPluginConfig().getStringProperty("UNRARPATH", JDUtilities.getDefaultDownloadDirectory());
        File ret = new File(path);
        if (!this.getPluginConfig().getBooleanProperty("USE_SUBPATH", false).booleanValue()) {
            return ret;
        }
        path = this.getPluginConfig().getStringProperty("SUBPATH", "%PACKAGENAME%");
        try {
            if (link.getFilePackage().getName() != null) {
                path = path.replace("%PACKAGENAME%", link.getFilePackage().getName());
            } else {
                path = path.replace("%PACKAGENAME%", "");
                logger.severe("link.getFilePackage().getName() ==null");
            }
            if (this.getArchiveName(link) != null) {
                path = path.replace("%ARCHIVENAME%", this.getArchiveName(link));
            } else {
                logger.severe("getArchiveName(link) ==null");
            }
            if (link.getHost() != null) {
                path = path.replace("%HOSTER%", link.getHost());
            } else {
                logger.severe("link.getFilePackage().getName() ==null");
            }
            String dif = new File(JDUtilities.getDefaultDownloadDirectory()).getAbsolutePath().replace(new File(link.getFileOutput()).getParent(), "");
            if (new File(dif).isAbsolute()) {
                dif = "";
            }
            path = path.replace("%SUBFOLDER%", dif);
            path = path.replaceAll("[/]+", "\\\\");
            path = path.replaceAll("[\\\\]+", "\\\\");
            return new File(ret, path);
        }
        catch (Exception e) {
            JDLogger.exception((Throwable)e);
            return ret;
        }
    }

    public String getIconKey() {
        return "gui.images.addons.unrar";
    }

    public ArrayList<MenuAction> createMenuitems() {
        ArrayList<MenuAction> menu = new ArrayList<MenuAction>();
        MenuAction m = new MenuAction("optional.jdunrar.menu.toggle", 1);
        menu.add(m);
        m.setActionListener((ActionListener)this);
        m.setSelected(this.getPluginConfig().getBooleanProperty("ACTIVATED", true).booleanValue());
        menu.add(menuAction);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof MenuAction) {
            this.actionPerformedOnMenuItem((MenuAction)e.getSource());
        }
    }

    private void actionPerformedOnMenuItem(MenuAction source) {
        SubConfiguration cfg = this.getPluginConfig();
        switch (source.getActionID()) {
            case 1: {
                cfg.setProperty("ACTIVATED", (Object)(cfg.getBooleanProperty("ACTIVATED", true) == false ? 1 : 0));
                cfg.save();
                break;
            }
            case 1000: {
                DownloadLink link = this.findStartLink((DownloadLink)source.getProperty("LINK"));
                if (link == null) {
                    return;
                }
                final DownloadLink finalLink = link;
                System.out.print("queued to extract: " + link);
                new Thread(){

                    public void run() {
                        JDUnrar.this.addToQueue(finalLink);
                    }
                }.start();
                break;
            }
            case 1001: {
                FilePackage fp = (FilePackage)source.getProperty("PACKAGE");
                ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
                for (DownloadLink l : fp.getDownloadLinkList()) {
                    if (!l.getLinkStatus().hasStatus(2) || !l.getName().matches(".*part[0]*[1].rar$") && (l.getName().matches(".*part[0-9]+.rar$") || !l.getName().matches(".*rar$"))) continue;
                    links.add(l);
                }
                if (links.size() <= 0) {
                    return;
                }
                Iterator iterator = links.iterator();
                while (iterator.hasNext()) {
                    DownloadLink link0;
                    DownloadLink link = link0 = (DownloadLink)iterator.next();
                    if ((link = this.findStartLink(link)) == null) continue;
                    final DownloadLink finalLink0 = link;
                    System.out.print("queued to extract: " + link);
                    new Thread(){

                        public void run() {
                            JDUnrar.this.addToQueue(finalLink0);
                        }
                    }.start();
                }
                break;
            }
            case 1002: {
                DownloadLink link = (DownloadLink)source.getProperty("LINK");
                if (link == null) {
                    return;
                }
                String path = link.getStringProperty("EXTRACTEDPATH2");
                if (!new File(path).exists()) {
                    UserIO.getInstance().requestMessageDialog(JDL.LF((String)"plugins.optional.jdunrar.messages", (String)"The path %s does not exist.", (Object[])new Object[]{path}));
                    break;
                }
                JDUtilities.openExplorer((File)new File(path));
                break;
            }
            case 1003: {
                DownloadLink link = (DownloadLink)source.getProperty("LINK");
                ArrayList<DownloadLink> list = this.getArchiveList(link);
                JDFileChooser fc = new JDFileChooser("_JDUNRAR_");
                fc.setMultiSelectionEnabled(false);
                fc.setFileSelectionMode(1);
                FileFilter ff = new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }

                    public String getDescription() {
                        return JDL.L((String)"plugins.optional.jdunrar.filefilter.extractto", (String)"Extract Directory");
                    }
                };
                fc.setFileFilter(ff);
                File extractto = this.getExtractToPath(link);
                while (extractto != null && !extractto.isDirectory()) {
                    extractto = extractto.getParentFile();
                }
                fc.setCurrentDirectory(extractto);
                if (fc.showOpenDialog((Component)SwingGui.getInstance().getMainFrame()) != 0) break;
                File dl = fc.getSelectedFile();
                if (dl == null) {
                    return;
                }
                for (DownloadLink l : list) {
                    l.setProperty("EXTRAXT_TO_PATH", (Object)dl);
                }
                break;
            }
            case 1005: {
                DownloadLink link = (DownloadLink)source.getProperty("LINK");
                if (link == null) {
                    return;
                }
                link.getFilePackage().setExtractAfterDownload(!link.getFilePackage().isExtractAfterDownload());
                break;
            }
            case 1006: {
                FilePackage fp = (FilePackage)source.getProperty("PACKAGE");
                if (fp == null) {
                    return;
                }
                fp.setExtractAfterDownload(!fp.isExtractAfterDownload());
            }
        }
    }

    public boolean initAddon() {
        if (menuAction == null) {
            menuAction = new MenuAction("optional.jdunrar.menu.extract.singlefils", "gui.images.addons.unrar"){
                private static final long serialVersionUID = -7569522709162921624L;

                public void initDefaults() {
                    this.setPriority(800);
                    this.setToolTipText(JDL.L((String)"plugins.optional.jdunrar.extractFiles", (String)"Extract RAR-Archives"));
                    this.setEnabled(true);
                }

                public void onAction(ActionEvent e) {
                    JDFileChooser fc = new JDFileChooser("_JDUNRAR_");
                    fc.setMultiSelectionEnabled(true);
                    FileFilter ff = new FileFilter(){

                        public boolean accept(File pathname) {
                            if (pathname.getName().matches(".*pa?r?t?\\.?[0]*[1].rar$")) {
                                return true;
                            }
                            if (!pathname.getName().matches(".*pa?r?t?\\.?[0-9]+.rar$") && pathname.getName().matches(".*rar$")) {
                                return true;
                            }
                            return pathname.isDirectory();
                        }

                        public String getDescription() {
                            return JDL.L((String)"plugins.optional.jdunrar.filefilter", (String)"Rar-Startvolumes");
                        }
                    };
                    fc.setFileFilter(ff);
                    if (fc.showOpenDialog((Component)SwingGui.getInstance().getMainFrame()) == 0) {
                        File[] list = fc.getSelectedFiles();
                        if (list == null) {
                            return;
                        }
                        File[] fileArray = list;
                        int n = list.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File archiveStartFile = fileArray[n2];
                            DownloadLink link = JDUtilities.getController().getDownloadLinkByFileOutput(archiveStartFile, Integer.valueOf(2));
                            if (link == null) {
                                link = new DownloadLink(null, archiveStartFile.getName(), JDUnrar.DUMMY_HOSTER, "", true);
                                link.setDownloadSize(archiveStartFile.length());
                                FilePackage fp = FilePackage.getInstance();
                                fp.setDownloadDirectory(archiveStartFile.getParent());
                                link.setFilePackage(fp);
                            }
                            if ((link = JDUnrar.this.findStartLink(link)) != null) {
                                final DownloadLink finalLink = link;
                                System.out.print("queued to extract: " + archiveStartFile);
                                new Thread(){

                                    public void run() {
                                        JDUnrar.this.addToQueue(finalLink);
                                    }
                                }.start();
                            }
                            ++n2;
                        }
                    }
                }
            };
        }
        JDUtilities.getController().addControlListener((ControlListener)this);
        return true;
    }

    public void initConfig() {
        ConfigEntry ce;
        SubConfiguration subConfig = this.getPluginConfig();
        String hash = this.getPluginConfig().getStringProperty("UNRAR_HASH", null);
        if (hash == null) {
            ce = new ConfigEntry(0, (Property)subConfig, "UNRARCOMMAND", JDL.L((String)"gui.config.unrar.cmd", (String)"UnRAR command"));
            this.config.addEntry(ce);
            ce.setDefaultValue((Object)"please install unrar");
            JDController.getInstance().addControlListener((ControlListener)new ConfigPropertyListener(new String[]{"UNRARCOMMAND"}){

                public void onPropertyChanged(Property source, String key) {
                    if ("UNRARCOMMAND".equalsIgnoreCase(key)) {
                        String path = JDUnrar.this.getPluginConfig().getStringProperty("UNRARCOMMAND", null);
                        if (path != null && JDUnrar.this.isUnrarCommandValid(path)) {
                            JDUnrar.this.getPluginConfig().setProperty("UNRAR_HASH", (Object)JDHash.getMD5((File)new File(path)));
                            JDUnrar.this.getPluginConfig().save();
                        } else {
                            JDUnrar.this.getPluginConfig().setProperty("UNRAR_HASH", null);
                            JDUnrar.this.getPluginConfig().save();
                        }
                    }
                }
            });
        }
        ConfigEntry conditionEntry = new ConfigEntry(3, (Property)subConfig, "USE_EXTRACT_PATH", JDL.L((String)"gui.config.unrar.use_extractto", (String)"Use customized extract path"));
        this.config.addEntry(conditionEntry);
        conditionEntry.setDefaultValue((Object)false);
        ce = new ConfigEntry(9, (Property)subConfig, "UNRARPATH", JDL.L((String)"gui.config.unrar.path", (String)"Extract to"));
        this.config.addEntry(ce);
        ce.setDefaultValue((Object)JDUtilities.getDefaultDownloadDirectory());
        ce.setEnabledCondidtion(conditionEntry, true);
        ce = new ConfigEntry(3, (Property)subConfig, "REMOVE_AFTER_EXTRACT", JDL.L((String)"gui.config.unrar.remove_after_extract", (String)"Delete archives after suc. extraction?"));
        this.config.addEntry(ce);
        ce.setDefaultValue((Object)false);
        ce = new ConfigEntry(3, (Property)subConfig, "OVERWRITE", JDL.L((String)"gui.config.unrar.overwrite", (String)"Overwrite existing files?"));
        this.config.addEntry(ce);
        ce.setDefaultValue((Object)false);
        ConfigContainer ext = new ConfigContainer(JDL.L((String)"plugins.optional.jdunrar.config.advanced", (String)"Premium settings"));
        this.config.addEntry(new ConfigEntry(13, ext));
        conditionEntry = new ConfigEntry(3, (Property)subConfig, "USE_SUBPATH", JDL.L((String)"gui.config.unrar.use_subpath", (String)"Use subpath"));
        ext.addEntry(conditionEntry);
        conditionEntry.setDefaultValue((Object)false);
        ce = new ConfigEntry(0, (Property)subConfig, "SUBPATH", JDL.L((String)"gui.config.unrar.subpath", (String)"Subpath"));
        ext.addEntry(ce);
        ce.setDefaultValue((Object)"%PACKAGENAME%");
        ce.setEnabledCondidtion(conditionEntry, true);
        ce = new ConfigEntry(8, (Property)subConfig, "KEY_SUBPATH_MINNUM", JDL.L((String)"gui.config.unrar.subpath_minnum", (String)"Only use subpath if archive contains more than x files"), 0, 600).setDefaultValue((Object)0);
        ext.addEntry(ce);
        ce = new ConfigEntry(3, (Property)subConfig, "ASK_UNKNOWN_PASS", JDL.L((String)"gui.config.unrar.ask_path", (String)"Ask for unknown passwords?"));
        ext.addEntry(ce);
        ce.setDefaultValue((Object)true);
        ce = new ConfigEntry(3, (Property)subConfig, "DEEP_EXTRACT", JDL.L((String)"gui.config.unrar.deep_extract", (String)"Deep-Extraction"));
        ext.addEntry(ce);
        ce.setDefaultValue((Object)true);
        ce = new ConfigEntry(3, (Property)subConfig, "REMOVE_INFO_FILE", JDL.L((String)"gui.config.unrar.remove_infofile", (String)"Delete Infofile after extraction"));
        ext.addEntry(ce);
        ce.setDefaultValue((Object)false);
    }

    private void chmodUnrar(String path) {
        Executer exec = new Executer("chmod");
        exec.setLogger(JDLogger.getLogger());
        exec.addParameter("+x");
        exec.addParameter(path);
        exec.setWaitTimeout(-1);
        exec.start();
        exec.waitTimeout();
    }

    private void checkUnrarCommand() {
        if (this.checkUnrarCommandIntern()) {
            logger.info("Found valid unrar binary at " + this.getPluginConfig().getStringProperty("UNRARCOMMAND", null));
        } else {
            logger.severe("No valid unrar binary found!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkUnrarCommandIntern() {
        String path = this.getPluginConfig().getStringProperty("UNRARCOMMAND", null);
        String hash = this.getPluginConfig().getStringProperty("UNRAR_HASH", null);
        if (hash != null && hash.length() == 32 && path != null && path.length() != 0) {
            String curhash = JDHash.getMD5((File)new File(path));
            if (curhash != null && curhash.equalsIgnoreCase(hash)) {
                return true;
            }
        } else {
            path = null;
            hash = null;
        }
        if (path != null && path.length() != 0) {
            this.getPluginConfig().setProperty("UNRARCOMMAND", null);
            this.getPluginConfig().setProperty("UNRAR_HASH", null);
            this.getPluginConfig().save();
            return false;
        }
        if (OSDetector.isWindows()) {
            path = JDUtilities.getResourceFile((String)"tools\\windows\\unrarw32\\unrar.exe").getAbsolutePath();
            this.getPluginConfig().setProperty("UNRARCOMMAND", (Object)path);
            this.getPluginConfig().setProperty("UNRAR_HASH", (Object)JDHash.getMD5((File)new File(path)));
            this.getPluginConfig().save();
            return true;
        }
        if (OSDetector.isLinux()) {
            path = JDUtilities.getResourceFile((String)"tools/linux/unrar/unrar").getAbsolutePath();
            this.chmodUnrar(path);
            if (this.isUnrarCommandValid(path)) {
                this.getPluginConfig().setProperty("UNRARCOMMAND", (Object)path);
                this.getPluginConfig().setProperty("UNRAR_HASH", (Object)JDHash.getMD5((File)new File(path)));
                this.getPluginConfig().save();
                return true;
            }
        }
        if (OSDetector.isMac()) {
            path = JDUtilities.getResourceFile((String)"tools/mac/unrar2/unrar").getAbsolutePath();
            this.chmodUnrar(path);
            if (this.isUnrarCommandValid(path)) {
                this.getPluginConfig().setProperty("UNRARCOMMAND", (Object)path);
                this.getPluginConfig().setProperty("UNRAR_HASH", (Object)JDHash.getMD5((File)new File(path)));
                this.getPluginConfig().save();
                return true;
            }
        }
        try {
            String[] charset;
            String[] stringArray = charset = System.getenv("PATH").split(":");
            int n = charset.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                File fi = new File(element, "unrar");
                File fi2 = new File(element, "rar");
                if (fi.isFile() && this.isUnrarCommandValid(fi.getAbsolutePath())) {
                    path = fi.getAbsolutePath();
                    this.getPluginConfig().setProperty("UNRARCOMMAND", (Object)path);
                    this.getPluginConfig().setProperty("UNRAR_HASH", (Object)JDHash.getMD5((File)new File(path)));
                    this.getPluginConfig().save();
                    return true;
                }
                if (fi2.isFile() && this.isUnrarCommandValid(fi2.getAbsolutePath())) {
                    path = fi2.getAbsolutePath();
                    this.getPluginConfig().setProperty("UNRARCOMMAND", (Object)path);
                    this.getPluginConfig().setProperty("UNRAR_HASH", (Object)JDHash.getMD5((File)new File(path)));
                    this.getPluginConfig().save();
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getPluginConfig().setProperty("UNRARCOMMAND", null);
        this.getPluginConfig().setProperty("UNRAR_HASH", null);
        this.getPluginConfig().save();
        return false;
    }

    private boolean isUnrarCommandValid(String path) {
        return UnrarWrapper.isUnrarCommandValid(path);
    }

    public void onExit() {
        JDUtilities.getController().removeControlListener((ControlListener)this);
    }

    @Override
    public void onUnrarEvent(int id, UnrarWrapper wrapper) {
        LinkStatus ls = wrapper.getDownloadLink().getLinkStatus();
        if (wrapper.getDownloadLink().getFilePackage() == FilePackage.getDefaultFilePackage() && wrapper.getProgressController() == null) {
            logger.warning("LINK GOT REMOVED_: " + wrapper.getDownloadLink());
            ProgressController progress = new ProgressController(JDL.LF((String)"plugins.optional.jdunrar.progress.extractfile", (String)"Extract %s", (Object[])new Object[]{wrapper.getDownloadLink().getFileOutput()}), 100L);
            wrapper.setProgressController(progress);
        }
        if (wrapper.getProgressController() != null) {
            this.onUnrarDummyEvent(id, wrapper);
            return;
        }
        switch (id) {
            case 99: {
                logger.severe("Invalid unrar binary!");
                this.getPluginConfig().setProperty("UNRARCOMMAND", null);
                this.getPluginConfig().setProperty("UNRAR_HASH", null);
                this.getPluginConfig().save();
                break;
            }
            case 12: {
                ArrayList<DownloadLink> list = this.getArchiveList(wrapper.getDownloadLink());
                for (DownloadLink link : list) {
                    if (link == null) continue;
                    LinkStatus lls = link.getLinkStatus();
                    if (wrapper.getException() != null) {
                        lls.addStatus(0x1000000);
                        lls.setErrorMessage("Extract failed: " + wrapper.getException().getMessage());
                        link.requestGuiUpdate();
                        continue;
                    }
                    lls.addStatus(0x1000000);
                    lls.setErrorMessage("Extract failed");
                    link.requestGuiUpdate();
                }
                this.onFinished(wrapper);
                break;
            }
            case 14: {
                wrapper.getDownloadLink().requestGuiUpdate();
                if (!this.getPluginConfig().getBooleanProperty("ASK_UNKNOWN_PASS", true).booleanValue()) break;
                String pass = UserIO.getInstance().requestInputDialog(0, JDL.LF((String)"plugins.optional.jdunrar.askForPassword", (String)"Password for %s?", (Object[])new Object[]{wrapper.getDownloadLink().getName()}), null);
                if (pass == null || pass.length() == 0) {
                    ls.addStatus(0x1000000);
                    ls.setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.extractfailedpass", (String)"Extract failed (password)"));
                    this.onFinished(wrapper);
                    break;
                }
                wrapper.setPassword(pass);
                break;
            }
            case 17: {
                wrapper.getDownloadLink().getLinkStatus().setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.crackingpass", (String)"Cracking password"));
                wrapper.getDownloadLink().requestGuiUpdate();
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                wrapper.getDownloadLink().getLinkStatus().setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.openingarchive", (String)"Opening archive"));
                wrapper.getDownloadLink().requestGuiUpdate();
                break;
            }
            case 9: {
                this.assignRealDownloadDir(wrapper);
                break;
            }
            case 10: {
                wrapper.getDownloadLink().getLinkStatus().setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.passfound", (String)"Password found"));
                wrapper.getDownloadLink().requestGuiUpdate();
                wrapper.getDownloadLink().setPluginProgress(null);
                break;
            }
            case 18: {
                wrapper.getDownloadLink().getLinkStatus().setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.crackingpass", (String)"Cracking password"));
                if (wrapper.getDownloadLink().getPluginProgress() == null) {
                    wrapper.getDownloadLink().setPluginProgress(new PluginProgress((long)wrapper.getCrackProgress(), 100L, Color.GREEN.darker()));
                } else {
                    wrapper.getDownloadLink().getPluginProgress().setCurrent((long)wrapper.getCrackProgress());
                }
                wrapper.getDownloadLink().requestGuiUpdate();
                break;
            }
            case 6: {
                wrapper.getDownloadLink().getLinkStatus().setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.extracting", (String)"Extracting"));
                if (wrapper.getDownloadLink().getPluginProgress() == null) {
                    wrapper.getDownloadLink().setPluginProgress(new PluginProgress(wrapper.getExtractedSize(), wrapper.getTotalSize(), Color.YELLOW.darker()));
                } else {
                    wrapper.getDownloadLink().getPluginProgress().setCurrent(wrapper.getExtractedSize());
                }
                wrapper.getDownloadLink().requestGuiUpdate();
                break;
            }
            case 16: {
                ArrayList<DownloadLink> list = this.getArchiveList(wrapper.getDownloadLink());
                try {
                    if (wrapper.getCurrentFile() != null) {
                        logger.info("Delete " + wrapper.getCurrentFile().getFile() + " because it was not extracted successfully!");
                        wrapper.getCurrentFile().getFile().delete();
                    }
                }
                catch (Exception pass) {
                    // empty catch block
                }
                DownloadLink crc = null;
                if (wrapper.getCurrentVolume() > 0) {
                    DownloadLink downloadLink = crc = list.size() >= wrapper.getCurrentVolume() ? list.get(wrapper.getCurrentVolume() - 1) : null;
                }
                if (crc != null) {
                    for (DownloadLink link : list) {
                        if (link == null) continue;
                        if (link == crc) {
                            link.getLinkStatus().removeStatus(2);
                            link.getLinkStatus().removeStatus(8192);
                            link.getLinkStatus().addStatus(16384);
                            link.getLinkStatus().setValue(0x8000000L);
                            link.getLinkStatus().setErrorMessage(JDL.LF((String)"plugins.optional.jdunrar.crcerrorin", (String)"Extract: failed (CRC in %s)", (Object[])new Object[]{crc.getName()}));
                        } else {
                            link.getLinkStatus().addStatus(0x1000000);
                            link.getLinkStatus().setErrorMessage("Extract failed");
                        }
                        link.requestGuiUpdate();
                    }
                } else {
                    for (DownloadLink link : list) {
                        if (link == null) continue;
                        link.getLinkStatus().setErrorMessage(JDL.L((String)"plugins.optional.jdunrar.error.extrfailedcrc", (String)"Extract: failed (CRC in unknown file)"));
                        link.requestGuiUpdate();
                    }
                }
                this.onFinished(wrapper);
                break;
            }
            case 15: {
                ArrayList<DownloadLink> list = this.getArchiveList(wrapper.getDownloadLink());
                File[] files = new File[wrapper.getFiles().size()];
                int i = 0;
                for (ArchivFile af : wrapper.getFiles()) {
                    files[i++] = af.getFile();
                }
                JDUtilities.getController().fireControlEvent(new ControlEvent((Object)wrapper, 33, (Object)files));
                for (DownloadLink link : list) {
                    if (link == null) continue;
                    link.getLinkStatus().addStatus(2);
                    link.getLinkStatus().removeStatus(0x1000000);
                    link.getLinkStatus().setStatusText(JDL.L((String)"plugins.optional.jdunrar.status.extractok", (String)"Extract OK"));
                    link.requestGuiUpdate();
                }
                if (this.getPluginConfig().getBooleanProperty("REMOVE_INFO_FILE", false).booleanValue()) {
                    File fileOutput = new File(wrapper.getDownloadLink().getFileOutput());
                    String packname = wrapper.getDownloadLink().getFilePackage().getName();
                    File infoFiles = new File(fileOutput.getParentFile(), String.valueOf(packname.replaceFirst("(?i)(\\.part[0-9]+\\.rar|\\.rar)$", "")) + ".info");
                    if (infoFiles.exists() && infoFiles.delete()) {
                        logger.info(String.valueOf(infoFiles.getName()) + " removed");
                    }
                }
                this.onFinished(wrapper);
            }
        }
    }

    private void assignRealDownloadDir(UnrarWrapper wrapper) {
        PasswordListController.getInstance().addPassword(wrapper.getPassword(), true);
        int min = this.getPluginConfig().getIntegerProperty("KEY_SUBPATH_MINNUM", 0);
        if (min > 0) {
            ArrayList<ArchivFile> files = wrapper.getFiles();
            int i = 0;
            for (ArchivFile af : files) {
                if (af.getSize() <= 0L) continue;
                ++i;
            }
            Boolean usesub = this.getPluginConfig().getBooleanProperty("USE_SUBPATH", false);
            if (min >= i) {
                this.getPluginConfig().setProperty("USE_SUBPATH", (Object)false);
            } else {
                this.getPluginConfig().setProperty("USE_SUBPATH", (Object)true);
            }
            File dl = this.getExtractToPath(wrapper.getDownloadLink());
            wrapper.setExtractTo(dl);
            this.getPluginConfig().setProperty("USE_SUBPATH", (Object)usesub);
            ArrayList<DownloadLink> linkList = this.getArchiveList(wrapper.getDownloadLink());
            for (DownloadLink l : linkList) {
                if (l == null) continue;
                l.setProperty("EXTRACTEDPATH", (Object)dl.getAbsolutePath());
            }
        }
    }

    private void onUnrarDummyEvent(int id, UnrarWrapper wrapper) {
        ProgressController pc = wrapper.getProgressController();
        switch (id) {
            case 99: {
                logger.severe("Invalid unrar binary!");
                this.getPluginConfig().setProperty("UNRARCOMMAND", null);
                this.getPluginConfig().setProperty("UNRAR_HASH", null);
                this.getPluginConfig().save();
                break;
            }
            case 12: {
                if (wrapper.getException() != null) {
                    pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.extractfailed", (String)"Extract failed") + ": " + wrapper.getException().getMessage());
                } else {
                    pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.extractfailed", (String)"Extract failed"));
                }
                this.onFinished(wrapper);
                break;
            }
            case 14: {
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.extractfailedpass", (String)"Extract failed (password)"));
                if (!this.getPluginConfig().getBooleanProperty("ASK_UNKNOWN_PASS", true).booleanValue()) break;
                String pass = UserIO.getInstance().requestInputDialog(0, JDL.LF((String)"plugins.optional.jdunrar.askForPassword", (String)"Password for %s?", (Object[])new Object[]{wrapper.getDownloadLink().getName()}), null);
                if (pass == null || pass.length() == 0) {
                    this.onFinished(wrapper);
                    break;
                }
                wrapper.setPassword(pass);
                break;
            }
            case 18: {
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.crackingpass", (String)"Cracking password"));
                pc.setRange(100L);
                pc.setStatus((long)wrapper.getCrackProgress());
                break;
            }
            case 8: {
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.openingarchive", (String)"Opening archive"));
                break;
            }
            case 9: {
                this.assignRealDownloadDir(wrapper);
                break;
            }
            case 10: {
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.passfound", (String)"Password found"));
                break;
            }
            case 6: {
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.extracting", (String)"Extracting"));
                pc.setRange(wrapper.getTotalSize());
                pc.setStatus(wrapper.getExtractedSize());
                break;
            }
            case 16: {
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.extractfailedcrc", (String)"Extract failed (CRC error)"));
                this.onFinished(wrapper);
                break;
            }
            case 15: {
                File fileOutput;
                File infoFiles;
                File[] files = new File[wrapper.getFiles().size()];
                int i = 0;
                for (ArchivFile af : wrapper.getFiles()) {
                    files[i++] = af.getFile();
                }
                JDUtilities.getController().fireControlEvent(new ControlEvent((Object)wrapper, 33, (Object)files));
                pc.setStatusText(String.valueOf(wrapper.getFile().getName()) + ": " + JDL.L((String)"plugins.optional.jdunrar.status.extractok", (String)"Extract OK"));
                if (this.getPluginConfig().getBooleanProperty("REMOVE_INFO_FILE", false).booleanValue() && (infoFiles = new File((fileOutput = new File(wrapper.getDownloadLink().getFileOutput())).getParentFile(), String.valueOf(fileOutput.getName().replaceFirst("(?i)(\\.part[0-9]+\\.rar|\\.rar)$", "")) + ".info")).exists() && infoFiles.delete()) {
                    logger.info(String.valueOf(infoFiles.getName()) + " removed");
                }
                this.onFinished(wrapper);
            }
        }
    }

    private ArrayList<DownloadLink> getArchiveList(DownloadLink downloadLink) {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        int type = JDUnrar.getArchivePartType(downloadLink);
        String name = null;
        int nums = 0;
        int i = 0;
        switch (type) {
            case 0: 
            case 1: 
            case 11: {
                name = this.getArchiveName(downloadLink);
                String test = null;
                test = new Regex(downloadLink.getFileOutput(), "part(\\d*?)\\.").getMatch(0);
                if (test != null) {
                    File file;
                    nums = test.length();
                    i = 1;
                    while ((file = new File(new File(downloadLink.getFileOutput()).getParentFile(), String.valueOf(name) + ".part" + Formatter.fillString((String)String.valueOf(i), (String)"0", (String)"", (int)nums) + ".rar")).exists() || JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2)) != null) {
                        DownloadLink dl = JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2));
                        if (dl == null) {
                            dl = JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(8192));
                        }
                        if (dl == null) {
                            dl = JDUtilities.getController().getDownloadLinkByFileOutput(file, null);
                        }
                        if (dl != null) {
                            ret.add(dl);
                        }
                        ++i;
                    }
                } else {
                    File file;
                    test = new Regex(downloadLink.getFileOutput(), "(.*)\\.rar$").getMatch(0);
                    if (test == null) break;
                    ret.add(downloadLink);
                    i = 0;
                    nums = -1;
                    int a = 5;
                    while (a > 0) {
                        String len = ".r";
                        int b = a;
                        while (b > 0) {
                            len = String.valueOf(len) + "0";
                            --b;
                        }
                        if (new File(String.valueOf(test) + len).exists()) {
                            nums = a;
                            break;
                        }
                        --a;
                    }
                    if (nums == -1) break;
                    while ((file = new File(new File(downloadLink.getFileOutput()).getParentFile(), String.valueOf(name) + ".r" + Formatter.fillString((String)String.valueOf(i), (String)"0", (String)"", (int)nums))).exists() || JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2)) != null) {
                        DownloadLink dl = JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2));
                        if (dl == null) {
                            dl = JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(8192));
                        }
                        if (dl == null) {
                            dl = JDUtilities.getController().getDownloadLinkByFileOutput(file, null);
                        }
                        if (dl != null) {
                            ret.add(dl);
                        }
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                ret.add(downloadLink);
            }
        }
        return ret;
    }

    private ArrayList<String> getFileList(String filepath) {
        ArrayList<String> ret = new ArrayList<String>();
        int type = JDUnrar.getArchivePartType(new File(filepath));
        String name = null;
        int nums = 0;
        int i = 0;
        switch (type) {
            case 0: 
            case 1: 
            case 11: {
                name = this.getArchiveName(filepath);
                String test = null;
                test = new Regex(filepath, "part(\\d*?)\\.").getMatch(0);
                if (test != null) {
                    File file;
                    nums = test.length();
                    i = 1;
                    while ((file = new File(new File(filepath).getParentFile(), String.valueOf(name) + ".part" + Formatter.fillString((String)String.valueOf(i), (String)"0", (String)"", (int)nums) + ".rar")).exists() || JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2)) != null) {
                        ret.add(file.toString());
                        ++i;
                    }
                } else {
                    File file;
                    test = new Regex(filepath, "(.*)\\.rar$").getMatch(0);
                    if (test == null) break;
                    ret.add(filepath);
                    i = 0;
                    nums = -1;
                    int a = 5;
                    while (a > 0) {
                        String len = ".r";
                        int b = a;
                        while (b > 0) {
                            len = String.valueOf(len) + "0";
                            --b;
                        }
                        if (new File(String.valueOf(test) + len).exists()) {
                            nums = a;
                            break;
                        }
                        --a;
                    }
                    if (nums == -1) break;
                    while ((file = new File(new File(filepath).getParentFile(), String.valueOf(name) + ".r" + Formatter.fillString((String)String.valueOf(i), (String)"0", (String)"", (int)nums))).exists() || JDUtilities.getController().getDownloadLinkByFileOutput(file, Integer.valueOf(2)) != null) {
                        ret.add(file.toString());
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                ret.add(filepath);
            }
        }
        return ret;
    }

    private void onFinished(UnrarWrapper wrapper) {
        wrapper.getDownloadLink().setPluginProgress(null);
        if (wrapper.getProgressController() != null) {
            wrapper.getProgressController().doFinalize(8000L);
        }
    }

    public Object interact(String command, Object parameter) {
        if (command.equals("isWorking")) {
            return this.queue.isAlive();
        }
        return null;
    }
}

