/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.jdunrar;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.config.SubConfiguration;
import jd.controlling.JDLogger;
import jd.controlling.ProgressController;
import jd.nutils.DynByteBuffer;
import jd.nutils.Executer;
import jd.nutils.ProcessListener;
import jd.nutils.jobber.JDRunnable;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.optional.jdunrar.ArchivFile;
import jd.plugins.optional.jdunrar.FileSignatures;
import jd.plugins.optional.jdunrar.PasswordListener;
import jd.plugins.optional.jdunrar.Signature;
import jd.plugins.optional.jdunrar.UnrarException;
import jd.plugins.optional.jdunrar.UnrarListener;
import jd.utils.EditDistance;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnrarWrapper
extends Thread
implements JDRunnable {
    public static final int EXIT_CODE_USER_BREAK = 255;
    public static final int EXIT_CODE_CREATE_ERROR = 9;
    public static final int EXIT_CODE_MEMORY_ERROR = 8;
    public static final int EXIT_CODE_USER_ERROR = 7;
    public static final int EXIT_CODE_OPEN_ERROR = 6;
    public static final int EXIT_CODE_WRITE_ERROR = 5;
    public static final int EXIT_CODE_LOCKED_ARCHIVE = 4;
    public static final int EXIT_CODE_CRC_ERROR = 3;
    public static final int EXIT_CODE_FATAL_ERROR = 2;
    public static final int EXIT_CODE_WARNING = 1;
    public static final int EXIT_CODE_SUCCESS = 0;
    private static final boolean DEBUG = true;
    private ArrayList<UnrarListener> listener = new ArrayList();
    private DownloadLink link;
    private String unrarCommand;
    private ArrayList<String> passwordList;
    private File file;
    private int statusid;
    private String password;
    private boolean isProtected = false;
    private ArrayList<ArchivFile> files;
    private boolean overwriteFiles = false;
    private long totalSize;
    private ArchivFile currentlyWorkingOn;
    private int currentVolume = 1;
    private long startTime;
    private SubConfiguration config = null;
    private long speed = 10000000L;
    private boolean exactProgress = false;
    private int volumeNum = 1;
    private Exception exception;
    private File extractTo;
    private boolean removeAfterExtraction;
    private ArrayList<String> archiveParts;
    private int crackProgress;
    private int exitCode;
    private boolean gotInterrupted;
    private Logger logger;
    private ProgressController progressController;

    public void setCurrentlyWorkingOn(ArchivFile currentlyWorkingOn) {
        this.currentlyWorkingOn = currentlyWorkingOn;
    }

    public UnrarWrapper(DownloadLink link) {
        this.link = link;
        this.logger = JDLogger.getLogger();
        this.config = SubConfiguration.getConfig((String)JDL.L((String)"plugins.optional.jdunrar.name", (String)"JD-Unrar"));
        this.speed = this.config.getIntegerProperty("SPEED", 10000000);
        if (link == null) {
            throw new IllegalArgumentException("link==null");
        }
        this.file = new File(link.getFileOutput());
        this.archiveParts = new ArrayList();
    }

    public UnrarWrapper(DownloadLink link, File file) {
        this.link = link;
        this.config = SubConfiguration.getConfig((String)JDL.L((String)"plugins.optional.jdunrar.name", (String)"JD-Unrar"));
        if (link == null) {
            throw new IllegalArgumentException("link==null");
        }
        this.file = file;
        this.archiveParts = new ArrayList();
    }

    public void addUnrarListener(UnrarListener listener) {
        this.removeUnrarListener(listener);
        this.listener.add(listener);
    }

    private void removeUnrarListener(UnrarListener listener) {
        this.listener.remove(listener);
    }

    public ArrayList<ArchivFile> getFiles() {
        return this.files;
    }

    @Override
    public void run() {
        try {
            this.fireEvent(7);
            if (this.open()) {
                if (this.isProtected && this.password == null) {
                    this.fireEvent(17);
                    if (this.isProtected && this.password == null) {
                        this.crackPassword();
                        if (this.password == null) {
                            this.fireEvent(14);
                            if (this.password != null) {
                                this.passwordList.clear();
                                this.passwordList.add(this.password);
                                this.password = null;
                                this.crackPassword();
                            }
                            if (this.password != null) {
                                this.fireEvent(10);
                            }
                        } else {
                            this.fireEvent(10);
                        }
                        if (this.password == null) {
                            this.fireEvent(12);
                            return;
                        }
                    } else {
                        this.fireEvent(10);
                    }
                }
                this.fireEvent(9);
                boolean okay = this.extract();
                this.checkSizes();
                switch (this.exitCode) {
                    case 0: {
                        if (!this.gotInterrupted && this.removeAfterExtraction && okay) {
                            this.removeArchiveFiles();
                        }
                        this.fireEvent(15);
                        break;
                    }
                    case 3: {
                        JDLogger.getLogger().warning("A CRC error occurred when unpacking");
                        this.fireEvent(16);
                        break;
                    }
                    case 255: {
                        JDLogger.getLogger().info(" User interrupted extraction");
                        this.fireEvent(12);
                        break;
                    }
                    case 9: {
                        JDLogger.getLogger().warning("Could not create Outputfile");
                        this.fireEvent(12);
                        break;
                    }
                    case 8: {
                        JDLogger.getLogger().warning("Not enough memory for operation");
                        this.fireEvent(12);
                        break;
                    }
                    case 7: {
                        JDLogger.getLogger().warning("Command line option error");
                        this.fireEvent(12);
                        break;
                    }
                    case 6: {
                        JDLogger.getLogger().warning("Open file error");
                        this.fireEvent(12);
                        break;
                    }
                    case 5: {
                        JDLogger.getLogger().warning("Write to disk error");
                        this.exception = new UnrarException("Write to disk error");
                        this.fireEvent(12);
                        break;
                    }
                    case 4: {
                        JDLogger.getLogger().warning("Attempt to modify an archive previously locked by the 'k' command");
                        this.fireEvent(12);
                        break;
                    }
                    case 2: {
                        JDLogger.getLogger().warning("A fatal error occurred");
                        this.fireEvent(12);
                        break;
                    }
                    case 1: {
                        JDLogger.getLogger().warning("Non fatal error(s) occurred");
                        this.fireEvent(12);
                        break;
                    }
                    default: {
                        JDLogger.getLogger().warning("Unknown Error");
                        this.fireEvent(12);
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            this.exception = e;
            JDLogger.exception((Throwable)e);
            this.fireEvent(12);
        }
    }

    private boolean checkSizes() {
        boolean c = true;
        for (ArchivFile f : this.files) {
            System.err.println("Sizecheck: " + f.getFilepath() + "(" + f.getSize() + ") = " + f.getFile().length());
            if (f.getSize() != f.getFile().length()) {
                if (!f.getFile().isDirectory()) {
                    System.err.println("^ERROR^^");
                    c = false;
                    continue;
                }
                f.setPercent(100);
                continue;
            }
            f.setPercent(100);
        }
        return c;
    }

    private void removeArchiveFiles() {
        for (String file : this.archiveParts) {
            if (file == null || file.trim().length() <= 0) continue;
            File tmpFile = new File(file);
            if (tmpFile.isAbsolute()) {
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
                JDLogger.getLogger().warning("Deleted archive after extraction: " + new File(file));
                continue;
            }
            tmpFile = new File(this.file.getParentFile(), file);
            if (!tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
            this.logger.warning("Deleted archive after extraction: " + tmpFile);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public int getStatus() {
        return this.statusid;
    }

    private boolean extract() {
        this.fireEvent(13);
        Executer exec = new Executer(this.unrarCommand);
        exec.setLogger(JDLogger.getLogger());
        exec.setDebug(true);
        exec.addParameter("x");
        exec.addParameter("-p");
        if (this.overwriteFiles) {
            exec.addParameter("-o+");
        } else {
            exec.addParameter("-o-");
        }
        exec.addParameter("-c-");
        exec.addParameter("-v");
        exec.addParameter("-ierr");
        exec.addParameter(this.file.getAbsolutePath());
        exec.setRunin(this.file.getParentFile().getAbsolutePath());
        if (this.extractTo != null) {
            if (this.extractTo.exists() || this.extractTo.mkdirs()) {
                exec.setRunin(this.extractTo.getAbsolutePath());
            } else {
                this.logger.severe("could not create " + this.extractTo.toString());
            }
        }
        exec.setWaitTimeout(-1);
        exec.addProcessListener((ProcessListener)new ExtractListener(), Executer.LISTENER_ERRORSTREAM);
        exec.addProcessListener((ProcessListener)new PasswordListener(this.password), Executer.LISTENER_ERRORSTREAM);
        exec.start();
        this.startTime = System.currentTimeMillis();
        Thread inter = new Thread(){

            public void run() {
                while (true) {
                    if (!UnrarWrapper.this.exactProgress) {
                        if (!UnrarWrapper.this.exactProgress) {
                            long est = UnrarWrapper.this.speed * ((System.currentTimeMillis() - UnrarWrapper.this.startTime) / 1000L);
                            for (ArchivFile f : UnrarWrapper.this.files) {
                                long part = Math.min(est, f.getSize());
                                est -= part;
                                if (part == 0L && f.getSize() == 0L) {
                                    f.setPercent(100);
                                } else {
                                    f.setPercent((int)(part * 100L / f.getSize()));
                                }
                                if (est <= 0L) break;
                            }
                            UnrarWrapper.this.fireEvent(6);
                        } else {
                            return;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.statusid = -1;
        inter.start();
        exec.waitTimeout();
        this.exitCode = exec.getExitValue();
        this.gotInterrupted = exec.gotInterrupted();
        inter.interrupt();
        this.config.setProperty("SPEED", (Object)this.speed);
        this.config.save();
        if (this.statusid > 0) {
            switch (this.statusid) {
                case 16: {
                    this.exitCode = 3;
                }
            }
            return false;
        }
        return true;
    }

    private void crackPassword() {
        ArchivFile smallestFile = null;
        ArchivFile biggestFile = null;
        this.crackProgress = 0;
        this.fireEvent(18);
        for (ArchivFile f : this.files) {
            if (!f.isProtected()) continue;
            if (smallestFile == null) {
                smallestFile = f;
            } else if (f.getSize() < smallestFile.getSize()) {
                smallestFile = f;
            }
            if (biggestFile == null) {
                biggestFile = f;
                continue;
            }
            if (f.getSize() <= biggestFile.getSize()) continue;
            biggestFile = f;
        }
        if (smallestFile.getSize() < 0x200000L) {
            int c = 0;
            for (String pass : this.passwordList) {
                this.crackProgress = c++ * 100 / this.passwordList.size();
                this.fireEvent(18);
                Executer exec = new Executer(this.unrarCommand);
                exec.setLogger(JDLogger.getLogger());
                exec.setDebug(true);
                exec.addParameter("t");
                exec.addParameter("-sl" + (smallestFile.getSize() + 1L));
                exec.addParameter("-sm" + (smallestFile.getSize() - 1L));
                exec.addParameter("-c-");
                exec.addParameter(this.file.getName());
                exec.setRunin(this.file.getParentFile().getAbsolutePath());
                exec.setWaitTimeout(-1);
                exec.addProcessListener(new ProcessListener(){

                    public void onBufferChanged(Executer exec, DynByteBuffer totalBuffer, int latestReadNum) {
                    }

                    public void onProcess(Executer exec, String latestLine, DynByteBuffer totalBuffer) {
                        if (new Regex(latestLine, "^\\s*?(OK)").getMatch(0) != null) {
                            exec.interrupt();
                            System.out.println("loaded enough.... one file is enough");
                            totalBuffer.put("All OK".getBytes(), 6);
                        }
                    }
                }, Executer.LISTENER_STDSTREAM);
                PasswordListener pwl = null;
                pwl = new PasswordListener(pass);
                exec.addProcessListener((ProcessListener)pwl, Executer.LISTENER_ERRORSTREAM);
                exec.start();
                exec.waitTimeout();
                String res = String.valueOf(exec.getOutputStream()) + " \r\n " + exec.getErrorStream();
                if (res.indexOf(" (password incorrect ?)") != -1 || res.contains("the file header is corrupt") || pwl.pwerror() || !res.matches("(?s).*[\\s]+All OK[\\s].*")) continue;
                this.password = pass;
                this.crackProgress = 100;
                this.fireEvent(18);
                return;
            }
        } else {
            int c = 0;
            for (String pass : this.passwordList) {
                Signature signature;
                this.crackProgress = c++ * 100 / this.passwordList.size();
                this.fireEvent(18);
                Executer exec = new Executer(this.unrarCommand);
                exec.setDebug(true);
                exec.addParameter("p");
                exec.addParameter("-sm" + (biggestFile.getSize() - 1L));
                exec.addParameter("-c-");
                exec.addParameter("-ierr");
                exec.addParameter(this.file.getName());
                exec.setRunin(this.file.getParentFile().getAbsolutePath());
                exec.setWaitTimeout(-1);
                exec.addProcessListener((ProcessListener)new PasswordListener(pass), Executer.LISTENER_ERRORSTREAM);
                exec.addProcessListener(new ProcessListener(){

                    public void onBufferChanged(Executer exec, DynByteBuffer buffer, int latestNum) {
                        if (buffer.position() >= 50) {
                            System.out.println("loaded enough.... interrupt");
                            exec.interrupt();
                        }
                    }

                    public void onProcess(Executer exec, String latestLine, DynByteBuffer sb) {
                    }
                }, Executer.LISTENER_STDSTREAM);
                exec.start();
                exec.waitTimeout();
                String res = exec.getErrorStream();
                if (new Regex(res, "(CRC failed|Total errors: )").matches() || res.contains("the file header is corrupt")) continue;
                StringBuilder sigger = new StringBuilder();
                DynByteBuffer buff = exec.getInputStreamBuffer();
                buff.flip();
                int i = 0;
                while (i < buff.limit()) {
                    byte f = buff.get();
                    String s = Integer.toHexString(f);
                    s = s.length() < 2 ? "0" + s : s;
                    s = s.substring(s.length() - 2);
                    sigger.append(s);
                    ++i;
                }
                String sig = sigger.toString();
                if (sig.trim().length() < 8 || (signature = FileSignatures.getSignature(sig)) == null || !signature.getExtension().matcher(smallestFile.getFilepath()).matches()) continue;
                this.password = pass;
                this.crackProgress = 100;
                this.fireEvent(18);
                return;
            }
        }
        this.crackProgress = 100;
        this.fireEvent(18);
    }

    public int getCrackProgress() {
        return this.crackProgress;
    }

    void fireEvent(int status2) {
        for (UnrarListener listener : this.listener) {
            listener.onUnrarEvent(status2, this);
        }
    }

    public static boolean isUnrarCommandValid(String path) {
        Executer exec;
        block5: {
            String ret;
            block4: {
                try {
                    exec = new Executer(path);
                    exec.setLogger(JDLogger.getLogger());
                    exec.setWaitTimeout(5);
                    exec.start();
                    exec.waitTimeout();
                    ret = String.valueOf(exec.getErrorStream()) + " " + exec.getOutputStream();
                    if (!new Regex(ret, "RAR.*?Alexander").matches()) break block4;
                    return true;
                }
                catch (Exception e) {
                    JDLogger.exception((Throwable)e);
                    return false;
                }
            }
            if (!new Regex(ret, "RAR.*?3\\.").matches()) break block5;
            return true;
        }
        System.err.println("Wrong unrar: " + Regex.getLines((String)exec.getErrorStream())[0]);
        return false;
    }

    private boolean open() throws UnrarException {
        String res;
        String pass = null;
        int i = 0;
        this.fireEvent(8);
        int c = 0;
        while (true) {
            Executer exec = new Executer(this.unrarCommand);
            exec.setDebug(true);
            if (i > 0) {
                if (this.passwordList.size() < i) {
                    this.fireEvent(14);
                    if (this.password == null) {
                        return false;
                    }
                    pass = this.password;
                    this.password = null;
                } else {
                    pass = this.passwordList.get(i - 1);
                }
            }
            if (c > 0) {
                this.crackProgress = c * 100 / this.passwordList.size();
                this.fireEvent(18);
            }
            ++c;
            ++i;
            exec.addParameter("v");
            exec.addParameter("-p");
            PasswordListener pwl = null;
            pwl = new PasswordListener(pass);
            exec.addProcessListener((ProcessListener)pwl, Executer.LISTENER_ERRORSTREAM);
            exec.addParameter("-v");
            exec.addParameter("-c-");
            exec.addParameter(this.file.getName());
            exec.setRunin(this.file.getParentFile().getAbsolutePath());
            exec.setWaitTimeout(-1);
            exec.setDebug(true);
            exec.start();
            exec.waitTimeout();
            if (exec.getException() != null && exec.getException().getMessage().contains("Cannot run")) {
                this.logger.severe(exec.getException().getMessage());
                this.fireEvent(99);
                return false;
            }
            res = String.valueOf(exec.getOutputStream()) + " \r\n " + exec.getErrorStream();
            this.logger.finest(res);
            String match = new Regex(res, Pattern.compile("Bad archive (.{5,})")).getMatch(0);
            if (match != null) {
                this.statusid = 16;
                String filename = match;
                this.currentVolume = 0;
                match = new Regex(filename, "\\.part(\\d+)\\.").getMatch(0);
                if (match != null) {
                    this.currentVolume = Integer.parseInt(match.trim());
                } else {
                    match = new Regex(filename, "(.*?)\\.rar").getMatch(0);
                    if (match != null) {
                        this.currentVolume = 1;
                    } else {
                        match = new Regex(filename, "\\.r(\\d+)").getMatch(0);
                        if (match != null) {
                            this.currentVolume = Integer.parseInt(match.trim()) + 2;
                        }
                    }
                }
                throw new UnrarException("Bad archive " + filename);
            }
            if (res.contains("Cannot open ") || res.contains("Das System kann die angegebene Datei nicht finden")) {
                throw new UnrarException("File not found " + this.file.getAbsolutePath());
            }
            if (res.contains("is not RAR archive")) {
                String message = new Regex(res, Pattern.compile("(^.*?is not RAR archive)", 8)).getMatch(0);
                throw new UnrarException(message);
            }
            if (res.indexOf(" (password incorrect") == -1 && !res.contains("the file header is corrupt") && !pwl.pwerror()) break;
            this.logger.finest("Password incorrect: " + this.file.getName() + " pw: " + pass);
        }
        if (res.indexOf("Cannot find volume") != -1) {
            String message = new Regex(res, Pattern.compile("(^.*?Cannot find volume.*?$)", 8)).getMatch(0);
            throw new UnrarException(message);
        }
        String[] volumes = Pattern.compile("Volume (.*?)Pathname/Comment", 32).split(res);
        ArchivFile tmp = null;
        String namen = "";
        this.files = new ArrayList();
        this.totalSize = 0L;
        String[] stringArray = volumes;
        int n = volumes.length;
        int n2 = 0;
        while (n2 < n) {
            String volume;
            res = volume = stringArray[n2];
            Pattern patternvolumes = Pattern.compile("(.+)\\s*?([\\d]+).*?[\\d]+\\-[\\d]+\\-[\\d]+.*?[\\d]+:[\\d]+.*?(.{1})(.{1})(.{1})", 2);
            Matcher matchervolumes = patternvolumes.matcher(res);
            String vol = new Regex(res, "       volume (\\d+)").getMatch(0);
            if (vol != null) {
                this.volumeNum = Integer.parseInt(vol.trim());
            }
            while (matchervolumes.find()) {
                long size;
                String name = matchervolumes.group(1);
                if (name.matches("\\*.*")) {
                    name = name.substring(1);
                    size = Long.parseLong(matchervolumes.group(2));
                    this.isProtected = true;
                    if (pass != null && this.password != pass) {
                        this.password = pass;
                        this.fireEvent(10);
                    }
                    if (!name.equals(namen) && !matchervolumes.group(4).equals("D")) {
                        tmp = new ArchivFile(name);
                        tmp.setSize(size);
                        tmp.setPath(this.getExtractTo());
                        tmp.setProtected(true);
                        tmp.addVolume(vol);
                        this.files.add(tmp);
                        namen = name;
                        this.totalSize += size;
                        continue;
                    }
                    if (!name.equals(namen)) continue;
                    tmp.addVolume(vol);
                    continue;
                }
                if (!(name = name.substring(1)).equals(namen) && !matchervolumes.group(4).equals("D")) {
                    tmp = new ArchivFile(name);
                    tmp.setPath(this.getExtractTo());
                    size = Long.parseLong(matchervolumes.group(2));
                    tmp.setSize(size);
                    this.totalSize += size;
                    tmp.setProtected(false);
                    tmp.addVolume(vol);
                    this.files.add(tmp);
                    namen = name;
                    continue;
                }
                if (!name.equals(namen)) continue;
                tmp.addVolume(vol);
            }
            ++n2;
        }
        return true;
    }

    public void setUnrarCommand(String file) {
        this.unrarCommand = file;
    }

    public void setPasswordList(ArrayList<String> passwordList) {
        this.passwordList = passwordList;
    }

    public int getCurrentVolume() {
        return this.currentVolume;
    }

    public long getExtractedSize() {
        long size = 0L;
        for (ArchivFile af : this.files) {
            size = (long)((double)size + (double)af.getSize() * ((double)af.getPercent() / 100.0));
        }
        return size;
    }

    ArchivFile getArchivFile(String currentWorkingFile) {
        for (ArchivFile af : this.files) {
            if (!af.getFilepath().equals(currentWorkingFile)) continue;
            return af;
        }
        ArchivFile best = null;
        int value = Integer.MAX_VALUE;
        for (ArchivFile af : this.files) {
            int cur = EditDistance.getLevenshteinDistance((String)af.getFilepath(), (String)currentWorkingFile);
            if (cur >= value) continue;
            value = cur;
            best = af;
        }
        return best;
    }

    public String getPassword() {
        return this.password;
    }

    public ProgressController getProgressController() {
        return this.progressController;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public ArchivFile getCurrentFile() {
        return this.currentlyWorkingOn;
    }

    public File getFile() {
        return this.file;
    }

    public DownloadLink getDownloadLink() {
        return this.link;
    }

    public void setExtractTo(File dl) {
        this.extractTo = dl;
        if (this.files != null) {
            for (ArchivFile af : this.files) {
                af.setPath(dl);
            }
        }
    }

    public File getExtractTo() {
        return this.extractTo;
    }

    public void setRemoveAfterExtract(boolean setProperty) {
        this.removeAfterExtraction = setProperty;
    }

    public void setOverwrite(boolean booleanProperty) {
        this.overwriteFiles = booleanProperty;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setProgressController(ProgressController progress) {
        this.progressController = progress;
    }

    public void go() throws Exception {
        this.run();
    }

    public class ExtractListener
    implements ProcessListener {
        private int lastLinePosition = 0;

        public void onBufferChanged(Executer exec, DynByteBuffer buffer, int latestReadNum) {
            String lastLine;
            try {
                lastLine = new String(buffer.getLast(buffer.position() - this.lastLinePosition), Executer.CODEPAGE);
            }
            catch (Exception e) {
                JDLogger.exception((Throwable)e);
                lastLine = new String(buffer.getLast(buffer.position() - this.lastLinePosition));
            }
            if (new Regex(lastLine, Pattern.compile("Write error.*?bort ", 2)).matches()) {
                exec.writetoOutputStream("A");
            }
        }

        public void onProcess(Executer exec, String latestLine, DynByteBuffer totalBuffer) {
            this.lastLinePosition = totalBuffer.position();
            String match = null;
            if (latestLine.length() > 0) {
                String filename;
                String currentWorkingFile;
                match = new Regex(latestLine, "Extracting  (.*)").getMatch(0);
                if (match != null) {
                    currentWorkingFile = match.trim();
                    UnrarWrapper.this.currentlyWorkingOn = UnrarWrapper.this.getArchivFile(currentWorkingFile);
                    UnrarWrapper.this.fireEvent(5);
                }
                if ((match = new Regex(latestLine, "Extracting from(.*)").getMatch(0)) != null) {
                    UnrarWrapper.this.archiveParts.add(match.trim());
                }
                if ((match = new Regex(latestLine, "Extracting from.*part(\\d+)\\.").getMatch(0)) != null) {
                    UnrarWrapper.this.currentVolume = Integer.parseInt(match.trim());
                    long ext = UnrarWrapper.this.totalSize / (long)UnrarWrapper.this.volumeNum * (long)(UnrarWrapper.this.currentVolume - 1);
                    if (ext == 0L) {
                        return;
                    }
                    try {
                        UnrarWrapper.this.speed = ext / ((System.currentTimeMillis() - UnrarWrapper.this.startTime) / 1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((match = new Regex(latestLine, "(\\d+)\\%").getMatch(0)) != null) {
                    if (UnrarWrapper.this.currentlyWorkingOn != null) {
                        UnrarWrapper.this.exactProgress = true;
                        UnrarWrapper.this.currentlyWorkingOn.setPercent(Integer.parseInt(match));
                        UnrarWrapper.this.fireEvent(6);
                    }
                    return;
                }
                match = new Regex(latestLine, "^\\s*?(OK)").getMatch(0);
                if (match != null && UnrarWrapper.this.currentlyWorkingOn != null) {
                    UnrarWrapper.this.currentlyWorkingOn.setPercent(100);
                    UnrarWrapper.this.fireEvent(6);
                    UnrarWrapper.this.fireEvent(4);
                }
                if ((match = new Regex(latestLine, "Bad archive (.{5,})").getMatch(0)) != null) {
                    UnrarWrapper.this.statusid = 16;
                    currentWorkingFile = match.trim();
                    UnrarWrapper.this.currentlyWorkingOn = UnrarWrapper.this.getArchivFile(currentWorkingFile);
                    filename = latestLine;
                    match = new Regex(filename, "\\.part(\\d+)\\.").getMatch(0);
                    if (match != null) {
                        UnrarWrapper.this.currentVolume = Integer.parseInt(match.trim());
                    } else {
                        match = new Regex(filename, "(.*?)\\.rar").getMatch(0);
                        if (match != null) {
                            UnrarWrapper.this.currentVolume = 1;
                        } else {
                            match = new Regex(filename, "\\.r(\\d+)").getMatch(0);
                            if (match != null) {
                                UnrarWrapper.this.currentVolume = Integer.parseInt(match.trim()) + 2;
                            }
                        }
                    }
                    exec.interrupt();
                }
                if ((match = new Regex(latestLine, " Total errors:").getMatch(0)) != null) {
                    UnrarWrapper.this.statusid = 12;
                    exec.interrupt();
                }
                if ((match = new Regex(latestLine, "CRC failed in (.*?) \\(").getMatch(0)) != null) {
                    UnrarWrapper.this.statusid = 16;
                    exec.interrupt();
                }
                if ((match = new Regex(latestLine, "packed data CRC failed in volume(.{5,})").getMatch(0)) != null) {
                    UnrarWrapper.this.statusid = 16;
                    currentWorkingFile = new Regex(latestLine, "(.*?): packed").getMatch(0);
                    UnrarWrapper.this.currentlyWorkingOn = UnrarWrapper.this.getArchivFile(currentWorkingFile.trim());
                    UnrarWrapper.this.currentVolume = 0;
                    filename = match;
                    match = new Regex(filename, "\\.part(\\d+)\\.").getMatch(0);
                    if (match != null) {
                        UnrarWrapper.this.currentVolume = Integer.parseInt(match.trim());
                    } else {
                        match = new Regex(filename, "(.*?)\\.rar").getMatch(0);
                        if (match != null) {
                            UnrarWrapper.this.currentVolume = 1;
                        } else {
                            match = new Regex(filename, "\\.r(\\d+)").getMatch(0);
                            if (match != null) {
                                UnrarWrapper.this.currentVolume = Integer.parseInt(match.trim()) + 2;
                            }
                        }
                    }
                    exec.interrupt();
                }
            }
        }
    }
}

