/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.Utilities;
import jd.controlling.JDLogger;

public class BackgroundFilterCreater {
    public static File create(EasyMethodFile methode) {
        return BackgroundFilterCreater.create(methode.getCaptchaFolder().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().matches("(?is).*\\.(jpg|png|gif)");
            }
        }), methode);
    }

    public static File create(File[] files, EasyMethodFile methode) {
        boolean ignoreBlack = false;
        JAntiCaptcha jac = new JAntiCaptcha(methode.getName());
        Image image = Utilities.loadImage(files[0]);
        Captcha firstCaptcha = jac.createCaptcha(image);
        HashMap[][] grid = new HashMap[firstCaptcha.getWidth()][firstCaptcha.getHeight()];
        int x = 0;
        while (x < grid.length) {
            int y = 0;
            while (y < grid[0].length) {
                grid[x][y] = new HashMap();
                grid[x][y].put(firstCaptcha.getPixelValue(x, y), 0);
                ++y;
            }
            ++x;
        }
        int i = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            image = Utilities.loadImage(file);
            Captcha captcha = jac.createCaptcha(image);
            if (captcha == null || captcha.getWidth() != firstCaptcha.getWidth() || captcha.getHeight() != firstCaptcha.getHeight()) {
                if (Utilities.isLoggerActive()) {
                    JDLogger.getLogger().info("ERROR Maske und Bild passen nicht zusammmen");
                }
            } else {
                if (i++ == 100) break;
                int x2 = 0;
                while (x2 < captcha.getWidth()) {
                    int y = 0;
                    while (y < captcha.getHeight()) {
                        HashMap map = grid[x2][y];
                        int val = captcha.getPixelValue(x2, y);
                        if (!ignoreBlack || val != 0) {
                            if (map.containsKey(val)) {
                                map.put(val, (Integer)map.get(val) + 1);
                            } else {
                                map.put(val, 0);
                            }
                        }
                        ++y;
                    }
                    ++x2;
                }
            }
            ++n2;
        }
        int x3 = 0;
        while (x3 < firstCaptcha.getWidth()) {
            int y = 0;
            while (y < firstCaptcha.getHeight()) {
                Set map = grid[x3][y].entrySet();
                Map.Entry<Integer, Integer> best = new Map.Entry<Integer, Integer>(){

                    @Override
                    public Integer getKey() {
                        return -1;
                    }

                    @Override
                    public Integer getValue() {
                        return -1;
                    }

                    @Override
                    public Integer setValue(Integer value) {
                        return -1;
                    }
                };
                for (Map.Entry entry : map) {
                    if ((Integer)entry.getValue() <= (Integer)best.getValue()) continue;
                    best = entry;
                }
                firstCaptcha.setPixelValue(x3, y, (Integer)best.getKey());
                ++y;
            }
            ++x3;
        }
        File ret = new File(methode.file, "mask_" + System.currentTimeMillis() + ".png");
        try {
            ImageIO.write((RenderedImage)firstCaptcha.getImage(), "png", ret);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

