/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy.load;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.easy.load.LoadImage;
import jd.captcha.easy.load.LoadInfo;
import jd.gui.swing.GuiRunnable;
import jd.gui.swing.components.JDTextField;
import jd.gui.swing.dialog.ProgressDialog;
import jd.http.Browser;
import jd.nutils.JDImage;
import jd.nutils.Screen;
import jd.parser.html.Form;
import jd.parser.html.HTMLParser;
import jd.utils.JDUtilities;
import jd.utils.locale.JDL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCaptchas {
    private static final long serialVersionUID = 1L;
    public String host;
    public boolean opendir = false;
    private LoadInfo loadinfo;
    private Browser br = new Browser();
    private ArrayList<LoadImage> images;
    private LoadImage selectedImage;
    private JFrame owner;
    public int maxHeight;
    public boolean threaded;
    public int maxWeight;
    private String dir;

    public LoadCaptchas(JFrame owner) {
        this(owner, null);
    }

    public LoadCaptchas(JFrame owner, String host) {
        this(owner, host, false);
    }

    public LoadCaptchas(JFrame owner, String host, boolean opendir) {
        this.br.setFollowRedirects(true);
        this.maxHeight = 500;
        this.threaded = false;
        this.maxWeight = 600;
        this.dir = null;
        this.host = host;
        this.opendir = opendir;
        this.owner = owner;
    }

    public boolean start() {
        JDialog dialog;
        block22: {
            block21: {
                this.selectedImage = LoadImage.loadFile(this.host);
                this.loadinfo = this.getLoadInfo(this.selectedImage);
                if (this.loadinfo != null) break block21;
                return false;
            }
            dialog = (JDialog)new GuiRunnable<JDialog>(){

                public JDialog runSave() {
                    return new JDialog(LoadCaptchas.this.owner);
                }
            }.getReturnValue();
            dialog.setModal(true);
            dialog.setAlwaysOnTop(true);
            this.br.getPage(this.loadinfo.link);
            if (this.host == null) {
                this.host = this.br.getHost().toLowerCase();
                if (this.host.matches(".*\\..*\\..*")) {
                    this.host = this.host.substring(this.host.indexOf(46) + 1);
                }
            }
            if (this.dir == null) {
                this.dir = String.valueOf(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath()) + "/captchas/" + this.host + "/";
            }
            new File(this.dir).mkdir();
            if (!this.loadDirect()) break block22;
            if (this.opendir) {
                LoadCaptchas.openDir(this.dir);
            }
            new EasyMethodFile(this.host).copyExampleImage();
            return true;
        }
        try {
            if (this.selectedImage != null) {
                this.selectedImage.load(this.host);
            } else {
                dialog.setTitle(JDL.L((String)"easycaptcha.loadcaptchas.clickoncaptcha", (String)"click on the captcha"));
                this.images = this.getAllImages(this.br);
                this.loadImages();
                dialog.addWindowListener(new WindowListener(){

                    public void windowActivated(WindowEvent e) {
                    }

                    public void windowClosed(WindowEvent e) {
                    }

                    public void windowClosing(WindowEvent e) {
                        for (LoadImage loadImage : LoadCaptchas.this.images) {
                            loadImage.file.delete();
                        }
                        dialog.dispose();
                    }

                    public void windowDeactivated(WindowEvent e) {
                    }

                    public void windowDeiconified(WindowEvent e) {
                    }

                    public void windowIconified(WindowEvent e) {
                    }

                    public void windowOpened(WindowEvent e) {
                    }
                });
                final ArrayList<JButton> bts = new ArrayList<JButton>();
                System.out.println(this.images.size());
                int j = 0;
                while (j < this.images.size()) {
                    final LoadImage f = this.images.get(j);
                    if (f != null && f.file != null && f.file.exists() && f.file.length() >= 100L) {
                        final BufferedImage captchaImage = JDImage.getImage((File)f.file);
                        if (captchaImage == null) {
                            f.file.delete();
                        } else {
                            int area = captchaImage.getHeight(null) * captchaImage.getHeight(null);
                            if (area < 50 || captchaImage.getHeight(null) > this.maxHeight || captchaImage.getWidth(null) > this.maxWeight || captchaImage.getWidth(null) < 10 || captchaImage.getHeight(null) < 5) {
                                f.file.delete();
                            } else {
                                double faktor = Math.max((double)captchaImage.getWidth(null) / 100.0, (double)captchaImage.getHeight(null) / 100.0);
                                final int width = (int)((double)captchaImage.getWidth(null) / faktor);
                                final int height = (int)((double)captchaImage.getHeight(null) / faktor);
                                try {
                                    JButton ic = (JButton)new GuiRunnable<JButton>(){

                                        public JButton runSave() {
                                            return new JButton(new ImageIcon(captchaImage.getScaledInstance(width, height, 4)));
                                        }
                                    }.getReturnValue();
                                    ic.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent e) {
                                            LoadCaptchas.this.selectedImage = f;
                                            dialog.dispose();
                                        }
                                    });
                                    bts.add(ic);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    ++j;
                }
                final JPanel panel = (JPanel)new GuiRunnable<JPanel>(){

                    public JPanel runSave() {
                        return new JPanel(new GridLayout((int)Math.ceil((double)bts.size() / 5.0), 5));
                    }
                }.getReturnValue();
                for (JButton button : bts) {
                    panel.add(button);
                }
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        dialog.add(new JScrollPane(panel));
                        dialog.pack();
                        dialog.setLocation(Screen.getCenterOfComponent((Component)LoadCaptchas.this.owner, (Component)dialog));
                        dialog.setAlwaysOnTop(true);
                        dialog.setVisible(true);
                        return null;
                    }
                }.waitForEDT();
            }
            if (this.selectedImage != null && this.selectedImage.file != null) {
                this.loadProcess();
                if (this.opendir) {
                    LoadCaptchas.openDir(this.dir);
                }
                new EasyMethodFile(this.host).copyExampleImage();
                return this.dir.length() > 0;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static Form[] getForms(Browser browser) {
        Form[] forms;
        ArrayList<Form> retForms = new ArrayList<Form>();
        Form[] formArray = forms = browser.getForms();
        int n = forms.length;
        int n2 = 0;
        while (n2 < n) {
            Form form = formArray[n2];
            ArrayList fi = form.getInputFieldsByType("submit");
            if (fi.size() > 1) {
                int i = 1;
                while (i < fi.size()) {
                    Form fo = new Form(form.getHtmlCode());
                    fo.getInputFields().remove(fo.getInputFieldsByType("submit").get(i));
                    if (!retForms.contains(fo)) {
                        retForms.add(fo);
                    }
                    ++i;
                }
                form.getInputFields().remove(fi.get(0));
            }
            if (!retForms.contains(form)) {
                retForms.add(form);
            }
            ++n2;
        }
        return retForms.toArray(new Form[0]);
    }

    static String[] getImages(Browser br) throws Exception {
        Pattern[] basePattern;
        ArrayList<String> ret = new ArrayList<String>();
        Pattern[] patternArray = basePattern = new Pattern[]{Pattern.compile("(?is)<[ ]?input[^>]*?src=['|\"]?([^>\\s'\"]*)['|\">\\s][^>]*?type=.?image[^>]*?", 2), Pattern.compile("(?is)<[ ]?input[^>]*?type=.?image[^>]*?src=['|\"]?([^>\\s'\"]*)['|\">\\s]", 2), Pattern.compile("(?is)<[ ]?IMG[^>]*?src=['|\"]?([^>\\s'\"]*)['|\">\\s]", 2)};
        int n = basePattern.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern element = patternArray[n2];
            Matcher m = element.matcher(br.toString());
            while (m.find()) {
                try {
                    String src = m.group(1);
                    if (!src.startsWith("http")) {
                        src = src.charAt(0) == '/' ? "http://" + br.getHost() + src : (src.charAt(0) == '#' ? "http://" + br.getURL() + src : String.valueOf(br.getBaseURL()) + src);
                    }
                    if (ret.contains(src)) continue;
                    ret.add(src);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return ret.toArray(new String[0]);
    }

    private static void openDir(final String dir) {
        new GuiRunnable<Object>(){

            public Object runSave() {
                if (JOptionPane.showConfirmDialog(null, "Captcha Ordner:" + dir + " jetzt \u00f6ffnen?") == 0) {
                    JDUtilities.openExplorer((File)new File(dir));
                }
                return null;
            }
        }.waitForEDT();
    }

    private LoadInfo getLoadInfo(final LoadImage loadImage) {
        final JDialog dialog = (JDialog)new GuiRunnable<JDialog>(){

            public JDialog runSave() {
                return new JDialog(LoadCaptchas.this.owner);
            }
        }.getReturnValue();
        dialog.setModal(true);
        dialog.setAlwaysOnTop(true);
        final JPanel p = (JPanel)new GuiRunnable<JPanel>(){

            public JPanel runSave() {
                JPanel ret = new JPanel(new GridLayout(6, 2));
                ret.add(new JLabel(String.valueOf(JDL.L((String)"easycaptcha.loadcaptchas.link", (String)"Link")) + ":"));
                return ret;
            }
        }.getReturnValue();
        final JDTextField tfl = (JDTextField)new GuiRunnable<JDTextField>(){

            public JDTextField runSave() {
                return new JDTextField();
            }
        }.getReturnValue();
        tfl.setBorder(BorderFactory.createEtchedBorder());
        p.add((Component)tfl);
        JSpinner sm = (JSpinner)new GuiRunnable<JSpinner>(){

            public JSpinner runSave() {
                p.add(new JLabel(String.valueOf(JDL.L((String)"easycaptcha.loadcaptchas.howmuch", (String)"How much captchas you need")) + ":"));
                if (loadImage != null) {
                    tfl.setText(loadImage.baseUrl);
                }
                return new JSpinner(new SpinnerNumberModel(100, 1, 4000, 1));
            }
        }.getReturnValue();
        p.add(sm);
        JCheckBox followLinks = (JCheckBox)new GuiRunnable<JCheckBox>(){

            public JCheckBox runSave() {
                p.add(new JLabel(String.valueOf(JDL.L((String)"easycaptcha.loadcaptchas.followlinks", (String)"follow normal Links (very slow)")) + ":"));
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(false);
                p.add(checkBox);
                return checkBox;
            }
        }.getReturnValue();
        JCheckBox threadedCheck = (JCheckBox)new GuiRunnable<JCheckBox>(){

            public JCheckBox runSave() {
                p.add(new JLabel(String.valueOf(JDL.L((String)"easycaptcha.loadcaptchas.threaded", (String)"threaded image Download (very fast)")) + ":"));
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(false);
                p.add(checkBox);
                return checkBox;
            }
        }.getReturnValue();
        JCheckBox loadDirect = (JCheckBox)new GuiRunnable<JCheckBox>(){

            public JCheckBox runSave() {
                p.add(new JLabel(String.valueOf(JDL.L((String)"easycaptcha.loadcaptchas.loaddirect", (String)"Load direct if possible (much faster)")) + ":"));
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(true);
                p.add(checkBox);
                return checkBox;
            }
        }.getReturnValue();
        JButton ok = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"gui.btn_ok", (String)"OK"));
            }
        }.getReturnValue();
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        p.add(ok);
        WindowListener l = new WindowListener(){

            public void windowActivated(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                tfl.setText("");
                dialog.dispose();
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }
        };
        JButton cancel = (JButton)new GuiRunnable<JButton>(){

            public JButton runSave() {
                return new JButton(JDL.L((String)"gui.btn_cancel", (String)"Cancel"));
            }
        }.getReturnValue();
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tfl.setText("");
                dialog.dispose();
            }
        });
        p.add(cancel);
        dialog.addWindowListener(l);
        dialog.add(p);
        new GuiRunnable<Object>(){

            public Object runSave() {
                dialog.setLocation(Screen.getCenterOfComponent((Component)LoadCaptchas.this.owner, (Component)dialog));
                dialog.pack();
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                return null;
            }
        }.waitForEDT();
        String link = tfl.getText();
        if (link == null || link.matches("\\s*")) {
            return null;
        }
        int menge = (Integer)sm.getValue();
        dialog.dispose();
        LoadInfo retLI = new LoadInfo(link, menge);
        retLI.followLinks = followLinks.isSelected();
        this.threaded = threadedCheck.isSelected();
        retLI.directLoad = loadDirect.isSelected();
        return retLI;
    }

    private static String getImageExtentionFromHeader(Browser br) {
        String ret = null;
        String contentType = br.getHttpConnection().getContentType();
        if (contentType != null && contentType.toLowerCase().contains("image")) {
            ret = contentType.toLowerCase().equals("image/jpeg") ? ".jpg" : contentType.toLowerCase().replaceFirst("image/", ".");
        }
        return ret;
    }

    private boolean loadDirect() {
        final String imageType = LoadCaptchas.getImageExtentionFromHeader(this.br);
        if (imageType != null) {
            final ProgressDialog pd = (ProgressDialog)new GuiRunnable<ProgressDialog>(){

                public ProgressDialog runSave() {
                    return new ProgressDialog(LoadCaptchas.this.owner, JDL.L((String)"easycaptcha.loadcaptchas.loadimages", (String)"load images please wait"), null, false, true);
                }
            }.getReturnValue();
            pd.setAlwaysOnTop(true);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!LoadCaptchas.this.threaded) {
                        int k = 0;
                        while (k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge) {
                            try {
                                File f2 = new File(String.valueOf(LoadCaptchas.this.dir) + System.currentTimeMillis() + imageType);
                                LoadCaptchas.this.br.getDownload(f2, ((LoadCaptchas)LoadCaptchas.this).loadinfo.link);
                                final int c = k;
                                new GuiRunnable<Object>(){

                                    public Object runSave() {
                                        pd.setValue(c);
                                        return null;
                                    }
                                }.waitForEDT();
                            }
                            catch (Exception ev) {
                                ev.printStackTrace();
                            }
                            ++k;
                        }
                    } else {
                        Thread[] ths = new Thread[((LoadCaptchas)LoadCaptchas.this).loadinfo.menge];
                        int k = 0;
                        while (k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge) {
                            ths[k] = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        File f2 = new File(String.valueOf(LoadCaptchas.this.dir) + System.currentTimeMillis() + imageType);
                                        LoadCaptchas.this.br.getDownload(f2, ((LoadCaptchas)(this).LoadCaptchas.this).loadinfo.link);
                                    }
                                    catch (Exception ev) {
                                        ev.printStackTrace();
                                    }
                                    2 var1_1 = this;
                                    synchronized (var1_1) {
                                        this.notify();
                                    }
                                }
                            });
                            ths[k].start();
                            ++k;
                        }
                        k = 0;
                        Thread[] threadArray = ths;
                        int n = ths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Thread thread = threadArray[n2];
                            while (thread.isAlive()) {
                                Thread thread2 = thread;
                                synchronized (thread2) {
                                    try {
                                        thread.wait(30000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            final int c = k++;
                            new GuiRunnable<Object>(){

                                public Object runSave() {
                                    pd.setValue(c);
                                    return null;
                                }
                            }.waitForEDT();
                            ++n2;
                        }
                    }
                    pd.dispose();
                }
            };
            final Thread th = new Thread(runnable);
            th.start();
            new GuiRunnable<Object>(){

                public Object runSave() {
                    pd.setThread(th);
                    pd.setVisible(true);
                    return null;
                }
            }.waitForEDT();
            return true;
        }
        return false;
    }

    private ArrayList<LoadImage> getAllImages(Browser br) {
        LoadImage li;
        Browser brc;
        String[] imagea;
        ArrayList<LoadImage> images = new ArrayList<LoadImage>();
        try {
            imagea = LoadCaptchas.getImages(br);
            int i = 0;
            while (i < imagea.length) {
                LoadImage li2 = new LoadImage(this.loadinfo, imagea[i], br);
                li2.form = -1;
                li2.location = i++;
                images.add(li2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.loadinfo.followLinks) {
            String[] links = HTMLParser.getHttpLinks((String)br.toString(), (String)br.getURL());
            int b = 0;
            while (b < links.length) {
                String string = links[b];
                try {
                    brc = br.cloneBrowser();
                    brc.getPage(string);
                    imagea = LoadCaptchas.getImages(brc);
                    int i = 0;
                    while (i < imagea.length) {
                        li = new LoadImage(this.loadinfo, imagea[i], brc);
                        li.form = -1;
                        li.location = i++;
                        li.followUrl = b;
                        images.add(li);
                    }
                }
                catch (Exception brc2) {
                    // empty catch block
                }
                ++b;
            }
        }
        Form[] forms = LoadCaptchas.getForms(br);
        int i = 0;
        while (i < forms.length) {
            try {
                Form form = forms[i];
                brc = br.cloneBrowser();
                brc.submitForm(form);
                imagea = LoadCaptchas.getImages(brc);
                int b = 0;
                while (b < imagea.length) {
                    li = new LoadImage(this.loadinfo, imagea[b], brc);
                    li.form = i;
                    li.location = b;
                    if (!images.contains(li)) {
                        images.add(li);
                    }
                    ++b;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return images;
    }

    private void loadImages() {
        final ProgressDialog pd = (ProgressDialog)new GuiRunnable<ProgressDialog>(){

            public ProgressDialog runSave() {
                return new ProgressDialog(LoadCaptchas.this.owner, JDL.L((String)"easycaptcha.loadcaptchas.loadimages", (String)"load images please wait"), null, false, true);
            }
        }.getReturnValue();
        pd.setAlwaysOnTop(true);
        final Thread th = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final Thread[] jb = new Thread[LoadCaptchas.this.images.size()];
                int j = 0;
                while (j < LoadCaptchas.this.images.size()) {
                    final int i = j++;
                    jb[i] = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            LoadImage image = (LoadImage)LoadCaptchas.this.images.get(i);
                            image.directCaptchaLoad(LoadCaptchas.this.dir);
                            Thread thread = jb[i];
                            synchronized (thread) {
                                jb[i].notify();
                            }
                        }
                    });
                    jb[i].start();
                }
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        pd.setMaximum(LoadCaptchas.this.images.size());
                        return null;
                    }
                }.waitForEDT();
                int c = 0;
                Thread[] threadArray = jb;
                int n = jb.length;
                int n2 = 0;
                while (n2 < n) {
                    Thread thread = threadArray[n2];
                    while (thread.isAlive()) {
                        Thread thread2 = thread;
                        synchronized (thread2) {
                            try {
                                thread.wait(3000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    final int d = c++;
                    new GuiRunnable<Object>(){

                        public Object runSave() {
                            pd.setValue(d);
                            return null;
                        }
                    }.waitForEDT();
                    ++n2;
                }
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        pd.dispose();
                        return null;
                    }
                }.waitForEDT();
            }
        });
        th.start();
        new GuiRunnable<Object>(){

            public Object runSave() {
                pd.setThread(th);
                pd.setVisible(true);
                return null;
            }
        }.waitForEDT();
    }

    private void loadProcess() {
        final ProgressDialog pd = (ProgressDialog)new GuiRunnable<ProgressDialog>(){

            public ProgressDialog runSave() {
                return new ProgressDialog(LoadCaptchas.this.owner, JDL.L((String)"easycaptcha.loadcaptchas.loadimages", (String)"load images please wait"), null, false, true);
            }
        }.getReturnValue();
        pd.setAlwaysOnTop(true);
        final Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block25: {
                    try {
                        Thread[] ths;
                        if (LoadCaptchas.this.images != null) {
                            for (LoadImage loadImage : LoadCaptchas.this.images) {
                                if (loadImage.file.equals(((LoadCaptchas)LoadCaptchas.this).selectedImage.file)) continue;
                                loadImage.file.delete();
                            }
                        }
                        boolean direct = LoadCaptchas.this.selectedImage.directCaptchaLoad(LoadCaptchas.this.dir);
                        LoadImage.save(LoadCaptchas.this.selectedImage, LoadCaptchas.this.host);
                        new GuiRunnable<Object>(){

                            public Object runSave() {
                                pd.setValue(1);
                                return null;
                            }
                        }.waitForEDT();
                        if (direct && ((LoadCaptchas)LoadCaptchas.this).loadinfo.directLoad) {
                            if (!LoadCaptchas.this.threaded) {
                                int k = 1;
                                while (k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1) {
                                    LoadCaptchas.this.selectedImage.directCaptchaLoad(LoadCaptchas.this.dir);
                                    final int d = k++;
                                    new GuiRunnable<Object>(){

                                        public Object runSave() {
                                            pd.setValue(d);
                                            return null;
                                        }
                                    }.waitForEDT();
                                }
                                break block25;
                            }
                            ths = new Thread[((LoadCaptchas)LoadCaptchas.this).loadinfo.menge];
                            int k = 1;
                            while (k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1) {
                                ths[k] = new Thread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        try {
                                            LoadCaptchas.this.selectedImage.directCaptchaLoad(LoadCaptchas.this.dir);
                                        }
                                        catch (Exception ev) {
                                            ev.printStackTrace();
                                        }
                                        3 var1_2 = this;
                                        synchronized (var1_2) {
                                            this.notify();
                                        }
                                    }
                                });
                                ths[k].start();
                                ++k;
                            }
                            k = 0;
                            Thread[] threadArray = ths;
                            int n = ths.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Thread thread = threadArray[n2];
                                while (thread != null && thread.isAlive()) {
                                    Thread thread2 = thread;
                                    synchronized (thread2) {
                                        try {
                                            thread.wait(30000L);
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                final int c = k++;
                                new GuiRunnable<Object>(){

                                    public Object runSave() {
                                        pd.setValue(c);
                                        return null;
                                    }
                                }.waitForEDT();
                                ++n2;
                            }
                            break block25;
                        }
                        ((LoadCaptchas)LoadCaptchas.this).selectedImage.file.delete();
                        if (!LoadCaptchas.this.threaded) {
                            int k = 1;
                            while (k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1) {
                                LoadCaptchas.this.selectedImage.load(LoadCaptchas.this.host);
                                final int d = k++;
                                new GuiRunnable<Object>(){

                                    public Object runSave() {
                                        pd.setValue(d);
                                        return null;
                                    }
                                }.waitForEDT();
                            }
                            break block25;
                        }
                        ths = new Thread[((LoadCaptchas)LoadCaptchas.this).loadinfo.menge];
                        int k = 1;
                        while (k < ((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1) {
                            ths[k] = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        LoadCaptchas.this.selectedImage.load((this).LoadCaptchas.this.host);
                                    }
                                    catch (Exception ev) {
                                        ev.printStackTrace();
                                    }
                                    6 var1_2 = this;
                                    synchronized (var1_2) {
                                        this.notify();
                                    }
                                }
                            });
                            ths[k].start();
                            ++k;
                        }
                        k = 0;
                        Thread[] threadArray = ths;
                        int n = ths.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Thread thread = threadArray[n3];
                            while (thread != null && thread.isAlive()) {
                                Thread c = thread;
                                synchronized (c) {
                                    try {
                                        thread.wait(30000L);
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            final int c = k++;
                            new GuiRunnable<Object>(){

                                public Object runSave() {
                                    pd.setValue(c);
                                    return null;
                                }
                            }.waitForEDT();
                            ++n3;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                new GuiRunnable<Object>(){

                    public Object runSave() {
                        pd.dispose();
                        return null;
                    }
                }.waitForEDT();
            }
        };
        new GuiRunnable<Object>(){

            public Object runSave() {
                Thread th2 = new Thread(runnable);
                th2.start();
                pd.setMaximum(((LoadCaptchas)LoadCaptchas.this).loadinfo.menge - 1);
                pd.setThread(th2);
                pd.setVisible(true);
                return null;
            }
        }.waitForEDT();
    }
}

