/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColoredPixelGrid
extends PixelGrid {
    private static final long serialVersionUID = 1L;

    public ColoredPixelGrid(int width, int height) {
        super(width, height);
    }

    @Override
    public Vector<PixelObject> getColorObjects(int letterNum) {
        this.logger.info("Max pixel value: " + this.getMaxPixelValue());
        HashMap<Integer[], PixelObject> map = new HashMap<Integer[], PixelObject>();
        int[] nArray = new int[3];
        nArray[2] = 204;
        int[] nArray2 = new int[3];
        nArray2[2] = 184;
        this.logger.info("" + Colors.getColorDifference((int[])nArray, (int[])nArray2));
        int[] nArray3 = new int[3];
        nArray3[2] = 204;
        this.logger.info("" + Colors.getColorDifference((int[])nArray3, (int[])new int[]{60, 10, 240}));
        this.logger.info("" + Colors.getColorDifference((int[])new int[]{255, 255, 255}, (int[])new int[3]));
        int avg = this.getAverage();
        int intensivity = 9;
        int h = this.getWidth() / letterNum / 4;
        Integer[] last = null;
        int d = 0;
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                Integer key = this.getPixelValue(x, y);
                int[] rgbA = Colors.hexToRgb((int)key);
                if (this.isElement(key, avg) || Colors.rgb2hsb((int)rgbA[0], (int)rgbA[1], (int)rgbA[2])[0] * 100.0f > 0.0f) {
                    if (map.get(key) == null) {
                        if (d++ < this.getHeight() * 2) {
                            d = 0;
                            int[] bv = Colors.hexToRgb((int)key);
                            boolean found = false;
                            if (last != null && Colors.getHueColorDifference((int[])bv, (int[])Colors.hexToRgb((int)((PixelObject)map.get(last)).getAverage())) < (double)intensivity) {
                                ((PixelObject)map.get(last)).add(x, y, key);
                                found = true;
                            } else {
                                Iterator iterator = map.keySet().iterator();
                                Iterator valsiter = map.values().iterator();
                                Integer[] bestKey = new Integer[]{-1, -1};
                                double bestValue = 255.0;
                                double dif = 255.0;
                                while (iterator.hasNext() && valsiter.hasNext()) {
                                    Integer[] key2 = (Integer[])iterator.next();
                                    PixelObject object = (PixelObject)valsiter.next();
                                    if (!(Math.abs((double)(x - key2[1] - object.getWidth())) < (double)h) || !((dif = Colors.getHueColorDifference((int[])bv, (int[])Colors.hexToRgb((int)object.getAverage()))) < bestValue)) continue;
                                    bestKey = key2;
                                    bestValue = dif;
                                }
                                if (bestValue < (double)intensivity) {
                                    ((PixelObject)map.get(bestKey)).add(x, y, key);
                                    found = true;
                                }
                            }
                            if (!found) {
                                PixelObject object = new PixelObject(this);
                                object.add(x, y, key);
                                last = new Integer[]{key, x};
                                map.put(last, object);
                            }
                        } else {
                            PixelObject object = new PixelObject(this);
                            object.add(x, y, key);
                            last = new Integer[]{key, x};
                            map.put(last, object);
                            d = 0;
                        }
                    } else {
                        ((PixelObject)map.get(key)).add(x, y, key);
                    }
                } else {
                    ++d;
                }
                ++y;
            }
            ++x;
        }
        ArrayList<Object[]> els = new ArrayList<Object[]>();
        Iterator vals = map.values().iterator();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext() && vals.hasNext()) {
            PixelObject ob = (PixelObject)vals.next();
            els.add(new Object[]{keys.next(), ob});
        }
        Collections.sort(els, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                Letter letter1 = ((PixelObject)o1[1]).toLetter();
                Letter letter2 = ((PixelObject)o2[1]).toLetter();
                if (letter1.getElementPixel() > letter2.getElementPixel()) {
                    return 1;
                }
                return 0;
            }
        });
        int c = map.size();
        if (c > letterNum) {
            Iterator iter = els.iterator();
            double addd = intensivity / 2;
            while (c > letterNum) {
                if (!iter.hasNext()) {
                    iter = els.iterator();
                    addd += 1.0;
                }
                Object[] thisel = (Object[])iter.next();
                Integer[] integers = (Integer[])thisel[0];
                PixelObject object = (PixelObject)thisel[1];
                Iterator iterator = els.iterator();
                Integer[] bestKey = null;
                PixelObject bestobj = null;
                double bestValue = Double.MAX_VALUE;
                double dif = Double.MAX_VALUE;
                double dif2 = Double.MAX_VALUE;
                while (iterator.hasNext()) {
                    Object[] it = (Object[])iterator.next();
                    PixelObject obj = (PixelObject)it[1];
                    Integer[] key2 = (Integer[])it[0];
                    if (key2 == integers) continue;
                    dif = key2[1] - integers[1];
                    dif2 = Math.abs((double)(key2[1] + obj.getWidth() - (integers[1] + object.getWidth())));
                    if (dif == 0.0 || dif2 == 0.0 || dif < 0.0 && dif + (double)obj.getWidth() > 0.0) {
                        ((PixelObject)map.get(key2)).add(object);
                        map.remove(integers);
                        iter.remove();
                        --c;
                        bestKey = null;
                        break;
                    }
                    if (Math.abs(dif) < bestValue) {
                        bestKey = key2;
                        bestobj = obj;
                        bestValue = Math.abs(dif);
                    }
                    if (!(dif2 < bestValue)) continue;
                    bestKey = key2;
                    bestobj = obj;
                    bestValue = dif2;
                }
                if (bestKey == null || !((dif = Colors.getHueColorDifference((int[])Colors.hexToRgb((int)bestobj.getAverage()), (int[])Colors.hexToRgb((int)object.getAverage()))) < addd)) continue;
                ((PixelObject)map.get(bestKey)).add(object);
                map.remove(integers);
                iter.remove();
                --c;
            }
        }
        ArrayList ar = new ArrayList();
        ar.addAll(map.keySet());
        Collections.sort(ar, new Comparator<Integer[]>(){

            @Override
            public int compare(Integer[] o1, Integer[] o2) {
                return o1[1].compareTo(o2[1]);
            }
        });
        Iterator iterator2 = ar.iterator();
        Vector<PixelObject> ret = new Vector<PixelObject>();
        while (iterator2.hasNext()) {
            PixelObject it = (PixelObject)map.get(iterator2.next());
            ret.add(it);
        }
        return ret;
    }
}

