/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dlm {
    private static void clearAt(Captcha captcha, int x, int y) {
        if (captcha.getHeight() >= y && captcha.getWidth() >= x && x > 0 && y > 0 && captcha.getPixelValue(x, y) != 0xFFFFFF) {
            captcha.grid[x][y] = 0xFFFFFF;
            Dlm.clearAt(captcha, x + 1, y + 1);
            Dlm.clearAt(captcha, x, y + 1);
            Dlm.clearAt(captcha, x + 1, y);
            Dlm.clearAt(captcha, x - 1, y - 1);
            Dlm.clearAt(captcha, x - 1, y);
            Dlm.clearAt(captcha, x, y - 1);
            Dlm.clearAt(captcha, x + 1, y - 1);
            Dlm.clearAt(captcha, x - 1, y + 1);
        }
    }

    private static boolean checkAt(Captcha captcha, int x, int y) {
        int yMin;
        int yMax = Math.min(captcha.getHeight(), y + 7);
        int i = yMin = Math.max(0, y - 7);
        while (i < yMax) {
            if (captcha.getPixelValue(x, i) == 0xFFFFFF) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void clear(Captcha captcha) {
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                if (captcha.getPixelValue(x, y) != 0xFFFFFF && !Dlm.checkAt(captcha, x, y)) {
                    Dlm.clearAt(captcha, x, y);
                }
                ++y;
            }
            ++x;
        }
    }

    private static int[] getHeader(Captcha captcha, int xMin, int xMax) {
        int y = 0;
        while (y < captcha.getHeight() / 8) {
            int x = xMin;
            while (x < xMax) {
                if (captcha.getPixelValue(x, y) != 0xFFFFFF) {
                    return new int[]{x, y};
                }
                ++x;
            }
            ++y;
        }
        return null;
    }

    private static Letter createLetter(Captcha captcha, int[] header1) {
        captcha.crop(Math.max(0, header1[0] - 15), header1[1], Math.max(0, captcha.getWidth() - header1[0] - 15), Math.max(0, captcha.getHeight() - header1[1] - 25));
        Letter l = captcha.createLetter();
        captcha.toBlackAndWhite();
        l.setLocation(header1);
        l.setGrid(captcha.getGrid());
        captcha.reset();
        return l;
    }

    public static Letter[] getLetters(Captcha captcha) throws Exception {
        LetterComperator rc1;
        LetterComperator r;
        captcha.crop(206, 150, 233, 0);
        Vector<PixelObject> obj = captcha.getObjects(0.7, 0.7);
        Letter let = obj.get(0).toLetter();
        let.invert();
        let = let.toPixelObject(0.7).toLetter();
        let.detected = r = captcha.owner.getLetter(let);
        let.setDecodedValue(r.getDecodedValue());
        captcha.reset();
        int xMax = captcha.getWidth() / 3;
        Letter head1 = Dlm.createLetter(captcha, Dlm.getHeader(captcha, 0, xMax));
        Letter head2 = Dlm.createLetter(captcha, Dlm.getHeader(captcha, xMax, xMax * 2));
        Letter head3 = Dlm.createLetter(captcha, Dlm.getHeader(captcha, xMax * 2, xMax * 3));
        int pos = 0;
        String hoster = "3dl.amHeads";
        JAntiCaptcha jac = new JAntiCaptcha(hoster);
        head1.detected = rc1 = jac.getLetter(head1);
        head1.setDecodedValue(rc1.getDecodedValue());
        if (head1.getDecodedValue().equals(let.getDecodedValue())) {
            pos = 0;
        } else {
            LetterComperator rc2;
            head2.detected = rc2 = jac.getLetter(head2);
            head2.setDecodedValue(rc2.getDecodedValue());
            if (head2.getDecodedValue().equals(let.getDecodedValue())) {
                pos = 1;
            } else {
                LetterComperator rc3;
                head3.detected = rc3 = jac.getLetter(head3);
                head3.setDecodedValue(rc3.getDecodedValue());
                pos = head3.getDecodedValue().equals(let.getDecodedValue()) ? 2 : (head1.detected.getValityPercent() > head2.detected.getValityPercent() ? (head1.detected.getValityPercent() > head3.detected.getValityPercent() ? 0 : 2) : (head2.detected.getValityPercent() > head3.detected.getValityPercent() ? 1 : 2));
            }
        }
        captcha.crop(0, 0, 0, 20);
        Dlm.clear(captcha);
        captcha.toBlackAndWhite(0.8);
        obj = Dlm.getObjects(captcha, 3);
        Collections.sort(obj);
        if (obj.size() > 3) {
            Iterator<PixelObject> iterator = obj.iterator();
            while (iterator.hasNext()) {
                PixelObject pixelObject = iterator.next();
                if (pixelObject.getArea() >= 80) continue;
                iterator.remove();
            }
        }
        captcha.owner.getJas().set("minimumObjectArea", 1);
        captcha.owner.getJas().set("minimumLetterWidth", 1);
        captcha.grid = obj.get((int)pos).toLetter().grid;
        obj = captcha.getObjects(0.7, 0.7);
        int merge = 0;
        for (PixelObject pixelObject : obj) {
            if (pixelObject.getArea() >= 4) continue;
            ++merge;
        }
        captcha.owner.setLetterNum(obj.size() - merge);
        EasyCaptcha.mergeObjectsBasic(obj, captcha, 2);
        Collections.sort(obj);
        ArrayList<Letter> ret = new ArrayList<Letter>();
        PixelObject last = obj.get(0);
        ListIterator<PixelObject> iterator = obj.listIterator();
        while (iterator.hasNext()) {
            PixelObject pixelObject = iterator.next();
            if (pixelObject.getArea() <= 4 && pixelObject.getHeight() <= 5 || pixelObject.getArea() >= 250 || Math.abs(last.getYMin() - pixelObject.getYMin()) >= 3 && !(iterator.hasNext() & Math.abs(iterator.next().getYMin() - pixelObject.getYMin()) < 3 & iterator.previous() == pixelObject)) continue;
            ret.addAll(Dlm.getSplitted(pixelObject, captcha, 0));
        }
        Dlm.replaceLetters(ret);
        return ret.toArray(new Letter[0]);
    }

    private static void replaceLetters(ArrayList<Letter> lets) {
        int i = 0;
        String add = null;
        for (Letter letter : lets) {
            if (letter.detected.getDecodedValue().equals("1")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "i";
                break;
            }
            if (letter.detected.getDecodedValue().equals("2")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "l";
                break;
            }
            if (letter.detected.getDecodedValue().equals("3")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "t";
                break;
            }
            if (letter.detected.getDecodedValue().equals("4")) {
                letter.detected.getB().setDecodedValue("r");
                letter.setDecodedValue("r");
                add = "n";
                break;
            }
            ++i;
        }
        if (add != null) {
            Letter re = new Letter();
            re.setDecodedValue(add);
            LetterComperator let1 = new LetterComperator(re, re);
            let1.setValityPercent(0.0);
            re.detected = let1;
            lets.add(i + 1, re);
            Dlm.replaceLetters(lets);
        }
    }

    static Vector<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        Vector<PixelObject> ret = new Vector<PixelObject>();
        int x = 0;
        while (x < grid.getWidth()) {
            int y = 0;
            while (y < grid.getHeight()) {
                if (grid.getGrid()[x][y] >= 0 && grid.getGrid()[x][y] == 0) {
                    PixelObject n = new PixelObject(grid);
                    n.add(x, y, grid.getGrid()[x][y]);
                    Vector<PixelObject> merge = new Vector<PixelObject>();
                    for (PixelObject o : ret) {
                        if (!o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                        merge.add(o);
                    }
                    if (merge.size() == 0) {
                        ret.add(n);
                    } else if (merge.size() == 1) {
                        ((PixelObject)merge.get(0)).add(n);
                    } else {
                        for (PixelObject po : merge) {
                            ret.remove(po);
                            n.add(po);
                        }
                        ret.add(n);
                    }
                }
                ++y;
            }
            ++x;
        }
        return ret;
    }

    private static ArrayList<Letter> getSplitted(PixelObject pixelObject, Captcha captcha, int index) {
        LetterComperator r2;
        ArrayList<Letter> ret = new ArrayList<Letter>();
        if (pixelObject.getArea() < 4) {
            return ret;
        }
        Letter let1 = pixelObject.toLetter();
        let1.toBlackAndWhite();
        let1.detected = r2 = captcha.owner.getLetter(let1);
        if (r2.getValityPercent() < 3.0 || index == 2 || pixelObject.getArea() < 15) {
            ret.add(let1);
            return ret;
        }
        if (r2.getValityPercent() < 10.0) {
            PixelObject[] bestAArray = pixelObject.splitAt(r2.getB().getWidth());
            if (bestAArray[0].getArea() > 4) {
                Letter bestA = bestAArray[0].toLetter();
                bestA.toBlackAndWhite();
                bestA.detected = r2 = captcha.owner.getLetter(bestA);
                ret.add(bestA);
            }
            if (bestAArray[1].getArea() > 4) {
                LetterComperator r3;
                Letter bestB = bestAArray[1].toLetter();
                bestB.toBlackAndWhite();
                bestB.detected = r3 = captcha.owner.getLetter(bestB);
                ret.add(bestB);
            }
            return ret;
        }
        ++index;
        int b = pixelObject.getWidth() / 2;
        PixelObject[] bestAArray = pixelObject.splitAt(b);
        Letter bestA = bestAArray[0].toLetter();
        bestA.toBlackAndWhite();
        bestA.detected = r2 = captcha.owner.getLetter(bestA);
        if (r2.getValityPercent() < 1.0) {
            ret.add(bestA);
            ret.addAll(Dlm.getSplitted(bestAArray[1], captcha, index));
            return ret;
        }
        PixelObject[] bestBArray = pixelObject.splitAt(b);
        Letter bestB = bestAArray[0].toLetter();
        int a = b + 1;
        while (a < pixelObject.getWidth() / 3 * 2) {
            LetterComperator rb;
            LetterComperator ra;
            --b;
            PixelObject[] aArray = pixelObject.splitAt(a);
            Letter letA = aArray[0].toLetter();
            letA.toBlackAndWhite();
            letA.detected = ra = captcha.owner.getLetter(letA);
            if (ra != null && (bestA.detected == null || ra.getValityPercent() < bestA.detected.getValityPercent())) {
                bestA = letA;
                bestAArray = aArray;
                if (ra.getValityPercent() < 1.0) break;
            }
            PixelObject[] bArray = pixelObject.splitAt(b);
            Letter letB = bArray[0].toLetter();
            letB.toBlackAndWhite();
            letB.detected = rb = captcha.owner.getLetter(letB);
            if (rb != null && (bestB.detected == null || rb.getValityPercent() < bestB.detected.getValityPercent())) {
                bestB = letB;
                bestBArray = bArray;
                if (rb.getValityPercent() < 1.0) break;
            }
            ++a;
        }
        if (let1.detected != null && (bestA.detected == null || let1.detected.getValityPercent() < bestA.detected.getValityPercent() || bestB.detected == null || let1.detected.getValityPercent() < bestB.detected.getValityPercent())) {
            if (index == 1) {
                b = pixelObject.getWidth() / 2;
                bestAArray = pixelObject.splitAt(b);
                bestA = bestAArray[0].toLetter();
                bestA.toBlackAndWhite();
                bestA.detected = r2 = captcha.owner.getLetter(bestA);
                ret.add(bestA);
                bestB = bestAArray[1].toLetter();
                bestB.toBlackAndWhite();
                bestB.detected = r2 = captcha.owner.getLetter(bestB);
                ret.add(bestB);
                return ret;
            }
            ret.add(let1);
            return ret;
        }
        if (bestA.detected != null && bestB.detected == null || bestA.detected != null && bestA.detected.getValityPercent() < bestB.detected.getValityPercent()) {
            ret.add(bestB);
            ret.addAll(Dlm.getSplitted(bestAArray[1], captcha, index));
            return ret;
        }
        if (bestB.detected != null) {
            ret.add(bestB);
            ret.addAll(Dlm.getSplitted(bestBArray[1], captcha, index));
            return ret;
        }
        if (index == 1) {
            b = pixelObject.getWidth() / 2;
            bestAArray = pixelObject.splitAt(b);
            bestA = bestAArray[0].toLetter();
            bestA.toBlackAndWhite();
            bestA.detected = r2 = captcha.owner.getLetter(bestA);
            ret.add(bestA);
            bestB = bestAArray[1].toLetter();
            bestB.toBlackAndWhite();
            bestB.detected = r2 = captcha.owner.getLetter(bestB);
            ret.add(bestB);
            return ret;
        }
        ret.add(let1);
        return ret;
    }

    public static Letter[] letterFilter(Letter[] org, JAntiCaptcha jac) {
        return org;
    }
}

