/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotFile {
    private static void mergeObjects(Vector<PixelObject> os) {
        for (PixelObject a : os) {
            for (PixelObject b : os) {
                if (a == b) continue;
                int xMin = Math.max(a.getXMin(), b.getXMin());
                int xMax = Math.min(a.getXMin() + a.getWidth(), b.getXMin() + b.getWidth());
                if (xMax + 1 < xMin) continue;
                int yMin = Math.max(a.getYMin(), b.getYMin());
                int yMax = Math.min(a.getYMin() + a.getHeight(), b.getYMin() + b.getHeight());
                if (xMax - xMin >= 30 || yMax - yMin >= 30) continue;
                a.add(b);
                os.remove(b);
                HotFile.mergeObjects(os);
                return;
            }
        }
    }

    private static void clean(Captcha captcha) {
        int[][] newgrid = new int[captcha.getWidth()][captcha.getHeight()];
        Color lastC = null;
        int[] lastpos = new int[2];
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                int p = captcha.getPixelValue(x, y);
                Color c = new Color(p);
                if (c.getBlue() > 110 && c.getRed() > 110 && c.getGreen() > 110) {
                    if (lastC == null || Math.abs(lastpos[0] - x) + Math.abs(lastpos[1] - y) >= 3 || !(Colors.getColorDifference((int)lastC.getRGB(), (int)c.getRGB()) < 20.0)) {
                        PixelGrid.setPixelValue(x, y, newgrid, captcha.getMaxPixelValue());
                    } else {
                        newgrid[x][y] = captcha.grid[x][y];
                    }
                } else {
                    newgrid[x][y] = captcha.grid[x][y];
                    lastC = c;
                    lastpos = new int[]{x, y};
                }
                ++y;
            }
            ++x;
        }
        captcha.grid = newgrid;
    }

    public static Letter[] getLetters(Captcha captcha) {
        HotFile.clean(captcha);
        captcha.removeSmallObjects(0.75, 0.75, 6);
        captcha.toBlackAndWhite(0.95);
        Vector<PixelObject> os = captcha.getObjects(0.5, 0.5);
        Collections.sort(os);
        HotFile.mergeObjects(os);
        ArrayList<Letter> ret = new ArrayList<Letter>();
        for (PixelObject pixelObject : os) {
            if (pixelObject.getArea() <= 50) continue;
            Letter let = pixelObject.toLetter();
            let.removeSmallObjects(0.75, 0.75, 6);
            ret.add(let);
        }
        return ret.toArray(new Letter[0]);
    }
}

