/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import jd.captcha.easy.CPoint;
import jd.captcha.easy.ColorTrainer;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrbBt {
    public static ArrayList<PixelObject> getObjects(PixelGrid grid, int neighbourradius) {
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        int x = 0;
        while (x < grid.getWidth()) {
            int y = 0;
            while (y < grid.getHeight()) {
                int c = grid.grid[x][y];
                if (c != 0xFFFFFF) {
                    PixelObject n = new PixelObject(grid);
                    n.add(x, y, c);
                    ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                    for (PixelObject o : ret) {
                        if (!(Colors.getColorDifference((int)c, (int)o.getMostcolor()) < 20.0) || !o.isTouching(x, y, true, neighbourradius, neighbourradius)) continue;
                        merge.add(o);
                    }
                    if (merge.size() == 0) {
                        ret.add(n);
                    } else if (merge.size() == 1) {
                        ((PixelObject)merge.get(0)).add(n);
                    } else {
                        for (PixelObject po : merge) {
                            ret.remove(po);
                            n.add(po);
                        }
                        ret.add(n);
                    }
                }
                ++y;
            }
            ++x;
        }
        return ret;
    }

    private static void toBlack(PixelGrid captcha) {
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                if (captcha.grid[x][y] != 0xFFFFFF) {
                    captcha.grid[x][y] = 0;
                }
                ++y;
            }
            ++x;
        }
    }

    private static PixelObject getNexTOS(PixelObject aos, List<PixelObject> os) {
        PixelObject nextos;
        int i = 0;
        while ((nextos = os.get(i)) == aos) {
            ++i;
        }
        ++i;
        int matching = Math.min(aos.getXMax(), nextos.getXMax()) - Math.max(aos.getXMin(), nextos.getXMin());
        int best = matching >= 0 ? -matching : Math.min(Math.min(Math.abs(aos.getXMin() + aos.getWidth() - nextos.getXMin()), Math.abs(aos.getXMin() - (nextos.getXMin() + nextos.getWidth()))), Math.min(Math.abs(aos.getXMin() - nextos.getXMin()), Math.abs(aos.getXMin() + aos.getWidth() - (nextos.getXMin() + nextos.getWidth()))));
        while (i < os.size()) {
            int ib;
            PixelObject b = os.get(i);
            if (b != aos && (ib = (matching = Math.min(aos.getXMax(), b.getXMax()) - Math.max(aos.getXMin(), b.getXMin())) >= 0 ? -matching : Math.min(Math.min(Math.abs(aos.getXMin() + aos.getWidth() - b.getXMin()), Math.abs(aos.getXMin() - (b.getXMin() + b.getWidth()))), Math.min(Math.abs(aos.getXMin() - b.getXMin()), Math.abs(aos.getXMin() + aos.getWidth() - (b.getXMin() + b.getWidth()))))) < best) {
                best = ib;
                nextos = b;
            }
            ++i;
        }
        return nextos;
    }

    private static void merge(List<PixelObject> os) {
        if (os.size() == 4) {
            return;
        }
        double mergeos = Double.MAX_VALUE;
        PixelObject aos = null;
        for (PixelObject pixelObject : os) {
            int mg = pixelObject.getSize();
            PixelObject nos = TrbBt.getNexTOS(pixelObject, os);
            double cd = Colors.getColorDifference((int)pixelObject.getMostcolor(), (int)nos.getMostcolor()) / 100.0 + (double)mg;
            if (!(mergeos > cd)) continue;
            mergeos = cd;
            aos = pixelObject;
        }
        EasyCaptcha.mergeos(aos, os);
        TrbBt.merge(os);
    }

    public static Letter[] getLetters(Captcha captcha) {
        captcha.crop(0, 5, 0, 5);
        File file = captcha.owner.getResourceFile("CPoints.xml");
        Vector<CPoint> ret = ColorTrainer.load(file);
        int x = 0;
        while (x < captcha.getWidth()) {
            int y = 0;
            while (y < captcha.getHeight()) {
                double bestDist1 = Double.MAX_VALUE;
                CPoint cpBestDist1 = null;
                double bestDist2 = Double.MAX_VALUE;
                CPoint cpBestDist2 = null;
                for (CPoint cp : ret) {
                    double dist = cp.getColorDifference(captcha.grid[x][y]);
                    if (bestDist1 > dist) {
                        bestDist1 = dist;
                        cpBestDist1 = cp;
                    }
                    if (!(dist < (double)cp.getDistance()) || !(bestDist2 > dist)) continue;
                    bestDist2 = 0.0;
                    cpBestDist2 = cp;
                }
                if (cpBestDist2 != null) {
                    if (!cpBestDist2.isForeground()) {
                        captcha.setPixelValue(x, y, 0xFFFFFF);
                    }
                } else if (cpBestDist1 != null && !cpBestDist1.isForeground()) {
                    captcha.setPixelValue(x, y, 0xFFFFFF);
                }
                ++y;
            }
            ++x;
        }
        ArrayList<PixelObject> os = TrbBt.getObjects(captcha, 5);
        TrbBt.merge(os);
        while (os.size() > 4) {
            PixelObject smallest = null;
            for (PixelObject pixelObject : os) {
                if (smallest != null && pixelObject.getSize() >= smallest.getSize()) continue;
                smallest = pixelObject;
            }
            os.remove(smallest);
        }
        Collections.sort(os);
        Letter[] lets = new Letter[os.size()];
        int i = 0;
        while (i < lets.length) {
            lets[i] = os.get(i).toLetter();
            TrbBt.toBlack(lets[i]);
            lets[i].autoAlign();
            lets[i].resizetoHeight(25);
            ++i;
        }
        return lets;
    }
}

