/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.avi;

import de.savemytube.avi.Framerate;
import de.savemytube.flv.FLV;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class AVIWriter
extends FLV {
    private RandomAccessFile file;
    private ArrayList _index;
    private int _codecID;
    private int _width;
    private int _height;
    private int _framecount = 0;
    private int _moviDataSize;
    private int _frameCount;
    private int _indexChunkSize;

    public AVIWriter(String path, int codecID) throws Exception {
        if (codecID != 2 && codecID != 4 && codecID != 5) {
            throw new Exception("Unsupported video codec.");
        }
        this._codecID = codecID;
        this.file = new RandomAccessFile(path, "rw");
        this.WriteFourCC("RIFF");
        this.writeInt(0);
        this.WriteFourCC("AVI ");
        this.WriteFourCC("LIST");
        this.writeInt(192);
        this.WriteFourCC("hdrl");
        this.WriteFourCC("avih");
        this.writeInt(56);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.WriteFourCC("LIST");
        this.writeInt(116);
        this.WriteFourCC("strl");
        this.WriteFourCC("strh");
        this.writeInt(56);
        this.WriteFourCC("vids");
        this.WriteFourCC(this.getCodecFourCC(codecID));
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.WriteFourCC("strf");
        this.writeInt(40);
        this.writeInt(40);
        this.writeInt(0);
        this.writeInt(0);
        this.writeShort((short)1);
        this.writeShort((short)24);
        this.WriteFourCC(this.getCodecFourCC(codecID));
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.WriteFourCC("LIST");
        this.writeInt(0);
        this.WriteFourCC("movi");
        this._index = new ArrayList();
    }

    private String getCodecFourCC(int _codecID) {
        if (_codecID == 2) {
            return "FLV1";
        }
        if (_codecID == 4 || _codecID == 5) {
            return "FLV4";
        }
        return "NULL";
    }

    private void WriteFourCC(String string) throws Exception {
        byte[] bytes = string.getBytes();
        if (bytes.length != 4) {
            throw new Exception("Invalid FourCC length.");
        }
        this.file.write(bytes);
    }

    public void writeChunk(byte[] chunk, int timeStamp, int frameType) throws Exception {
        int offset = 0;
        if (this._codecID == 4) {
            offset = 1;
        }
        if (this._codecID == 5) {
            offset = 4;
        }
        int len = Math.max(chunk.length - offset, 0);
        this._index.add(frameType == 1 ? new Integer(16) : new Integer(0));
        this._index.add(new Integer(this._moviDataSize + 4));
        this._index.add(new Integer(len));
        if (this._width == 0 && this._height == 0) {
            this.getFrameSize(chunk);
        }
        this.WriteFourCC("00dc");
        this.writeInt(len);
        this.file.write(chunk, offset, len);
        if (len % 2 != 0) {
            this.file.write(0);
            ++len;
        }
        this._moviDataSize += len + 8;
        ++this._frameCount;
    }

    private void getFrameSize(byte[] chunk) {
        block13: {
            block12: {
                if (this._codecID != 2) break block12;
                if (chunk[0] != 0 || chunk[1] != 0) {
                    return;
                }
                byte[] d = new byte[]{chunk[2], chunk[3], chunk[4], chunk[5]};
                long x = AVIWriter.arr2long(d, 0);
                this.readBits(x, 5);
                this.readBits(x, 8);
                int format = this.readBits(x, 3);
                switch (format) {
                    case 0: {
                        this._width = this.readBits(x, 8);
                        this._height = this.readBits(x, 8);
                        break block13;
                    }
                    case 1: {
                        this._width = this.readBits(x, 16);
                        this._height = this.readBits(x, 16);
                        break block13;
                    }
                    case 2: {
                        this._width = 352;
                        this._height = 288;
                        break block13;
                    }
                    case 3: {
                        this._width = 176;
                        this._height = 144;
                        break block13;
                    }
                    case 4: {
                        this._width = 128;
                        this._height = 96;
                        break block13;
                    }
                    case 5: {
                        this._width = 320;
                        this._height = 240;
                        break block13;
                    }
                    case 6: {
                        this._width = 160;
                        this._height = 120;
                        break block13;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (this._codecID == 4 || this._codecID == 5) {
                byte[] d = null;
                d = this._codecID != 4 ? new byte[]{chunk[0], chunk[1], chunk[2], chunk[3]} : new byte[]{chunk[0]};
                long x = AVIWriter.getInt(d);
                if ((this.readBits(x, 16) & 0x80FE) != 70) {
                    return;
                }
                this._height = this.readBits(x, 8) * 16;
                this._width = this.readBits(x, 8) * 16;
            }
        }
    }

    private int readBits(long x, int length) {
        int r = (int)(x >> 32 - length);
        x <<= length;
        return r;
    }

    private void WriteIndexChunk() throws Exception {
        int indexDataSize = this._frameCount * 16;
        this.WriteFourCC("idx1");
        this.writeInt(indexDataSize);
        int i = 0;
        while (i < this._frameCount) {
            this.WriteFourCC("00dc");
            Integer x1 = (Integer)this._index.get(i * 3 + 0);
            Integer x2 = (Integer)this._index.get(i * 3 + 1);
            Integer x3 = (Integer)this._index.get(i * 3 + 2);
            this.writeInt(x1);
            this.writeInt(x2);
            this.writeInt(x3);
            ++i;
        }
        this._indexChunkSize = indexDataSize + 8;
    }

    private void writeInt(int x) throws IOException {
        x = Integer.reverseBytes(x);
        this.file.writeInt(x);
    }

    private void writeShort(short x) throws IOException {
        x = Short.reverseBytes(x);
        this.file.writeShort(x);
    }

    public void finish(Framerate averageFrameRate) throws Exception {
        this.WriteIndexChunk();
        int p = 4;
        this.file.seek(p);
        this.writeInt(224 + this._moviDataSize + this._indexChunkSize - 8);
        p = 32;
        this.file.seek(p);
        this.writeInt(0);
        p = p + 12 + 4;
        this.file.seek(p);
        this.writeInt(this._frameCount);
        p = p + 12 + 4;
        this.file.seek(p);
        this.writeInt(this._width);
        this.writeInt(this._height);
        p = 128;
        this.file.seek(p);
        this.writeInt(averageFrameRate.D);
        this.writeInt(averageFrameRate.N);
        p = p + 4 + 4 + 4;
        this.file.seek(p);
        this.writeInt(this._frameCount);
        p = p + 16 + 4;
        this.file.seek(p);
        this.writeShort((short)this._width);
        this.writeShort((short)this._height);
        p = 176;
        this.file.seek(p);
        this.writeInt(this._width);
        this.writeInt(this._height);
        p = p + 8 + 4 + 4;
        this.file.seek(p);
        this.writeInt(this._width * this._height * 6);
        p = 216;
        this.file.seek(p);
        this.writeInt(this._moviDataSize + 4);
        this.file.close();
    }
}

