/*
 * Decompiled with CFR 0.152.
 */
package de.savemytube.flv;

import de.savemytube.flv.ByteData;
import de.savemytube.flv.FLVTag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class FLVTagVideo
extends FLVTag {
    public static final int VIDEO_CODECID_H263 = 2;
    public static final int VIDEO_CODECID_SCREENVIDEO = 3;
    public static final int VIDEO_CODECID_ON2_VP6 = 4;
    public static final int VIDEO_CODECID_ON2_VP6_ALPHA = 5;
    public static final int VIDEO_CODECID_SCREENVIDEO2 = 6;
    public static final int VIDEOFRAMETYPE_KEYFRAME = 1;
    public static final int VIDEOFRAMETYPE_INTERFRAME = 2;
    public static final int VIDEOFRAMETYPE_DISPOSABLEINTERFRAME = 3;
    public static final String[] S_CODEC = new String[]{"", "", "H.263", "Screen video", "On2 VP6", "On2 VP6 Alpha", "ScreenVideo 2"};
    public static final String[] S_FRAMETYPE = new String[]{"", "keyframe", "inter frame", "disposable inter frame"};
    private int codecID;
    private int frameType;

    public FLVTagVideo(byte type, int bodyLength, int timestamp, byte timestampExtended, int streamId) {
        super(type, bodyLength, timestamp, timestampExtended, streamId);
    }

    public void read(ReadableByteChannel channel) throws IOException {
        ByteData bData = this.read(channel, 1);
        ByteBuffer buf = bData.getByteBuffer();
        byte b = this.getBytes(buf)[0];
        this.setInfo(b);
        this.setBodyLength(this.getBodyLength() - 1);
        bData = this.read(channel, this.getBodyLength());
        this.setBody(this.getBytes(bData.getByteBuffer()));
    }

    private void setInfo(byte b) {
        this.codecID = (b & 0xF) >> 0;
        this.frameType = (b & 0xF0) >> 4;
    }

    public String toString() {
        String s = "---- VideoFormat ----\n";
        s = String.valueOf(s) + super.toString() + "\n";
        s = String.valueOf(s) + S_CODEC[this.codecID] + " " + S_FRAMETYPE[this.frameType];
        return s;
    }

    public int getCodecID() {
        return this.codecID;
    }

    public void setCodecID(int codecID) {
        this.codecID = codecID;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setFrameType(int frameType) {
        this.frameType = frameType;
    }
}

