/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import jd.config.SubConfiguration;
import jd.controlling.DistributeData;
import jd.controlling.DownloadController;
import jd.controlling.DownloadWatchDog;
import jd.controlling.JDLogger;
import jd.controlling.LinkGrabberController;
import jd.controlling.PasswordListController;
import jd.controlling.reconnect.Reconnecter;
import jd.gui.swing.jdgui.views.linkgrabberview.LinkGrabberPanel;
import jd.nutils.Formatter;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.LinkGrabberFilePackage;
import jd.plugins.optional.webinterface.JDSimpleWebserverResponseCreator;
import jd.plugins.optional.webinterface.JDSimpleWebserverStaticFileRequestHandler;
import jd.plugins.optional.webinterface.JDSimpleWebserverTemplateFileRequestHandler;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDSimpleWebserverRequestHandler {
    private HashMap<String, String> headers;
    private Logger logger = JDLogger.getLogger();
    private JDSimpleWebserverResponseCreator response;
    private LinkGrabberController lgi = LinkGrabberController.getInstance();

    public JDSimpleWebserverRequestHandler(HashMap<String, String> headers, JDSimpleWebserverResponseCreator response) {
        this.response = response;
        this.headers = headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        String tempurl;
        File fileToRead2;
        File fileToRead;
        String request = this.headers.get(null);
        String[] requ = request.split(" ");
        String cPath = requ[1];
        String path = cPath.substring(1);
        HashMap<String, String> requestParameter = new HashMap<String, String>();
        requestParameter.put("package_all_downloads_counter", "0");
        requestParameter.put("package_single_download_counter", "0");
        requestParameter.put("package_all_add_counter", "0");
        requestParameter.put("package_single_add_counter", "0");
        if (cPath.indexOf("?") >= 0) {
            String[] params;
            String querry = cPath.substring(cPath.indexOf("?") + 1);
            path = cPath.substring(1, cPath.indexOf("?"));
            String[] stringArray = params = querry.split("\\&");
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                entry = entry.trim();
                int index = entry.indexOf("=");
                String key = entry;
                String value = null;
                if (index >= 0) {
                    key = entry.substring(0, index);
                    value = entry.substring(index + 1);
                }
                if (requestParameter.containsKey(key) || requestParameter.containsKey(String.valueOf(key) + "_counter")) {
                    if (requestParameter.containsKey(String.valueOf(key) + "_counter")) {
                        Integer keycounter = 0;
                        keycounter = Formatter.filterInt((String)requestParameter.get(String.valueOf(key) + "_counter"));
                        keycounter = keycounter + 1;
                        requestParameter.put(String.valueOf(key) + "_counter", keycounter.toString());
                        requestParameter.put(String.valueOf(key) + "_" + keycounter.toString(), value);
                    }
                } else {
                    requestParameter.put(key, value);
                }
                ++n2;
            }
        }
        String url = path.replaceAll("\\.\\.", "");
        if (requestParameter.containsKey("do")) {
            if (((String)requestParameter.get("do")).compareToIgnoreCase("submit") == 0) {
                if (requestParameter.containsKey("speed")) {
                    int setspeed = Formatter.filterInt((String)((String)requestParameter.get("speed")));
                    if (setspeed < 0) {
                        setspeed = 0;
                    }
                    SubConfiguration.getConfig((String)"DOWNLOAD").setProperty("DOWNLOAD_MAX_SPEED_V2", (Object)setspeed);
                }
                if (requestParameter.containsKey("maxdls")) {
                    int maxdls = Formatter.filterInt((String)((String)requestParameter.get("maxdls")));
                    if (maxdls < 1) {
                        maxdls = 1;
                    }
                    SubConfiguration.getConfig((String)"DOWNLOAD").setProperty("DOWNLOAD_MAX_SIMULTAN", (Object)maxdls);
                }
                if (!requestParameter.containsKey("selected_dowhat_link_adder")) {
                    if (requestParameter.containsKey("autoreconnect")) {
                        JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", (Object)true);
                    } else {
                        JDUtilities.getConfiguration().setProperty("ALLOW_RECONNECT", (Object)false);
                    }
                }
                if (requestParameter.containsKey("package_single_add_counter")) {
                    Object maxdls = LinkGrabberController.ControllerLock;
                    synchronized (maxdls) {
                        ArrayList arrayList = this.lgi.getPackages();
                        synchronized (arrayList) {
                            Integer download_id = 0;
                            Integer package_id = 0;
                            int counter_max = Formatter.filterInt((String)requestParameter.get("package_single_add_counter"));
                            int counter_index = 0;
                            ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
                            ArrayList<LinkGrabberFilePackage> packages = new ArrayList<LinkGrabberFilePackage>();
                            counter_index = 1;
                            while (counter_index <= counter_max) {
                                if (requestParameter.containsKey("package_single_add_" + counter_index)) {
                                    String[] ids = requestParameter.get("package_single_add_" + counter_index).toString().split("[+]", 2);
                                    package_id = Formatter.filterInt((String)ids[0].toString());
                                    download_id = Formatter.filterInt((String)ids[1].toString());
                                    links.add(((LinkGrabberFilePackage)this.lgi.getPackages().get(package_id)).get(download_id.intValue()));
                                    if (!packages.contains(this.lgi.getPackages().get(package_id))) {
                                        packages.add((LinkGrabberFilePackage)this.lgi.getPackages().get(package_id));
                                    }
                                }
                                ++counter_index;
                            }
                            if (requestParameter.containsKey("selected_dowhat_link_adder")) {
                                String dowhat = requestParameter.get("selected_dowhat_link_adder");
                                int i = 0;
                                while (i < this.lgi.getPackages().size()) {
                                    if (requestParameter.containsKey("adder_package_name_" + i)) {
                                        ((LinkGrabberFilePackage)this.lgi.getPackages().get(i)).setName(Encoding.htmlDecode((String)requestParameter.get("adder_package_name_" + i).toString()));
                                    }
                                    ++i;
                                }
                                if (dowhat.compareToIgnoreCase("remove") == 0) {
                                    for (LinkGrabberFilePackage fp : packages) {
                                        fp.remove(links);
                                    }
                                } else if (dowhat.compareToIgnoreCase("remove+offline") == 0) {
                                    links = new ArrayList();
                                    i = 0;
                                    while (i < this.lgi.getPackages().size()) {
                                        int ii = 0;
                                        while (ii < ((LinkGrabberFilePackage)this.lgi.getPackages().get(i)).size()) {
                                            links.add(((LinkGrabberFilePackage)this.lgi.getPackages().get(i)).get(ii));
                                            ++ii;
                                        }
                                        ++i;
                                    }
                                    for (DownloadLink link : links) {
                                        if (!link.isAvailabilityStatusChecked() || link.isAvailable()) continue;
                                        link.getFilePackage().remove(link);
                                    }
                                } else if (dowhat.compareToIgnoreCase("add") == 0) {
                                    for (LinkGrabberFilePackage fp : packages) {
                                        LinkGrabberPanel.getLinkGrabber().confirmPackage(fp, null, -1);
                                    }
                                }
                            }
                        }
                    }
                }
                if (requestParameter.containsKey("package_single_download_counter")) {
                    Integer download_id = 0;
                    Integer package_id = 0;
                    int counter_max = Formatter.filterInt((String)requestParameter.get("package_single_download_counter"));
                    int counter_index = 0;
                    ArrayList<DownloadLink> links = new ArrayList<DownloadLink>();
                    counter_index = 1;
                    while (counter_index <= counter_max) {
                        if (requestParameter.containsKey("package_single_download_" + counter_index)) {
                            String[] ids = requestParameter.get("package_single_download_" + counter_index).toString().split("[+]", 2);
                            package_id = Formatter.filterInt((String)ids[0].toString());
                            download_id = Formatter.filterInt((String)ids[1].toString());
                            links.add((DownloadLink)((FilePackage)JDUtilities.getController().getPackages().get(package_id)).getDownloadLinkList().get(download_id));
                        }
                        ++counter_index;
                    }
                    if (requestParameter.containsKey("selected_dowhat_index")) {
                        String dowhat = requestParameter.get("selected_dowhat_index");
                        if (dowhat.compareToIgnoreCase("activate") == 0) {
                            for (DownloadLink link : links) {
                                link.setEnabled(true);
                            }
                            DownloadController.getInstance().fireGlobalUpdate();
                        }
                        if (dowhat.compareToIgnoreCase("deactivate") == 0) {
                            for (DownloadLink link : links) {
                                link.setEnabled(false);
                            }
                            DownloadController.getInstance().fireGlobalUpdate();
                        }
                        if (dowhat.compareToIgnoreCase("reset") == 0) {
                            for (DownloadLink link : links) {
                                link.getLinkStatus().setStatus(1);
                                link.getLinkStatus().setStatusText("");
                                link.reset();
                            }
                            DownloadController.getInstance().fireGlobalUpdate();
                        }
                        if (dowhat.compareToIgnoreCase("remove") == 0) {
                            for (DownloadLink dl : links) {
                                dl.getFilePackage().remove(dl);
                            }
                        }
                        if (dowhat.compareToIgnoreCase("abort") == 0) {
                            for (DownloadLink link : links) {
                                link.setAborted(true);
                            }
                            DownloadController.getInstance().fireGlobalUpdate();
                        }
                    }
                }
            } else if (((String)requestParameter.get("do")).compareToIgnoreCase("reconnect") == 0) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            JDLogger.exception((Throwable)e);
                        }
                        if (Reconnecter.doManualReconnect()) {
                            JDSimpleWebserverRequestHandler.this.logger.info("Reconnect erfolgreich");
                        } else {
                            JDSimpleWebserverRequestHandler.this.logger.info("Reconnect fehlgeschlagen");
                        }
                    }
                }).start();
            } else if (((String)requestParameter.get("do")).compareToIgnoreCase("close") == 0) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            JDLogger.exception((Throwable)e);
                        }
                        JDUtilities.getController().exit();
                    }
                }).start();
            } else if (((String)requestParameter.get("do")).compareToIgnoreCase("start") == 0) {
                DownloadWatchDog.getInstance().startDownloads();
            } else if (((String)requestParameter.get("do")).compareToIgnoreCase("stop") == 0) {
                DownloadWatchDog.getInstance().stopDownloads();
            } else if (requestParameter.get("do").compareToIgnoreCase("restart") == 0) {
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            JDLogger.exception((Throwable)e);
                        }
                        JDUtilities.restartJD((boolean)false);
                    }
                }).start();
            } else if (requestParameter.get("do").compareToIgnoreCase("add") == 0) {
                if (requestParameter.containsKey("addlinks")) {
                    String AddLinks = Encoding.htmlDecode((String)requestParameter.get("addlinks"));
                    ArrayList waitingLinkList = new DistributeData(AddLinks).findLinks();
                    LinkGrabberPanel.getLinkGrabber().addLinks(waitingLinkList);
                }
            } else if (requestParameter.get("do").compareToIgnoreCase("upload") == 0 && requestParameter.containsKey("file")) {
                File container = JDUtilities.getResourceFile((String)("container/" + requestParameter.get("file")));
                ArrayList waitingLinkList = JDUtilities.getController().getContainerLinks(container);
                LinkGrabberPanel.getLinkGrabber().addLinks(waitingLinkList);
            }
        }
        if (requestParameter.containsKey("passwd") && ((String)requestParameter.get("passwd")).compareToIgnoreCase("save") == 0 && requestParameter.containsKey("password_list")) {
            String passwordList = Encoding.htmlDecode((String)((String)requestParameter.get("password_list")));
            ArrayList<String> pws = new ArrayList<String>();
            String[] stringArray = Regex.getLines((String)passwordList);
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String pw = stringArray[n3];
                pws.add(0, pw);
                ++n3;
            }
            PasswordListController.getInstance().setPasswordList(pws);
        }
        if (!(fileToRead = JDUtilities.getResourceFile((String)("plugins/webinterface/" + url))).isFile() && (fileToRead2 = JDUtilities.getResourceFile((String)("plugins/webinterface/" + (tempurl = String.valueOf(url) + "index.tmpl")))).isFile()) {
            url = tempurl;
            fileToRead = JDUtilities.getResourceFile((String)("plugins/webinterface/" + url));
        }
        if (!fileToRead.exists()) {
            this.response.setNotFound(url);
        } else if (url.endsWith(".tmpl")) {
            JDSimpleWebserverTemplateFileRequestHandler filerequest = new JDSimpleWebserverTemplateFileRequestHandler(this.response);
            filerequest.handleRequest(url, requestParameter);
        } else {
            JDSimpleWebserverStaticFileRequestHandler filerequest = new JDSimpleWebserverStaticFileRequestHandler(this.headers, this.response);
            filerequest.handleRequest(url, requestParameter);
        }
    }
}

