/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Logger;
import jd.controlling.JDLogger;
import jd.nutils.io.JDIO;
import jd.parser.Regex;
import jd.plugins.optional.webinterface.JDSimpleWebserverResponseCreator;
import jd.utils.JDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDSimpleWebserverStaticFileRequestHandler {
    private Logger logger = JDLogger.getLogger();
    private JDSimpleWebserverResponseCreator response;
    private HashMap<String, String> headers = new HashMap();

    public JDSimpleWebserverStaticFileRequestHandler(HashMap<String, String> headers, JDSimpleWebserverResponseCreator response) {
        this.headers = headers;
        this.response = response;
    }

    public void handleRequest(String url, HashMap<String, String> requestParameter) {
        File fileToRead = JDUtilities.getResourceFile((String)("plugins/webinterface/" + url));
        if (fileToRead.length() > 10240L) {
            this.response.setContentType("application/octet-stream");
            if (!this.headers.containsKey("range")) {
                this.response.setFileServe(fileToRead.toString(), 0L, -1L, fileToRead.length(), false);
            } else {
                String[] dat = new Regex(this.headers.get("range"), "bytes=(\\d+)-(\\d+)?").getRow(0);
                if (dat[1] == null) {
                    this.response.setFileServe(fileToRead.toString(), Long.parseLong(dat[0]), -1L, fileToRead.length(), true);
                } else {
                    this.response.setFileServe(fileToRead.toString(), Long.parseLong(dat[0]), Long.parseLong(dat[1]), fileToRead.length(), true);
                }
            }
            this.response.setFilename(fileToRead.getName());
            this.response.setOk();
            return;
        }
        HashMap<String, String> mimes = new HashMap<String, String>();
        mimes.put("html", "text/html");
        mimes.put("htm", "text/html");
        mimes.put("txt", "text/plain");
        mimes.put("gif", "image/gif");
        mimes.put("css", "text/css");
        mimes.put("png", "image/png");
        mimes.put("jpeg", "image/jpeg");
        mimes.put("jpg", "image/jpeg");
        mimes.put("jpe", "image/jpeg");
        mimes.put("ico", "image/x-icon");
        String mimeType = null;
        int indexOfDot = fileToRead.getName().indexOf(46);
        if (indexOfDot >= 0) {
            String extension = JDIO.getFileExtension((File)fileToRead);
            mimeType = "text/plain";
            if (mimes.containsKey(extension.toLowerCase())) {
                mimeType = (String)mimes.get(extension.toLowerCase());
            }
        }
        if (mimeType != null) {
            this.response.setContentType(mimeType);
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(fileToRead);
                if (mimeType == null || mimeType.startsWith("text")) {
                    int nextByte;
                    StringWriter writer = new StringWriter();
                    while ((nextByte = in.read()) >= 0) {
                        writer.write(nextByte);
                    }
                    writer.close();
                    this.response.addContent(writer.toString());
                } else {
                    int nextByte;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((nextByte = in.read()) >= 0) {
                        out.write(nextByte);
                    }
                    out.close();
                    this.response.setBinaryContent(out.toByteArray());
                }
            }
            catch (Exception e) {
                this.logger.severe("error reading file" + e);
                this.response.setError(e);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        this.logger.severe("failed to close stream" + e2);
                    }
                }
                return;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.severe("failed to close stream" + e);
                }
            }
        }
        this.response.setOk();
    }
}

