/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface.template;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Conditional;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Element;
import jd.plugins.optional.webinterface.template.Tmpl.Element.If;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Var;
import jd.plugins.optional.webinterface.template.Tmpl.Filter;
import jd.plugins.optional.webinterface.template.Tmpl.Parsers.Parser;
import jd.plugins.optional.webinterface.template.Tmpl.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private If __template__ = new If("__template__");
    private String[] arrayref = null;
    private boolean case_sensitive = false;
    private boolean debug = false;
    private boolean die_on_bad_params = false;
    private Stack<Element> elements = new Stack();
    private Reader filehandle = null;
    private String filename = null;
    private Filter[] filters = null;
    private boolean global_vars = false;
    private boolean loop_context_vars = false;
    private int max_includes = 11;
    private boolean no_includes = false;
    private Hashtable<String, Object> params = new Hashtable();
    private Parser parser;
    private String[] path = null;
    private String scalarref = null;
    private boolean search_path_on_include = false;
    private boolean strict = true;

    private static boolean boolify(Object o) {
        if (o.getClass().getName().endsWith(".Boolean")) {
            return (Boolean)o;
        }
        String s = o.getClass().getName().endsWith(".String") ? (String)o : o.toString();
        return !s.equals("0") && !s.equals("") && !s.equals("false");
    }

    private static int intify(Object o) {
        if (o.getClass().getName().endsWith(".Integer")) {
            return (Integer)o;
        }
        String s = o.getClass().getName().endsWith(".String") ? (String)o : o.toString();
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private static Vector<Hashtable<String, Object>> lowerCaseAll(Vector<?> v) {
        Vector<Hashtable<String, Object>> v2 = new Vector<Hashtable<String, Object>>();
        for (Object name : v) {
            Hashtable h = (Hashtable)name;
            if (h == null) {
                v2.addElement(null);
                continue;
            }
            Hashtable h2 = new Hashtable();
            Enumeration e2 = h.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                Object value = h.get(key);
                String value_type = value.getClass().getName();
                Util.debug_print("to lower case: " + key + "(" + value_type + ")");
                if (value_type.endsWith(".Vector")) {
                    value = Template.lowerCaseAll((Vector)value);
                }
                h2.put(key.toLowerCase(), value);
            }
            v2.addElement(h2);
        }
        return v2;
    }

    private static String stringify(boolean b) {
        if (b) {
            return "1";
        }
        return "";
    }

    public Template(Hashtable<?, ?> args) throws FileNotFoundException, IllegalArgumentException, IllegalStateException, IOException {
        Enumeration<?> e = args.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = args.get(key);
            this.parseParam(key, value);
        }
        this.init();
    }

    public Template(Object[] args) throws ArrayIndexOutOfBoundsException, FileNotFoundException, IllegalArgumentException, IllegalStateException, IOException {
        if (args.length % 2 != 0) {
            throw new ArrayIndexOutOfBoundsException("odd number of arguments passed");
        }
        int i = 0;
        while (i < args.length) {
            this.parseParam((String)args[i], args[i + 1]);
            i += 2;
        }
        this.init();
    }

    public Template(String filename) throws FileNotFoundException, IllegalStateException, IOException {
        this.filename = filename;
        this.init();
    }

    public Object getParam(String name) throws NoSuchElementException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (!this.params.containsKey(name)) {
            throw new NoSuchElementException(String.valueOf(name) + " is not a parameter in this template");
        }
        if (this.case_sensitive) {
            return this.params.get(name);
        }
        return this.params.get(name.toLowerCase());
    }

    private void init() throws FileNotFoundException, IllegalStateException, IOException {
        if (this.filename == null && this.scalarref == null && this.arrayref == null && this.filehandle == null) {
            throw new FileNotFoundException("template filename required");
        }
        Util.debug = this.debug;
        this.params.put("__template__", "true");
        String[] parser_params = new String[]{"case_sensitive", Template.stringify(this.case_sensitive), "strict", Template.stringify(this.strict), "loop_context_vars", Template.stringify(this.loop_context_vars), "global_vars", Template.stringify(this.global_vars)};
        this.parser = new Parser(parser_params);
        if (this.filename != null) {
            this.read_file(this.filename);
        } else if (this.arrayref != null) {
            this.read_line_array(this.arrayref);
        } else if (this.scalarref != null) {
            this.read_line(this.scalarref);
        } else if (this.filehandle != null) {
            this.read_fh(this.filehandle);
        }
        if (!this.elements.empty()) {
            System.err.println("stack not empty");
        }
    }

    private BufferedReader openFile(String filename) throws FileNotFoundException {
        boolean add_path = true;
        if (!this.elements.empty() && !this.search_path_on_include) {
            add_path = false;
        }
        if (filename.startsWith("/")) {
            add_path = false;
        }
        if (this.path == null) {
            add_path = false;
        }
        Util.debug_print("open " + filename);
        if (!add_path) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                return new BufferedReader(new FileReader(filename));
            }
        }
        BufferedReader br = null;
        String[] stringArray = this.path;
        int n = this.path.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                Util.debug_print("trying " + element + "/" + filename);
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    br = new BufferedReader(new FileReader(filename));
                }
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
                ++n2;
            }
        }
        if (br == null) {
            throw new FileNotFoundException(filename);
        }
        return br;
    }

    public String output() {
        return this.__template__.parse(this.params);
    }

    private Element parseLine(String line, Element e) throws FileNotFoundException, IllegalStateException, IOException, EmptyStackException {
        Vector<Object> parts = this.parser.parseLine(line);
        Util.debug_print("Items: " + parts.size());
        for (Object o : parts) {
            if (o.getClass().getName().endsWith(".String")) {
                if (((String)o).equals("")) continue;
                e.add((String)o);
                Util.debug_print("added: " + (String)o);
                continue;
            }
            Properties p = (Properties)o;
            String type = p.getProperty("type");
            Util.debug_print("adding element: " + type);
            if (type.equals("include")) {
                if (this.no_includes) {
                    throw new IllegalStateException("<tmpl_include> not allowed when no_includes in effect");
                }
                if (this.max_includes == 0) {
                    throw new IndexOutOfBoundsException("include too deep");
                }
                this.elements.push(e);
                this.read_file(p.getProperty("name"));
                continue;
            }
            if (type.equals("var")) {
                String name = p.getProperty("name");
                String escape = p.getProperty("escape");
                String def = p.getProperty("default");
                Util.debug_print("name: " + name);
                Util.debug_print("escape: " + escape);
                Util.debug_print("default: " + def);
                e.add(new Var(name, escape, (Object)def));
                continue;
            }
            if (type.equals("else")) {
                Util.debug_print("adding branch");
                ((Conditional)e).addBranch();
                continue;
            }
            if (p.getProperty("close").equals("true")) {
                Util.debug_print("closing tag");
                if (!type.equals(e.Type())) {
                    throw new EmptyStackException();
                }
                e = this.elements.pop();
                continue;
            }
            Element t = this.parser.getElement(p);
            e.add(t);
            this.elements.push(e);
            e = t;
        }
        return e;
    }

    private void parseParam(String key, Object value) throws IllegalStateException {
        if (key.equals("case_sensitive")) {
            this.case_sensitive = Template.boolify(value);
            Util.debug_print("case_sensitive: " + value);
        } else if (key.equals("strict")) {
            this.strict = Template.boolify(value);
            Util.debug_print("strict: " + value);
        } else if (key.equals("global_vars")) {
            this.global_vars = Template.boolify(value);
            Util.debug_print("global_vars: " + value);
        } else if (key.equals("die_on_bad_params")) {
            this.die_on_bad_params = Template.boolify(value);
            Util.debug_print("die_obp: " + value);
        } else if (key.equals("max_includes")) {
            this.max_includes = Template.intify(value) + 1;
            Util.debug_print("max_includes: " + value);
        } else if (key.equals("no_includes")) {
            this.no_includes = Template.boolify(value);
            Util.debug_print("no_includes: " + value);
        } else if (key.equals("search_path_on_include")) {
            this.search_path_on_include = Template.boolify(value);
            Util.debug_print("path_includes: " + value);
        } else if (key.equals("loop_context_vars")) {
            this.loop_context_vars = Template.boolify(value);
            Util.debug_print("loop_c_v: " + value);
        } else if (key.equals("debug")) {
            Util.debug = this.debug = Template.boolify(value);
            Util.debug_print("debug: " + value);
        } else if (key.equals("filename")) {
            this.filename = (String)value;
            Util.debug_print("filename: " + value);
        } else if (key.equals("scalarref")) {
            this.scalarref = (String)value;
            Util.debug_print("scalarref");
        } else if (key.equals("arrayref")) {
            this.arrayref = (String[])value;
            Util.debug_print("arrayref");
        } else if (key.equals("path")) {
            if (value.getClass().getName().startsWith("[")) {
                this.path = (String[])value;
            } else {
                this.path = new String[1];
                this.path[0] = (String)value;
            }
            Util.debug_print("path");
            String[] stringArray = this.path;
            int n = this.path.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Util.debug_print(element);
                ++n2;
            }
        } else if (key.equals("filter")) {
            if (value.getClass().getName().startsWith("[")) {
                this.filters = (Filter[])value;
            } else {
                this.filters = new Filter[1];
                this.filters[0] = (Filter)value;
            }
            Util.debug_print("filters set: " + this.filters.length);
        } else if (key.equals("filehandle")) {
            this.filehandle = (Reader)value;
            Util.debug_print("filehandle");
        } else {
            throw new IllegalArgumentException(key);
        }
    }

    public void printTo(PrintWriter out) {
        out.print(this.output());
    }

    private void read_fh(Reader handle) throws FileNotFoundException, IllegalStateException, IOException, EmptyStackException {
        String line;
        BufferedReader br = new BufferedReader(handle);
        Element e = null;
        e = this.elements.empty() ? this.__template__ : this.elements.pop();
        --this.max_includes;
        while ((line = br.readLine()) != null) {
            Util.debug_print("Line: " + line);
            e = this.parseLine(String.valueOf(line) + "\n", e);
        }
        ++this.max_includes;
        br.close();
        br = null;
    }

    private void read_file(String filename) throws FileNotFoundException, IllegalStateException, IOException, EmptyStackException {
        String line;
        BufferedReader br = this.openFile(filename);
        Element e = null;
        e = this.elements.empty() ? this.__template__ : this.elements.pop();
        --this.max_includes;
        while ((line = br.readLine()) != null) {
            Util.debug_print("Line: " + line);
            e = this.parseLine(String.valueOf(line) + "\n", e);
        }
        ++this.max_includes;
        br.close();
        br = null;
    }

    private void read_line(String lines) throws FileNotFoundException, IllegalStateException, IOException, EmptyStackException {
        Element e = this.__template__;
        --this.max_includes;
        StringTokenizer st = new StringTokenizer(lines, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            Util.debug_print(line);
            e = this.parseLine(String.valueOf(line) + "\n", e);
        }
        ++this.max_includes;
    }

    private void read_line_array(String[] lines) throws FileNotFoundException, IllegalStateException, IOException, EmptyStackException {
        Element e = this.__template__;
        --this.max_includes;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Util.debug_print(element);
            e = this.parseLine(element, e);
            ++n2;
        }
        ++this.max_includes;
    }

    public boolean setParam(String name, boolean value) throws IllegalArgumentException, NullPointerException {
        return this.setParam(name, (Boolean)value);
    }

    public Boolean setParam(String name, Boolean value) throws IllegalArgumentException, NullPointerException {
        try {
            return (Boolean)this.setParam(name, (Object)value);
        }
        catch (ClassCastException iae) {
            return null;
        }
    }

    public int setParam(String name, int value) throws IllegalArgumentException, NullPointerException {
        return this.setParam(name, new Integer(value));
    }

    public Integer setParam(String name, Integer value) throws IllegalArgumentException, NullPointerException {
        try {
            return (Integer)this.setParam(name, (Object)value);
        }
        catch (ClassCastException iae) {
            return null;
        }
    }

    private Object setParam(String name, Object value) throws ClassCastException, NullPointerException, IllegalArgumentException {
        String valid_types;
        String type;
        if (name == null) {
            throw new NullPointerException("parameter name cannot be null");
        }
        if (!Util.isNameChar(name)) {
            throw new IllegalArgumentException("parameter name may only contain letters, digits, ., /, +, -, _");
        }
        if (name.startsWith("__") && name.endsWith("__")) {
            throw new IllegalArgumentException("parameter name may not start and end with a double underscore");
        }
        if (this.die_on_bad_params && !this.__template__.contains(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + "is not a valid template entity");
        }
        if (value == null) {
            value = "";
        }
        if ((type = value.getClass().getName()).indexOf(".") > 0) {
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        if ((valid_types = ",String,Vector,Boolean,Integer,").indexOf(type) < 0) {
            throw new ClassCastException("value is neither scalar nor list");
        }
        String string = name = this.case_sensitive ? name : name.toLowerCase();
        if (!this.case_sensitive && type.equals("Vector")) {
            value = Template.lowerCaseAll(value);
        }
        Util.debug_print("setting: " + name);
        this.params.put(name, value);
        return value;
    }

    public String setParam(String name, String value) throws IllegalArgumentException, NullPointerException {
        try {
            return (String)this.setParam(name, (Object)value);
        }
        catch (ClassCastException iae) {
            return null;
        }
    }

    public Vector<?> setParam(String name, Vector<?> value) throws IllegalArgumentException, NullPointerException {
        try {
            return (Vector)this.setParam(name, (Object)value);
        }
        catch (ClassCastException iae) {
            return null;
        }
    }

    public int setParams(Hashtable<?, ?> params) {
        if (params == null || params.isEmpty()) {
            return 0;
        }
        int count = 0;
        Enumeration<?> e = params.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (!key.getClass().getName().endsWith(".String")) continue;
            Object value = params.get(key);
            try {
                this.setParam((String)key, value);
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (count > 0) {
            Util.debug_print("Now dirty: set params");
        }
        return count;
    }
}

