/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface.template.Tmpl.Element;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conditional
extends Element {
    private boolean control_val = false;
    private Vector<Object>[] data;

    public Conditional(String type, String name) throws IllegalArgumentException {
        if (type.equalsIgnoreCase("if")) {
            this.type = "if";
        } else if (type.equalsIgnoreCase("unless")) {
            this.type = "unless";
        } else {
            throw new IllegalArgumentException("Unrecognised type: " + type);
        }
        this.name = name;
        this.data = new Vector[2];
        this.data[0] = new Vector();
    }

    @Override
    public void add(Element node) {
        if (this.data[1] != null) {
            this.data[1].addElement(node);
        } else {
            this.data[0].addElement(node);
        }
    }

    @Override
    public void add(String text) {
        if (this.data[1] != null) {
            this.data[1].addElement(text);
        } else {
            this.data[0].addElement(text);
        }
    }

    public void addBranch() throws IndexOutOfBoundsException {
        if (this.data[1] != null) {
            throw new IndexOutOfBoundsException("Already have two branches");
        }
        if (this.data[0] == null) {
            this.data[0] = new Vector();
        } else if (this.data[1] == null) {
            this.data[1] = new Vector();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String parse(Hashtable<?, ?> params) {
        Enumeration<Object> de;
        if (!params.containsKey(this.name)) {
            this.control_val = false;
        } else {
            this.setControlValue(params.get(this.name));
        }
        StringBuilder output = new StringBuilder();
        if (this.type.equals("if") && this.control_val || this.type.equals("unless") && !this.control_val) {
            de = this.data[0].elements();
        } else {
            if (this.data[1] == null) {
                return "";
            }
            de = this.data[1].elements();
        }
        while (de.hasMoreElements()) {
            Object e = de.nextElement();
            if (e.getClass().getName().endsWith(".String")) {
                output.append((String)e);
                continue;
            }
            output.append(((Element)e).parse(params));
        }
        return output.toString();
    }

    private boolean process_var(Object control_val) throws IllegalArgumentException {
        String control_class = "";
        if (control_val == null) {
            return false;
        }
        control_class = control_val.getClass().getName();
        if (control_class.indexOf(".") > 0) {
            control_class = control_class.substring(control_class.lastIndexOf(".") + 1);
        }
        if (control_class.equals("String")) {
            return !((String)control_val).equals("") && !((String)control_val).equals("0");
        }
        if (control_class.equals("Vector")) {
            return !((Vector)control_val).isEmpty();
        }
        if (control_class.equals("Boolean")) {
            return (Boolean)control_val;
        }
        if (control_class.equals("Integer")) {
            return (Integer)control_val != 0;
        }
        throw new IllegalArgumentException("Unrecognised type");
    }

    public void setControlValue(Object control_val) throws IllegalArgumentException {
        this.control_val = this.process_var(control_val);
    }

    @Override
    public String typeOfParam(String param) throws NoSuchElementException {
        Vector<Object>[] vectorArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            Vector<Object> element = vectorArray[n2];
            if (element != null) {
                Enumeration<Object> e = element.elements();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o.getClass().getName().endsWith(".String") || !((Element)o).Name().equals(param)) continue;
                    return ((Element)o).Type();
                }
            }
            ++n2;
        }
        throw new NoSuchElementException(param);
    }
}

