/*
 * Decompiled with CFR 0.152.
 */
package jd.plugins.optional.webinterface.template.Tmpl.Parsers;

import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Element;
import jd.plugins.optional.webinterface.template.Tmpl.Element.If;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Loop;
import jd.plugins.optional.webinterface.template.Tmpl.Element.Unless;
import jd.plugins.optional.webinterface.template.Tmpl.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private boolean case_sensitive = false;
    private boolean global_vars = false;
    private boolean loop_context_vars = false;
    private boolean strict = true;

    public Parser() {
    }

    public Parser(String[] args) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (args.length % 2 != 0) {
            throw new ArrayIndexOutOfBoundsException("odd number of arguments passed");
        }
        int i = 0;
        while (i < args.length) {
            String s;
            if (args[i].equals("case_sensitive")) {
                String cs = args[i + 1];
                this.case_sensitive = !cs.equals("") && !cs.equals("0");
            } else if (args[i].equals("strict")) {
                s = args[i + 1];
                this.strict = !s.equals("") && !s.equals("0");
            } else if (args[i].equals("loop_context_vars")) {
                s = args[i + 1];
                this.loop_context_vars = !s.equals("") && !s.equals("0");
            } else if (args[i].equals("global_vars")) {
                s = args[i + 1];
                this.global_vars = !s.equals("") && !s.equals("0");
            } else {
                throw new IllegalArgumentException(args[i]);
            }
            i += 2;
        }
    }

    private String cleanTag(String tag) throws IllegalArgumentException {
        String test_tag = new String(tag);
        if (test_tag.startsWith("<")) {
            test_tag = test_tag.substring(1);
        }
        if (!test_tag.endsWith(">")) {
            throw new IllegalArgumentException("Tags must start and end on the same line");
        }
        test_tag = test_tag.substring(0, test_tag.length() - 1);
        if (test_tag.startsWith("!--")) {
            test_tag = test_tag.substring(3);
        }
        if (test_tag.endsWith("--")) {
            test_tag = test_tag.substring(0, test_tag.length() - 2);
        }
        test_tag = test_tag.trim();
        return test_tag;
    }

    public Element getElement(Properties p) throws NoSuchElementException {
        String type = p.getProperty("type");
        if (type.equals("if")) {
            return new If(p.getProperty("name"));
        }
        if (type.equals("unless")) {
            return new Unless(p.getProperty("name"));
        }
        if (type.equals("loop")) {
            return new Loop(p.getProperty("name"), this.loop_context_vars, this.global_vars);
        }
        throw new NoSuchElementException(type);
    }

    private Properties getTagProps(String tag) throws IllegalArgumentException, NullPointerException {
        Properties p = new Properties();
        tag = this.cleanTag(tag);
        Util.debug_print("clean: " + tag);
        if (tag.startsWith("/")) {
            p.put("close", "true");
            tag = tag.substring(1);
        } else {
            p.put("close", "");
        }
        Util.debug_print("close: " + p.getProperty("close"));
        p.put("type", this.getTagType(tag));
        Util.debug_print("type: " + p.getProperty("type"));
        if (p.getProperty("type").equals("else") || p.getProperty("close").equals("true")) {
            return p;
        }
        if (p.getProperty("type").equals("var")) {
            p.put("escape", "");
        }
        int sp = tag.indexOf(" ");
        tag = tag.substring(sp).trim();
        Util.debug_print("checking params: " + tag);
        if (tag.indexOf("=") < 0) {
            sp = tag.toLowerCase().indexOf(" escape");
            if (sp < 0) {
                p.put("name", tag);
                p.put("escape", "0");
            } else {
                tag = tag.substring(0, sp);
                p.put("name", tag);
                p.put("escape", "html");
            }
        } else {
            StringTokenizer st = new StringTokenizer(tag, " =");
            while (st.hasMoreTokens()) {
                String value;
                String key = st.nextToken().toLowerCase();
                if (st.hasMoreTokens()) {
                    value = st.nextToken();
                } else if (key.equals("escape")) {
                    value = "html";
                } else {
                    throw new NullPointerException("parameter " + key + " has no value");
                }
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                } else if (value.startsWith("'") && value.endsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                if (value.length() == 0) {
                    throw new NullPointerException("parameter " + key + " has no value");
                }
                if (key.equals("escape")) {
                    value = value.toLowerCase();
                }
                p.put(key, value);
            }
        }
        String name = p.getProperty("name");
        if (!(this.case_sensitive || p.getProperty("type").equals("include") || name.startsWith("__") && name.endsWith("__"))) {
            p.put("name", name.toLowerCase());
        }
        if (!Util.isNameChar(name)) {
            throw new IllegalArgumentException("parameter name may only contain letters, digits, ., /, +, -, _");
        }
        return p;
    }

    private String getTagType(String tag) {
        int sp = tag.indexOf(" ");
        String tag_type = "";
        tag_type = sp < 0 ? tag.toLowerCase() : tag.substring(0, sp).toLowerCase();
        if (tag_type.startsWith("tmpl_")) {
            tag_type = tag_type.substring(5);
        }
        Util.debug_print("tag_type: " + tag_type);
        if (tag_type.equals("var") || tag_type.equals("if") || tag_type.equals("unless") || tag_type.equals("loop") || tag_type.equals("include") || tag_type.equals("else")) {
            return tag_type;
        }
        return null;
    }

    public Vector<Object> parseLine(String line) throws IllegalArgumentException {
        Vector<Object> parts = new Vector<Object>();
        char[] c = line.toCharArray();
        int i = 0;
        StringBuilder temp = new StringBuilder();
        i = 0;
        while (i < c.length) {
            if (c[i] != '<') {
                temp.append(c[i]);
            } else {
                Util.debug_print("line so far: " + temp);
                StringBuilder tag = new StringBuilder();
                while (i < c.length && c[i] != '>') {
                    tag.append(c[i]);
                    ++i;
                }
                if (i < c.length) {
                    tag.append(c[i]);
                }
                while (tag.toString().substring(1).indexOf("<") > -1) {
                    do {
                        temp.append(tag.charAt(0));
                    } while ((tag = new StringBuilder(tag.toString().substring(1))).charAt(0) != '<');
                }
                Util.debug_print("tag: " + tag);
                String test_tag = tag.toString().toLowerCase();
                if (test_tag.indexOf("tmpl_") < 0) {
                    temp.append((CharSequence)tag);
                } else {
                    test_tag = this.cleanTag(test_tag);
                    Util.debug_print("clean: " + test_tag);
                    if (test_tag.startsWith("/")) {
                        test_tag = test_tag.substring(1);
                    }
                    if (!test_tag.startsWith("tmpl_")) {
                        temp.append((CharSequence)tag);
                    } else {
                        String tag_type = this.getTagType(test_tag);
                        if (tag_type == null) {
                            if (this.strict) {
                                throw new IllegalArgumentException(tag.toString());
                            }
                            temp.append((CharSequence)tag);
                        }
                        Util.debug_print("type: " + tag_type);
                        if (tag_type != null) {
                            if (temp.length() > 0) {
                                parts.addElement(temp.toString());
                                temp = new StringBuilder();
                            }
                            Util.debug_print("Checking: " + tag);
                            Properties tag_props = this.getTagProps(tag.toString());
                            if (tag_props.containsKey("name")) {
                                Util.debug_print("name: " + tag_props.getProperty("name"));
                            } else {
                                Util.debug_print("no name");
                            }
                            parts.addElement(tag_props);
                        }
                    }
                }
            }
            ++i;
        }
        if (temp.length() > 0) {
            parts.addElement(temp.toString());
        }
        return parts;
    }
}

