/*
 * Decompiled with CFR 0.152.
 */
package jd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jd.JDInit;
import jd.ObjectConverter;
import jd.config.Configuration;
import jd.config.Property;
import jd.config.SubConfiguration;
import jd.controlling.JDController;
import jd.event.ControlEvent;
import jd.event.ControlListener;
import jd.gui.swing.dialog.AbstractDialog;
import jd.gui.swing.jdgui.userio.UserIOGui;
import jd.gui.swing.laf.LookAndFeelController;
import jd.update.JDUpdateUtils;
import jd.utils.JDTheme;
import jd.utils.JDUtilities;
import net.miginfocom.swing.MigLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private Configuration mainConfig;
    private ArrayList<SubConfiguration> configs;
    private JComboBox configSelection;
    private SubConfiguration currentConfig;
    private JTable table;
    private ConfigTableModel tableModel;
    private ArrayList<Object> values;
    private ArrayList<String> keys;
    private JButton add;
    private JButton edit;
    private JButton remove;
    private JFrame frame;

    public Config() {
        JDInit jDInit = new JDInit();
        jDInit.init();
        JDController jDController = JDController.getInstance();
        JDUpdateUtils.backupDataBase();
        System.out.println("Backuped Database");
        this.mainConfig = JDUtilities.getConfiguration();
        LookAndFeelController.setUIManager();
        final SubConfiguration subConfiguration = SubConfiguration.getConfig("LAF_CFG." + LookAndFeelController.getPlaf().getClassName());
        final SubConfiguration subConfiguration2 = SubConfiguration.getConfig("CURRENT_LOOK_AND_FEEL");
        subConfiguration2.setProperties(new HashMap<String, Object>());
        subConfiguration2.getProperties().putAll(subConfiguration.getProperties());
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || subConfiguration2.hasProperty(k.toString())) continue;
            System.out.println("ORG UI Defauls: " + k.toString() + " : " + uIDefaults.get(k.toString()));
            subConfiguration2.setProperty(k.toString(), uIDefaults.get(k.toString()));
        }
        jDController.addControlListener(new ControlListener(){

            public void controlEvent(ControlEvent controlEvent) {
                if (controlEvent.getSource() == subConfiguration2 && controlEvent.getID() == 27) {
                    Object object = subConfiguration2.getProperty(controlEvent.getParameter().toString());
                    if (object == null) {
                        object = Property.NULL;
                    }
                    subConfiguration.setProperty(controlEvent.getParameter().toString(), object);
                    if (object != null && object != Property.NULL) {
                        UIManager.put(controlEvent.getParameter().toString(), object);
                    }
                    subConfiguration.save();
                    SwingUtilities.updateComponentTreeUI(Config.this.frame);
                    Config.this.frame.pack();
                }
            }
        });
        this.configs = JDUtilities.getDatabaseConnector().getSubConfigurationKeys();
        this.configs.add(0, this.mainConfig);
        this.sort();
        this.setCurrentConfig(this.configs.get(0));
        this.initGUI();
    }

    private void sort() {
        Collections.sort(this.configs, new Comparator<SubConfiguration>(){

            @Override
            public int compare(SubConfiguration subConfiguration, SubConfiguration subConfiguration2) {
                return subConfiguration.toString().compareToIgnoreCase(subConfiguration2.toString());
            }
        });
    }

    private int[] getSelectedRows() {
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.table.convertRowIndexToModel(nArray[n]);
            ++n;
        }
        Arrays.sort(nArray2);
        return nArray2;
    }

    private void setCurrentConfig(SubConfiguration subConfiguration) {
        this.currentConfig = subConfiguration;
        this.keys = new ArrayList();
        this.values = new ArrayList();
        this.createMap(subConfiguration.getProperties(), this.keys, this.values, "");
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
    }

    private void createMap(HashMap<?, ?> hashMap, ArrayList<String> arrayList, ArrayList<Object> arrayList2, String string) {
        for (Map.Entry<?, ?> entry : hashMap.entrySet()) {
            String string2;
            String string3 = string2 = string.length() > 0 ? String.valueOf(string) + "/" + entry.getKey() : "" + entry.getKey();
            if (entry.getValue() instanceof HashMap) {
                arrayList.add(string2);
                arrayList2.add(entry.getValue());
                this.createMap((HashMap)entry.getValue(), arrayList, arrayList2, string2);
                continue;
            }
            arrayList.add(string2);
            arrayList2.add(entry.getValue());
        }
    }

    private void initGUI() {
        this.frame = new JFrame("JDownloader Config - leave any warranty behind you!");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout((LayoutManager)new MigLayout("ins 10,wrap 1", "[grow,fill]", "[][grow,fill]"));
        this.frame.setMinimumSize(new Dimension(800, 600));
        this.configSelection = new JComboBox<SubConfiguration>(this.configs.toArray(new SubConfiguration[0]));
        this.configSelection.setEditable(true);
        this.configSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Config.this.configSelection.getSelectedItem() instanceof String) {
                    SubConfiguration subConfiguration = SubConfiguration.getConfig(Config.this.configSelection.getSelectedItem().toString());
                    Config.this.configs.add(subConfiguration);
                    Config.this.sort();
                    Config.this.configSelection.setModel(new DefaultComboBoxModel<SubConfiguration>(Config.this.configs.toArray(new SubConfiguration[0])));
                    Config.this.configSelection.setSelectedItem(subConfiguration);
                    Config.this.setCurrentConfig(subConfiguration);
                    Config.this.tableModel.fireTableDataChanged();
                } else {
                    Config.this.setCurrentConfig((SubConfiguration)Config.this.configSelection.getSelectedItem());
                    Config.this.tableModel.fireTableDataChanged();
                }
            }
        });
        this.tableModel = new ConfigTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = Config.this.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                int n = nArray[0];
                Object object = Config.this.tableModel.getValueAt(n, 1);
                try {
                    new ObjectConverter().toString(object);
                    Config.this.edit.setEnabled(true);
                    Config.this.remove.setEnabled(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Config.this.edit.setEnabled(false);
                    Config.this.remove.setEnabled(true);
                }
            }
        });
        this.add = new JButton(JDTheme.II("gui.images.add", 24, 24));
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = UserIOGui.getInstance().requestInputDialog(4, "Enter Key", "Enter your key use / deliminator to create new sub-maps", "NEW_KEY", null, "Create Entry", "Cancel");
                if (string == null) {
                    return;
                }
                if (Config.this.keys.contains(string)) {
                    UserIOGui.getInstance().requestMessageDialog("Key " + string + " is already available. Try Edit feature");
                    return;
                }
                String string2 = UserIOGui.getInstance().requestInputDialog(68, "Edit value for " + string, "Please take care to keep xml structure", "<classtype>VALUE</classtype>\r\n e.g.: <boolean>true</boolean>", null, "Save", "Cancel");
                if (string2 == null) {
                    return;
                }
                try {
                    if (string2 != null) {
                        ObjectConverter objectConverter = new ObjectConverter();
                        objectConverter.toString(new Object());
                        Object object = objectConverter.toObject(string2);
                        String[] stringArray = string.toString().split("/");
                        HashMap hashMap = Config.this.currentConfig.getProperties();
                        System.out.println("Save Object " + string);
                        int n = 0;
                        while (n < stringArray.length) {
                            String string3 = stringArray[n];
                            if (n < stringArray.length - 1) {
                                Object object2 = hashMap.get(string3);
                                if (object2 instanceof HashMap) {
                                    System.out.println("sub Hashmap " + string3);
                                    hashMap = (HashMap)object2;
                                } else {
                                    System.out.println("create sub Hashmap " + string3);
                                    HashMap hashMap2 = hashMap;
                                    hashMap = new HashMap();
                                    hashMap2.put(string3, hashMap);
                                }
                            }
                            ++n;
                        }
                        Config.this.currentConfig.setProperty(stringArray[stringArray.length - 1], object);
                        Config.this.currentConfig.save();
                        Config.this.setCurrentConfig(Config.this.currentConfig);
                    }
                }
                catch (Exception exception) {
                    UserIOGui.getInstance().requestMessageDialog("Could not save object. Failures in XML structure!");
                }
            }
        });
        this.edit = new JButton(JDTheme.II("gui.images.findandreplace", 24, 24));
        this.edit.setEnabled(false);
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = Config.this.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                int n = nArray[0];
                Object object = Config.this.tableModel.getValueAt(n, 0);
                Object object2 = Config.this.tableModel.getValueAt(n, 1);
                try {
                    AbstractDialog.setDefaultDimension((Dimension)new Dimension(550, 400));
                    ObjectConverter objectConverter = new ObjectConverter();
                    String string = objectConverter.toString(object2);
                    String string2 = UserIOGui.getInstance().requestInputDialog(68, "Edit value for " + object, "Please take care to keep xml structure", string, null, "Save", "Cancel");
                    try {
                        if (string2 != null) {
                            Object object3 = objectConverter.toObject(string2);
                            String[] stringArray = object.toString().split("/");
                            HashMap hashMap = Config.this.currentConfig.getProperties();
                            String string3 = null;
                            System.out.println("Save Object " + object);
                            String[] stringArray2 = stringArray;
                            int n2 = stringArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String string4 = stringArray2[n3];
                                Object object4 = hashMap.get(string4);
                                if (!(object4 instanceof HashMap)) {
                                    string3 = string4;
                                    System.out.println("Save Object to key " + string4);
                                    break;
                                }
                                System.out.println("sub Hashmap " + string4);
                                hashMap = (HashMap)object4;
                                ++n3;
                            }
                            Config.this.currentConfig.setProperty(string3, object3);
                            Config.this.currentConfig.save();
                            Config.this.setCurrentConfig(Config.this.currentConfig);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        UserIOGui.getInstance().requestMessageDialog("Could not save object. Failures in XML structure!");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.remove = new JButton(JDTheme.II("gui.images.delete", 24, 24));
        this.remove.setEnabled(false);
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = Config.this.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                int n = nArray[0];
                Object object = Config.this.tableModel.getValueAt(n, 0);
                String[] stringArray = object.toString().split("/");
                if (stringArray[stringArray.length - 1].equals("null")) {
                    stringArray[stringArray.length - 1] = null;
                }
                if (stringArray.length == 1) {
                    Config.this.currentConfig.setProperty(stringArray[0], Property.NULL);
                    Config.this.currentConfig.save();
                    Config.this.setCurrentConfig(Config.this.currentConfig);
                } else {
                    HashMap hashMap = Config.this.currentConfig.getProperties();
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string = stringArray2[n3];
                        Object object2 = hashMap.get(string);
                        if (object2 instanceof HashMap) {
                            System.out.println("sub Hashmap " + string);
                            hashMap = (HashMap)object2;
                        } else if (string != stringArray[stringArray.length - 1]) {
                            System.out.println("error key " + string);
                            return;
                        }
                        ++n3;
                    }
                    Config.this.currentConfig.setProperty(stringArray[stringArray.length - 1], Property.NULL);
                    Config.this.currentConfig.save();
                    Config.this.setCurrentConfig(Config.this.currentConfig);
                }
            }
        });
        this.add.setOpaque(false);
        this.add.setBorderPainted(false);
        this.add.setContentAreaFilled(false);
        this.edit.setOpaque(false);
        this.edit.setBorderPainted(false);
        this.edit.setContentAreaFilled(false);
        this.remove.setOpaque(false);
        this.remove.setBorderPainted(false);
        this.remove.setContentAreaFilled(false);
        this.frame.add((Component)this.configSelection, "split 4,pushx,growx");
        this.frame.add((Component)this.add, "alignx right");
        this.frame.add((Component)this.remove, "alignx right");
        this.frame.add((Component)this.edit, "alignx right");
        this.frame.add(new JScrollPane(this.table));
        this.frame.setVisible(true);
        this.frame.pack();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5434313385327397539L;
        private String[] columnNames = new String[]{"Key", "Value"};

        private ConfigTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Config.this.values.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object getValueAt(int var1_1, int var2_2) {
            switch (var2_2) {
                case 0: {
                    return Config.access$1(Config.this).get(var1_1);
                }
                case 1: {
                    ** GOTO lbl12
                }
                default: {
                    return "";
                }
            }
            {
                catch (Exception var3_4) {
                    // empty catch block
                    return "";
                }
lbl12:
                // 1 sources

                try {
                    new ObjectConverter().toString(Config.access$0(Config.this).get(var1_1));
                    return Config.access$0(Config.this).get(var1_1);
                }
                catch (Exception var3_3) {}
                return Config.access$0(Config.this).get(var1_1);
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

